/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.printconnectintentswrapper;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.util.Log;
import com.zebra.printconnectintentswrapper.PCConstants;
import com.zebra.printconnectintentswrapper.PCIntentsBase;
import com.zebra.printconnectintentswrapper.PCIntentsBaseSettings;
import com.zebra.printconnectintentswrapper.PCPassthroughPrintSettings;
import java.io.UnsupportedEncodingException;

public class PCPassthroughPrint
extends PCIntentsBase {
    private onPassthroughResult mPassthroughCallback = null;

    public PCPassthroughPrint(Context aContext) {
        super(aContext);
    }

    public void execute(PCPassthroughPrintSettings settings, onPassthroughResult callback) {
        if (callback == null) {
            Log.e((String)TAG, (String)"Error: callback member is null.");
            return;
        }
        this.mPassthroughCallback = callback;
        if ((settings.mPassthroughData == null || settings.mPassthroughData.isEmpty()) && this.mPassthroughCallback != null) {
            this.mPassthroughCallback.error("Error: no data to print.", -1, null, settings);
            return;
        }
        super.execute(settings);
        this.PrintTemplateString(settings);
    }

    private void PrintTemplateString(final PCPassthroughPrintSettings settings) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.zebra.printconnect", "com.zebra.printconnect.print.PassthroughService"));
        byte[] passthroughBytes = null;
        try {
            passthroughBytes = settings.mPassthroughData.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (this.mPassthroughCallback != null) {
                this.mPassthroughCallback.error(e.getMessage(), -1, null, settings);
            }
            this.cleanAll();
            return;
        }
        intent.putExtra("com.zebra.printconnect.PrintService.PASSTHROUGH_DATA", passthroughBytes);
        ResultReceiver receiver = this.buildIPCSafeReceiver(new ResultReceiver(null){

            protected void onReceiveResult(int resultCode, Bundle resultData) {
                PCPassthroughPrint.this.cleanAll();
                if (resultCode == 0) {
                    if (PCPassthroughPrint.this.mPassthroughCallback != null) {
                        PCPassthroughPrint.this.mPassthroughCallback.success(settings);
                    }
                } else {
                    String errorMessage = resultData.getString("com.zebra.printconnect.PrintService.ERROR_MESSAGE");
                    if (errorMessage == null) {
                        errorMessage = PCConstants.getErrorMessage(resultCode);
                    }
                    if (PCPassthroughPrint.this.mPassthroughCallback != null) {
                        PCPassthroughPrint.this.mPassthroughCallback.error(errorMessage, resultCode, resultData, settings);
                    }
                }
            }
        });
        intent.putExtra("com.zebra.printconnect.PrintService.RESULT_RECEIVER", (Parcelable)receiver);
        this.mContext.startService(intent);
    }

    @Override
    protected void onTimeOut(PCIntentsBaseSettings settings) {
        if (this.mPassthroughCallback != null) {
            this.mPassthroughCallback.timeOut((PCPassthroughPrintSettings)settings);
        }
    }

    public static interface onPassthroughResult {
        public void success(PCPassthroughPrintSettings var1);

        public void error(String var1, int var2, Bundle var3, PCPassthroughPrintSettings var4);

        public void timeOut(PCPassthroughPrintSettings var1);
    }
}

