/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.deviceidentifierswrapper;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import com.zebra.deviceidentifierswrapper.DIHelper;
import com.zebra.deviceidentifierswrapper.DIProfileManagerCommand;
import com.zebra.deviceidentifierswrapper.ExecutorTask;
import com.zebra.deviceidentifierswrapper.IDIResultCallbacks;
import java.util.Base64;

class RetrieveOEMInfoTask
extends ExecutorTask<Object, Void, Boolean> {
    RetrieveOEMInfoTask() {
    }

    @Override
    protected Boolean doInBackground(Object ... objects) {
        Context context = (Context)objects[0];
        Uri uri = (Uri)objects[1];
        IDIResultCallbacks idiResultCallbacks = (IDIResultCallbacks)objects[2];
        RetrieveOEMInfoTask.RetrieveOEMInfo(context, uri, idiResultCallbacks);
        return true;
    }

    private static void RetrieveOEMInfo(final Context context, final Uri uri, final IDIResultCallbacks callbackInterface) {
        Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
        if (cursor == null || cursor.getCount() < 1) {
            if (callbackInterface != null) {
                callbackInterface.onDebugStatus("App not registered to call OEM Service:" + uri.toString() + "\nRegistering current application using profile manger, this may take a couple of seconds...");
            }
            RetrieveOEMInfoTask.registerCurrentApplication(context, uri, new IDIResultCallbacks(){

                @Override
                public void onSuccess(String message) {
                    Cursor cursor2 = context.getContentResolver().query(uri, null, null, null, null);
                    if ((cursor2 == null || cursor2.getCount() < 1) && callbackInterface != null) {
                        callbackInterface.onError("Fail to register the app for OEM Service call:" + uri + "\nIt's time to debug this app ;)");
                        return;
                    }
                    RetrieveOEMInfoTask.getURIValue(cursor2, uri, callbackInterface);
                }

                @Override
                public void onError(String message) {
                    if (callbackInterface != null) {
                        callbackInterface.onError(message);
                        return;
                    }
                }

                @Override
                public void onDebugStatus(String message) {
                    if (callbackInterface != null) {
                        callbackInterface.onDebugStatus(message);
                    }
                }
            });
        } else {
            RetrieveOEMInfoTask.getURIValue(cursor, uri, callbackInterface);
        }
    }

    private static void registerCurrentApplication(Context context, Uri serviceIdentifier, IDIResultCallbacks callbackInterface) {
        block6: {
            String profileName = "AccessMgr-1";
            String profileData = "";
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0x8000000);
                String path = context.getApplicationInfo().sourceDir;
                String strName = packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
                String strVendor = packageInfo.packageName;
                Signature sig = DIHelper.apkCertificate;
                if (sig == null) {
                    Signature[] arrSignatures = null;
                    if (Build.VERSION.SDK_INT >= 28) {
                        arrSignatures = packageInfo.signingInfo.getApkContentsSigners();
                    }
                    if ((arrSignatures == null || arrSignatures.length == 0) && callbackInterface != null) {
                        callbackInterface.onError("Error : Package has no signing certificates... how's that possible ?");
                        return;
                    }
                    sig = arrSignatures[0];
                }
                byte[] rawCert = sig.toByteArray();
                String encoded = null;
                if (Build.VERSION.SDK_INT >= 26) {
                    encoded = Base64.getEncoder().encodeToString(rawCert);
                }
                profileData = "<?xml version=\"1.0\" encoding=\"utf-8\"?><characteristic type=\"Profile\"><parm name=\"ProfileName\" value=\"" + profileName + "\"/><characteristic type=\"AccessMgr\" version=\"9.2\"><parm name=\"OperationMode\" value=\"1\" /><parm name=\"ServiceAccessAction\" value=\"4\" /><parm name=\"ServiceIdentifier\" value=\"" + serviceIdentifier + "\" /><parm name=\"CallerPackageName\" value=\"" + context.getPackageName().toString() + "\" /><parm name=\"CallerSignature\" value=\"" + encoded + "\" /></characteristic></characteristic>";
                DIProfileManagerCommand profileManagerCommand = new DIProfileManagerCommand(context);
                profileManagerCommand.execute(profileData, profileName, callbackInterface);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callbackInterface == null) break block6;
                callbackInterface.onError("Error on profile: " + profileName + "\nError:" + e.getLocalizedMessage() + "\nProfileData:" + profileData);
            }
        }
    }

    private static void getURIValue(Cursor cursor, Uri uri, IDIResultCallbacks resultCallbacks) {
        while (cursor.moveToNext()) {
            if (cursor.getColumnCount() == 0) {
                String errorMsg = "Error: " + uri + " does not exist on this device";
                resultCallbacks.onDebugStatus(errorMsg);
                continue;
            }
            for (int i = 0; i < cursor.getColumnCount(); ++i) {
                try {
                    String data = cursor.getString(cursor.getColumnIndex(cursor.getColumnName(i)));
                    resultCallbacks.onSuccess(data);
                    cursor.close();
                    return;
                }
                catch (Exception e) {
                    resultCallbacks.onDebugStatus(e.getLocalizedMessage());
                    continue;
                }
            }
        }
        cursor.close();
        resultCallbacks.onError("Data not found in Uri:" + uri);
    }
}

