/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.zebra.datawedgeprofileintents.DWStatusScannerSettings;

public class DWStatusScanner {
    private static String TAG = "DWStatusScanner";
    private Context mContext;
    private dataWedgeScannerStatusReceiver mStatusBroadcastReceiver = null;
    private DWStatusScannerSettings mStatusSettings = null;
    private Handler broadcastReceiverHandler = null;
    private HandlerThread broadcastReceiverThread = null;
    private Looper broadcastReceiverThreadLooper = null;

    public DWStatusScanner(Context aContext, DWStatusScannerSettings settings) {
        this.mContext = aContext;
        this.mStatusSettings = settings;
        this.mStatusBroadcastReceiver = new dataWedgeScannerStatusReceiver();
    }

    public void start() {
        Log.d((String)TAG, (String)"Start Status Scanner Receiver");
        this.registerNotificationReceiver();
        this.registerForScannerStatus(this.mStatusSettings);
    }

    public void stop() {
        Log.d((String)TAG, (String)"Stop Status Scanner Receiver");
        this.unRegisterNotificationReceiver();
        this.unRegisterForScannerStatus(this.mStatusSettings);
    }

    protected void registerForScannerStatus(DWStatusScannerSettings settings) {
        Log.d((String)TAG, (String)"Scanner Receiver: registerForScannerStatus");
        Bundle b = new Bundle();
        b.putString("com.symbol.datawedge.api.APPLICATION_NAME", settings.mPackageName);
        b.putString("com.symbol.datawedge.api.NOTIFICATION_TYPE", "SCANNER_STATUS");
        Intent i = new Intent();
        i.setAction("com.symbol.datawedge.api.ACTION");
        i.putExtra("com.symbol.datawedge.api.REGISTER_FOR_NOTIFICATION", b);
        this.mContext.getApplicationContext().sendBroadcast(i);
    }

    protected void unRegisterForScannerStatus(DWStatusScannerSettings settings) {
        Log.d((String)TAG, (String)"Scanner Receiver: unRegisterForScannerStatus");
        Bundle b = new Bundle();
        b.putString("com.symbol.datawedge.api.APPLICATION_NAME", settings.mPackageName);
        b.putString("com.symbol.datawedge.api.NOTIFICATION_TYPE", "SCANNER_STATUS");
        Intent i = new Intent();
        i.setAction("com.symbol.datawedge.api.ACTION");
        i.putExtra("com.symbol.datawedge.api.UNREGISTER_FOR_NOTIFICATION", b);
        this.mContext.getApplicationContext().sendBroadcast(i);
    }

    void registerNotificationReceiver() {
        if (this.mStatusSettings.mUseSeparateThread) {
            this.QuitReceiverThreadNicely();
            Log.d((String)TAG, (String)"registerNotificationReceiver()");
            this.broadcastReceiverThread = new HandlerThread(this.mStatusSettings.mPackageName + ".NOTIFICATION.THREAD");
            this.broadcastReceiverThread.start();
            this.broadcastReceiverThreadLooper = this.broadcastReceiverThread.getLooper();
            this.broadcastReceiverHandler = new Handler(this.broadcastReceiverThreadLooper);
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.symbol.datawedge.api.NOTIFICATION_ACTION");
            this.mContext.registerReceiver((BroadcastReceiver)this.mStatusBroadcastReceiver, filter, null, this.broadcastReceiverHandler);
        } else {
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.symbol.datawedge.api.NOTIFICATION_ACTION");
            this.mContext.registerReceiver((BroadcastReceiver)this.mStatusBroadcastReceiver, filter);
        }
    }

    void unRegisterNotificationReceiver() {
        if (this.mStatusSettings.mUseSeparateThread) {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mStatusBroadcastReceiver);
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)"registerNotificationReceiver(): Trying to unregister a receiver that has not been previously released..");
                Log.d((String)TAG, (String)"registerNotificationReceiver(): Status receiver should be started before trying to stop it.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.QuitReceiverThreadNicely();
        } else {
            try {
                this.mContext.unregisterReceiver((BroadcastReceiver)this.mStatusBroadcastReceiver);
            }
            catch (IllegalArgumentException e) {
                Log.d((String)TAG, (String)"registerNotificationReceiver(): Trying to unregister a receiver that has not been previously released..");
                Log.d((String)TAG, (String)"registerNotificationReceiver(): Status receiver should be started before trying to stop it.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void QuitReceiverThreadNicely() {
        Log.d((String)TAG, (String)"QuitReceiverThreadNicely()");
        if (this.broadcastReceiverHandler != null) {
            try {
                Log.d((String)TAG, (String)"QuitReceiverThreadNicely():broadcastReceiverHandler.removeCallbacksAndMessages(null)");
                this.broadcastReceiverHandler.removeCallbacksAndMessages(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.broadcastReceiverHandler = null;
            if (this.broadcastReceiverThreadLooper != null) {
                try {
                    Log.d((String)TAG, (String)"QuitReceiverThreadNicely():broadcastReceiverThreadLooper.quit()");
                    this.broadcastReceiverThreadLooper.quit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.broadcastReceiverThreadLooper = null;
            }
            if (this.broadcastReceiverThread != null) {
                try {
                    Log.d((String)TAG, (String)"QuitReceiverThreadNicely():broadcastReceiverThread.quit()");
                    this.broadcastReceiverThread.quit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.broadcastReceiverThread = null;
            }
        }
    }

    protected class dataWedgeScannerStatusReceiver
    extends BroadcastReceiver {
        protected dataWedgeScannerStatusReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Bundle b;
            String NOTIFICATION_TYPE;
            String action = intent.getAction();
            if (action.equals("com.symbol.datawedge.api.NOTIFICATION_ACTION") && intent.hasExtra("com.symbol.datawedge.api.NOTIFICATION") && (NOTIFICATION_TYPE = (b = intent.getBundleExtra("com.symbol.datawedge.api.NOTIFICATION")).getString("NOTIFICATION_TYPE")) != null) {
                switch (NOTIFICATION_TYPE) {
                    case "SCANNER_STATUS": {
                        String status = b.getString("STATUS");
                        if (status == null) break;
                        ((DWStatusScanner)DWStatusScanner.this).mStatusSettings.mScannerCallback.result(status);
                    }
                }
            }
        }
    }
}

