/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.zebra.datawedgeprofileintents.DWProfileBase;
import com.zebra.datawedgeprofileintents.DWProfileBaseSettings;

public class DWScannerPluginStatus
extends DWProfileBase {
    private Handler broadcastReceiverHandler = null;
    private HandlerThread broadcastReceiverThread = null;
    private Looper broadcastReceiverThreadLooper = null;
    private onScannerPluginStatus mScannerPluginStatusCallback = null;
    private pluginStatusReceiver mBroadcastReceiver = new pluginStatusReceiver();

    public DWScannerPluginStatus(Context aContext) {
        super(aContext);
    }

    public void execute(DWProfileBaseSettings settings, onScannerPluginStatus callback) {
        super.execute(settings);
        this.mScannerPluginStatusCallback = callback;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.symbol.datawedge.api.RESULT_ACTION");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        this.broadcastReceiverThread = new HandlerThread(settings.mProfileName.isEmpty() ? this.mContext.getPackageName() : settings.mProfileName + ".GETSTATUS.THREAD");
        this.broadcastReceiverThread.start();
        this.broadcastReceiverThreadLooper = this.broadcastReceiverThread.getLooper();
        this.broadcastReceiverHandler = new Handler(this.broadcastReceiverThreadLooper);
        this.mContext.registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, intentFilter, null, this.broadcastReceiverHandler);
        this.sendDataWedgeIntentWithExtra("com.symbol.datawedge.api.ACTION", "com.symbol.datawedge.api.GET_DATAWEDGE_STATUS", "");
    }

    @Override
    protected void cleanAll() {
        this.mSettings.mProfileName = "";
        this.mScannerPluginStatusCallback = null;
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
        if (this.broadcastReceiverThread != null) {
            this.broadcastReceiverThreadLooper.quit();
            this.broadcastReceiverThreadLooper = null;
            this.broadcastReceiverThread = null;
            this.broadcastReceiverHandler = null;
        }
        super.cleanAll();
    }

    @Override
    protected void onTimeOut() {
        if (this.mScannerPluginStatusCallback != null) {
            this.mScannerPluginStatusCallback.timeOut(this.mSettings.mProfileName);
            this.cleanAll();
        }
    }

    private class pluginStatusReceiver
    extends BroadcastReceiver {
        private pluginStatusReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra("com.symbol.datawedge.api.RESULT_GET_DATAWEDGE_STATUS")) {
                String status = intent.getStringExtra("com.symbol.datawedge.api.RESULT_GET_DATAWEDGE_STATUS");
                boolean enabled = status.equalsIgnoreCase("enabled");
                if (DWScannerPluginStatus.this.mScannerPluginStatusCallback != null) {
                    DWScannerPluginStatus.this.mScannerPluginStatusCallback.result(DWScannerPluginStatus.this.mSettings.mProfileName, enabled);
                    DWScannerPluginStatus.this.cleanAll();
                }
            }
        }
    }

    public static interface onScannerPluginStatus {
        public void result(String var1, boolean var2);

        public void timeOut(String var1);
    }
}

