/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

public class DWScanReceiver {
    private String mIntentAction = "";
    private String mIntentCategory = "";
    private boolean mShowSpecialCharacters = false;
    private IntentFilter mIntentFilter = null;
    private Context mContext = null;
    private onScannedData mOnScannedDataCallback = null;
    private BroadcastReceiver mMessageReceiver = null;
    private boolean mUseSeparateThread = false;
    private Handler mBroadcastReceiverHandler = null;
    private HandlerThread mBroadcastReceiverThread = null;
    private Looper mBroadcastReceiverThreadLooper = null;

    public DWScanReceiver(Context myContext, String intentAction, String intentCategory, boolean showSpecialChars, onScannedData scannedDataCallback) {
        this.mIntentAction = intentAction != null && !intentAction.isEmpty() ? intentAction : myContext.getPackageName().toString() + ".RECVR";
        this.mIntentCategory = intentCategory != null && !intentCategory.isEmpty() ? intentCategory : "android.intent.category.DEFAULT";
        this.mContext = myContext;
        this.mOnScannedDataCallback = scannedDataCallback;
        this.mShowSpecialCharacters = showSpecialChars;
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction(this.mIntentAction);
        this.mIntentFilter.addCategory(this.mIntentCategory);
        this.mMessageReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                DWScanReceiver.this.handleDecodeData(intent);
            }
        };
    }

    public DWScanReceiver(Context myContext, String intentAction, String intentCategory, boolean showSpecialChars, onScannedData scannedDataCallback, boolean useSeparateThread) {
        this.mIntentAction = intentAction;
        this.mIntentCategory = intentCategory;
        this.mContext = myContext;
        this.mOnScannedDataCallback = scannedDataCallback;
        this.mShowSpecialCharacters = showSpecialChars;
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction(this.mIntentAction);
        this.mIntentFilter.addCategory(this.mIntentCategory);
        this.mUseSeparateThread = useSeparateThread;
        this.mMessageReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                DWScanReceiver.this.handleDecodeData(intent);
            }
        };
    }

    public void startReceive() {
        if (this.mUseSeparateThread) {
            try {
                this.mBroadcastReceiverThread = new HandlerThread(this.mContext.getPackageName() + ".SCANNER.THREAD");
                this.mBroadcastReceiverThread.start();
                this.mBroadcastReceiverThreadLooper = this.mBroadcastReceiverThread.getLooper();
                this.mBroadcastReceiverHandler = new Handler(this.mBroadcastReceiverThreadLooper);
                this.mContext.registerReceiver(this.mMessageReceiver, this.mIntentFilter, null, this.mBroadcastReceiverHandler);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.cleanReceiverThread();
            }
        } else {
            this.mContext.registerReceiver(this.mMessageReceiver, this.mIntentFilter);
        }
    }

    public void stopReceive() {
        try {
            if (this.mBroadcastReceiverThread != null) {
                this.cleanReceiverThread();
                this.mContext.unregisterReceiver(this.mMessageReceiver);
            } else {
                this.mContext.unregisterReceiver(this.mMessageReceiver);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void cleanReceiverThread() {
        if (this.mUseSeparateThread && this.mBroadcastReceiverThread != null) {
            if (this.mBroadcastReceiverHandler != null) {
                this.mBroadcastReceiverHandler.removeCallbacksAndMessages(null);
                this.mBroadcastReceiverHandler = null;
            }
            if (this.mBroadcastReceiverThreadLooper != null) {
                this.mBroadcastReceiverThreadLooper.quit();
                this.mBroadcastReceiverThreadLooper = null;
            }
            if (this.mBroadcastReceiverThread != null) {
                this.mBroadcastReceiverThread.quit();
                this.mBroadcastReceiverThread = null;
            }
        }
    }

    private boolean handleDecodeData(Intent i) {
        if (i.getAction().contentEquals(this.mIntentAction)) {
            String out = "";
            String source = i.getStringExtra("com.motorolasolutions.emdk.datawedge.source");
            if (source == null) {
                source = "scanner";
            }
            String data = i.getStringExtra("com.motorolasolutions.emdk.datawedge.data_string");
            String sLabelType = null;
            if (source.equalsIgnoreCase("scanner") && data != null && data.length() > 0) {
                sLabelType = i.getStringExtra("com.motorolasolutions.emdk.datawedge.label_type");
                sLabelType = sLabelType != null && sLabelType.length() > 0 ? sLabelType.substring(11) : "Unknown";
            }
            if (data != null && this.mShowSpecialCharacters) {
                data = this.showSpecialChars(data);
            }
            if (this.mOnScannedDataCallback != null) {
                this.mOnScannedDataCallback.scannedData(source, data, sLabelType);
            }
            return true;
        }
        return false;
    }

    private String showSpecialChars(String data) {
        char[] dataChar;
        String returnString = "";
        for (char acar : dataChar = data.toCharArray()) {
            returnString = !Character.isISOControl(acar) ? returnString + acar : returnString + "[" + acar + "]";
        }
        return returnString;
    }

    public static interface onScannedData {
        public void scannedData(String var1, String var2, String var3);
    }
}

