/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.widget.Toast;
import com.zebra.datawedgeprofileenums.MB_E_CONFIG_MODE;
import com.zebra.datawedgeprofileintents.DWProfileCommandBase;
import com.zebra.datawedgeprofileintents.DWProfileSetConfigSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DWProfileSetConfig
extends DWProfileCommandBase {
    private DWProfileSetConfigSettings mBaseSettings = new DWProfileSetConfigSettings();

    public DWProfileSetConfig(Context aContext) {
        super(aContext);
    }

    public void execute(DWProfileSetConfigSettings settings, DWProfileCommandBase.onProfileCommandResult callback) {
        super.execute(settings, callback);
        this.setProfileConfig(settings);
    }

    private void setProfileConfig(DWProfileSetConfigSettings settings) {
        Bundle profileConfig = new Bundle();
        if (settings.mProfileName != null) {
            profileConfig.putString("PROFILE_NAME", settings.mProfileName);
        }
        if (settings.MainBundle.PROFILE_ENABLED != null) {
            profileConfig.putString("PROFILE_ENABLED", settings.MainBundle.PROFILE_ENABLED != false ? "true" : "false");
        }
        if (settings.MainBundle.CONFIG_MODE != null) {
            profileConfig.putString("CONFIG_MODE", settings.MainBundle.CONFIG_MODE.toString());
        }
        if (settings.MainBundle.CONFIG_MODE != MB_E_CONFIG_MODE.UPDATE && !settings.IntentPlugin.use_component) {
            if (settings.MainBundle.APP_LIST == null || settings.MainBundle.APP_LIST.size() == 0) {
                Bundle appConfig = new Bundle();
                appConfig.putString("PACKAGE_NAME", this.mContext.getPackageName());
                appConfig.putStringArray("ACTIVITY_LIST", new String[]{"*"});
                profileConfig.putParcelableArray("APP_LIST", (Parcelable[])new Bundle[]{appConfig});
            } else {
                Bundle[] appConfigs = new Bundle[settings.MainBundle.APP_LIST.size()];
                int index = 0;
                for (Map.Entry<String, List<String>> packageDescription : settings.MainBundle.APP_LIST.entrySet()) {
                    Bundle appConfig = new Bundle();
                    appConfig.putString("PACKAGE_NAME", packageDescription.getKey());
                    List<String> activityList = packageDescription.getValue();
                    if (activityList == null || activityList.size() == 0) {
                        appConfig.putStringArray("ACTIVITY_LIST", new String[]{"*"});
                    } else {
                        appConfig.putStringArray("ACTIVITY_LIST", (String[])activityList.toArray());
                    }
                    appConfigs[index] = appConfig;
                    ++index;
                }
                profileConfig.putParcelableArray("APP_LIST", (Parcelable[])appConfigs);
            }
        }
        ArrayList<Bundle> pluginConfigs = new ArrayList<Bundle>();
        try {
            pluginConfigs.add(settings.ScannerPlugin.getBarcodePluginBundleForSetConfig(true));
        }
        catch (Exception e) {
            e.printStackTrace();
            Toast.makeText((Context)this.mContext, (CharSequence)e.getMessage(), (int)1);
            System.exit(0);
        }
        pluginConfigs.add(settings.KeystrokePlugin.getKeyStrokePluginBundle(true));
        pluginConfigs.add(settings.BasicDataFormatting.getBDFPluginBundle(true, "INTENT"));
        pluginConfigs.add(settings.IntentPlugin.getIntentPluginBundle(true, this.mContext));
        profileConfig.putParcelableArrayList("PLUGIN_CONFIG", pluginConfigs);
        String jsonwn = DWProfileSetConfigSettings.toJsonWN(settings);
        this.sendDataWedgeIntentWithExtraRequestResult("com.symbol.datawedge.api.ACTION", "com.symbol.datawedge.api.SET_CONFIG", profileConfig);
    }
}

