/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.zebra.datawedgeprofileintents.DWProfileBase;
import com.zebra.datawedgeprofileintents.DWProfileBaseSettings;
import java.util.Date;
import java.util.Set;

public class DWProfileCommandBase
extends DWProfileBase {
    private Handler broadcastReceiverHandler = null;
    private HandlerThread broadcastReceiverThread = null;
    private Looper broadcastReceiverThreadLooper = null;
    protected String mCommandIdentifier = "";
    private onProfileCommandResult mProfileCommandCallback = null;
    private dataWedgeActionResultReceiver mBroadcastReceiver = new dataWedgeActionResultReceiver();

    public DWProfileCommandBase(Context aContext) {
        super(aContext);
    }

    protected void execute(DWProfileBaseSettings settings, onProfileCommandResult callback) {
        super.execute(settings);
        this.mProfileCommandCallback = callback;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.symbol.datawedge.api.RESULT_ACTION");
        intentFilter.addCategory("android.intent.category.DEFAULT");
        this.broadcastReceiverThread = new HandlerThread(settings.mProfileName + ".THREAD");
        this.broadcastReceiverThread.start();
        this.broadcastReceiverThreadLooper = this.broadcastReceiverThread.getLooper();
        this.broadcastReceiverHandler = new Handler(this.broadcastReceiverThreadLooper);
        this.mContext.registerReceiver((BroadcastReceiver)this.mBroadcastReceiver, intentFilter, null, this.broadcastReceiverHandler);
    }

    protected void sendDataWedgeIntentWithExtraRequestResult(String action, String extraKey, String extraValue) {
        Intent dwIntent = new Intent();
        dwIntent.setAction(action);
        dwIntent.putExtra(extraKey, extraValue);
        dwIntent.putExtra("SEND_RESULT", "true");
        this.mCommandIdentifier = this.mSettings.mProfileName + new Date().getTime();
        dwIntent.putExtra("COMMAND_IDENTIFIER", this.mCommandIdentifier);
        this.mContext.sendBroadcast(dwIntent);
    }

    protected void sendDataWedgeIntentWithExtraRequestResult(String action, String extraKey, boolean extraValue) {
        Intent dwIntent = new Intent();
        dwIntent.setAction(action);
        dwIntent.putExtra(extraKey, extraValue);
        dwIntent.putExtra("SEND_RESULT", "true");
        this.mCommandIdentifier = this.mSettings.mProfileName + new Date().getTime();
        dwIntent.putExtra("COMMAND_IDENTIFIER", this.mCommandIdentifier);
        this.mContext.sendBroadcast(dwIntent);
    }

    protected void sendDataWedgeIntentWithExtraRequestResult(String action, String extraKey, Bundle extras) {
        Intent dwIntent = new Intent();
        dwIntent.setAction(action);
        dwIntent.putExtra(extraKey, extras);
        dwIntent.putExtra("SEND_RESULT", "true");
        this.mCommandIdentifier = this.mSettings.mProfileName + new Date().getTime();
        dwIntent.putExtra("COMMAND_IDENTIFIER", this.mCommandIdentifier);
        this.mContext.sendBroadcast(dwIntent);
    }

    @Override
    protected void cleanAll() {
        this.mProfileCommandCallback = null;
        this.mContext.unregisterReceiver((BroadcastReceiver)this.mBroadcastReceiver);
        if (this.broadcastReceiverThread != null) {
            this.broadcastReceiverThreadLooper.quit();
            this.broadcastReceiverThreadLooper = null;
            this.broadcastReceiverThread = null;
            this.broadcastReceiverHandler = null;
        }
        super.cleanAll();
    }

    @Override
    protected void onTimeOut() {
        if (this.mProfileCommandCallback != null) {
            this.mProfileCommandCallback.timeout(this.mSettings.mProfileName);
            this.cleanAll();
        }
    }

    protected class dataWedgeActionResultReceiver
    extends BroadcastReceiver {
        protected dataWedgeActionResultReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equalsIgnoreCase("com.symbol.datawedge.api.RESULT_ACTION")) {
                String action = intent.getAction();
                String command = intent.getStringExtra("COMMAND");
                String commandidentifier = intent.getStringExtra("COMMAND_IDENTIFIER");
                String result = intent.getStringExtra("RESULT");
                if (commandidentifier == null) {
                    return;
                }
                Bundle bundle = new Bundle();
                String resultInfo = "";
                if (intent.hasExtra("RESULT_INFO")) {
                    bundle = intent.getBundleExtra("RESULT_INFO");
                    Set keys = bundle.keySet();
                    for (String key : keys) {
                        String value = "";
                        if (bundle.getString(key) != null) {
                            value = bundle.getString(key);
                        } else if (bundle.getStringArray(key) != null) {
                            for (String innerString : bundle.getStringArray(key)) {
                                value = value + innerString + ";";
                            }
                        }
                        if (resultInfo.length() > 0 && value != null) {
                            resultInfo = resultInfo + "\n";
                        }
                        if (value != null) {
                            resultInfo = resultInfo + key + ": " + value;
                        }
                        if (!key.equalsIgnoreCase("PROFILE_NAME") || value.equalsIgnoreCase(DWProfileCommandBase.this.mSettings.mProfileName)) continue;
                        resultInfo = resultInfo + "\n-> active profile differs from expected profile " + DWProfileCommandBase.this.mSettings.mProfileName;
                    }
                }
                String text = "Action: " + action + "\nCommand: " + command + "\nResult: " + result + "\nResult Info: " + resultInfo + "\nCID:" + commandidentifier;
                Log.d((String)DWProfileBase.TAG, (String)text);
                if (!commandidentifier.equalsIgnoreCase(DWProfileCommandBase.this.mCommandIdentifier)) {
                    return;
                }
                if (DWProfileCommandBase.this.mProfileCommandCallback != null) {
                    DWProfileCommandBase.this.mProfileCommandCallback.result(DWProfileCommandBase.this.mSettings.mProfileName, action, command, result, resultInfo, commandidentifier);
                    DWProfileCommandBase.this.cleanAll();
                }
            }
        }
    }

    public static interface onProfileCommandResult {
        public void result(String var1, String var2, String var3, String var4, String var5, String var6);

        public void timeout(String var1);
    }
}

