/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.datawedgeprofileintents;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import com.zebra.datawedgeprofileintents.DWProfileBaseSettings;

public abstract class DWProfileBase {
    protected static String TAG = "DWINTENTSAPI";
    protected Context mContext = null;
    protected DWProfileBaseSettings mSettings = null;
    protected Handler mTimeOutHandler = new Handler();
    protected Runnable mTimeOutRunnable = new Runnable(){

        @Override
        public void run() {
            DWProfileBase.this.onTimeOut();
        }
    };

    public DWProfileBase(Context aContext) {
        this.mContext = aContext;
    }

    protected void sendDataWedgeIntentWithExtra(String action, String extraKey, String extraValue) {
        Intent dwIntent = new Intent();
        dwIntent.setAction(action);
        dwIntent.putExtra(extraKey, extraValue);
        this.mContext.sendBroadcast(dwIntent);
    }

    protected void sendDataWedgeIntentWithExtra(String action, String extraKey, String[] extraValues) {
        Intent dwIntent = new Intent();
        dwIntent.setAction(action);
        dwIntent.putExtra(extraKey, extraValues);
        this.mContext.sendBroadcast(dwIntent);
    }

    protected void sendDataWedgeIntentWithExtra(String action, String extraKey, Bundle extras) {
        Intent dwIntent = new Intent();
        dwIntent.setAction(action);
        dwIntent.putExtra(extraKey, extras);
        this.mContext.sendBroadcast(dwIntent);
    }

    protected void execute(DWProfileBaseSettings settings) {
        this.mSettings = settings;
        if (settings != null && settings.mEnableTimeOutMechanism) {
            this.mTimeOutHandler.postDelayed(this.mTimeOutRunnable, this.mSettings.mTimeOutMS);
        }
    }

    protected abstract void onTimeOut();

    protected void cleanAll() {
        if (this.mTimeOutHandler != null) {
            this.mTimeOutHandler.removeCallbacks(this.mTimeOutRunnable);
        }
    }
}

