/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.criticalpermissionshelper;

import android.content.Context;
import android.content.UriPermission;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.net.Uri;
import com.zebra.criticalpermissionshelper.EPermissionType;
import com.zebra.criticalpermissionshelper.GrantContentPermission;
import com.zebra.criticalpermissionshelper.IResultCallbacks;
import com.zebra.criticalpermissionshelper.ProfileManagerCommand;
import java.util.Base64;
import java.util.List;

public class CriticalPermissionsHelper {
    public static Signature apkCertificate = null;
    public static final long SEC_IN_MS = 1000L;
    public static final long MIN_IN_MS = 60000L;
    public static long MAX_EMDK_TIMEOUT_IN_MS = 600000L;
    public static long WAIT_PERIOD_BEFORE_RETRY_EMDK_RETRIEVAL_IN_MS = 2000L;

    public static void grantPermission(Context context, EPermissionType permissionType, IResultCallbacks callbackInterface) {
        CriticalPermissionsHelper.executeAccessMgrPermissionCommand(context, EPermissionAccessAction.GRANT_PERMISSION, permissionType, callbackInterface);
    }

    public static void denyPermission(Context context, EPermissionType permissionType, IResultCallbacks callbackInterface) {
        CriticalPermissionsHelper.executeAccessMgrPermissionCommand(context, EPermissionAccessAction.DENY_PERMISSION, permissionType, callbackInterface);
    }

    public static void allowUserToChoosePermission(Context context, EPermissionType permissionType, IResultCallbacks callbackInterface) {
        CriticalPermissionsHelper.executeAccessMgrPermissionCommand(context, EPermissionAccessAction.ALLOW_USER_TO_CHOOSE, permissionType, callbackInterface);
    }

    public static void verifyPermission(Context context, EPermissionType permissionType, final IResultCallbacks callbackInterface) {
        CriticalPermissionsHelper.executeAccessMgrPermissionCommand(context, EPermissionAccessAction.VERIFY, permissionType, new IResultCallbacks(){

            @Override
            public void onSuccess(String message, String resultXML) {
                String toParse = resultXML;
                callbackInterface.onSuccess(message, resultXML);
            }

            @Override
            public void onError(String message, String resultXML) {
                callbackInterface.onError(message, resultXML);
            }

            @Override
            public void onDebugStatus(String message) {
                callbackInterface.onDebugStatus(message);
            }
        });
    }

    public static void grantFileOrFolderAcessPermission(Context context, Uri uriToAllow, IResultCallbacks callbackInterface) {
        new GrantContentPermission().execute(new Object[]{context, uriToAllow, callbackInterface});
    }

    public static boolean hasAccessPermissions(Context context, Uri uriToCheck) {
        boolean hasAccessToSpecialFolder = false;
        List uriPermissions = context.getContentResolver().getPersistedUriPermissions();
        if (uriPermissions != null && uriPermissions.size() > 0) {
            for (UriPermission p : uriPermissions) {
                if (!p.isReadPermission() || !p.equals(uriToCheck)) continue;
                hasAccessToSpecialFolder = true;
                break;
            }
        }
        return hasAccessToSpecialFolder;
    }

    private static void executeAccessMgrPermissionCommand(Context context, EPermissionAccessAction permissionAccessAction, EPermissionType permissionType, IResultCallbacks callbackInterface) {
        block4: {
            String profileName = "AccessMgr-1";
            String profileData = "";
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0x8000000);
                String path = context.getApplicationInfo().sourceDir;
                String strName = packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
                String strVendor = packageInfo.packageName;
                Signature sig = apkCertificate;
                if (sig == null) {
                    Signature[] arrSignatures = packageInfo.signingInfo.getApkContentsSigners();
                    if ((arrSignatures == null || arrSignatures.length == 0) && callbackInterface != null) {
                        callbackInterface.onError("Error : Package has no signing certificates... how's that possible ?", "");
                        return;
                    }
                    sig = arrSignatures[0];
                }
                byte[] rawCert = sig.toByteArray();
                String encoded = Base64.getEncoder().encodeToString(rawCert);
                profileData = "<?xml version=\"1.0\" encoding=\"utf-8\"?><characteristic type=\"Profile\"><parm name=\"ProfileName\" value=\"" + profileName + "\"/><characteristic type=\"AccessMgr\" version=\"11.3\"><parm name=\"PermissionAccessAction\" value=\"" + permissionAccessAction.toString() + "\" /><parm name=\"PermissionAccessPackageName\" value=\"" + context.getPackageName() + "\" /><parm name=\"PermissionAccessPermissionName\" value=\"" + permissionType.toString() + "\" />\n<parm name=\"PermissionAccessSignature\" value=\"" + encoded + "\" /></characteristic></characteristic>";
                ProfileManagerCommand profileManagerCommand = new ProfileManagerCommand(context);
                profileManagerCommand.execute(profileData, profileName, callbackInterface);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callbackInterface == null) break block4;
                callbackInterface.onError("Error on profile: " + profileName + "\nError:" + e.getLocalizedMessage() + "\nProfileData:" + profileData, "");
            }
        }
    }

    private static enum EPermissionAccessAction {
        GRANT_PERMISSION("1"),
        DENY_PERMISSION("2"),
        ALLOW_USER_TO_CHOOSE("3"),
        VERIFY("4");

        String stringContent = "";

        private EPermissionAccessAction(String stringContent) {
            this.stringContent = stringContent;
        }

        public String toString() {
            return this.stringContent;
        }
    }
}

