/*
 * Decompiled with CFR 0.152.
 */
package com.loper7.date_time_picker.utils;

import android.os.Build;
import android.text.format.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\u0003\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lcom/loper7/date_time_picker/utils/StringUtils;", "", "()V", "conversionTime", "", "time", "", "format", "getWeek", "date_time_picker_release"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();

    private StringUtils() {
    }

    public final long conversionTime(@NotNull String time, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (Build.VERSION.SDK_INT >= 26) {
            DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern(format);
            return LocalDateTime.parse(time, ofPattern).toInstant(ZoneOffset.ofHours(8)).toEpochMilli();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.getDefault());
        try {
            long l;
            Date date = sdf.parse(time);
            return date == null ? 0L : (l = date.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static /* synthetic */ long conversionTime$default(StringUtils stringUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "yyyy-MM-dd HH:mm:ss";
        }
        return stringUtils.conversionTime(string, string2);
    }

    @NotNull
    public final String conversionTime(long time, @NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        return ((Object)DateFormat.format((CharSequence)format, (long)time)).toString();
    }

    public static /* synthetic */ String conversionTime$default(StringUtils stringUtils, long l, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        return stringUtils.conversionTime(l, string);
    }

    @NotNull
    public final String getWeek(long time) {
        String string;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(time);
        int n = c.get(7);
        switch (n) {
            case 1: {
                string = "\u5468\u65e5";
                break;
            }
            case 2: {
                string = "\u5468\u4e00";
                break;
            }
            case 3: {
                string = "\u5468\u4e8c";
                break;
            }
            case 4: {
                string = "\u5468\u4e09";
                break;
            }
            case 5: {
                string = "\u5468\u56db";
                break;
            }
            case 6: {
                string = "\u5468\u4e94";
                break;
            }
            case 7: {
                string = "\u5468\u516d";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }
}

