/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.core.joran.spi.NoAutoStart;
import com.github.loki4j.common.LokiResponse;
import com.github.loki4j.logback.AbstractHttpSender;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

@NoAutoStart
public class ApacheHttpSender
extends AbstractHttpSender {
    private int maxConnections = 1;
    private long connectionKeepAliveMs = 120000L;
    private CloseableHttpClient client;
    private Supplier<HttpPost> requestBuilder;
    private byte[] bodyBuffer = new byte[0];

    @Override
    public void start() {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(this.maxConnections);
        cm.setDefaultMaxPerRoute(this.maxConnections);
        this.client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return ApacheHttpSender.this.connectionKeepAliveMs;
            }
        }).setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout((int)this.connectionTimeoutMs).setConnectTimeout((int)this.connectionTimeoutMs).setConnectionRequestTimeout((int)this.requestTimeoutMs).build()).build();
        this.requestBuilder = () -> {
            HttpPost request = new HttpPost(this.url);
            request.addHeader("Content-Type", this.contentType);
            this.tenantId.ifPresent(tenant -> request.addHeader("X-Scope-OrgID", tenant));
            this.basicAuthToken.ifPresent(token -> request.setHeader("Authorization", "Basic " + token));
            return request;
        };
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.client.close();
        }
        catch (IOException e) {
            this.addWarn("Error while closing Apache HttpClient", e);
        }
    }

    @Override
    public LokiResponse send(ByteBuffer batch) {
        try {
            HttpPost request = this.requestBuilder.get();
            if (batch.hasArray()) {
                request.setEntity((HttpEntity)new ByteArrayEntity(batch.array(), batch.position(), batch.remaining()));
            } else {
                int len = batch.remaining();
                if (len > this.bodyBuffer.length) {
                    this.bodyBuffer = new byte[len];
                }
                batch.get(this.bodyBuffer, 0, len);
                request.setEntity((HttpEntity)new ByteArrayEntity(this.bodyBuffer, 0, len));
            }
            CloseableHttpResponse r = this.client.execute((HttpUriRequest)request);
            HttpEntity entity = r.getEntity();
            return new LokiResponse(r.getStatusLine().getStatusCode(), entity != null ? EntityUtils.toString((HttpEntity)entity) : "");
        }
        catch (Exception e) {
            throw new RuntimeException("Error while sending batch to Loki", e);
        }
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setConnectionKeepAliveMs(long connectionKeepAliveMs) {
        this.connectionKeepAliveMs = connectionKeepAliveMs;
    }
}

