/*
 * Decompiled with CFR 0.152.
 */
package ru.lliepmah.lib;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import ru.lliepmah.lib.Builder;
import ru.lliepmah.lib.DefaultViewHolder;
import ru.lliepmah.lib.ViewModelWrapper;
import ru.lliepmah.lib.exceptions.ErrorHandler;

public class UniversalAdapter
extends RecyclerView.Adapter<DefaultViewHolder> {
    private final List<ViewModelWrapper> mItems = new ArrayList<ViewModelWrapper>();
    @SuppressLint(value={"UseSparseArrays"})
    private final HashMap<Integer, Builder> mBuilders = new HashMap();

    public UniversalAdapter(Builder ... builders) {
        for (Builder builder : builders) {
            this.mBuilders.put(builder.getId(), builder);
        }
    }

    public UniversalAdapter(List<Builder> builders) {
        for (Builder builder : builders) {
            this.mBuilders.put(builder.getId(), builder);
        }
    }

    @NonNull
    public DefaultViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return this.mBuilders.get(viewType).build(parent);
    }

    public void onBindViewHolder(@NonNull DefaultViewHolder holder, int position) {
        holder.bind(this.getItem(position));
    }

    public int getItemViewType(int position) {
        return this.mItems.get(position).getBuilderId();
    }

    public int getItemCount() {
        return this.mItems.size();
    }

    public int getItemCount(Class itemClass) {
        int count = 0;
        for (ViewModelWrapper wrapper : this.mItems) {
            if (!itemClass.isInstance(wrapper.getModel())) continue;
            ++count;
        }
        return count;
    }

    public void add(int pos, ViewModelWrapper wrapper) {
        if (wrapper != null) {
            this.mItems.add(pos, wrapper);
        }
    }

    public void replace(int index, Object item, int holderId) {
        if (item != null) {
            Builder builder = this.findBuilder(holderId);
            if (!builder.getHolderClass().isInstance(item)) {
                ErrorHandler.errorBuilderCannotHandleItem(builder, item);
            }
            this.mItems.remove(index);
            this.add(index, ViewModelWrapper.build(item, holderId));
        }
    }

    public void replace(int index, Object item) {
        if (item != null) {
            this.mItems.remove(index);
            this.add(index, item);
        }
    }

    public boolean add(ViewModelWrapper wrapper) {
        return wrapper != null && this.mItems.add(wrapper);
    }

    public void add(Object item, int builderId) {
        this.add(this.mItems.size(), item, builderId);
    }

    public boolean add(Object item) {
        return this.add(this.mItems.size(), item);
    }

    public boolean add(int index, Object item) {
        if (item != null) {
            int builderId = this.findBuilderId(item);
            this.mItems.add(index, ViewModelWrapper.build(item, builderId));
            return true;
        }
        return false;
    }

    public void add(int index, Object item, int builderId) {
        if (item != null) {
            Builder builder = this.findBuilder(builderId);
            if (!builder.getHolderClass().isInstance(item)) {
                ErrorHandler.errorBuilderCannotHandleItem(builder, item);
            }
            this.mItems.add(index, ViewModelWrapper.build(item, builderId));
        }
    }

    public Object getItem(int position) {
        return this.mItems.get(position).getModel();
    }

    public void addAll(List items) {
        if (items != null && !items.isEmpty()) {
            for (Object item : items) {
                int builderId = this.findBuilderId(item);
                this.add(item, builderId);
            }
        }
    }

    public void addAll(List items, int builderId) {
        if (items != null && !items.isEmpty()) {
            Builder builder = this.findBuilder(builderId);
            Object firstItem = items.get(0);
            if (!builder.getHolderClass().isInstance(firstItem)) {
                ErrorHandler.errorBuilderCannotHandleItem(builder, firstItem);
            }
            for (Object item : items) {
                this.mItems.add(new ViewModelWrapper(item, builderId));
            }
        }
    }

    public void replaceAll(List items) {
        this.mItems.clear();
        this.addAll(items);
    }

    public void replaceAll(List items, int builderId) {
        this.mItems.clear();
        this.addAll(items, builderId);
    }

    public void addAllWrappers(List<ViewModelWrapper> items) {
        this.mItems.addAll(items);
    }

    public void replaceAllWrappers(List<ViewModelWrapper> elements) {
        this.mItems.clear();
        this.mItems.addAll(elements);
    }

    public void removeItems(int startIndex, int endIndex) {
        for (int i = startIndex; i <= endIndex; ++i) {
            this.mItems.remove(startIndex);
        }
    }

    public boolean clear() {
        if (this.mItems.isEmpty()) {
            return false;
        }
        this.mItems.clear();
        return true;
    }

    private Builder findBuilder(int builderId) {
        if (!this.mBuilders.containsKey(builderId)) {
            ErrorHandler.erroNoOneBuildersHaveId(this.mBuilders.values(), builderId);
        }
        return this.mBuilders.get(builderId);
    }

    private int findBuilderId(Object item) {
        List<Builder> builders = this.findBuilders(item);
        if (builders.isEmpty()) {
            ErrorHandler.erroNoOneBuildersHandleItem(this.mBuilders.values(), item);
        } else if (builders.size() > 1) {
            ErrorHandler.errorMoreThanOneBuildersHandleItem(builders, item);
        }
        return builders.get(0).getId();
    }

    @NonNull
    private List<Builder> findBuilders(Object item) {
        LinkedList<Builder> list = new LinkedList<Builder>();
        for (Builder builder : this.mBuilders.values()) {
            if (!builder.getHolderClass().isInstance(item)) continue;
            list.add(builder);
        }
        return list;
    }

    public int indexOf(Object searchItem) {
        for (ViewModelWrapper wrapper : this.mItems) {
            if (!searchItem.equals(wrapper.getModel())) continue;
            return this.mItems.indexOf(wrapper);
        }
        return -1;
    }
}

