/*
 * Decompiled with CFR 0.152.
 */
package com.darkprograms.speech.microphone;

import com.darkprograms.speech.microphone.Microphone;
import com.darkprograms.speech.util.Complex;
import com.darkprograms.speech.util.FFT;
import javax.sound.sampled.AudioFileFormat;

public class MicrophoneAnalyzer
extends Microphone {
    public MicrophoneAnalyzer(AudioFileFormat.Type fileType) {
        super(fileType);
    }

    public int getAudioVolume() {
        return this.getAudioVolume(100);
    }

    public int getAudioVolume(int interval) {
        return this.calculateAudioVolume(this.getNumOfBytes((double)interval / 1000.0));
    }

    private int calculateAudioVolume(int numOfBytes) {
        byte[] data = this.getBytes(numOfBytes);
        if (data == null) {
            return -1;
        }
        return MicrophoneAnalyzer.calculateRMSLevel(data);
    }

    public static int calculateRMSLevel(byte[] audioData) {
        long lSum = 0L;
        for (int i = 0; i < audioData.length; ++i) {
            lSum += (long)audioData[i];
        }
        double dAvg = lSum / (long)audioData.length;
        double sumMeanSquare = 0.0;
        for (int j = 0; j < audioData.length; ++j) {
            sumMeanSquare += Math.pow((double)audioData[j] - dAvg, 2.0);
        }
        double averageMeanSquare = sumMeanSquare / (double)audioData.length;
        return (int)(Math.pow(averageMeanSquare, 0.5) + 0.5);
    }

    public int getNumOfBytes(int seconds) {
        return this.getNumOfBytes((double)seconds);
    }

    public int getNumOfBytes(double seconds) {
        return (int)(seconds * (double)this.getAudioFormat().getSampleRate() * (double)this.getAudioFormat().getFrameSize() + 0.5);
    }

    private byte[] getBytes(int numOfBytes) {
        if (this.getTargetDataLine() != null) {
            byte[] data = new byte[numOfBytes];
            this.getTargetDataLine().read(data, 0, numOfBytes);
            return data;
        }
        return null;
    }

    public int getFrequency() {
        try {
            return this.getFrequency(4096);
        }
        catch (Exception e) {
            return -666;
        }
    }

    public int getFrequency(int numOfBytes) throws Exception {
        if (this.getTargetDataLine() == null) {
            return -1;
        }
        byte[] data = new byte[numOfBytes + 1];
        this.getTargetDataLine().read(data, 0, numOfBytes);
        return this.getFrequency(data);
    }

    public int getFrequency(byte[] bytes) {
        double[] audioData = this.bytesToDoubleArray(bytes);
        audioData = this.applyHanningWindow(audioData);
        Complex[] complex = new Complex[audioData.length];
        for (int i = 0; i < complex.length; ++i) {
            complex[i] = new Complex(audioData[i], 0.0);
        }
        Complex[] fftTransformed = FFT.fft(complex);
        return this.calculateFundamentalFrequency(fftTransformed, 4);
    }

    private double[] applyHanningWindow(double[] data) {
        return this.applyHanningWindow(data, 0, data.length);
    }

    private double[] applyHanningWindow(double[] signal_in, int pos, int size) {
        for (int i = pos; i < pos + size; ++i) {
            int j = i - pos;
            signal_in[i] = signal_in[i] * 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)j / (double)size));
        }
        return signal_in;
    }

    private int calculateFundamentalFrequency(Complex[] fftData, int N) {
        if (N <= 0 || fftData == null) {
            return -1;
        }
        int LENGTH = fftData.length;
        fftData = this.removeNegativeFrequencies(fftData);
        Complex[][] data = new Complex[N][fftData.length / N];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                data[i][j] = fftData[j * (i + 1)];
            }
        }
        Complex[] result = new Complex[fftData.length / N];
        for (int i = 0; i < result.length; ++i) {
            Complex tmp = new Complex(1.0, 0.0);
            for (int j = 0; j < N; ++j) {
                tmp = tmp.times(data[j][i]);
            }
            result[i] = tmp;
        }
        int index = this.findMaxMagnitude(result);
        return index * this.getFFTBinSize(LENGTH);
    }

    private Complex[] removeNegativeFrequencies(Complex[] c) {
        Complex[] out = new Complex[c.length / 2];
        for (int i = 0; i < out.length; ++i) {
            out[i] = c[i];
        }
        return out;
    }

    private int getFFTBinSize(int fftDataLength) {
        return (int)((double)(this.getAudioFormat().getSampleRate() / (float)fftDataLength) + 0.5);
    }

    private int findMaxMagnitude(Complex[] input) {
        double max = Double.MIN_VALUE;
        int index = -1;
        for (int i = 0; i < input.length; ++i) {
            Complex c = input[i];
            double tmp = c.getMagnitude();
            if (!(tmp > max)) continue;
            max = tmp;
            index = i;
        }
        return index;
    }

    private double[] bytesToDoubleArray(byte[] bufferData) {
        int bytesRecorded = bufferData.length;
        int bytesPerSample = this.getAudioFormat().getSampleSizeInBits() / 8;
        double amplification = 100.0;
        double[] micBufferData = new double[bytesRecorded - bytesPerSample + 1];
        int index = 0;
        int floatIndex = 0;
        while (index < bytesRecorded - bytesPerSample + 1) {
            double sample32;
            double sample = 0.0;
            for (int b = 0; b < bytesPerSample; ++b) {
                int v = bufferData[index + b];
                if (b < bytesPerSample - 1 || bytesPerSample == 1) {
                    v &= 0xFF;
                }
                sample += (double)(v << b * 8);
            }
            micBufferData[floatIndex] = sample32 = 100.0 * (sample / 32768.0);
            index += bytesPerSample;
            ++floatIndex;
        }
        return micBufferData;
    }
}

