/*
 * Decompiled with CFR 0.152.
 */
package com.darkprograms.speech.microphone;

import java.io.Closeable;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class Microphone
implements Closeable {
    private TargetDataLine targetDataLine;
    CaptureState state;
    private AudioFileFormat.Type fileType;
    private File audioFile;

    public CaptureState getState() {
        return this.state;
    }

    private void setState(CaptureState state) {
        this.state = state;
    }

    public File getAudioFile() {
        return this.audioFile;
    }

    public void setAudioFile(File audioFile) {
        this.audioFile = audioFile;
    }

    public AudioFileFormat.Type getFileType() {
        return this.fileType;
    }

    public void setFileType(AudioFileFormat.Type fileType) {
        this.fileType = fileType;
    }

    public TargetDataLine getTargetDataLine() {
        return this.targetDataLine;
    }

    public void setTargetDataLine(TargetDataLine targetDataLine) {
        this.targetDataLine = targetDataLine;
    }

    public Microphone(AudioFileFormat.Type fileType) {
        this.setState(CaptureState.CLOSED);
        this.setFileType(fileType);
        this.initTargetDataLine();
    }

    private void initTargetDataLine() {
        DataLine.Info dataLineInfo = new DataLine.Info(TargetDataLine.class, this.getAudioFormat());
        try {
            this.setTargetDataLine((TargetDataLine)AudioSystem.getLine(dataLineInfo));
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            return;
        }
    }

    public void captureAudioToFile(File audioFile) throws LineUnavailableException {
        this.setState(CaptureState.STARTING_CAPTURE);
        this.setAudioFile(audioFile);
        if (this.getTargetDataLine() == null) {
            this.initTargetDataLine();
        }
        new Thread(new CaptureThread()).start();
    }

    public void captureAudioToFile(String audioFile) throws LineUnavailableException {
        File file = new File(audioFile);
        this.captureAudioToFile(file);
    }

    public AudioFormat getAudioFormat() {
        float sampleRate = 8000.0f;
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    public void open() {
        if (this.getTargetDataLine() == null) {
            this.initTargetDataLine();
        }
        if (!(this.getTargetDataLine().isOpen() || this.getTargetDataLine().isRunning() || this.getTargetDataLine().isActive())) {
            try {
                this.setState(CaptureState.PROCESSING_AUDIO);
                this.getTargetDataLine().open(this.getAudioFormat());
                this.getTargetDataLine().start();
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    public void close() {
        if (this.getState() != CaptureState.CLOSED) {
            this.getTargetDataLine().stop();
            this.getTargetDataLine().close();
            this.setState(CaptureState.CLOSED);
        }
    }

    private class CaptureThread
    implements Runnable {
        private CaptureThread() {
        }

        public void run() {
            try {
                AudioFileFormat.Type fileType = Microphone.this.getFileType();
                File audioFile = Microphone.this.getAudioFile();
                Microphone.this.open();
                AudioSystem.write(new AudioInputStream(Microphone.this.getTargetDataLine()), fileType, audioFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CaptureState {
        PROCESSING_AUDIO,
        STARTING_CAPTURE,
        CLOSED;

    }
}

