/*
 * Decompiled with CFR 0.152.
 */
package com.lksnext.sqlite.impl.config;

import com.lksnext.sqlite.config.SQLitePropertyConfig;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="sqlite.builder.location")
public class SQLiteConfigImpl
implements SQLitePropertyConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLiteConfigImpl.class);
    private String databasePath;
    private URI databasePathURI;
    private String temporalPath;
    private URI temporalPathURI;
    private int maxDBCopyNumber;
    private int maxPatchNumber;
    private boolean moveDisabled;
    private boolean symLinkDisabled;

    public void setDatabasePath(String path) {
        this.databasePath = path;
    }

    public void setTemporalPath(String temporalPath) {
        this.temporalPath = temporalPath;
    }

    public URI getDatabasePath() {
        if (this.databasePathURI == null && this.databasePath != null) {
            try {
                this.databasePathURI = new URI(this.databasePath);
            }
            catch (URISyntaxException e) {
                LOGGER.error("'{}' is not a valid value for param 'location.sqlite.databasePath'.", (Object)this.databasePath, (Object)e);
            }
        }
        return this.databasePathURI;
    }

    public URI getTemporalPath() {
        if (this.temporalPathURI == null && this.temporalPath != null) {
            try {
                this.temporalPathURI = new URI(this.temporalPath);
            }
            catch (URISyntaxException e) {
                LOGGER.error("'{}' is not a valid value for param 'location.sqlite.temporalPath'.", (Object)this.temporalPath, (Object)e);
            }
        }
        return this.temporalPathURI;
    }

    public int getMaxDBCopyNumber() {
        return this.maxDBCopyNumber;
    }

    public void setMaxDBCopyNumber(int maxDBCopyNumber) {
        this.maxDBCopyNumber = maxDBCopyNumber;
    }

    public int getMaxPatchNumber() {
        return this.maxPatchNumber;
    }

    public void setMaxPatchNumber(int maxPatchNumber) {
        this.maxPatchNumber = maxPatchNumber;
    }

    public boolean isMoveDisabled() {
        return this.moveDisabled;
    }

    public void setMoveDisabled(boolean moveDisabled) {
        this.moveDisabled = moveDisabled;
    }

    public boolean isSymLinkDisabled() {
        return this.symLinkDisabled;
    }

    public void setSymLinkDisabled(boolean symLinkDisabled) {
        this.symLinkDisabled = symLinkDisabled;
    }
}

