/*
 * Decompiled with CFR 0.152.
 */
package com.lksnext.sqlite.impl;

import com.lksnext.sqlite.SQLiteDBConfigurableGenerator;
import com.lksnext.sqlite.SQLiteDBPersistManager;
import com.lksnext.sqlite.config.SQLitePropertyConfig;
import com.lksnext.sqlite.impl.definition.DatabaseDefinition;
import com.lksnext.sqlite.impl.definition.SchemaElement;
import com.lksnext.sqlite.impl.util.SQLitePathUtils;
import com.lksnext.sqlite.impl.util.SQLiteUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Service
public class SQLiteDBConfigurableGeneratorImpl
implements SQLiteDBConfigurableGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(SQLiteDBConfigurableGeneratorImpl.class);
    @Autowired
    @Qualifier(value="builderDs")
    private DataSource dataSource;
    @Autowired
    private SQLitePropertyConfig sqliteConfig;
    @Autowired
    private SQLiteDBPersistManager sqliteDBPersistManager;
    private static final String FINAL = "final";
    private static final String YML_EXT = ".yml";
    private static final String YAML_EXT = ".yaml";

    public synchronized void createDatabase(String definition, Map<String, String> context) {
        this.buildDatabase(definition, context, new HashSet<String>());
    }

    public synchronized void createDatabases(String definition, List<Map<String, String>> contexts) {
        StopWatch timing = new StopWatch("SQLite database generation");
        AtomicInteger atomicInteger = new AtomicInteger(0);
        int totalDbs = contexts.size();
        HashSet<String> avalableDatabases = new HashSet<String>();
        for (Map<String, String> context : contexts) {
            String description = context.entrySet().stream().map(x -> (String)x.getKey() + "=" + (String)x.getValue()).collect(Collectors.joining(","));
            int idx = atomicInteger.incrementAndGet();
            LOG.info("{}/{} Processing DB {}", new Object[]{idx, totalDbs, description});
            timing.start("Generate db " + description);
            this.buildDatabase(definition, context, avalableDatabases);
            timing.stop();
        }
        LOG.info("Finish SQLite database generation");
        LOG.info(timing.prettyPrint());
    }

    private String buildDatabase(String definition, Map<String, String> context, Set<String> availableDatabases) {
        DatabaseDefinition database = this.getDatabaseDefinition(definition);
        String dbName = StrSubstitutor.replace((Object)database.getDatabase(), context);
        if (availableDatabases.contains(dbName)) {
            LOG.info("Database {} is already built", (Object)dbName);
            return dbName;
        }
        if (this.isDBLocked(dbName)) {
            LOG.warn("Database {} is locked. Generation is cancelled", (Object)dbName);
            return null;
        }
        String extendsFrom = database.getExtends();
        String extendedDb = null;
        if (StringUtils.isNotEmpty((String)extendsFrom)) {
            extendedDb = this.buildDatabase(extendsFrom, context, availableDatabases);
        }
        try (Connection sqliteCon = this.createNewDatabase(extendedDb, database, context);){
            this.createLockForDB(dbName);
            for (SchemaElement table : database.getSchema()) {
                this.populateTableData(sqliteCon, table, context);
            }
            sqliteCon.commit();
            SQLiteUtils.vacuum(sqliteCon);
            sqliteCon.close();
            availableDatabases.add(dbName);
            if (FINAL.equalsIgnoreCase(database.getType())) {
                this.sqliteDBPersistManager.persist(dbName, dbName);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The file name or path is incorrect.", e);
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            throw new IllegalStateException("An error ocurred while creating the database", e);
        }
        finally {
            try {
                this.releaseLockForDB(dbName);
            }
            catch (Exception e) {
                LOG.error("Unable to remove lock for db {}", (Object)dbName, (Object)e);
            }
        }
        return dbName;
    }

    private Connection createNewDatabase(String extendedDb, DatabaseDefinition definition, Map<String, String> context) throws ClassNotFoundException, URISyntaxException, SQLException, IOException {
        String dbName = StrSubstitutor.replace((Object)definition.getDatabase(), context);
        String extendsFrom = definition.getExtends();
        if (StringUtils.isNotEmpty((String)extendsFrom)) {
            return SQLiteUtils.createNewDatabaseFrom(this.sqliteConfig.getTemporalPath(), extendedDb, dbName);
        }
        return SQLiteUtils.createNewDatabase(this.sqliteConfig.getTemporalPath(), dbName);
    }

    private DatabaseDefinition getDatabaseDefinition(String definition) {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(DatabaseDefinition.class));
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(definition + YML_EXT);
        if (inputStream == null) {
            inputStream = this.getClass().getClassLoader().getResourceAsStream(definition + YAML_EXT);
        }
        DatabaseDefinition database = (DatabaseDefinition)yaml.load(inputStream);
        return database;
    }

    private void populateTableData(Connection sqliteCon, SchemaElement table, Map<String, String> context) throws SQLException {
        String query = table.getSource();
        String cleanup = table.getCleanup();
        if (StringUtils.isNotEmpty((String)query)) {
            if (context != null) {
                SQLiteUtils.importData(this.dataSource, sqliteCon, query, table.getTable(), context);
            } else {
                SQLiteUtils.importData(this.dataSource, sqliteCon, query, table.getTable());
            }
        }
        if (StringUtils.isNotEmpty((String)cleanup)) {
            LOG.info("Cleaning table {}...", (Object)table.getTable());
            if (context != null) {
                SQLiteUtils.cleanupAction(sqliteCon, cleanup, context);
            } else {
                SQLiteUtils.cleanupAction(sqliteCon, cleanup);
            }
        }
    }

    private void createLockForDB(String dbFilename) throws URISyntaxException, IOException {
        SQLitePathUtils.createMasterdataLock(this.sqliteConfig.getDatabasePath(), dbFilename);
    }

    private void releaseLockForDB(String dbFilename) throws URISyntaxException, IOException {
        SQLitePathUtils.releaseMasterdataLock(this.sqliteConfig.getDatabasePath(), dbFilename);
    }

    private boolean isDBLocked(String dbFilename) {
        return SQLitePathUtils.isMasterdataLocked(this.sqliteConfig.getDatabasePath(), dbFilename);
    }
}

