/*
 * Decompiled with CFR 0.152.
 */
package com.lksnext.sqlite.impl.metadata;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.lksnext.sqlite.SQLiteDBCleanupStrategy;
import com.lksnext.sqlite.config.SQLitePropertyConfig;
import com.lksnext.sqlite.file.FileManager;
import com.lksnext.sqlite.impl.util.SQLitePathUtils;
import com.lksnext.sqlite.metadata.SQLiteDBFileInfo;
import com.lksnext.sqlite.metadata.SQLiteDBMetadata;
import com.lksnext.sqlite.metadata.SQLiteDBMetadataManager;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLiteDBMetadataManagerImpl
implements SQLiteDBMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(SQLiteDBMetadataManagerImpl.class);
    @Autowired
    private FileManager fileManager;
    @Autowired
    private SQLitePropertyConfig sqliteConfig;
    @Autowired(required=false)
    private List<SQLiteDBCleanupStrategy> cleanupStrategies;

    public SQLiteDBMetadata loadMetadata(String database) throws URISyntaxException, IOException {
        Gson gson = new Gson();
        URI dbsBaseDir = this.sqliteConfig.getDatabasePath();
        URI metaDataPath = SQLitePathUtils.getMasterdataMetadataPath(dbsBaseDir, database);
        boolean metadataFileExits = this.fileManager.fileExists(metaDataPath.toString());
        if (metadataFileExits) {
            try (JsonReader reader = new JsonReader((Reader)new FileReader(metaDataPath.getPath()));){
                SQLiteDBMetadata sQLiteDBMetadata = (SQLiteDBMetadata)gson.fromJson(reader, SQLiteDBMetadata.class);
                return sQLiteDBMetadata;
            }
        }
        return new SQLiteDBMetadata();
    }

    public boolean existsMetadata(String database) throws URISyntaxException {
        URI dbsBaseDir = this.sqliteConfig.getDatabasePath();
        URI centerMetaDataPath = SQLitePathUtils.getMasterdataMetadataPath(dbsBaseDir, database);
        return this.fileManager.fileExists(centerMetaDataPath.toString());
    }

    public void saveMetadata(SQLiteDBMetadata sqliteDBMetadata, String database) throws URISyntaxException, IOException {
        LOG.info("Start updating Metadata for Database {}", (Object)database);
        long metadataTime = System.currentTimeMillis();
        URI dbsBaseDir = this.sqliteConfig.getDatabasePath();
        URI metadataPath = SQLitePathUtils.getMasterdataMetadataPath(dbsBaseDir, database);
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(metadataPath), new OpenOption[0]);){
            Gson gson = new GsonBuilder().create();
            gson.toJson((Object)sqliteDBMetadata, (Appendable)writer);
        }
        metadataTime = System.currentTimeMillis() - metadataTime;
        LOG.info("Metadata updated for Database {} in {} ms", (Object)database, (Object)metadataTime);
    }

    public List<SQLiteDBFileInfo> addDBtoMetadata(SQLiteDBMetadata sqliteDBMetadata, String owner, String database, String file, String md5) throws URISyntaxException, IOException {
        SQLiteDBFileInfo current = sqliteDBMetadata.getCurrent();
        if (current != null) {
            sqliteDBMetadata.getPrevious().add(0, current);
        }
        current = new SQLiteDBFileInfo();
        current.setFile(file);
        current.setMd5(md5);
        sqliteDBMetadata.setCurrent(current);
        ArrayList toDelete = new ArrayList();
        if (this.cleanupStrategies != null) {
            for (SQLiteDBCleanupStrategy strategy : this.cleanupStrategies) {
                List toDeleteFromStrategy = strategy.selectDbsToCleanup(sqliteDBMetadata, owner, database);
                toDelete.addAll(toDeleteFromStrategy);
            }
        }
        List<SQLiteDBFileInfo> toDeleteFromMaxFiles = this.metadataCleanupBasedOnMaxDBs(sqliteDBMetadata);
        return Stream.of(toDelete, toDeleteFromMaxFiles).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<SQLiteDBFileInfo> metadataCleanupBasedOnMaxDBs(SQLiteDBMetadata sqliteDBMetadata) {
        List previous = sqliteDBMetadata.getPrevious();
        if (previous == null || previous.size() == 0) {
            return Collections.emptyList();
        }
        if (previous.size() > this.sqliteConfig.getMaxDBCopyNumber()) {
            List<SQLiteDBFileInfo> toDelete = previous.subList(this.sqliteConfig.getMaxDBCopyNumber(), previous.size());
            sqliteDBMetadata.setPrevious(previous.subList(0, this.sqliteConfig.getMaxDBCopyNumber()));
            return toDelete;
        }
        return Collections.emptyList();
    }
}

