/*
 * Decompiled with CFR 0.152.
 */
package com.lin.generator;

import com.lin.random.RandomData;
import java.lang.reflect.Array;
import java.util.List;

public class Generator {
    public static <T> RepeatCountRandom of(T ... valueList) {
        return new RepeatCountRandom<T>(valueList);
    }

    public static <T> RepeatCountRandom ofList(List<T> valueList) {
        int listSize = valueList.size();
        String[] array = (String[])Array.newInstance(String.class, listSize);
        for (int i = 0; i < listSize; ++i) {
            array[i] = String.valueOf(valueList.get(i));
        }
        return new RepeatCountRandom<String>(array);
    }

    public static IntegerRandom ofIntStart(int startValue) {
        return new IntegerRandom(startValue);
    }

    public static LongRandom ofLongStart(long startValue) {
        return new LongRandom(startValue);
    }

    public static class LongRandom
    implements RandomData<Long> {
        private Long startValue;

        public LongRandom(Long startValue) {
            this.startValue = startValue;
        }

        @Override
        public Long next() {
            Long l = this.startValue;
            Long l2 = this.startValue = Long.valueOf(this.startValue + 1L);
            return l;
        }
    }

    public static class IntegerRandom
    implements RandomData<Integer> {
        private Integer startValue;

        public IntegerRandom(Integer startValue) {
            this.startValue = startValue;
        }

        @Override
        public Integer next() {
            Integer n = this.startValue;
            Integer n2 = this.startValue = Integer.valueOf(this.startValue + 1);
            return n;
        }
    }

    public static class RepeatCountRandom<T>
    implements RandomData<T> {
        private int repeatCount = 1;
        private T[] valueList;
        private int currentIndex = 0;
        private int totalIndex = 0;

        RepeatCountRandom(T[] valueList) {
            this.valueList = valueList;
        }

        public RandomData<T> repeatCount(int repeatCount) {
            this.repeatCount = repeatCount;
            return this;
        }

        @Override
        public T next() {
            T value = this.valueList[this.currentIndex];
            if (++this.totalIndex % this.repeatCount == 0) {
                ++this.currentIndex;
                if (this.currentIndex >= this.valueList.length) {
                    this.currentIndex = 0;
                }
            }
            return value;
        }
    }
}

