/*
 * Decompiled with CFR 0.152.
 */
package com.lin.faker;

import com.lin.asserts.Asserts;
import com.lin.datatype.DataType;
import com.lin.helper.DatabaseHelper;
import com.lin.logger.Logger;
import com.lin.logger.LoggerFactory;
import com.lin.mapping.DataTypeMapping;
import com.lin.random.RandomData;
import com.lin.utils.FlyweightUtils;
import com.lin.utils.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Faker {
    private String tableName;
    private int count;
    private int totalCount = 0;
    private boolean isInsertDataToDb;
    private final Map<String, Object> PARAM_MAP = Collections.synchronizedMap(new LinkedHashMap(10));
    private static final Logger LOGGER = LoggerFactory.getLogger(Faker.class);
    private ThreadLocal<SimpleDateFormat> dateFormatter = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    private Faker() {
    }

    public static Faker tableName(String tableName) {
        return FakerHolder.INSTANCE.setTableName(tableName);
    }

    private Faker setTableName(String tableName) {
        this.tableName = tableName;
        this.resetVariable();
        return this;
    }

    private void resetVariable() {
        this.PARAM_MAP.clear();
        this.count = 0;
        this.totalCount = 0;
        this.isInsertDataToDb = false;
    }

    public Faker param(String paramName, Object paramType) {
        this.PARAM_MAP.put(paramName, paramType);
        return this;
    }

    public Faker insertCount(int count) {
        this.count = count;
        return this;
    }

    public void ignored() {
    }

    public void onlyShowSql() {
        this.isInsertDataToDb = false;
        this.executeMainLogic();
    }

    public void execute() {
        this.isInsertDataToDb = true;
        this.executeMainLogic();
    }

    private void executeMainLogic() {
        this.checkParams();
        this.generateAndExecuteSql();
    }

    private void checkParams() {
        Asserts.isTrue(StringUtils.isNotEmpty(this.tableName), "\u6570\u636e\u5e93\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
        Asserts.isTrue(this.PARAM_MAP.size() >= 1, "\u5fc5\u987b\u8bbe\u7f6e\u4e00\u6761\u4ee5\u4e0a\u5c5e\u6027\u503c\uff0c\u9700\u8981\u4f7f\u7528param(paramName,paramType)\u65b9\u6cd5\u8bbe\u7f6e", new Object[0]);
        Asserts.isTrue(this.count >= 1, "\u63d2\u5165\u6761\u6570\u5e94\u5927\u4e8e\u7b49\u4e8e1\u6761\uff0c\u9700\u8981\u4f7f\u7528insertCount(int)\u65b9\u6cd5\u8bbe\u7f6e\u63d2\u5165\u6761\u6570", new Object[0]);
    }

    private void generateAndExecuteSql() {
        block7: {
            int commitSize = 1000;
            try {
                if (this.isInsertDataToDb) {
                    DatabaseHelper.beginTransaction();
                }
                for (int i = 0; i < this.count; ++i) {
                    String[] paramNameAndValue = this.generateParamNameAndValue();
                    String paramName = paramNameAndValue[0];
                    String paramValue = paramNameAndValue[1];
                    String sql = String.format("insert into %s(%s) values(%s)", this.tableName, paramName, paramValue);
                    sql = this.handleWithSpecifyDatabase(paramName, paramValue, sql);
                    LOGGER.info(sql);
                    if (!this.isInsertDataToDb) continue;
                    int effectCount = DatabaseHelper.executeUpdate(sql, new Object[0]);
                    this.totalCount += effectCount;
                    if (this.totalCount % commitSize != 0) continue;
                    DatabaseHelper.commitBatchTransaction();
                }
                if (this.isInsertDataToDb && this.totalCount % commitSize != 0) {
                    DatabaseHelper.commitTransaction();
                }
                if (this.isInsertDataToDb) {
                    LOGGER.print(String.format("\u6210\u529f\u63d2\u5165[ %s ]\u6761\u6570\u636e", this.totalCount));
                } else {
                    LOGGER.print(String.format("\u6210\u529f\u751f\u6210[ %s ]\u6761\u6570\u636e", this.count));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.isInsertDataToDb) break block7;
                DatabaseHelper.rollbackTransaction();
            }
        }
    }

    private String handleWithSpecifyDatabase(String paramName, String paramValue, String sql) {
        String url = DatabaseHelper.getDataSource().getUrl();
        if (url != null && !url.isEmpty()) {
            if (url.contains("jdbc:sqlserver")) {
                sql = String.format("insert into [dbo].[%s](%s) values(%s)", this.tableName, paramName, paramValue);
            }
            if (url.contains("jdbc:h2")) {
                String[] valueArray = paramValue.split(",");
                StringBuilder sb = new StringBuilder();
                for (String value : valueArray) {
                    try {
                        this.dateFormatter.get().parse(value.replace("'", ""));
                        sb.append(String.format("parsedatetime(%s, 'yyyy-MM-dd HH:mm:ss')", value));
                    }
                    catch (ParseException e) {
                        sb.append(value);
                    }
                    sb.append(",");
                }
                paramValue = StringUtils.deleteLastComma(sb);
                sql = String.format("insert into %s(%s) values(%s)", this.tableName, paramName, paramValue);
            }
        }
        return sql;
    }

    private String[] generateParamNameAndValue() {
        StringBuilder paramNameSb = new StringBuilder();
        StringBuilder paramValueSb = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.PARAM_MAP.entrySet()) {
            String paramName = entry.getKey();
            Object paramType = entry.getValue();
            paramNameSb.append(paramName.trim()).append(",");
            this.createParamValue(paramType, paramValueSb);
        }
        String paramNames = StringUtils.deleteLastComma(paramNameSb);
        String paramValues = StringUtils.deleteLastComma(paramValueSb);
        return new String[]{paramNames, paramValues};
    }

    private void createParamValue(Object paramType, StringBuilder paramValueSb) {
        Object target;
        Asserts.isTrue(paramType instanceof DataType || paramType instanceof RandomData || RandomData.class.isAssignableFrom(paramType), "\u4f20\u5165\u7684paramType\u5fc5\u987b\u662fDataType\u679a\u4e3e\u503c\u6216\u5b9e\u73b0RandomData\u63a5\u53e3\u7684\u7c7b", new Object[0]);
        if (paramType instanceof RandomData) {
            target = paramType;
        } else {
            if (paramType instanceof DataType) {
                DataType dataType = (DataType)((Object)paramType);
                paramType = DataTypeMapping.getMapping(dataType);
            }
            target = FlyweightUtils.getInstance(paramType);
        }
        Object randomData = ((RandomData)target).next();
        String data = randomData instanceof String ? (String)randomData : String.valueOf(randomData);
        paramValueSb.append(StringUtils.addSingleQuotesAround(data)).append(",");
    }

    private static final class FakerHolder {
        private static final Faker INSTANCE = new Faker();

        private FakerHolder() {
        }
    }
}

