/*
 * Decompiled with CFR 0.152.
 */
package com.lin.creator;

import com.lin.creator.BaseFakerCreator;
import com.lin.entity.common.CommonFieldInfo;
import com.lin.entity.common.CommonTableInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class MysqlFakerCreator
extends BaseFakerCreator<CommonTableInfo, CommonFieldInfo> {
    public static BaseFakerCreator url(String url) {
        return FakerCreatorHolder.INSTANCE.setUrl(url);
    }

    public static BaseFakerCreator dbName(String dbName) {
        return FakerCreatorHolder.INSTANCE.setDbName(dbName);
    }

    @Override
    protected String getQueryTablesInfoSql() {
        return String.format("select table_name as tableName, table_comment as tableComment from information_schema.tables where table_schema='%s'", this.dbName);
    }

    @Override
    protected String getQueryFieldsInfoSql(String tableName) {
        return String.format("select column_name as fieldName,column_comment as comments,data_type as dataType from information_schema.columns where table_name='%s' and table_schema = '%s' order by ordinal_position", tableName, this.dbName);
    }

    @Override
    protected String getDefaultUsername() {
        return "root";
    }

    @Override
    protected String getDefaultPassword() {
        return "123456";
    }

    @Override
    protected String getDefaultDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    protected String getDefaultUrlPrefix() {
        return "jdbc:mysql://localhost:3306/";
    }

    @Override
    protected void setDbStringTypeSet(Collection<String> dbStringTypeSet) {
        dbStringTypeSet.addAll(Arrays.asList("CHAR", "VARCHAR", "TINYBLOB", "TINYTEXT", "BLOB", "TEXT", "MEDIUMBLOB", "MEDIUMTEXT", "LONGBLOB", "LONGTEXT"));
    }

    @Override
    protected void setDatabaseInferMap(Map<String, String> databaseInferMap) {
        databaseInferMap.put("TINYINT", "INT");
        databaseInferMap.put("SMALLINT", "INT");
        databaseInferMap.put("MEDIUMINT", "INT");
        databaseInferMap.put("INT", "INT");
        databaseInferMap.put("INTEGER", "INT");
        databaseInferMap.put("BIGINT", "INT");
        databaseInferMap.put("FLOAT", "FLOAT");
        databaseInferMap.put("DOUBLE", "FLOAT");
        databaseInferMap.put("DECIMAL", "FLOAT");
        databaseInferMap.put("DATE", "TIME");
        databaseInferMap.put("TIME", "TIME");
        databaseInferMap.put("YEAR", "TIME");
        databaseInferMap.put("DATETIME", "TIME");
        databaseInferMap.put("TIMESTAMP", "TIME");
        databaseInferMap.put("CHAR", "TEXT");
        databaseInferMap.put("VARCHAR", "TEXT");
        databaseInferMap.put("TINYBLOB", "TEXT");
        databaseInferMap.put("TINYTEXT", "TEXT");
        databaseInferMap.put("BLOB", "TEXT");
        databaseInferMap.put("TEXT", "TEXT");
        databaseInferMap.put("MEDIUMBLOB", "TEXT");
        databaseInferMap.put("MEDIUMTEXT", "TEXT");
        databaseInferMap.put("LONGBLOB", "TEXT");
        databaseInferMap.put("LONGTEXT", "TEXT");
        databaseInferMap.put("VARBINARY", "TEXT");
    }

    private static final class FakerCreatorHolder {
        private static final BaseFakerCreator INSTANCE = new MysqlFakerCreator();

        private FakerCreatorHolder() {
        }
    }
}

