package com.lin.random.impl;

import com.lin.random.RandomData;
import com.lin.utils.RandomUtils;

/**
 * 随机地址生成器（国内地址，详细到门牌号，如：四川省绵阳市盐亭县北利路738号）
 * @author lkmc2
 * @since 1.0.0
 */
public class AddressRandom implements RandomData<String> {

    @Override
    public String next() {
        // 城市名
        String cityName = RandomUtils.selectOneInArray(cityNames);

        // 路名
        String roadName = RandomUtils.selectOneInArray(roadNames);

        // 门牌号
        String codeName = String.format("%s号", RandomUtils.nextIntRange(1, 999));

        return cityName + roadName + codeName;
    }

    // 城市名
    private static final String[] cityNames = {
            "北京市",
            "北京市东城区",
            "北京市西城区",
            "北京市崇文区",
            "北京市宣武区",
            "北京市朝阳区",
            "北京市丰台区",
            "北京市石景山区",
            "北京市海淀区",
            "北京市门头沟区",
            "北京市房山区",
            "北京市通州区",
            "北京市顺义区",
            "北京市昌平区",
            "北京市大兴区",
            "北京市怀柔区",
            "北京市平谷区",
            "北京市密云县",
            "北京市延庆县",
            "天津市",
            "天津市和平区",
            "天津市河东区",
            "天津市河西区",
            "天津市南开区",
            "天津市河北区",
            "天津市红桥区",
            "天津市塘沽区",
            "天津市汉沽区",
            "天津市大港区",
            "天津市东丽区",
            "天津市西青区",
            "天津市津南区",
            "天津市北辰区",
            "天津市武清区",
            "天津市宝坻区",
            "天津市宁河县",
            "天津市静海县",
            "天津市蓟县",
            "河北省石家庄市长安区",
            "河北省石家庄市桥东区",
            "河北省石家庄市桥西区",
            "河北省石家庄市新华区",
            "河北省石家庄市井陉矿区",
            "河北省石家庄市裕华区",
            "河北省石家庄市井陉县",
            "河北省石家庄市正定县",
            "河北省石家庄市栾城县",
            "河北省石家庄市行唐县",
            "河北省石家庄市灵寿县",
            "河北省石家庄市高邑县",
            "河北省石家庄市深泽县",
            "河北省石家庄市赞皇县",
            "河北省石家庄市无极县",
            "河北省石家庄市平山县",
            "河北省石家庄市元氏县",
            "河北省石家庄市赵县",
            "河北省石家庄市辛集市",
            "河北省石家庄市藁城市",
            "河北省石家庄市晋州市",
            "河北省石家庄市新乐市",
            "河北省石家庄市鹿泉市",
            "河北省唐山市路南区",
            "河北省唐山市路北区",
            "河北省唐山市古冶区",
            "河北省唐山市开平区",
            "河北省唐山市丰南区",
            "河北省唐山市丰润区",
            "河北省唐山市滦县",
            "河北省唐山市滦南县",
            "河北省唐山市乐亭县",
            "河北省唐山市迁西县",
            "河北省唐山市玉田县",
            "河北省唐山市唐海县",
            "河北省唐山市遵化市",
            "河北省唐山市迁安市",
            "河北省秦皇岛市海港区",
            "河北省秦皇岛市山海关区",
            "河北省秦皇岛市北戴河区",
            "河北省秦皇岛市青龙满族自治县",
            "河北省秦皇岛市昌黎县",
            "河北省秦皇岛市抚宁县",
            "河北省秦皇岛市卢龙县",
            "河北省邯郸市邯山区",
            "河北省邯郸市丛台区",
            "河北省邯郸市复兴区",
            "河北省邯郸市峰峰矿区",
            "河北省邯郸市邯郸县",
            "河北省邯郸市临漳县",
            "河北省邯郸市成安县",
            "河北省邯郸市大名县",
            "河北省邯郸市涉县",
            "河北省邯郸市磁县",
            "河北省邯郸市肥乡县",
            "河北省邯郸市永年县",
            "河北省邯郸市邱县",
            "河北省邯郸市鸡泽县",
            "河北省邯郸市广平县",
            "河北省邯郸市馆陶县",
            "河北省邯郸市魏县",
            "河北省邯郸市曲周县",
            "河北省邯郸市武安市",
            "河北省邢台市桥东区",
            "河北省邢台市桥西区",
            "河北省邢台市邢台县",
            "河北省邢台市临城县",
            "河北省邢台市内丘县",
            "河北省邢台市柏乡县",
            "河北省邢台市隆尧县",
            "河北省邢台市任县",
            "河北省邢台市南和县",
            "河北省邢台市宁晋县",
            "河北省邢台市巨鹿县",
            "河北省邢台市新河县",
            "河北省邢台市广宗县",
            "河北省邢台市平乡县",
            "河北省邢台市威县",
            "河北省邢台市清河县",
            "河北省邢台市临西县",
            "河北省邢台市南宫市",
            "河北省邢台市沙河市",
            "河北省保定市新市区",
            "河北省保定市北市区",
            "河北省保定市南市区",
            "河北省保定市满城县",
            "河北省保定市清苑县",
            "河北省保定市涞水县",
            "河北省保定市阜平县",
            "河北省保定市徐水县",
            "河北省保定市定兴县",
            "河北省保定市唐县",
            "河北省保定市高阳县",
            "河北省保定市容城县",
            "河北省保定市涞源县",
            "河北省保定市望都县",
            "河北省保定市安新县",
            "河北省保定市易县",
            "河北省保定市曲阳县",
            "河北省保定市蠡县",
            "河北省保定市顺平县",
            "河北省保定市博野县",
            "河北省保定市雄县",
            "河北省保定市涿州市",
            "河北省保定市定州市",
            "河北省保定市安国市",
            "河北省保定市高碑店市",
            "河北省张家口市桥东区",
            "河北省张家口市桥西区",
            "河北省张家口市宣化区",
            "河北省张家口市下花园区",
            "河北省张家口市宣化县",
            "河北省张家口市张北县",
            "河北省张家口市康保县",
            "河北省张家口市沽源县",
            "河北省张家口市尚义县",
            "河北省张家口市蔚县",
            "河北省张家口市阳原县",
            "河北省张家口市怀安县",
            "河北省张家口市万全县",
            "河北省张家口市怀来县",
            "河北省张家口市涿鹿县",
            "河北省张家口市赤城县",
            "河北省张家口市崇礼县",
            "河北省承德市双桥区",
            "河北省承德市双滦区",
            "河北省承德市鹰手营子矿区",
            "河北省承德市承德县",
            "河北省承德市兴隆县",
            "河北省承德市平泉县",
            "河北省承德市滦平县",
            "河北省承德市隆化县",
            "河北省承德市丰宁满族自治县",
            "河北省承德市宽城满族自治县",
            "河北省承德市围场满族蒙古族自治县",
            "河北省沧州市新华区",
            "河北省沧州市运河区",
            "河北省沧州市沧县",
            "河北省沧州市青县",
            "河北省沧州市东光县",
            "河北省沧州市海兴县",
            "河北省沧州市盐山县",
            "河北省沧州市肃宁县",
            "河北省沧州市南皮县",
            "河北省沧州市吴桥县",
            "河北省沧州市献县",
            "河北省沧州市孟村回族自治县",
            "河北省沧州市泊头市",
            "河北省沧州市任丘市",
            "河北省沧州市黄骅市",
            "河北省沧州市河间市",
            "河北省廊坊市安次区",
            "河北省廊坊市广阳区",
            "河北省廊坊市固安县",
            "河北省廊坊市永清县",
            "河北省廊坊市香河县",
            "河北省廊坊市大城县",
            "河北省廊坊市文安县",
            "河北省廊坊市大厂回族自治县",
            "河北省廊坊市霸州市",
            "河北省廊坊市三河市",
            "河北省衡水市桃城区",
            "河北省衡水市枣强县",
            "河北省衡水市武邑县",
            "河北省衡水市武强县",
            "河北省衡水市饶阳县",
            "河北省衡水市安平县",
            "河北省衡水市故城县",
            "河北省衡水市景县",
            "河北省衡水市阜城县",
            "河北省衡水市冀州市",
            "河北省衡水市深州市",
            "山西省太原市小店区",
            "山西省太原市迎泽区",
            "山西省太原市杏花岭区",
            "山西省太原市尖草坪区",
            "山西省太原市万柏林区",
            "山西省太原市晋源区",
            "山西省太原市清徐县",
            "山西省太原市阳曲县",
            "山西省太原市娄烦县",
            "山西省太原市古交市",
            "山西省大同市城区",
            "山西省大同市矿区",
            "山西省大同市南郊区",
            "山西省大同市新荣区",
            "山西省大同市阳高县",
            "山西省大同市天镇县",
            "山西省大同市广灵县",
            "山西省大同市灵丘县",
            "山西省大同市浑源县",
            "山西省大同市左云县",
            "山西省大同市大同县",
            "山西省阳泉市城区",
            "山西省阳泉市矿区",
            "山西省阳泉市郊区",
            "山西省阳泉市平定县",
            "山西省阳泉市盂县",
            "山西省长治市城区",
            "山西省长治市郊区",
            "山西省长治市长治县",
            "山西省长治市襄垣县",
            "山西省长治市屯留县",
            "山西省长治市平顺县",
            "山西省长治市黎城县",
            "山西省长治市壶关县",
            "山西省长治市长子县",
            "山西省长治市武乡县",
            "山西省长治市沁县",
            "山西省长治市沁源县",
            "山西省长治市潞城市",
            "山西省晋城市城区",
            "山西省晋城市沁水县",
            "山西省晋城市阳城县",
            "山西省晋城市陵川县",
            "山西省晋城市泽州县",
            "山西省晋城市高平市",
            "山西省朔州市朔城区",
            "山西省朔州市平鲁区",
            "山西省朔州市山阴县",
            "山西省朔州市应县",
            "山西省朔州市右玉县",
            "山西省朔州市怀仁县",
            "山西省晋中市榆次区",
            "山西省晋中市榆社县",
            "山西省晋中市左权县",
            "山西省晋中市和顺县",
            "山西省晋中市昔阳县",
            "山西省晋中市寿阳县",
            "山西省晋中市太谷县",
            "山西省晋中市祁县",
            "山西省晋中市平遥县",
            "山西省晋中市灵石县",
            "山西省晋中市介休市",
            "山西省运城市盐湖区",
            "山西省运城市临猗县",
            "山西省运城市万荣县",
            "山西省运城市闻喜县",
            "山西省运城市稷山县",
            "山西省运城市新绛县",
            "山西省运城市绛县",
            "山西省运城市垣曲县",
            "山西省运城市夏县",
            "山西省运城市平陆县",
            "山西省运城市芮城县",
            "山西省运城市永济市",
            "山西省运城市河津市",
            "山西省忻州市忻府区",
            "山西省忻州市定襄县",
            "山西省忻州市五台县",
            "山西省忻州市代县",
            "山西省忻州市繁峙县",
            "山西省忻州市宁武县",
            "山西省忻州市静乐县",
            "山西省忻州市神池县",
            "山西省忻州市五寨县",
            "山西省忻州市岢岚县",
            "山西省忻州市河曲县",
            "山西省忻州市保德县",
            "山西省忻州市偏关县",
            "山西省忻州市原平市",
            "山西省临汾市尧都区",
            "山西省临汾市曲沃县",
            "山西省临汾市翼城县",
            "山西省临汾市襄汾县",
            "山西省临汾市洪洞县",
            "山西省临汾市古县",
            "山西省临汾市安泽县",
            "山西省临汾市浮山县",
            "山西省临汾市吉县",
            "山西省临汾市乡宁县",
            "山西省临汾市大宁县",
            "山西省临汾市隰县",
            "山西省临汾市永和县",
            "山西省临汾市蒲县",
            "山西省临汾市汾西县",
            "山西省临汾市侯马市",
            "山西省临汾市霍州市",
            "山西省吕梁市离石区",
            "山西省吕梁市文水县",
            "山西省吕梁市交城县",
            "山西省吕梁市兴县",
            "山西省吕梁市临县",
            "山西省吕梁市柳林县",
            "山西省吕梁市石楼县",
            "山西省吕梁市岚县",
            "山西省吕梁市方山县",
            "山西省吕梁市中阳县",
            "山西省吕梁市交口县",
            "山西省吕梁市孝义市",
            "山西省吕梁市汾阳市",
            "内蒙古自治区呼和浩特市新城区",
            "内蒙古自治区呼和浩特市回民区",
            "内蒙古自治区呼和浩特市玉泉区",
            "内蒙古自治区呼和浩特市赛罕区",
            "内蒙古自治区呼和浩特市土默特左旗",
            "内蒙古自治区呼和浩特市托克托县",
            "内蒙古自治区呼和浩特市和林格尔县",
            "内蒙古自治区呼和浩特市清水河县",
            "内蒙古自治区呼和浩特市武川县",
            "内蒙古自治区包头市东河区",
            "内蒙古自治区包头市昆都仑区",
            "内蒙古自治区包头市青山区",
            "内蒙古自治区包头市石拐区",
            "内蒙古自治区包头市白云矿区",
            "内蒙古自治区包头市九原区",
            "内蒙古自治区包头市土默特右旗",
            "内蒙古自治区包头市固阳县",
            "内蒙古自治区包头市达尔罕茂明安联合旗",
            "内蒙古自治区乌海市海勃湾区",
            "内蒙古自治区乌海市海南区",
            "内蒙古自治区乌海市乌达区",
            "内蒙古自治区赤峰市红山区",
            "内蒙古自治区赤峰市元宝山区",
            "内蒙古自治区赤峰市松山区",
            "内蒙古自治区赤峰市阿鲁科尔沁旗",
            "内蒙古自治区赤峰市巴林左旗",
            "内蒙古自治区赤峰市巴林右旗",
            "内蒙古自治区赤峰市林西县",
            "内蒙古自治区赤峰市克什克腾旗",
            "内蒙古自治区赤峰市翁牛特旗",
            "内蒙古自治区赤峰市喀喇沁旗",
            "内蒙古自治区赤峰市宁城县",
            "内蒙古自治区赤峰市敖汉旗",
            "内蒙古自治区通辽市科尔沁区",
            "内蒙古自治区通辽市科尔沁左翼中旗",
            "内蒙古自治区通辽市科尔沁左翼后旗",
            "内蒙古自治区通辽市开鲁县",
            "内蒙古自治区通辽市库伦旗",
            "内蒙古自治区通辽市奈曼旗",
            "内蒙古自治区通辽市扎鲁特旗",
            "内蒙古自治区通辽市霍林郭勒市",
            "内蒙古自治区鄂尔多斯市东胜区",
            "内蒙古自治区鄂尔多斯市达拉特旗",
            "内蒙古自治区鄂尔多斯市准格尔旗",
            "内蒙古自治区鄂尔多斯市鄂托克前旗",
            "内蒙古自治区鄂尔多斯市鄂托克旗",
            "内蒙古自治区鄂尔多斯市杭锦旗",
            "内蒙古自治区鄂尔多斯市乌审旗",
            "内蒙古自治区鄂尔多斯市伊金霍洛旗",
            "内蒙古自治区呼伦贝尔市海拉尔区",
            "内蒙古自治区呼伦贝尔市阿荣旗",
            "内蒙古自治区呼伦贝尔市莫力达瓦达斡尔族自治旗",
            "内蒙古自治区呼伦贝尔市鄂伦春自治旗",
            "内蒙古自治区呼伦贝尔市鄂温克族自治旗",
            "内蒙古自治区呼伦贝尔市陈巴尔虎旗",
            "内蒙古自治区呼伦贝尔市新巴尔虎左旗",
            "内蒙古自治区呼伦贝尔市新巴尔虎右旗",
            "内蒙古自治区呼伦贝尔市满洲里市",
            "内蒙古自治区呼伦贝尔市牙克石市",
            "内蒙古自治区呼伦贝尔市扎兰屯市",
            "内蒙古自治区呼伦贝尔市额尔古纳市",
            "内蒙古自治区呼伦贝尔市根河市",
            "内蒙古自治区巴彦淖尔市临河区",
            "内蒙古自治区巴彦淖尔市五原县",
            "内蒙古自治区巴彦淖尔市磴口县",
            "内蒙古自治区巴彦淖尔市乌拉特前旗",
            "内蒙古自治区巴彦淖尔市乌拉特中旗",
            "内蒙古自治区巴彦淖尔市乌拉特后旗",
            "内蒙古自治区巴彦淖尔市杭锦后旗",
            "内蒙古自治区乌兰察布市集宁区",
            "内蒙古自治区乌兰察布市卓资县",
            "内蒙古自治区乌兰察布市化德县",
            "内蒙古自治区乌兰察布市商都县",
            "内蒙古自治区乌兰察布市兴和县",
            "内蒙古自治区乌兰察布市凉城县",
            "内蒙古自治区乌兰察布市察哈尔右翼前旗",
            "内蒙古自治区乌兰察布市察哈尔右翼中旗",
            "内蒙古自治区乌兰察布市察哈尔右翼后旗",
            "内蒙古自治区乌兰察布市四子王旗",
            "内蒙古自治区乌兰察布市丰镇市",
            "内蒙古自治区兴安盟乌兰浩特市",
            "内蒙古自治区兴安盟阿尔山市",
            "内蒙古自治区兴安盟科尔沁右翼前旗",
            "内蒙古自治区兴安盟科尔沁右翼中旗",
            "内蒙古自治区兴安盟扎赉特旗",
            "内蒙古自治区兴安盟突泉县",
            "内蒙古自治区锡林郭勒盟二连浩特市",
            "内蒙古自治区锡林郭勒盟锡林浩特市",
            "内蒙古自治区锡林郭勒盟阿巴嘎旗",
            "内蒙古自治区锡林郭勒盟苏尼特左旗",
            "内蒙古自治区锡林郭勒盟苏尼特右旗",
            "内蒙古自治区锡林郭勒盟东乌珠穆沁旗",
            "内蒙古自治区锡林郭勒盟西乌珠穆沁旗",
            "内蒙古自治区锡林郭勒盟太仆寺旗",
            "内蒙古自治区锡林郭勒盟镶黄旗",
            "内蒙古自治区锡林郭勒盟正镶白旗",
            "内蒙古自治区锡林郭勒盟正蓝旗",
            "内蒙古自治区锡林郭勒盟多伦县",
            "内蒙古自治区阿拉善盟阿拉善左旗",
            "内蒙古自治区阿拉善盟阿拉善右旗",
            "内蒙古自治区阿拉善盟额济纳旗",
            "辽宁省沈阳市和平区",
            "辽宁省沈阳市沈河区",
            "辽宁省沈阳市大东区",
            "辽宁省沈阳市皇姑区",
            "辽宁省沈阳市铁西区",
            "辽宁省沈阳市苏家屯区",
            "辽宁省沈阳市东陵区",
            "辽宁省沈阳市沈北新区*",
            "辽宁省沈阳市于洪区",
            "辽宁省沈阳市辽中县",
            "辽宁省沈阳市康平县",
            "辽宁省沈阳市法库县",
            "辽宁省沈阳市新民市",
            "辽宁省大连市中山区",
            "辽宁省大连市西岗区",
            "辽宁省大连市沙河口区",
            "辽宁省大连市甘井子区",
            "辽宁省大连市旅顺口区",
            "辽宁省大连市金州区",
            "辽宁省大连市长海县",
            "辽宁省大连市瓦房店市",
            "辽宁省大连市普兰店市",
            "辽宁省大连市庄河市",
            "辽宁省鞍山市铁东区",
            "辽宁省鞍山市铁西区",
            "辽宁省鞍山市立山区",
            "辽宁省鞍山市千山区",
            "辽宁省鞍山市台安县",
            "辽宁省鞍山市岫岩满族自治县",
            "辽宁省鞍山市海城市",
            "辽宁省抚顺市新抚区",
            "辽宁省抚顺市东洲区",
            "辽宁省抚顺市望花区",
            "辽宁省抚顺市顺城区",
            "辽宁省抚顺市抚顺县",
            "辽宁省抚顺市新宾满族自治县",
            "辽宁省抚顺市清原满族自治县",
            "辽宁省本溪市平山区",
            "辽宁省本溪市溪湖区",
            "辽宁省本溪市明山区",
            "辽宁省本溪市南芬区",
            "辽宁省本溪市本溪满族自治县",
            "辽宁省本溪市桓仁满族自治县",
            "辽宁省丹东市元宝区",
            "辽宁省丹东市振兴区",
            "辽宁省丹东市振安区",
            "辽宁省丹东市宽甸满族自治县",
            "辽宁省丹东市东港市",
            "辽宁省丹东市凤城市",
            "辽宁省锦州市古塔区",
            "辽宁省锦州市凌河区",
            "辽宁省锦州市太和区",
            "辽宁省锦州市黑山县",
            "辽宁省锦州市义县",
            "辽宁省锦州市凌海市",
            "辽宁省锦州市北镇市*",
            "辽宁省营口市站前区",
            "辽宁省营口市西市区",
            "辽宁省营口市鲅鱼圈区",
            "辽宁省营口市老边区",
            "辽宁省营口市盖州市",
            "辽宁省营口市大石桥市",
            "辽宁省阜新市海州区",
            "辽宁省阜新市新邱区",
            "辽宁省阜新市太平区",
            "辽宁省阜新市清河门区",
            "辽宁省阜新市细河区",
            "辽宁省阜新市阜新蒙古族自治县",
            "辽宁省阜新市彰武县",
            "辽宁省辽阳市白塔区",
            "辽宁省辽阳市文圣区",
            "辽宁省辽阳市宏伟区",
            "辽宁省辽阳市弓长岭区",
            "辽宁省辽阳市太子河区",
            "辽宁省辽阳市辽阳县",
            "辽宁省辽阳市灯塔市",
            "辽宁省盘锦市双台子区",
            "辽宁省盘锦市兴隆台区",
            "辽宁省盘锦市大洼县",
            "辽宁省盘锦市盘山县",
            "辽宁省铁岭市银州区",
            "辽宁省铁岭市清河区",
            "辽宁省铁岭市铁岭县",
            "辽宁省铁岭市西丰县",
            "辽宁省铁岭市昌图县",
            "辽宁省铁岭市调兵山市",
            "辽宁省铁岭市开原市",
            "辽宁省铁岭市朝阳市",
            "辽宁省铁岭市",
            "辽宁省铁岭市双塔区",
            "辽宁省铁岭市龙城区",
            "辽宁省朝阳县建平县",
            "辽宁省朝阳县喀喇沁左翼蒙古族自治县",
            "辽宁省朝阳县北票市",
            "辽宁省朝阳县凌源市",
            "辽宁省葫芦岛市连山区",
            "辽宁省葫芦岛市龙港区",
            "辽宁省葫芦岛市南票区",
            "辽宁省葫芦岛市绥中县",
            "辽宁省葫芦岛市建昌县",
            "辽宁省葫芦岛市兴城市",
            "吉林省长春市南关区",
            "吉林省长春市宽城区",
            "吉林省长春市朝阳区",
            "吉林省长春市二道区",
            "吉林省长春市绿园区",
            "吉林省长春市双阳区",
            "吉林省长春市农安县",
            "吉林省长春市九台市",
            "吉林省长春市榆树市",
            "吉林省长春市德惠市",
            "吉林省吉林市昌邑区",
            "吉林省吉林市龙潭区",
            "吉林省吉林市船营区",
            "吉林省吉林市丰满区",
            "吉林省吉林市永吉县",
            "吉林省吉林市蛟河市",
            "吉林省吉林市桦甸市",
            "吉林省吉林市舒兰市",
            "吉林省吉林市磐石市",
            "吉林省四平市铁西区",
            "吉林省四平市铁东区",
            "吉林省四平市梨树县",
            "吉林省四平市伊通满族自治县",
            "吉林省四平市公主岭市",
            "吉林省四平市双辽市",
            "吉林省辽源市龙山区",
            "吉林省辽源市西安区",
            "吉林省辽源市东丰县",
            "吉林省辽源市东辽县",
            "吉林省通化市东昌区",
            "吉林省通化市二道江区",
            "吉林省通化市通化县",
            "吉林省通化市辉南县",
            "吉林省通化市柳河县",
            "吉林省通化市梅河口市",
            "吉林省通化市集安市",
            "吉林省白山市八道江区",
            "吉林省白山市江源区",
            "吉林省白山市抚松县",
            "吉林省白山市靖宇县",
            "吉林省白山市长白朝鲜族自治县",
            "吉林省白山市临江市",
            "吉林省松原市宁江区",
            "吉林省松原市前郭尔罗斯蒙古族自治县",
            "吉林省松原市长岭县",
            "吉林省松原市乾安县",
            "吉林省松原市扶余县",
            "吉林省白城市洮北区",
            "吉林省白城市镇赉县",
            "吉林省白城市通榆县",
            "吉林省白城市洮南市",
            "吉林省白城市大安市",
            "吉林省延边朝鲜族自治州延吉市",
            "吉林省延边朝鲜族自治州图们市",
            "吉林省延边朝鲜族自治州敦化市",
            "吉林省延边朝鲜族自治州珲春市",
            "吉林省延边朝鲜族自治州龙井市",
            "吉林省延边朝鲜族自治州和龙市",
            "吉林省延边朝鲜族自治州汪清县",
            "吉林省延边朝鲜族自治州安图县",
            "黑龙江省哈尔滨市道里区",
            "黑龙江省哈尔滨市南岗区",
            "黑龙江省哈尔滨市道外区",
            "黑龙江省哈尔滨市平房区",
            "黑龙江省哈尔滨市松北区",
            "黑龙江省哈尔滨市香坊区",
            "黑龙江省哈尔滨市呼兰区",
            "黑龙江省哈尔滨市阿城区",
            "黑龙江省哈尔滨市依兰县",
            "黑龙江省哈尔滨市方正县",
            "黑龙江省哈尔滨市宾县",
            "黑龙江省哈尔滨市巴彦县",
            "黑龙江省哈尔滨市木兰县",
            "黑龙江省哈尔滨市通河县",
            "黑龙江省哈尔滨市延寿县",
            "黑龙江省哈尔滨市双城市",
            "黑龙江省哈尔滨市尚志市",
            "黑龙江省哈尔滨市五常市",
            "黑龙江省齐齐哈尔市龙沙区",
            "黑龙江省齐齐哈尔市建华区",
            "黑龙江省齐齐哈尔市铁锋区",
            "黑龙江省齐齐哈尔市昂昂溪区",
            "黑龙江省齐齐哈尔市富拉尔基区",
            "黑龙江省齐齐哈尔市碾子山区",
            "黑龙江省齐齐哈尔市梅里斯达斡尔族区",
            "黑龙江省齐齐哈尔市龙江县",
            "黑龙江省齐齐哈尔市依安县",
            "黑龙江省齐齐哈尔市泰来县",
            "黑龙江省齐齐哈尔市甘南县",
            "黑龙江省齐齐哈尔市富裕县",
            "黑龙江省齐齐哈尔市克山县",
            "黑龙江省齐齐哈尔市克东县",
            "黑龙江省齐齐哈尔市拜泉县",
            "黑龙江省齐齐哈尔市讷河市",
            "黑龙江省鸡西市鸡冠区",
            "黑龙江省鸡西市恒山区",
            "黑龙江省鸡西市滴道区",
            "黑龙江省鸡西市梨树区",
            "黑龙江省鸡西市城子河区",
            "黑龙江省鸡西市麻山区",
            "黑龙江省鸡西市鸡东县",
            "黑龙江省鸡西市虎林市",
            "黑龙江省鸡西市密山市",
            "黑龙江省鹤岗市向阳区",
            "黑龙江省鹤岗市工农区",
            "黑龙江省鹤岗市南山区",
            "黑龙江省鹤岗市兴安区",
            "黑龙江省鹤岗市东山区",
            "黑龙江省鹤岗市兴山区",
            "黑龙江省鹤岗市萝北县",
            "黑龙江省鹤岗市绥滨县",
            "黑龙江省双鸭山市尖山区",
            "黑龙江省双鸭山市岭东区",
            "黑龙江省双鸭山市四方台区",
            "黑龙江省双鸭山市宝山区",
            "黑龙江省双鸭山市集贤县",
            "黑龙江省双鸭山市友谊县",
            "黑龙江省双鸭山市宝清县",
            "黑龙江省双鸭山市饶河县",
            "黑龙江省大庆市萨尔图区",
            "黑龙江省大庆市龙凤区",
            "黑龙江省大庆市让胡路区",
            "黑龙江省大庆市红岗区",
            "黑龙江省大庆市大同区",
            "黑龙江省大庆市肇州县",
            "黑龙江省大庆市肇源县",
            "黑龙江省大庆市林甸县",
            "黑龙江省大庆市杜尔伯特蒙古族自治县",
            "黑龙江省伊春市伊春区",
            "黑龙江省伊春市南岔区",
            "黑龙江省伊春市友好区",
            "黑龙江省伊春市西林区",
            "黑龙江省伊春市翠峦区",
            "黑龙江省伊春市新青区",
            "黑龙江省伊春市美溪区",
            "黑龙江省伊春市金山屯区",
            "黑龙江省伊春市五营区",
            "黑龙江省伊春市乌马河区",
            "黑龙江省伊春市汤旺河区",
            "黑龙江省伊春市带岭区",
            "黑龙江省伊春市乌伊岭区",
            "黑龙江省伊春市红星区",
            "黑龙江省伊春市上甘岭区",
            "黑龙江省伊春市嘉荫县",
            "黑龙江省伊春市铁力市",
            "黑龙江省佳木斯市向阳区",
            "黑龙江省佳木斯市前进区",
            "黑龙江省佳木斯市东风区",
            "黑龙江省佳木斯市郊区",
            "黑龙江省佳木斯市桦南县",
            "黑龙江省佳木斯市桦川县",
            "黑龙江省佳木斯市汤原县",
            "黑龙江省佳木斯市抚远县",
            "黑龙江省佳木斯市同江市",
            "黑龙江省佳木斯市富锦市",
            "黑龙江省七台河市新兴区",
            "黑龙江省七台河市桃山区",
            "黑龙江省七台河市茄子河区",
            "黑龙江省七台河市勃利县",
            "黑龙江省牡丹江市东安区",
            "黑龙江省牡丹江市阳明区",
            "黑龙江省牡丹江市爱民区",
            "黑龙江省牡丹江市西安区",
            "黑龙江省牡丹江市东宁县",
            "黑龙江省牡丹江市林口县",
            "黑龙江省牡丹江市绥芬河市",
            "黑龙江省牡丹江市海林市",
            "黑龙江省牡丹江市宁安市",
            "黑龙江省牡丹江市穆棱市",
            "黑龙江省黑河市爱辉区",
            "黑龙江省黑河市嫩江县",
            "黑龙江省黑河市逊克县",
            "黑龙江省黑河市孙吴县",
            "黑龙江省黑河市北安市",
            "黑龙江省黑河市五大连池市",
            "黑龙江省绥化市北林区",
            "黑龙江省绥化市望奎县",
            "黑龙江省绥化市兰西县",
            "黑龙江省绥化市青冈县",
            "黑龙江省绥化市庆安县",
            "黑龙江省绥化市明水县",
            "黑龙江省绥化市绥棱县",
            "黑龙江省绥化市安达市",
            "黑龙江省绥化市肇东市",
            "黑龙江省绥化市海伦市",
            "黑龙江省大兴安岭地区加格达奇区",
            "黑龙江省大兴安岭地区松岭区",
            "黑龙江省大兴安岭地区新林区",
            "黑龙江省大兴安岭地区呼中区",
            "黑龙江省大兴安岭地区呼玛县",
            "黑龙江省大兴安岭地区塔河县",
            "黑龙江省大兴安岭地区漠河县",
            "上海市黄浦区",
            "上海市卢湾区",
            "上海市徐汇区",
            "上海市长宁区",
            "上海市静安区",
            "上海市普陀区",
            "上海市闸北区",
            "上海市虹口区",
            "上海市杨浦区",
            "上海市闵行区",
            "上海市宝山区",
            "上海市嘉定区",
            "上海市浦东新区",
            "上海市金山区",
            "上海市松江区",
            "上海市青浦区",
            "上海市南汇区",
            "上海市奉贤区",
            "上海市崇明县",
            "江苏省南京市玄武区",
            "江苏省南京市白下区",
            "江苏省南京市秦淮区",
            "江苏省南京市建邺区",
            "江苏省南京市鼓楼区",
            "江苏省南京市下关区",
            "江苏省南京市浦口区",
            "江苏省南京市栖霞区",
            "江苏省南京市雨花台区",
            "江苏省南京市江宁区",
            "江苏省南京市六合区",
            "江苏省南京市溧水县",
            "江苏省南京市高淳县",
            "江苏省无锡市崇安区",
            "江苏省无锡市南长区",
            "江苏省无锡市北塘区",
            "江苏省无锡市锡山区",
            "江苏省无锡市惠山区",
            "江苏省无锡市滨湖区",
            "江苏省无锡市江阴市",
            "江苏省无锡市宜兴市",
            "江苏省徐州市鼓楼区",
            "江苏省徐州市云龙区",
            "江苏省徐州市九里区",
            "江苏省徐州市贾汪区",
            "江苏省徐州市泉山区",
            "江苏省徐州市丰县",
            "江苏省徐州市沛县",
            "江苏省徐州市铜山县",
            "江苏省徐州市睢宁县",
            "江苏省徐州市新沂市",
            "江苏省徐州市邳州市",
            "江苏省常州市天宁区",
            "江苏省常州市钟楼区",
            "江苏省常州市戚墅堰区",
            "江苏省常州市新北区",
            "江苏省常州市武进区",
            "江苏省常州市溧阳市",
            "江苏省常州市金坛市",
            "江苏省苏州市沧浪区",
            "江苏省苏州市平江区",
            "江苏省苏州市金阊区",
            "江苏省苏州市虎丘区",
            "江苏省苏州市吴中区",
            "江苏省苏州市相城区",
            "江苏省苏州市常熟市",
            "江苏省苏州市张家港市",
            "江苏省苏州市昆山市",
            "江苏省苏州市吴江市",
            "江苏省苏州市太仓市",
            "江苏省南通市崇川区",
            "江苏省南通市港闸区",
            "江苏省南通市海安县",
            "江苏省南通市如东县",
            "江苏省南通市启东市",
            "江苏省南通市如皋市",
            "江苏省南通市通州市",
            "江苏省南通市海门市",
            "江苏省连云港市连云区",
            "江苏省连云港市新浦区",
            "江苏省连云港市海州区",
            "江苏省连云港市赣榆县",
            "江苏省连云港市东海县",
            "江苏省连云港市灌云县",
            "江苏省连云港市灌南县",
            "江苏省淮安市清河区",
            "江苏省淮安市楚州区",
            "江苏省淮安市淮阴区",
            "江苏省淮安市清浦区",
            "江苏省淮安市涟水县",
            "江苏省淮安市洪泽县",
            "江苏省淮安市盱眙县",
            "江苏省淮安市金湖县",
            "江苏省盐城市亭湖区",
            "江苏省盐城市盐都区",
            "江苏省盐城市响水县",
            "江苏省盐城市滨海县",
            "江苏省盐城市阜宁县",
            "江苏省盐城市射阳县",
            "江苏省盐城市建湖县",
            "江苏省盐城市东台市",
            "江苏省盐城市大丰市",
            "江苏省扬州市广陵区",
            "江苏省扬州市邗江区",
            "江苏省扬州市维扬区",
            "江苏省扬州市宝应县",
            "江苏省扬州市仪征市",
            "江苏省扬州市高邮市",
            "江苏省扬州市江都市",
            "江苏省镇江市京口区",
            "江苏省镇江市润州区",
            "江苏省镇江市丹徒区",
            "江苏省镇江市丹阳市",
            "江苏省镇江市扬中市",
            "江苏省镇江市句容市",
            "江苏省泰州市海陵区",
            "江苏省泰州市高港区",
            "江苏省泰州市兴化市",
            "江苏省泰州市靖江市",
            "江苏省泰州市泰兴市",
            "江苏省泰州市姜堰市",
            "江苏省宿迁市宿城区",
            "江苏省宿迁市宿豫区",
            "江苏省宿迁市沭阳县",
            "江苏省宿迁市泗阳县",
            "江苏省宿迁市泗洪县",
            "浙江省杭州市上城区",
            "浙江省杭州市下城区",
            "浙江省杭州市江干区",
            "浙江省杭州市拱墅区",
            "浙江省杭州市西湖区",
            "浙江省杭州市滨江区",
            "浙江省杭州市萧山区",
            "浙江省杭州市余杭区",
            "浙江省杭州市桐庐县",
            "浙江省杭州市淳安县",
            "浙江省杭州市建德市",
            "浙江省杭州市富阳市",
            "浙江省杭州市临安市",
            "浙江省宁波市海曙区",
            "浙江省宁波市江东区",
            "浙江省宁波市江北区",
            "浙江省宁波市北仑区",
            "浙江省宁波市镇海区",
            "浙江省宁波市鄞州区",
            "浙江省宁波市象山县",
            "浙江省宁波市宁海县",
            "浙江省宁波市余姚市",
            "浙江省宁波市慈溪市",
            "浙江省宁波市奉化市",
            "浙江省温州市鹿城区",
            "浙江省温州市龙湾区",
            "浙江省温州市瓯海区",
            "浙江省温州市洞头县",
            "浙江省温州市永嘉县",
            "浙江省温州市平阳县",
            "浙江省温州市苍南县",
            "浙江省温州市文成县",
            "浙江省温州市泰顺县",
            "浙江省温州市瑞安市",
            "浙江省温州市乐清市",
            "浙江省嘉兴市秀城区",
            "浙江省嘉兴市秀洲区",
            "浙江省嘉兴市嘉善县",
            "浙江省嘉兴市海盐县",
            "浙江省嘉兴市海宁市",
            "浙江省嘉兴市平湖市",
            "浙江省嘉兴市桐乡市",
            "浙江省湖州市吴兴区",
            "浙江省湖州市南浔区",
            "浙江省湖州市德清县",
            "浙江省湖州市长兴县",
            "浙江省湖州市安吉县",
            "浙江省绍兴市越城区",
            "浙江省绍兴市绍兴县",
            "浙江省绍兴市新昌县",
            "浙江省绍兴市诸暨市",
            "浙江省绍兴市上虞市",
            "浙江省绍兴市嵊州市",
            "浙江省金华市婺城区",
            "浙江省金华市金东区",
            "浙江省金华市武义县",
            "浙江省金华市浦江县",
            "浙江省金华市磐安县",
            "浙江省金华市兰溪市",
            "浙江省金华市义乌市",
            "浙江省金华市东阳市",
            "浙江省金华市永康市",
            "浙江省衢州市柯城区",
            "浙江省衢州市衢江区",
            "浙江省衢州市常山县",
            "浙江省衢州市开化县",
            "浙江省衢州市龙游县",
            "浙江省衢州市江山市",
            "浙江省舟山市定海区",
            "浙江省舟山市普陀区",
            "浙江省舟山市岱山县",
            "浙江省舟山市嵊泗县",
            "浙江省台州市椒江区",
            "浙江省台州市黄岩区",
            "浙江省台州市路桥区",
            "浙江省台州市玉环县",
            "浙江省台州市三门县",
            "浙江省台州市天台县",
            "浙江省台州市仙居县",
            "浙江省台州市温岭市",
            "浙江省台州市临海市",
            "浙江省丽水市莲都区",
            "浙江省丽水市青田县",
            "浙江省丽水市缙云县",
            "浙江省丽水市遂昌县",
            "浙江省丽水市松阳县",
            "浙江省丽水市云和县",
            "浙江省丽水市庆元县",
            "浙江省丽水市景宁畲族自治县",
            "浙江省丽水市龙泉市",
            "安徽省合肥市瑶海区",
            "安徽省合肥市庐阳区",
            "安徽省合肥市蜀山区",
            "安徽省合肥市包河区",
            "安徽省合肥市长丰县",
            "安徽省合肥市肥东县",
            "安徽省合肥市肥西县",
            "安徽省芜湖市镜湖区",
            "安徽省芜湖市弋江区",
            "安徽省芜湖市鸠江区",
            "安徽省芜湖市三山区",
            "安徽省芜湖市芜湖县",
            "安徽省芜湖市繁昌县",
            "安徽省芜湖市南陵县",
            "安徽省蚌埠市龙子湖区",
            "安徽省蚌埠市蚌山区",
            "安徽省蚌埠市禹会区",
            "安徽省蚌埠市淮上区",
            "安徽省蚌埠市怀远县",
            "安徽省蚌埠市五河县",
            "安徽省蚌埠市固镇县",
            "安徽省淮南市大通区",
            "安徽省淮南市田家庵区",
            "安徽省淮南市谢家集区",
            "安徽省淮南市八公山区",
            "安徽省淮南市潘集区",
            "安徽省淮南市凤台县",
            "安徽省马鞍山市金家庄区",
            "安徽省马鞍山市花山区",
            "安徽省马鞍山市雨山区",
            "安徽省马鞍山市当涂县",
            "安徽省淮北市杜集区",
            "安徽省淮北市相山区",
            "安徽省淮北市烈山区",
            "安徽省淮北市濉溪县",
            "安徽省铜陵市铜官山区",
            "安徽省铜陵市狮子山区",
            "安徽省铜陵市郊区",
            "安徽省铜陵市铜陵县",
            "安徽省安庆市迎江区",
            "安徽省安庆市大观区",
            "安徽省安庆市宜秀区",
            "安徽省安庆市怀宁县",
            "安徽省安庆市枞阳县",
            "安徽省安庆市潜山县",
            "安徽省安庆市太湖县",
            "安徽省安庆市宿松县",
            "安徽省安庆市望江县",
            "安徽省安庆市岳西县",
            "安徽省安庆市桐城市",
            "安徽省黄山市屯溪区",
            "安徽省黄山市黄山区",
            "安徽省黄山市徽州区",
            "安徽省黄山市歙县",
            "安徽省黄山市休宁县",
            "安徽省黄山市黟县",
            "安徽省黄山市祁门县",
            "安徽省滁州市琅琊区",
            "安徽省滁州市南谯区",
            "安徽省滁州市来安县",
            "安徽省滁州市全椒县",
            "安徽省滁州市定远县",
            "安徽省滁州市凤阳县",
            "安徽省滁州市天长市",
            "安徽省滁州市明光市",
            "安徽省阜阳市颍州区",
            "安徽省阜阳市颍东区",
            "安徽省阜阳市颍泉区",
            "安徽省阜阳市临泉县",
            "安徽省阜阳市太和县",
            "安徽省阜阳市阜南县",
            "安徽省阜阳市颍上县",
            "安徽省阜阳市界首市",
            "安徽省宿州市埇桥区",
            "安徽省宿州市砀山县",
            "安徽省宿州市萧县",
            "安徽省宿州市灵璧县",
            "安徽省宿州市泗县",
            "安徽省巢湖市居巢区",
            "安徽省巢湖市庐江县",
            "安徽省巢湖市无为县",
            "安徽省巢湖市含山县",
            "安徽省巢湖市和县",
            "安徽省六安市金安区",
            "安徽省六安市裕安区",
            "安徽省六安市寿县",
            "安徽省六安市霍邱县",
            "安徽省六安市舒城县",
            "安徽省六安市金寨县",
            "安徽省六安市霍山县",
            "安徽省亳州市谯城区",
            "安徽省亳州市涡阳县",
            "安徽省亳州市蒙城县",
            "安徽省亳州市利辛县",
            "安徽省池州市贵池区",
            "安徽省池州市东至县",
            "安徽省池州市石台县",
            "安徽省池州市青阳县",
            "安徽省宣城市宣州区",
            "安徽省宣城市郎溪县",
            "安徽省宣城市广德县",
            "安徽省宣城市泾县",
            "安徽省宣城市绩溪县",
            "安徽省宣城市旌德县",
            "安徽省宣城市宁国市",
            "福建省福州市鼓楼区",
            "福建省福州市台江区",
            "福建省福州市仓山区",
            "福建省福州市马尾区",
            "福建省福州市晋安区",
            "福建省福州市闽侯县",
            "福建省福州市连江县",
            "福建省福州市罗源县",
            "福建省福州市闽清县",
            "福建省福州市永泰县",
            "福建省福州市平潭县",
            "福建省福州市福清市",
            "福建省福州市长乐市",
            "福建省厦门市思明区",
            "福建省厦门市海沧区",
            "福建省厦门市湖里区",
            "福建省厦门市集美区",
            "福建省厦门市同安区",
            "福建省厦门市翔安区",
            "福建省莆田市城厢区",
            "福建省莆田市涵江区",
            "福建省莆田市荔城区",
            "福建省莆田市秀屿区",
            "福建省莆田市仙游县",
            "福建省三明市梅列区",
            "福建省三明市三元区",
            "福建省三明市明溪县",
            "福建省三明市清流县",
            "福建省三明市宁化县",
            "福建省三明市大田县",
            "福建省三明市尤溪县",
            "福建省三明市沙县",
            "福建省三明市将乐县",
            "福建省三明市泰宁县",
            "福建省三明市建宁县",
            "福建省三明市永安市",
            "福建省泉州市鲤城区",
            "福建省泉州市丰泽区",
            "福建省泉州市洛江区",
            "福建省泉州市泉港区",
            "福建省泉州市惠安县",
            "福建省泉州市安溪县",
            "福建省泉州市永春县",
            "福建省泉州市德化县",
            "福建省泉州市金门县",
            "福建省泉州市石狮市",
            "福建省泉州市晋江市",
            "福建省泉州市南安市",
            "福建省漳州市芗城区",
            "福建省漳州市龙文区",
            "福建省漳州市云霄县",
            "福建省漳州市漳浦县",
            "福建省漳州市诏安县",
            "福建省漳州市长泰县",
            "福建省漳州市东山县",
            "福建省漳州市南靖县",
            "福建省漳州市平和县",
            "福建省漳州市华安县",
            "福建省漳州市龙海市",
            "福建省南平市延平区",
            "福建省南平市顺昌县",
            "福建省南平市浦城县",
            "福建省南平市光泽县",
            "福建省南平市松溪县",
            "福建省南平市政和县",
            "福建省南平市邵武市",
            "福建省南平市武夷山市",
            "福建省南平市建瓯市",
            "福建省南平市建阳市",
            "福建省龙岩市新罗区",
            "福建省龙岩市长汀县",
            "福建省龙岩市永定县",
            "福建省龙岩市上杭县",
            "福建省龙岩市武平县",
            "福建省龙岩市连城县",
            "福建省龙岩市漳平市",
            "福建省宁德市蕉城区",
            "福建省宁德市霞浦县",
            "福建省宁德市古田县",
            "福建省宁德市屏南县",
            "福建省宁德市寿宁县",
            "福建省宁德市周宁县",
            "福建省宁德市柘荣县",
            "福建省宁德市福安市",
            "福建省宁德市福鼎市",
            "江西省南昌市东湖区",
            "江西省南昌市西湖区",
            "江西省南昌市青云谱区",
            "江西省南昌市湾里区",
            "江西省南昌市青山湖区",
            "江西省南昌市南昌县",
            "江西省南昌市新建县",
            "江西省南昌市安义县",
            "江西省南昌市进贤县",
            "江西省景德镇市昌江区",
            "江西省景德镇市珠山区",
            "江西省景德镇市浮梁县",
            "江西省景德镇市乐平市",
            "江西省萍乡市安源区",
            "江西省萍乡市湘东区",
            "江西省萍乡市莲花县",
            "江西省萍乡市上栗县",
            "江西省萍乡市芦溪县",
            "江西省九江市庐山区",
            "江西省九江市浔阳区",
            "江西省九江市九江县",
            "江西省九江市武宁县",
            "江西省九江市修水县",
            "江西省九江市永修县",
            "江西省九江市德安县",
            "江西省九江市星子县",
            "江西省九江市都昌县",
            "江西省九江市湖口县",
            "江西省九江市彭泽县",
            "江西省九江市瑞昌市",
            "江西省新余市渝水区",
            "江西省新余市分宜县",
            "江西省鹰潭市月湖区",
            "江西省鹰潭市余江县",
            "江西省鹰潭市贵溪市",
            "江西省赣州市章贡区",
            "江西省赣州市赣县",
            "江西省赣州市信丰县",
            "江西省赣州市大余县",
            "江西省赣州市上犹县",
            "江西省赣州市崇义县",
            "江西省赣州市安远县",
            "江西省赣州市龙南县",
            "江西省赣州市定南县",
            "江西省赣州市全南县",
            "江西省赣州市宁都县",
            "江西省赣州市于都县",
            "江西省赣州市兴国县",
            "江西省赣州市会昌县",
            "江西省赣州市寻乌县",
            "江西省赣州市石城县",
            "江西省赣州市瑞金市",
            "江西省赣州市南康市",
            "江西省吉安市吉州区",
            "江西省吉安市青原区",
            "江西省吉安市吉安县",
            "江西省吉安市吉水县",
            "江西省吉安市峡江县",
            "江西省吉安市新干县",
            "江西省吉安市永丰县",
            "江西省吉安市泰和县",
            "江西省吉安市遂川县",
            "江西省吉安市万安县",
            "江西省吉安市安福县",
            "江西省吉安市永新县",
            "江西省吉安市井冈山市",
            "江西省宜春市袁州区",
            "江西省宜春市奉新县",
            "江西省宜春市万载县",
            "江西省宜春市上高县",
            "江西省宜春市宜丰县",
            "江西省宜春市靖安县",
            "江西省宜春市铜鼓县",
            "江西省宜春市丰城市",
            "江西省宜春市樟树市",
            "江西省宜春市高安市",
            "江西省抚州市临川区",
            "江西省抚州市南城县",
            "江西省抚州市黎川县",
            "江西省抚州市南丰县",
            "江西省抚州市崇仁县",
            "江西省抚州市乐安县",
            "江西省抚州市宜黄县",
            "江西省抚州市金溪县",
            "江西省抚州市资溪县",
            "江西省抚州市东乡县",
            "江西省抚州市广昌县",
            "江西省上饶市信州区",
            "江西省上饶市上饶县",
            "江西省上饶市广丰县",
            "江西省上饶市玉山县",
            "江西省上饶市铅山县",
            "江西省上饶市横峰县",
            "江西省上饶市弋阳县",
            "江西省上饶市余干县",
            "江西省上饶市鄱阳县",
            "江西省上饶市万年县",
            "江西省上饶市婺源县",
            "江西省上饶市德兴市",
            "山东省济南市历下区",
            "山东省济南市市中区",
            "山东省济南市槐荫区",
            "山东省济南市天桥区",
            "山东省济南市历城区",
            "山东省济南市长清区",
            "山东省济南市平阴县",
            "山东省济南市济阳县",
            "山东省济南市商河县",
            "山东省济南市章丘市",
            "山东省青岛市市南区",
            "山东省青岛市市北区",
            "山东省青岛市四方区",
            "山东省青岛市黄岛区",
            "山东省青岛市崂山区",
            "山东省青岛市李沧区",
            "山东省青岛市城阳区",
            "山东省青岛市胶州市",
            "山东省青岛市即墨市",
            "山东省青岛市平度市",
            "山东省青岛市胶南市",
            "山东省青岛市莱西市",
            "山东省淄博市淄川区",
            "山东省淄博市张店区",
            "山东省淄博市博山区",
            "山东省淄博市临淄区",
            "山东省淄博市周村区",
            "山东省淄博市桓台县",
            "山东省淄博市高青县",
            "山东省淄博市沂源县",
            "山东省枣庄市市中区",
            "山东省枣庄市薛城区",
            "山东省枣庄市峄城区",
            "山东省枣庄市台儿庄区",
            "山东省枣庄市山亭区",
            "山东省枣庄市滕州市",
            "山东省东营市东营区",
            "山东省东营市河口区",
            "山东省东营市垦利县",
            "山东省东营市利津县",
            "山东省东营市广饶县",
            "山东省烟台市芝罘区",
            "山东省烟台市福山区",
            "山东省烟台市牟平区",
            "山东省烟台市莱山区",
            "山东省烟台市长岛县",
            "山东省烟台市龙口市",
            "山东省烟台市莱阳市",
            "山东省烟台市莱州市",
            "山东省烟台市蓬莱市",
            "山东省烟台市招远市",
            "山东省烟台市栖霞市",
            "山东省烟台市海阳市",
            "山东省潍坊市潍城区",
            "山东省潍坊市寒亭区",
            "山东省潍坊市坊子区",
            "山东省潍坊市奎文区",
            "山东省潍坊市临朐县",
            "山东省潍坊市昌乐县",
            "山东省潍坊市青州市",
            "山东省潍坊市诸城市",
            "山东省潍坊市寿光市",
            "山东省潍坊市安丘市",
            "山东省潍坊市高密市",
            "山东省潍坊市昌邑市",
            "山东省济宁市市中区",
            "山东省济宁市任城区",
            "山东省济宁市微山县",
            "山东省济宁市鱼台县",
            "山东省济宁市金乡县",
            "山东省济宁市嘉祥县",
            "山东省济宁市汶上县",
            "山东省济宁市泗水县",
            "山东省济宁市梁山县",
            "山东省济宁市曲阜市",
            "山东省济宁市兖州市",
            "山东省济宁市邹城市",
            "山东省泰安市泰山区",
            "山东省泰安市岱岳区",
            "山东省泰安市宁阳县",
            "山东省泰安市东平县",
            "山东省泰安市新泰市",
            "山东省泰安市肥城市",
            "山东省威海市环翠区",
            "山东省威海市文登市",
            "山东省威海市荣成市",
            "山东省威海市乳山市",
            "山东省日照市东港区",
            "山东省日照市岚山区",
            "山东省日照市五莲县",
            "山东省日照市莒县",
            "山东省莱芜市莱城区",
            "山东省莱芜市钢城区",
            "山东省莱芜市兰山区",
            "山东省莱芜市罗庄区",
            "山东省莱芜市河东区",
            "山东省莱芜市沂南县",
            "山东省莱芜市郯城县",
            "山东省莱芜市沂水县",
            "山东省莱芜市苍山县",
            "山东省莱芜市费县",
            "山东省莱芜市平邑县",
            "山东省莱芜市莒南县",
            "山东省莱芜市蒙阴县",
            "山东省莱芜市临沭县",
            "山东省德州市德城区",
            "山东省德州市陵县",
            "山东省德州市宁津县",
            "山东省德州市庆云县",
            "山东省德州市临邑县",
            "山东省德州市齐河县",
            "山东省德州市平原县",
            "山东省德州市夏津县",
            "山东省德州市武城县",
            "山东省德州市乐陵市",
            "山东省德州市禹城市",
            "山东省聊城市东昌府区",
            "山东省聊城市阳谷县",
            "山东省聊城市莘县",
            "山东省聊城市茌平县",
            "山东省聊城市东阿县",
            "山东省聊城市冠县",
            "山东省聊城市高唐县",
            "山东省聊城市临清市",
            "山东省滨州市滨城区",
            "山东省滨州市惠民县",
            "山东省滨州市阳信县",
            "山东省滨州市无棣县",
            "山东省滨州市沾化县",
            "山东省滨州市博兴县",
            "山东省滨州市邹平县",
            "山东省菏泽市牡丹区",
            "山东省菏泽市曹县",
            "山东省菏泽市单县",
            "山东省菏泽市成武县",
            "山东省菏泽市巨野县",
            "山东省菏泽市郓城县",
            "山东省菏泽市鄄城县",
            "山东省菏泽市定陶县",
            "山东省菏泽市东明县",
            "河南省郑州市中原区",
            "河南省郑州市二七区",
            "河南省郑州市管城回族区",
            "河南省郑州市金水区",
            "河南省郑州市上街区",
            "河南省郑州市惠济区",
            "河南省郑州市中牟县",
            "河南省郑州市巩义市",
            "河南省郑州市荥阳市",
            "河南省郑州市新密市",
            "河南省郑州市新郑市",
            "河南省郑州市登封市",
            "河南省开封市龙亭区",
            "河南省开封市顺河回族区",
            "河南省开封市鼓楼区",
            "河南省开封市禹王台区",
            "河南省开封市金明区",
            "河南省开封市杞县",
            "河南省开封市通许县",
            "河南省开封市尉氏县",
            "河南省开封市开封县",
            "河南省开封市兰考县",
            "河南省洛阳市老城区",
            "河南省洛阳市西工区",
            "河南省洛阳市廛河回族区",
            "河南省洛阳市涧西区",
            "河南省洛阳市吉利区",
            "河南省洛阳市洛龙区",
            "河南省洛阳市孟津县",
            "河南省洛阳市新安县",
            "河南省洛阳市栾川县",
            "河南省洛阳市嵩县",
            "河南省洛阳市汝阳县",
            "河南省洛阳市宜阳县",
            "河南省洛阳市洛宁县",
            "河南省洛阳市伊川县",
            "河南省洛阳市偃师市",
            "河南省平顶山市新华区",
            "河南省平顶山市卫东区",
            "河南省平顶山市石龙区",
            "河南省平顶山市湛河区",
            "河南省平顶山市宝丰县",
            "河南省平顶山市叶县",
            "河南省平顶山市鲁山县",
            "河南省平顶山市郏县",
            "河南省平顶山市舞钢市",
            "河南省平顶山市汝州市",
            "河南省安阳市文峰区",
            "河南省安阳市北关区",
            "河南省安阳市殷都区",
            "河南省安阳市龙安区",
            "河南省安阳市安阳县",
            "河南省安阳市汤阴县",
            "河南省安阳市滑县",
            "河南省安阳市内黄县",
            "河南省安阳市林州市",
            "河南省鹤壁市鹤山区",
            "河南省鹤壁市山城区",
            "河南省鹤壁市淇滨区",
            "河南省鹤壁市浚县",
            "河南省鹤壁市淇县",
            "河南省新乡市红旗区",
            "河南省新乡市卫滨区",
            "河南省新乡市凤泉区",
            "河南省新乡市牧野区",
            "河南省新乡市新乡县",
            "河南省新乡市获嘉县",
            "河南省新乡市原阳县",
            "河南省新乡市延津县",
            "河南省新乡市封丘县",
            "河南省新乡市长垣县",
            "河南省新乡市卫辉市",
            "河南省新乡市辉县市",
            "河南省焦作市解放区",
            "河南省焦作市中站区",
            "河南省焦作市马村区",
            "河南省焦作市山阳区",
            "河南省焦作市修武县",
            "河南省焦作市博爱县",
            "河南省焦作市武陟县",
            "河南省焦作市温县",
            "河南省焦作市济源市",
            "河南省焦作市沁阳市",
            "河南省焦作市孟州市",
            "河南省濮阳市华龙区",
            "河南省濮阳市清丰县",
            "河南省濮阳市南乐县",
            "河南省濮阳市范县",
            "河南省濮阳市台前县",
            "河南省濮阳市濮阳县",
            "河南省许昌市魏都区",
            "河南省许昌市许昌县",
            "河南省许昌市鄢陵县",
            "河南省许昌市襄城县",
            "河南省许昌市禹州市",
            "河南省许昌市长葛市",
            "河南省许昌市源汇区",
            "河南省许昌市郾城区",
            "河南省许昌市召陵区",
            "河南省许昌市舞阳县",
            "河南省许昌市临颍县",
            "河南省三门峡市湖滨区",
            "河南省三门峡市渑池县",
            "河南省三门峡市陕县",
            "河南省三门峡市卢氏县",
            "河南省三门峡市义马市",
            "河南省三门峡市灵宝市",
            "河南省南阳市宛城区",
            "河南省南阳市卧龙区",
            "河南省南阳市南召县",
            "河南省南阳市方城县",
            "河南省南阳市西峡县",
            "河南省南阳市镇平县",
            "河南省南阳市内乡县",
            "河南省南阳市淅川县",
            "河南省南阳市社旗县",
            "河南省南阳市唐河县",
            "河南省南阳市新野县",
            "河南省南阳市桐柏县",
            "河南省南阳市邓州市",
            "河南省商丘市梁园区",
            "河南省商丘市睢阳区",
            "河南省商丘市民权县",
            "河南省商丘市睢县",
            "河南省商丘市宁陵县",
            "河南省商丘市柘城县",
            "河南省商丘市虞城县",
            "河南省商丘市夏邑县",
            "河南省商丘市永城市",
            "河南省信阳市浉河区",
            "河南省信阳市平桥区",
            "河南省信阳市罗山县",
            "河南省信阳市光山县",
            "河南省信阳市新县",
            "河南省信阳市商城县",
            "河南省信阳市固始县",
            "河南省信阳市潢川县",
            "河南省信阳市淮滨县",
            "河南省信阳市息县",
            "河南省周口市川汇区",
            "河南省周口市扶沟县",
            "河南省周口市西华县",
            "河南省周口市商水县",
            "河南省周口市沈丘县",
            "河南省周口市郸城县",
            "河南省周口市淮阳县",
            "河南省周口市太康县",
            "河南省周口市鹿邑县",
            "河南省周口市项城市",
            "河南省驻马店市驿城区",
            "河南省驻马店市西平县",
            "河南省驻马店市上蔡县",
            "河南省驻马店市平舆县",
            "河南省驻马店市正阳县",
            "河南省驻马店市确山县",
            "河南省驻马店市泌阳县",
            "河南省驻马店市汝南县",
            "河南省驻马店市遂平县",
            "河南省驻马店市新蔡县",
            "湖北省武汉市江岸区",
            "湖北省武汉市江汉区",
            "湖北省武汉市硚口区",
            "湖北省武汉市汉阳区",
            "湖北省武汉市武昌区",
            "湖北省武汉市青山区",
            "湖北省武汉市洪山区",
            "湖北省武汉市东西湖区",
            "湖北省武汉市汉南区",
            "湖北省武汉市蔡甸区",
            "湖北省武汉市江夏区",
            "湖北省武汉市黄陂区",
            "湖北省武汉市新洲区",
            "湖北省黄石市黄石港区",
            "湖北省黄石市西塞山区",
            "湖北省黄石市下陆区",
            "湖北省黄石市铁山区",
            "湖北省黄石市阳新县",
            "湖北省黄石市大冶市",
            "湖北省十堰市茅箭区",
            "湖北省十堰市张湾区",
            "湖北省十堰市郧县",
            "湖北省十堰市郧西县",
            "湖北省十堰市竹山县",
            "湖北省十堰市竹溪县",
            "湖北省十堰市房县",
            "湖北省十堰市丹江口市",
            "湖北省宜昌市西陵区",
            "湖北省宜昌市伍家岗区",
            "湖北省宜昌市点军区",
            "湖北省宜昌市猇亭区",
            "湖北省宜昌市夷陵区",
            "湖北省宜昌市远安县",
            "湖北省宜昌市兴山县",
            "湖北省宜昌市秭归县",
            "湖北省宜昌市长阳土家族自治县",
            "湖北省宜昌市五峰土家族自治县",
            "湖北省宜昌市宜都市",
            "湖北省宜昌市当阳市",
            "湖北省宜昌市枝江市",
            "湖北省襄樊市襄城区",
            "湖北省襄樊市樊城区",
            "湖北省襄樊市襄阳区",
            "湖北省襄樊市南漳县",
            "湖北省襄樊市谷城县",
            "湖北省襄樊市保康县",
            "湖北省襄樊市老河口市",
            "湖北省襄樊市枣阳市",
            "湖北省襄樊市宜城市",
            "湖北省鄂州市梁子湖区",
            "湖北省鄂州市华容区",
            "湖北省鄂州市鄂城区",
            "湖北省荆门市东宝区",
            "湖北省荆门市掇刀区",
            "湖北省荆门市京山县",
            "湖北省荆门市沙洋县",
            "湖北省荆门市钟祥市",
            "湖北省孝感市孝南区",
            "湖北省孝感市孝昌县",
            "湖北省孝感市大悟县",
            "湖北省孝感市云梦县",
            "湖北省孝感市应城市",
            "湖北省孝感市安陆市",
            "湖北省孝感市汉川市",
            "湖北省荆州市沙市区",
            "湖北省荆州市荆州区",
            "湖北省荆州市公安县",
            "湖北省荆州市监利县",
            "湖北省荆州市江陵县",
            "湖北省荆州市石首市",
            "湖北省荆州市洪湖市",
            "湖北省荆州市松滋市",
            "湖北省黄冈市黄州区",
            "湖北省黄冈市团风县",
            "湖北省黄冈市红安县",
            "湖北省黄冈市罗田县",
            "湖北省黄冈市英山县",
            "湖北省黄冈市浠水县",
            "湖北省黄冈市蕲春县",
            "湖北省黄冈市黄梅县",
            "湖北省黄冈市麻城市",
            "湖北省黄冈市武穴市",
            "湖北省咸宁市咸安区",
            "湖北省咸宁市通城县",
            "湖北省咸宁市崇阳县",
            "湖北省咸宁市通山县",
            "湖北省咸宁市赤壁市",
            "湖北省随州市曾都区",
            "湖北省随州市广水市",
            "湖北省恩施土家族苗族自治州恩施市",
            "湖北省恩施土家族苗族自治州利川市",
            "湖北省恩施土家族苗族自治州建始县",
            "湖北省恩施土家族苗族自治州巴东县",
            "湖北省恩施土家族苗族自治州宣恩县",
            "湖北省恩施土家族苗族自治州咸丰县",
            "湖北省恩施土家族苗族自治州来凤县",
            "湖北省恩施土家族苗族自治州鹤峰县",
            "湖北省仙桃市",
            "湖北省潜江市",
            "湖北省天门市",
            "湖北省神农架林区",
            "湖南省长沙市芙蓉区",
            "湖南省长沙市天心区",
            "湖南省长沙市岳麓区",
            "湖南省长沙市开福区",
            "湖南省长沙市雨花区",
            "湖南省长沙市长沙县",
            "湖南省长沙市望城县",
            "湖南省长沙市宁乡县",
            "湖南省长沙市浏阳市",
            "湖南省株洲市荷塘区",
            "湖南省株洲市芦淞区",
            "湖南省株洲市石峰区",
            "湖南省株洲市天元区",
            "湖南省株洲市株洲县",
            "湖南省株洲市攸县",
            "湖南省株洲市茶陵县",
            "湖南省株洲市炎陵县",
            "湖南省株洲市醴陵市",
            "湖南省湘潭市雨湖区",
            "湖南省湘潭市岳塘区",
            "湖南省湘潭市湘潭县",
            "湖南省湘潭市湘乡市",
            "湖南省湘潭市韶山市",
            "湖南省衡阳市珠晖区",
            "湖南省衡阳市雁峰区",
            "湖南省衡阳市石鼓区",
            "湖南省衡阳市蒸湘区",
            "湖南省衡阳市南岳区",
            "湖南省衡阳市衡阳县",
            "湖南省衡阳市衡南县",
            "湖南省衡阳市衡山县",
            "湖南省衡阳市衡东县",
            "湖南省衡阳市祁东县",
            "湖南省衡阳市耒阳市",
            "湖南省衡阳市常宁市",
            "湖南省邵阳市双清区",
            "湖南省邵阳市大祥区",
            "湖南省邵阳市北塔区",
            "湖南省邵阳市邵东县",
            "湖南省邵阳市新邵县",
            "湖南省邵阳市邵阳县",
            "湖南省邵阳市隆回县",
            "湖南省邵阳市洞口县",
            "湖南省邵阳市绥宁县",
            "湖南省邵阳市新宁县",
            "湖南省邵阳市城步苗族自治县",
            "湖南省邵阳市武冈市",
            "湖南省岳阳市岳阳楼区",
            "湖南省岳阳市云溪区",
            "湖南省岳阳市君山区",
            "湖南省岳阳市岳阳县",
            "湖南省岳阳市华容县",
            "湖南省岳阳市湘阴县",
            "湖南省岳阳市平江县",
            "湖南省岳阳市汨罗市",
            "湖南省岳阳市临湘市",
            "湖南省常德市武陵区",
            "湖南省常德市鼎城区",
            "湖南省常德市安乡县",
            "湖南省常德市汉寿县",
            "湖南省常德市澧县",
            "湖南省常德市临澧县",
            "湖南省常德市桃源县",
            "湖南省常德市石门县",
            "湖南省常德市津市市",
            "湖南省张家界市永定区",
            "湖南省张家界市武陵源区",
            "湖南省张家界市慈利县",
            "湖南省张家界市桑植县",
            "湖南省益阳市资阳区",
            "湖南省益阳市赫山区",
            "湖南省益阳市南县",
            "湖南省益阳市桃江县",
            "湖南省益阳市安化县",
            "湖南省益阳市沅江市",
            "湖南省郴州市北湖区",
            "湖南省郴州市苏仙区",
            "湖南省郴州市桂阳县",
            "湖南省郴州市宜章县",
            "湖南省郴州市永兴县",
            "湖南省郴州市嘉禾县",
            "湖南省郴州市临武县",
            "湖南省郴州市汝城县",
            "湖南省郴州市桂东县",
            "湖南省郴州市安仁县",
            "湖南省郴州市资兴市",
            "湖南省永州市零陵区",
            "湖南省永州市冷水滩区",
            "湖南省永州市祁阳县",
            "湖南省永州市东安县",
            "湖南省永州市双牌县",
            "湖南省永州市道县",
            "湖南省永州市江永县",
            "湖南省永州市宁远县",
            "湖南省永州市蓝山县",
            "湖南省永州市新田县",
            "湖南省永州市江华瑶族自治县",
            "湖南省怀化市鹤城区",
            "湖南省怀化市中方县",
            "湖南省怀化市沅陵县",
            "湖南省怀化市辰溪县",
            "湖南省怀化市溆浦县",
            "湖南省怀化市会同县",
            "湖南省怀化市麻阳苗族自治县",
            "湖南省怀化市新晃侗族自治县",
            "湖南省怀化市芷江侗族自治县",
            "湖南省怀化市靖州苗族侗族自治县",
            "湖南省怀化市通道侗族自治县",
            "湖南省怀化市洪江市",
            "湖南省娄底市娄星区",
            "湖南省娄底市双峰县",
            "湖南省娄底市新化县",
            "湖南省娄底市冷水江市",
            "湖南省娄底市涟源市",
            "湖南省湘西土家族苗族自治州吉首市",
            "湖南省湘西土家族苗族自治州泸溪县",
            "湖南省湘西土家族苗族自治州凤凰县",
            "湖南省湘西土家族苗族自治州花垣县",
            "湖南省湘西土家族苗族自治州保靖县",
            "湖南省湘西土家族苗族自治州古丈县",
            "湖南省湘西土家族苗族自治州永顺县",
            "湖南省湘西土家族苗族自治州龙山县",
            "广东省广州市荔湾区",
            "广东省广州市越秀区",
            "广东省广州市海珠区",
            "广东省广州市天河区",
            "广东省广州市白云区",
            "广东省广州市黄埔区",
            "广东省广州市番禺区",
            "广东省广州市花都区",
            "广东省广州市南沙区",
            "广东省广州市萝岗区",
            "广东省广州市增城市",
            "广东省广州市从化市",
            "广东省韶关市武江区",
            "广东省韶关市浈江区",
            "广东省韶关市曲江区",
            "广东省韶关市始兴县",
            "广东省韶关市仁化县",
            "广东省韶关市翁源县",
            "广东省韶关市乳源瑶族自治县",
            "广东省韶关市新丰县",
            "广东省韶关市乐昌市",
            "广东省韶关市南雄市",
            "广东省深圳市罗湖区",
            "广东省深圳市福田区",
            "广东省深圳市南山区",
            "广东省深圳市宝安区",
            "广东省深圳市龙岗区",
            "广东省深圳市盐田区",
            "广东省珠海市香洲区",
            "广东省珠海市斗门区",
            "广东省珠海市金湾区",
            "广东省汕头市龙湖区",
            "广东省汕头市金平区",
            "广东省汕头市濠江区",
            "广东省汕头市潮阳区",
            "广东省汕头市潮南区",
            "广东省汕头市澄海区",
            "广东省汕头市南澳县",
            "广东省佛山市禅城区",
            "广东省佛山市南海区",
            "广东省佛山市顺德区",
            "广东省佛山市三水区",
            "广东省佛山市高明区",
            "广东省江门市蓬江区",
            "广东省江门市江海区",
            "广东省江门市新会区",
            "广东省江门市台山市",
            "广东省江门市开平市",
            "广东省江门市鹤山市",
            "广东省江门市恩平市",
            "广东省湛江市赤坎区",
            "广东省湛江市霞山区",
            "广东省湛江市坡头区",
            "广东省湛江市麻章区",
            "广东省湛江市遂溪县",
            "广东省湛江市徐闻县",
            "广东省湛江市廉江市",
            "广东省湛江市雷州市",
            "广东省湛江市吴川市",
            "广东省茂名市茂南区",
            "广东省茂名市茂港区",
            "广东省茂名市电白县",
            "广东省茂名市高州市",
            "广东省茂名市化州市",
            "广东省茂名市信宜市",
            "广东省肇庆市端州区",
            "广东省肇庆市鼎湖区",
            "广东省肇庆市广宁县",
            "广东省肇庆市怀集县",
            "广东省肇庆市封开县",
            "广东省肇庆市德庆县",
            "广东省肇庆市高要市",
            "广东省肇庆市四会市",
            "广东省惠州市惠城区",
            "广东省惠州市惠阳区",
            "广东省惠州市博罗县",
            "广东省惠州市惠东县",
            "广东省惠州市龙门县",
            "广东省梅州市梅江区",
            "广东省梅州市梅县",
            "广东省梅州市大埔县",
            "广东省梅州市丰顺县",
            "广东省梅州市五华县",
            "广东省梅州市平远县",
            "广东省梅州市蕉岭县",
            "广东省梅州市兴宁市",
            "广东省汕尾市城区",
            "广东省汕尾市海丰县",
            "广东省汕尾市陆河县",
            "广东省汕尾市陆丰市",
            "广东省河源市源城区",
            "广东省河源市紫金县",
            "广东省河源市龙川县",
            "广东省河源市连平县",
            "广东省河源市和平县",
            "广东省河源市东源县",
            "广东省阳江市江城区",
            "广东省阳江市阳西县",
            "广东省阳江市阳东县",
            "广东省阳江市阳春市",
            "广东省清远市清城区",
            "广东省清远市佛冈县",
            "广东省清远市阳山县",
            "广东省清远市连山壮族瑶族自治县",
            "广东省清远市连南瑶族自治县",
            "广东省清远市清新县",
            "广东省清远市英德市",
            "广东省清远市连州市",
            "广东省清远市东莞市",
            "广东省清远市中山市",
            "广东省潮州市湘桥区",
            "广东省潮州市潮安县",
            "广东省潮州市饶平县",
            "广东省揭阳市榕城区",
            "广东省揭阳市揭东县",
            "广东省揭阳市揭西县",
            "广东省揭阳市惠来县",
            "广东省揭阳市普宁市",
            "广东省云浮市云城区",
            "广东省云浮市新兴县",
            "广东省云浮市郁南县",
            "广东省云浮市云安县",
            "广东省云浮市罗定市",
            "广东省云浮市",
            "广西壮族自治区南宁市兴宁区",
            "广西壮族自治区南宁市青秀区",
            "广西壮族自治区南宁市江南区",
            "广西壮族自治区南宁市西乡塘区",
            "广西壮族自治区南宁市良庆区",
            "广西壮族自治区南宁市邕宁区",
            "广西壮族自治区南宁市武鸣县",
            "广西壮族自治区南宁市隆安县",
            "广西壮族自治区南宁市马山县",
            "广西壮族自治区南宁市上林县",
            "广西壮族自治区南宁市宾阳县",
            "广西壮族自治区南宁市横县",
            "广西壮族自治区柳州市城中区",
            "广西壮族自治区柳州市鱼峰区",
            "广西壮族自治区柳州市柳南区",
            "广西壮族自治区柳州市柳北区",
            "广西壮族自治区柳州市柳江县",
            "广西壮族自治区柳州市柳城县",
            "广西壮族自治区柳州市鹿寨县",
            "广西壮族自治区柳州市融安县",
            "广西壮族自治区柳州市融水苗族自治县",
            "广西壮族自治区柳州市三江侗族自治县",
            "广西壮族自治区桂林市秀峰区",
            "广西壮族自治区桂林市叠彩区",
            "广西壮族自治区桂林市象山区",
            "广西壮族自治区桂林市七星区",
            "广西壮族自治区桂林市雁山区",
            "广西壮族自治区桂林市阳朔县",
            "广西壮族自治区桂林市临桂县",
            "广西壮族自治区桂林市灵川县",
            "广西壮族自治区桂林市全州县",
            "广西壮族自治区桂林市兴安县",
            "广西壮族自治区桂林市永福县",
            "广西壮族自治区桂林市灌阳县",
            "广西壮族自治区桂林市龙胜各族自治县",
            "广西壮族自治区桂林市资源县",
            "广西壮族自治区桂林市平乐县",
            "广西壮族自治区桂林市荔蒲县",
            "广西壮族自治区桂林市恭城瑶族自治县",
            "广西壮族自治区梧州市万秀区",
            "广西壮族自治区梧州市蝶山区",
            "广西壮族自治区梧州市长洲区",
            "广西壮族自治区梧州市苍梧县",
            "广西壮族自治区梧州市藤县",
            "广西壮族自治区梧州市蒙山县",
            "广西壮族自治区梧州市岑溪市",
            "广西壮族自治区北海市海城区",
            "广西壮族自治区北海市银海区",
            "广西壮族自治区北海市铁山港区",
            "广西壮族自治区北海市合浦县",
            "广西壮族自治区防城港市港口区",
            "广西壮族自治区防城港市防城区",
            "广西壮族自治区防城港市上思县",
            "广西壮族自治区防城港市东兴市",
            "广西壮族自治区钦州市钦南区",
            "广西壮族自治区钦州市钦北区",
            "广西壮族自治区钦州市灵山县",
            "广西壮族自治区钦州市浦北县",
            "广西壮族自治区贵港市港北区",
            "广西壮族自治区贵港市港南区",
            "广西壮族自治区贵港市覃塘区",
            "广西壮族自治区贵港市平南县",
            "广西壮族自治区贵港市桂平市",
            "广西壮族自治区玉林市玉州区",
            "广西壮族自治区玉林市容县",
            "广西壮族自治区玉林市陆川县",
            "广西壮族自治区玉林市博白县",
            "广西壮族自治区玉林市兴业县",
            "广西壮族自治区玉林市北流市",
            "广西壮族自治区百色市右江区",
            "广西壮族自治区百色市田阳县",
            "广西壮族自治区百色市田东县",
            "广西壮族自治区百色市平果县",
            "广西壮族自治区百色市德保县",
            "广西壮族自治区百色市靖西县",
            "广西壮族自治区百色市那坡县",
            "广西壮族自治区百色市凌云县",
            "广西壮族自治区百色市乐业县",
            "广西壮族自治区百色市田林县",
            "广西壮族自治区百色市西林县",
            "广西壮族自治区百色市隆林各族自治县",
            "广西壮族自治区贺州市八步区",
            "广西壮族自治区贺州市昭平县",
            "广西壮族自治区贺州市钟山县",
            "广西壮族自治区贺州市富川瑶族自治县",
            "广西壮族自治区河池市金城江区",
            "广西壮族自治区河池市南丹县",
            "广西壮族自治区河池市天峨县",
            "广西壮族自治区河池市凤山县",
            "广西壮族自治区河池市东兰县",
            "广西壮族自治区河池市罗城仫佬族自治县",
            "广西壮族自治区河池市环江毛南族自治县",
            "广西壮族自治区河池市巴马瑶族自治县",
            "广西壮族自治区河池市都安瑶族自治县",
            "广西壮族自治区河池市大化瑶族自治县",
            "广西壮族自治区河池市宜州市",
            "广西壮族自治区来宾市兴宾区",
            "广西壮族自治区来宾市忻城县",
            "广西壮族自治区来宾市象州县",
            "广西壮族自治区来宾市武宣县",
            "广西壮族自治区来宾市金秀瑶族自治县",
            "广西壮族自治区来宾市合山市",
            "广西壮族自治区崇左市江洲区",
            "广西壮族自治区崇左市扶绥县",
            "广西壮族自治区崇左市宁明县",
            "广西壮族自治区崇左市龙州县",
            "广西壮族自治区崇左市大新县",
            "广西壮族自治区崇左市天等县",
            "广西壮族自治区崇左市凭祥市",
            "海南省海口市秀英区",
            "海南省海口市龙华区",
            "海南省海口市琼山区",
            "海南省海口市美兰区",
            "海南省三亚市五指山市",
            "海南省三亚市琼海市",
            "海南省三亚市儋州市",
            "海南省三亚市文昌市",
            "海南省三亚市万宁市",
            "海南省三亚市东方市",
            "海南省三亚市定安县",
            "海南省三亚市屯昌县",
            "海南省三亚市澄迈县",
            "海南省三亚市临高县",
            "海南省三亚市白沙黎族自治县",
            "海南省三亚市昌江黎族自治县",
            "海南省三亚市乐东黎族自治县",
            "海南省三亚市陵水黎族自治县",
            "海南省三亚市保亭黎族苗族自治县",
            "海南省三亚市琼中黎族苗族自治县",
            "海南省三亚市西沙群岛",
            "海南省三亚市南沙群岛",
            "海南省三亚市中沙群岛的岛礁及其海域",
            "海南省三亚市",
            "重庆市万州区",
            "重庆市涪陵区",
            "重庆市渝中区",
            "重庆市大渡口区",
            "重庆市江北区",
            "重庆市沙坪坝区",
            "重庆市九龙坡区",
            "重庆市南岸区",
            "重庆市北碚区",
            "重庆市万盛区",
            "重庆市双桥区",
            "重庆市渝北区",
            "重庆市巴南区",
            "重庆市黔江区",
            "重庆市长寿区",
            "重庆市江津区",
            "重庆市合川区",
            "重庆市永川区",
            "重庆市南川区",
            "重庆市綦江县",
            "重庆市潼南县",
            "重庆市铜梁县",
            "重庆市大足县",
            "重庆市荣昌县",
            "重庆市璧山县",
            "重庆市梁平县",
            "重庆市城口县",
            "重庆市丰都县",
            "重庆市垫江县",
            "重庆市武隆县",
            "重庆市忠县",
            "重庆市开县",
            "重庆市云阳县",
            "重庆市奉节县",
            "重庆市巫山县",
            "重庆市巫溪县",
            "重庆市石柱土家族自治县",
            "重庆市秀山土家族苗族自治县",
            "重庆市酉阳土家族苗族自治县",
            "重庆市彭水苗族土家族自治县",
            "四川省成都市锦江区",
            "四川省成都市青羊区",
            "四川省成都市金牛区",
            "四川省成都市武侯区",
            "四川省成都市成华区",
            "四川省成都市龙泉驿区",
            "四川省成都市青白江区",
            "四川省成都市新都区",
            "四川省成都市温江区",
            "四川省成都市金堂县",
            "四川省成都市双流县",
            "四川省成都市郫县",
            "四川省成都市大邑县",
            "四川省成都市蒲江县",
            "四川省成都市新津县",
            "四川省成都市都江堰市",
            "四川省成都市彭州市",
            "四川省成都市邛崃市",
            "四川省成都市崇州市",
            "四川省自贡市自流井区",
            "四川省自贡市贡井区",
            "四川省自贡市大安区",
            "四川省自贡市沿滩区",
            "四川省自贡市荣县",
            "四川省自贡市富顺县",
            "四川省攀枝花市东区",
            "四川省攀枝花市西区",
            "四川省攀枝花市仁和区",
            "四川省攀枝花市米易县",
            "四川省攀枝花市盐边县",
            "四川省泸州市江阳区",
            "四川省泸州市纳溪区",
            "四川省泸州市龙马潭区",
            "四川省泸州市泸县",
            "四川省泸州市合江县",
            "四川省泸州市叙永县",
            "四川省泸州市古蔺县",
            "四川省德阳市旌阳区",
            "四川省德阳市中江县",
            "四川省德阳市罗江县",
            "四川省德阳市广汉市",
            "四川省德阳市什邡市",
            "四川省德阳市绵竹市",
            "四川省绵阳市涪城区",
            "四川省绵阳市游仙区",
            "四川省绵阳市三台县",
            "四川省绵阳市盐亭县",
            "四川省绵阳市安县",
            "四川省绵阳市梓潼县",
            "四川省绵阳市北川羌族自治县",
            "四川省绵阳市平武县",
            "四川省绵阳市江油市",
            "四川省广元市市中区",
            "四川省广元市元坝区",
            "四川省广元市朝天区",
            "四川省广元市旺苍县",
            "四川省广元市青川县",
            "四川省广元市剑阁县",
            "四川省广元市苍溪县",
            "四川省遂宁市船山区",
            "四川省遂宁市安居区",
            "四川省遂宁市蓬溪县",
            "四川省遂宁市射洪县",
            "四川省遂宁市大英县",
            "四川省内江市市中区",
            "四川省内江市东兴区",
            "四川省内江市威远县",
            "四川省内江市资中县",
            "四川省内江市隆昌县",
            "四川省乐山市市中区",
            "四川省乐山市沙湾区",
            "四川省乐山市五通桥区",
            "四川省乐山市金口河区",
            "四川省乐山市犍为县",
            "四川省乐山市井研县",
            "四川省乐山市夹江县",
            "四川省乐山市沐川县",
            "四川省乐山市峨边彝族自治县",
            "四川省乐山市马边彝族自治县",
            "四川省乐山市峨眉山市",
            "四川省南充市顺庆区",
            "四川省南充市高坪区",
            "四川省南充市嘉陵区",
            "四川省南充市南部县",
            "四川省南充市营山县",
            "四川省南充市蓬安县",
            "四川省南充市仪陇县",
            "四川省南充市西充县",
            "四川省南充市阆中市",
            "四川省眉山市东坡区",
            "四川省眉山市仁寿县",
            "四川省眉山市彭山县",
            "四川省眉山市洪雅县",
            "四川省眉山市丹棱县",
            "四川省眉山市青神县",
            "四川省宜宾市翠屏区",
            "四川省宜宾市宜宾县",
            "四川省宜宾市南溪县",
            "四川省宜宾市江安县",
            "四川省宜宾市长宁县",
            "四川省宜宾市高县",
            "四川省宜宾市珙县",
            "四川省宜宾市筠连县",
            "四川省宜宾市兴文县",
            "四川省宜宾市屏山县",
            "四川省广安市广安区",
            "四川省广安市岳池县",
            "四川省广安市武胜县",
            "四川省广安市邻水县",
            "四川省广安市华蓥市",
            "四川省达州市通川区",
            "四川省达州市达县",
            "四川省达州市宣汉县",
            "四川省达州市开江县",
            "四川省达州市大竹县",
            "四川省达州市渠县",
            "四川省达州市万源市",
            "四川省雅安市雨城区",
            "四川省雅安市名山县",
            "四川省雅安市荥经县",
            "四川省雅安市汉源县",
            "四川省雅安市石棉县",
            "四川省雅安市天全县",
            "四川省雅安市芦山县",
            "四川省雅安市宝兴县",
            "四川省巴中市巴州区",
            "四川省巴中市通江县",
            "四川省巴中市南江县",
            "四川省巴中市平昌县",
            "四川省资阳市雁江区",
            "四川省资阳市安岳县",
            "四川省资阳市乐至县",
            "四川省资阳市简阳市",
            "四川省阿坝藏族羌族自治州汶川县",
            "四川省阿坝藏族羌族自治州理县",
            "四川省阿坝藏族羌族自治州茂县",
            "四川省阿坝藏族羌族自治州松潘县",
            "四川省阿坝藏族羌族自治州九寨沟县",
            "四川省阿坝藏族羌族自治州金川县",
            "四川省阿坝藏族羌族自治州小金县",
            "四川省阿坝藏族羌族自治州黑水县",
            "四川省阿坝藏族羌族自治州马尔康县",
            "四川省阿坝藏族羌族自治州壤塘县",
            "四川省阿坝藏族羌族自治州阿坝县",
            "四川省阿坝藏族羌族自治州若尔盖县",
            "四川省阿坝藏族羌族自治州红原县",
            "四川省甘孜藏族自治州康定县",
            "四川省甘孜藏族自治州泸定县",
            "四川省甘孜藏族自治州丹巴县",
            "四川省甘孜藏族自治州九龙县",
            "四川省甘孜藏族自治州雅江县",
            "四川省甘孜藏族自治州道孚县",
            "四川省甘孜藏族自治州炉霍县",
            "四川省甘孜藏族自治州甘孜县",
            "四川省甘孜藏族自治州新龙县",
            "四川省甘孜藏族自治州德格县",
            "四川省甘孜藏族自治州白玉县",
            "四川省甘孜藏族自治州石渠县",
            "四川省甘孜藏族自治州色达县",
            "四川省甘孜藏族自治州理塘县",
            "四川省甘孜藏族自治州巴塘县",
            "四川省甘孜藏族自治州乡城县",
            "四川省甘孜藏族自治州稻城县",
            "四川省甘孜藏族自治州得荣县",
            "四川省凉山彝族自治州西昌市",
            "四川省凉山彝族自治州木里藏族自治县",
            "四川省凉山彝族自治州盐源县",
            "四川省凉山彝族自治州德昌县",
            "四川省凉山彝族自治州会理县",
            "四川省凉山彝族自治州会东县",
            "四川省凉山彝族自治州宁南县",
            "四川省凉山彝族自治州普格县",
            "四川省凉山彝族自治州布拖县",
            "四川省凉山彝族自治州金阳县",
            "四川省凉山彝族自治州昭觉县",
            "四川省凉山彝族自治州喜德县",
            "四川省凉山彝族自治州冕宁县",
            "四川省凉山彝族自治州越西县",
            "四川省凉山彝族自治州甘洛县",
            "四川省凉山彝族自治州美姑县",
            "四川省凉山彝族自治州雷波县",
            "贵州省贵阳市南明区",
            "贵州省贵阳市云岩区",
            "贵州省贵阳市花溪区",
            "贵州省贵阳市乌当区",
            "贵州省贵阳市白云区",
            "贵州省贵阳市小河区",
            "贵州省贵阳市开阳县",
            "贵州省贵阳市息烽县",
            "贵州省贵阳市修文县",
            "贵州省贵阳市清镇市",
            "贵州省六盘水市钟山区",
            "贵州省六盘水市六枝特区",
            "贵州省六盘水市水城县",
            "贵州省六盘水市盘县",
            "贵州省遵义市红花岗区",
            "贵州省遵义市汇川区",
            "贵州省遵义市遵义县",
            "贵州省遵义市桐梓县",
            "贵州省遵义市绥阳县",
            "贵州省遵义市正安县",
            "贵州省遵义市道真仡佬族苗族自治县",
            "贵州省遵义市务川仡佬族苗族自治县",
            "贵州省遵义市凤冈县",
            "贵州省遵义市湄潭县",
            "贵州省遵义市余庆县",
            "贵州省遵义市习水县",
            "贵州省遵义市赤水市",
            "贵州省遵义市仁怀市",
            "贵州省安顺市西秀区",
            "贵州省安顺市平坝县",
            "贵州省安顺市普定县",
            "贵州省安顺市镇宁布依族苗族自治县",
            "贵州省安顺市关岭布依族苗族自治县",
            "贵州省安顺市紫云苗族布依族自治县",
            "贵州省铜仁地区铜仁市",
            "贵州省铜仁地区江口县",
            "贵州省铜仁地区玉屏侗族自治县",
            "贵州省铜仁地区石阡县",
            "贵州省铜仁地区思南县",
            "贵州省铜仁地区印江土家族苗族自治县",
            "贵州省铜仁地区德江县",
            "贵州省铜仁地区沿河土家族自治县",
            "贵州省铜仁地区松桃苗族自治县",
            "贵州省铜仁地区万山特区",
            "贵州省黔西南布依族苗族自治州兴义市",
            "贵州省黔西南布依族苗族自治州兴仁县",
            "贵州省黔西南布依族苗族自治州普安县",
            "贵州省黔西南布依族苗族自治州晴隆县",
            "贵州省黔西南布依族苗族自治州贞丰县",
            "贵州省黔西南布依族苗族自治州望谟县",
            "贵州省黔西南布依族苗族自治州册亨县",
            "贵州省黔西南布依族苗族自治州安龙县",
            "贵州省毕节地区毕节市",
            "贵州省毕节地区大方县",
            "贵州省毕节地区黔西县",
            "贵州省毕节地区金沙县",
            "贵州省毕节地区织金县",
            "贵州省毕节地区纳雍县",
            "贵州省毕节地区威宁彝族回族苗族自治县",
            "贵州省毕节地区赫章县",
            "贵州省黔东南苗族侗族自治州凯里市",
            "贵州省黔东南苗族侗族自治州黄平县",
            "贵州省黔东南苗族侗族自治州施秉县",
            "贵州省黔东南苗族侗族自治州三穗县",
            "贵州省黔东南苗族侗族自治州镇远县",
            "贵州省黔东南苗族侗族自治州岑巩县",
            "贵州省黔东南苗族侗族自治州天柱县",
            "贵州省黔东南苗族侗族自治州锦屏县",
            "贵州省黔东南苗族侗族自治州剑河县",
            "贵州省黔东南苗族侗族自治州台江县",
            "贵州省黔东南苗族侗族自治州黎平县",
            "贵州省黔东南苗族侗族自治州榕江县",
            "贵州省黔东南苗族侗族自治州从江县",
            "贵州省黔东南苗族侗族自治州雷山县",
            "贵州省黔东南苗族侗族自治州麻江县",
            "贵州省黔东南苗族侗族自治州丹寨县",
            "贵州省黔南布依族苗族自治州都匀市",
            "贵州省黔南布依族苗族自治州福泉市",
            "贵州省黔南布依族苗族自治州荔波县",
            "贵州省黔南布依族苗族自治州贵定县",
            "贵州省黔南布依族苗族自治州瓮安县",
            "贵州省黔南布依族苗族自治州独山县",
            "贵州省黔南布依族苗族自治州平塘县",
            "贵州省黔南布依族苗族自治州罗甸县",
            "贵州省黔南布依族苗族自治州长顺县",
            "贵州省黔南布依族苗族自治州龙里县",
            "贵州省黔南布依族苗族自治州惠水县",
            "贵州省黔南布依族苗族自治州三都水族自治县",
            "云南省昆明市五华区",
            "云南省昆明市盘龙区",
            "云南省昆明市官渡区",
            "云南省昆明市西山区",
            "云南省昆明市东川区",
            "云南省昆明市呈贡县",
            "云南省昆明市晋宁县",
            "云南省昆明市富民县",
            "云南省昆明市宜良县",
            "云南省昆明市石林彝族自治县",
            "云南省昆明市嵩明县",
            "云南省昆明市禄劝彝族苗族自治县",
            "云南省昆明市寻甸回族彝族自治县",
            "云南省昆明市安宁市",
            "云南省曲靖市麒麟区",
            "云南省曲靖市马龙县",
            "云南省曲靖市陆良县",
            "云南省曲靖市师宗县",
            "云南省曲靖市罗平县",
            "云南省曲靖市富源县",
            "云南省曲靖市会泽县",
            "云南省曲靖市沾益县",
            "云南省曲靖市宣威市",
            "云南省玉溪市红塔区",
            "云南省玉溪市江川县",
            "云南省玉溪市澄江县",
            "云南省玉溪市通海县",
            "云南省玉溪市华宁县",
            "云南省玉溪市易门县",
            "云南省玉溪市峨山彝族自治县",
            "云南省玉溪市新平彝族傣族自治县",
            "云南省玉溪市元江哈尼族彝族傣族自治县",
            "云南省保山市隆阳区",
            "云南省保山市施甸县",
            "云南省保山市腾冲县",
            "云南省保山市龙陵县",
            "云南省保山市昌宁县",
            "云南省昭通市昭阳区",
            "云南省昭通市鲁甸县",
            "云南省昭通市巧家县",
            "云南省昭通市盐津县",
            "云南省昭通市大关县",
            "云南省昭通市永善县",
            "云南省昭通市绥江县",
            "云南省昭通市镇雄县",
            "云南省昭通市彝良县",
            "云南省昭通市威信县",
            "云南省昭通市水富县",
            "云南省丽江市古城区",
            "云南省丽江市玉龙纳西族自治县",
            "云南省丽江市永胜县",
            "云南省丽江市华坪县",
            "云南省丽江市宁蒗彝族自治县",
            "云南省思茅市翠云区",
            "云南省思茅市普洱哈尼族彝族自治县",
            "云南省思茅市墨江哈尼族自治县",
            "云南省思茅市景东彝族自治县",
            "云南省思茅市景谷傣族彝族自治县",
            "云南省思茅市镇沅彝族哈尼族拉祜族自治县",
            "云南省思茅市江城哈尼族彝族自治县",
            "云南省思茅市孟连傣族拉祜族佤族自治县",
            "云南省思茅市澜沧拉祜族自治县",
            "云南省思茅市西盟佤族自治县",
            "云南省临沧市临翔区",
            "云南省临沧市凤庆县",
            "云南省临沧市云县",
            "云南省临沧市永德县",
            "云南省临沧市镇康县",
            "云南省临沧市双江拉祜族佤族布朗族傣族自治县",
            "云南省临沧市耿马傣族佤族自治县",
            "云南省临沧市沧源佤族自治县",
            "云南省楚雄彝族自治州楚雄市",
            "云南省楚雄彝族自治州双柏县",
            "云南省楚雄彝族自治州牟定县",
            "云南省楚雄彝族自治州南华县",
            "云南省楚雄彝族自治州姚安县",
            "云南省楚雄彝族自治州大姚县",
            "云南省楚雄彝族自治州永仁县",
            "云南省楚雄彝族自治州元谋县",
            "云南省楚雄彝族自治州武定县",
            "云南省楚雄彝族自治州禄丰县",
            "云南省红河哈尼族彝族自治州个旧市",
            "云南省红河哈尼族彝族自治州开远市",
            "云南省红河哈尼族彝族自治州蒙自县",
            "云南省红河哈尼族彝族自治州屏边苗族自治县",
            "云南省红河哈尼族彝族自治州建水县",
            "云南省红河哈尼族彝族自治州石屏县",
            "云南省红河哈尼族彝族自治州弥勒县",
            "云南省红河哈尼族彝族自治州泸西县",
            "云南省红河哈尼族彝族自治州元阳县",
            "云南省红河哈尼族彝族自治州红河县",
            "云南省红河哈尼族彝族自治州金平苗族瑶族傣族自治县",
            "云南省红河哈尼族彝族自治州绿春县",
            "云南省红河哈尼族彝族自治州河口瑶族自治县",
            "云南省文山壮族苗族自治州文山县",
            "云南省文山壮族苗族自治州砚山县",
            "云南省文山壮族苗族自治州西畴县",
            "云南省文山壮族苗族自治州麻栗坡县",
            "云南省文山壮族苗族自治州马关县",
            "云南省文山壮族苗族自治州丘北县",
            "云南省文山壮族苗族自治州广南县",
            "云南省文山壮族苗族自治州富宁县",
            "云南省西双版纳傣族自治州景洪市",
            "云南省西双版纳傣族自治州勐海县",
            "云南省西双版纳傣族自治州勐腊县",
            "云南省大理白族自治州大理市",
            "云南省大理白族自治州漾濞彝族自治县",
            "云南省大理白族自治州祥云县",
            "云南省大理白族自治州宾川县",
            "云南省大理白族自治州弥渡县",
            "云南省大理白族自治州南涧彝族自治县",
            "云南省大理白族自治州巍山彝族回族自治县",
            "云南省大理白族自治州永平县",
            "云南省大理白族自治州云龙县",
            "云南省大理白族自治州洱源县",
            "云南省大理白族自治州剑川县",
            "云南省大理白族自治州鹤庆县",
            "云南省德宏傣族景颇族自治州瑞丽市",
            "云南省德宏傣族景颇族自治州潞西市",
            "云南省德宏傣族景颇族自治州梁河县",
            "云南省德宏傣族景颇族自治州盈江县",
            "云南省德宏傣族景颇族自治州陇川县",
            "云南省怒江傈僳族自治州泸水县",
            "云南省怒江傈僳族自治州福贡县",
            "云南省怒江傈僳族自治州贡山独龙族怒族自治县",
            "云南省怒江傈僳族自治州兰坪白族普米族自治县",
            "云南省迪庆藏族自治州香格里拉县",
            "云南省迪庆藏族自治州德钦县",
            "云南省迪庆藏族自治州维西傈僳族自治县",
            "西藏自治区拉萨市城关区",
            "西藏自治区拉萨市林周县",
            "西藏自治区拉萨市当雄县",
            "西藏自治区拉萨市尼木县",
            "西藏自治区拉萨市曲水县",
            "西藏自治区拉萨市堆龙德庆县",
            "西藏自治区拉萨市达孜县",
            "西藏自治区拉萨市墨竹工卡县",
            "西藏自治区昌都地区昌都县",
            "西藏自治区昌都地区江达县",
            "西藏自治区昌都地区贡觉县",
            "西藏自治区昌都地区类乌齐县",
            "西藏自治区昌都地区丁青县",
            "西藏自治区昌都地区察雅县",
            "西藏自治区昌都地区八宿县",
            "西藏自治区昌都地区左贡县",
            "西藏自治区昌都地区芒康县",
            "西藏自治区昌都地区洛隆县",
            "西藏自治区昌都地区边坝县",
            "西藏自治区山南地区乃东县",
            "西藏自治区山南地区扎囊县",
            "西藏自治区山南地区贡嘎县",
            "西藏自治区山南地区桑日县",
            "西藏自治区山南地区琼结县",
            "西藏自治区山南地区曲松县",
            "西藏自治区山南地区措美县",
            "西藏自治区山南地区洛扎县",
            "西藏自治区山南地区加查县",
            "西藏自治区山南地区隆子县",
            "西藏自治区山南地区错那县",
            "西藏自治区山南地区浪卡子县",
            "西藏自治区日喀则地区日喀则市",
            "西藏自治区日喀则地区南木林县",
            "西藏自治区日喀则地区江孜县",
            "西藏自治区日喀则地区定日县",
            "西藏自治区日喀则地区萨迦县",
            "西藏自治区日喀则地区拉孜县",
            "西藏自治区日喀则地区昂仁县",
            "西藏自治区日喀则地区谢通门县",
            "西藏自治区日喀则地区白朗县",
            "西藏自治区日喀则地区仁布县",
            "西藏自治区日喀则地区康马县",
            "西藏自治区日喀则地区定结县",
            "西藏自治区日喀则地区仲巴县",
            "西藏自治区日喀则地区亚东县",
            "西藏自治区日喀则地区吉隆县",
            "西藏自治区日喀则地区聂拉木县",
            "西藏自治区日喀则地区萨嘎县",
            "西藏自治区日喀则地区岗巴县",
            "西藏自治区那曲地区那曲县",
            "西藏自治区那曲地区嘉黎县",
            "西藏自治区那曲地区比如县",
            "西藏自治区那曲地区聂荣县",
            "西藏自治区那曲地区安多县",
            "西藏自治区那曲地区申扎县",
            "西藏自治区那曲地区索县",
            "西藏自治区那曲地区班戈县",
            "西藏自治区那曲地区巴青县",
            "西藏自治区那曲地区尼玛县",
            "西藏自治区阿里地区普兰县",
            "西藏自治区阿里地区札达县",
            "西藏自治区阿里地区噶尔县",
            "西藏自治区阿里地区日土县",
            "西藏自治区阿里地区革吉县",
            "西藏自治区阿里地区改则县",
            "西藏自治区阿里地区措勤县",
            "西藏自治区林芝地区林芝县",
            "西藏自治区林芝地区工布江达县",
            "西藏自治区林芝地区米林县",
            "西藏自治区林芝地区墨脱县",
            "西藏自治区林芝地区波密县",
            "西藏自治区林芝地区察隅县",
            "西藏自治区林芝地区朗县",
            "陕西省西安市新城区",
            "陕西省西安市碑林区",
            "陕西省西安市莲湖区",
            "陕西省西安市灞桥区",
            "陕西省西安市未央区",
            "陕西省西安市雁塔区",
            "陕西省西安市阎良区",
            "陕西省西安市临潼区",
            "陕西省西安市长安区",
            "陕西省西安市蓝田县",
            "陕西省西安市周至县",
            "陕西省西安市户县",
            "陕西省西安市高陵县",
            "陕西省铜川市王益区",
            "陕西省铜川市印台区",
            "陕西省铜川市耀州区",
            "陕西省铜川市宜君县",
            "陕西省宝鸡市渭滨区",
            "陕西省宝鸡市金台区",
            "陕西省宝鸡市陈仓区",
            "陕西省宝鸡市凤翔县",
            "陕西省宝鸡市岐山县",
            "陕西省宝鸡市扶风县",
            "陕西省宝鸡市眉县",
            "陕西省宝鸡市陇县",
            "陕西省宝鸡市千阳县",
            "陕西省宝鸡市麟游县",
            "陕西省宝鸡市凤县",
            "陕西省宝鸡市太白县",
            "陕西省咸阳市秦都区",
            "陕西省咸阳市杨凌区",
            "陕西省咸阳市渭城区",
            "陕西省咸阳市三原县",
            "陕西省咸阳市泾阳县",
            "陕西省咸阳市乾县",
            "陕西省咸阳市礼泉县",
            "陕西省咸阳市永寿县",
            "陕西省咸阳市彬县",
            "陕西省咸阳市长武县",
            "陕西省咸阳市旬邑县",
            "陕西省咸阳市淳化县",
            "陕西省咸阳市武功县",
            "陕西省咸阳市兴平市",
            "陕西省渭南市临渭区",
            "陕西省渭南市华县",
            "陕西省渭南市潼关县",
            "陕西省渭南市大荔县",
            "陕西省渭南市合阳县",
            "陕西省渭南市澄城县",
            "陕西省渭南市蒲城县",
            "陕西省渭南市白水县",
            "陕西省渭南市富平县",
            "陕西省渭南市韩城市",
            "陕西省渭南市华阴市",
            "陕西省延安市宝塔区",
            "陕西省延安市延长县",
            "陕西省延安市延川县",
            "陕西省延安市子长县",
            "陕西省延安市安塞县",
            "陕西省延安市志丹县",
            "陕西省延安市吴起县",
            "陕西省延安市甘泉县",
            "陕西省延安市富县",
            "陕西省延安市洛川县",
            "陕西省延安市宜川县",
            "陕西省延安市黄龙县",
            "陕西省延安市黄陵县",
            "陕西省汉中市汉台区",
            "陕西省汉中市南郑县",
            "陕西省汉中市城固县",
            "陕西省汉中市洋县",
            "陕西省汉中市西乡县",
            "陕西省汉中市勉县",
            "陕西省汉中市宁强县",
            "陕西省汉中市略阳县",
            "陕西省汉中市镇巴县",
            "陕西省汉中市留坝县",
            "陕西省汉中市佛坪县",
            "陕西省榆林市榆阳区",
            "陕西省榆林市神木县",
            "陕西省榆林市府谷县",
            "陕西省榆林市横山县",
            "陕西省榆林市靖边县",
            "陕西省榆林市定边县",
            "陕西省榆林市绥德县",
            "陕西省榆林市米脂县",
            "陕西省榆林市佳县",
            "陕西省榆林市吴堡县",
            "陕西省榆林市清涧县",
            "陕西省榆林市子洲县",
            "陕西省安康市汉滨区",
            "陕西省安康市汉阴县",
            "陕西省安康市石泉县",
            "陕西省安康市宁陕县",
            "陕西省安康市紫阳县",
            "陕西省安康市岚皋县",
            "陕西省安康市平利县",
            "陕西省安康市镇坪县",
            "陕西省安康市旬阳县",
            "陕西省安康市白河县",
            "陕西省商洛市商州区",
            "陕西省商洛市洛南县",
            "陕西省商洛市丹凤县",
            "陕西省商洛市商南县",
            "陕西省商洛市山阳县",
            "陕西省商洛市镇安县",
            "陕西省商洛市柞水县",
            "甘肃省兰州市城关区",
            "甘肃省兰州市七里河区",
            "甘肃省兰州市西固区",
            "甘肃省兰州市安宁区",
            "甘肃省兰州市红古区",
            "甘肃省兰州市永登县",
            "甘肃省兰州市皋兰县",
            "甘肃省兰州市榆中县",
            "甘肃省嘉峪关市",
            "甘肃省金昌市金川区",
            "甘肃省金昌市永昌县",
            "甘肃省白银市白银区",
            "甘肃省白银市平川区",
            "甘肃省白银市靖远县",
            "甘肃省白银市会宁县",
            "甘肃省白银市景泰县",
            "甘肃省天水市秦城区",
            "甘肃省天水市北道区",
            "甘肃省天水市清水县",
            "甘肃省天水市秦安县",
            "甘肃省天水市甘谷县",
            "甘肃省天水市武山县",
            "甘肃省天水市张家川回族自治县",
            "甘肃省武威市凉州区",
            "甘肃省武威市民勤县",
            "甘肃省武威市古浪县",
            "甘肃省武威市天祝藏族自治县",
            "甘肃省张掖市甘州区",
            "甘肃省张掖市肃南裕固族自治县",
            "甘肃省张掖市民乐县",
            "甘肃省张掖市临泽县",
            "甘肃省张掖市高台县",
            "甘肃省张掖市山丹县",
            "甘肃省平凉市崆峒区",
            "甘肃省平凉市泾川县",
            "甘肃省平凉市灵台县",
            "甘肃省平凉市崇信县",
            "甘肃省平凉市华亭县",
            "甘肃省平凉市庄浪县",
            "甘肃省平凉市静宁县",
            "甘肃省酒泉市肃州区",
            "甘肃省酒泉市金塔县",
            "甘肃省酒泉市瓜州县*",
            "甘肃省酒泉市肃北蒙古族自治县",
            "甘肃省酒泉市阿克塞哈萨克族自治县",
            "甘肃省酒泉市玉门市",
            "甘肃省酒泉市敦煌市",
            "甘肃省庆阳市西峰区",
            "甘肃省庆阳市庆城县",
            "甘肃省庆阳市环县",
            "甘肃省庆阳市华池县",
            "甘肃省庆阳市合水县",
            "甘肃省庆阳市正宁县",
            "甘肃省庆阳市宁县",
            "甘肃省庆阳市镇原县",
            "甘肃省定西市安定区",
            "甘肃省定西市通渭县",
            "甘肃省定西市陇西县",
            "甘肃省定西市渭源县",
            "甘肃省定西市临洮县",
            "甘肃省定西市漳县",
            "甘肃省定西市岷县",
            "甘肃省陇南市武都区",
            "甘肃省陇南市成县",
            "甘肃省陇南市文县",
            "甘肃省陇南市宕昌县",
            "甘肃省陇南市康县",
            "甘肃省陇南市西和县",
            "甘肃省陇南市礼县",
            "甘肃省陇南市徽县",
            "甘肃省陇南市两当县",
            "甘肃省临夏回族自治州临夏市",
            "甘肃省临夏回族自治州临夏县",
            "甘肃省临夏回族自治州康乐县",
            "甘肃省临夏回族自治州永靖县",
            "甘肃省临夏回族自治州广河县",
            "甘肃省临夏回族自治州和政县",
            "甘肃省临夏回族自治州东乡族自治县",
            "甘肃省临夏回族自治州积石山保安族东乡族撒拉族自治县",
            "甘肃省甘南藏族自治州合作市",
            "甘肃省甘南藏族自治州临潭县",
            "甘肃省甘南藏族自治州卓尼县",
            "甘肃省甘南藏族自治州舟曲县",
            "甘肃省甘南藏族自治州迭部县",
            "甘肃省甘南藏族自治州玛曲县",
            "甘肃省甘南藏族自治州碌曲县",
            "甘肃省甘南藏族自治州夏河县",
            "青海省西宁市城东区",
            "青海省西宁市城中区",
            "青海省西宁市城西区",
            "青海省西宁市城北区",
            "青海省西宁市大通回族土族自治县",
            "青海省西宁市湟中县",
            "青海省西宁市湟源县",
            "青海省海东地区平安县",
            "青海省海东地区民和回族土族自治县",
            "青海省海东地区乐都县",
            "青海省海东地区互助土族自治县",
            "青海省海东地区化隆回族自治县",
            "青海省海东地区循化撒拉族自治县",
            "青海省海北藏族自治州门源回族自治县",
            "青海省海北藏族自治州祁连县",
            "青海省海北藏族自治州海晏县",
            "青海省海北藏族自治州刚察县",
            "青海省黄南藏族自治州同仁县",
            "青海省黄南藏族自治州尖扎县",
            "青海省黄南藏族自治州泽库县",
            "青海省黄南藏族自治州河南蒙古族自治县",
            "青海省黄南藏族自治州海南藏族自治州",
            "青海省黄南藏族自治州共和县",
            "青海省黄南藏族自治州同德县",
            "青海省黄南藏族自治州贵德县",
            "青海省黄南藏族自治州兴海县",
            "青海省黄南藏族自治州贵南县",
            "青海省果洛藏族自治州玛沁县",
            "青海省果洛藏族自治州班玛县",
            "青海省果洛藏族自治州甘德县",
            "青海省果洛藏族自治州达日县",
            "青海省果洛藏族自治州久治县",
            "青海省果洛藏族自治州玛多县",
            "青海省玉树藏族自治州玉树县",
            "青海省玉树藏族自治州杂多县",
            "青海省玉树藏族自治州称多县",
            "青海省玉树藏族自治州治多县",
            "青海省玉树藏族自治州囊谦县",
            "青海省玉树藏族自治州曲麻莱县",
            "青海省海西蒙古族藏族自治州格尔木市",
            "青海省海西蒙古族藏族自治州德令哈市",
            "青海省海西蒙古族藏族自治州乌兰县",
            "青海省海西蒙古族藏族自治州都兰县",
            "青海省海西蒙古族藏族自治州天峻县",
            "宁夏回族自治区银川市兴庆区",
            "宁夏回族自治区银川市西夏区",
            "宁夏回族自治区银川市金凤区",
            "宁夏回族自治区银川市永宁县",
            "宁夏回族自治区银川市贺兰县",
            "宁夏回族自治区银川市灵武市",
            "宁夏回族自治区石嘴山市大武口区",
            "宁夏回族自治区石嘴山市惠农区",
            "宁夏回族自治区石嘴山市平罗县",
            "宁夏回族自治区吴忠市利通区",
            "宁夏回族自治区吴忠市盐池县",
            "宁夏回族自治区吴忠市同心县",
            "宁夏回族自治区吴忠市青铜峡市",
            "宁夏回族自治区固原市原州区",
            "宁夏回族自治区固原市西吉县",
            "宁夏回族自治区固原市隆德县",
            "宁夏回族自治区固原市泾源县",
            "宁夏回族自治区固原市彭阳县",
            "宁夏回族自治区中卫市沙坡头区",
            "宁夏回族自治区中卫市中宁县",
            "宁夏回族自治区中卫市海原县",
            "新疆维吾尔自治区乌鲁木齐市天山区",
            "新疆维吾尔自治区乌鲁木齐市沙依巴克区",
            "新疆维吾尔自治区乌鲁木齐市新市区",
            "新疆维吾尔自治区乌鲁木齐市水磨沟区",
            "新疆维吾尔自治区乌鲁木齐市头屯河区",
            "新疆维吾尔自治区乌鲁木齐市达坂城区",
            "新疆维吾尔自治区乌鲁木齐市东山区",
            "新疆维吾尔自治区乌鲁木齐市乌鲁木齐县",
            "新疆维吾尔自治区克拉玛依市独山子区",
            "新疆维吾尔自治区克拉玛依市克拉玛依区",
            "新疆维吾尔自治区克拉玛依市白碱滩区",
            "新疆维吾尔自治区克拉玛依市乌尔禾区",
            "新疆维吾尔自治区吐鲁番地区吐鲁番市",
            "新疆维吾尔自治区吐鲁番地区鄯善县",
            "新疆维吾尔自治区吐鲁番地区托克逊县",
            "新疆维吾尔自治区哈密地区哈密市",
            "新疆维吾尔自治区哈密地区巴里坤哈萨克自治县",
            "新疆维吾尔自治区哈密地区伊吾县",
            "新疆维吾尔自治区昌吉回族自治州昌吉市",
            "新疆维吾尔自治区昌吉回族自治州阜康市",
            "新疆维吾尔自治区昌吉回族自治州米泉市",
            "新疆维吾尔自治区昌吉回族自治州呼图壁县",
            "新疆维吾尔自治区昌吉回族自治州玛纳斯县",
            "新疆维吾尔自治区昌吉回族自治州奇台县",
            "新疆维吾尔自治区昌吉回族自治州吉木萨尔县",
            "新疆维吾尔自治区昌吉回族自治州木垒哈萨克自治县",
            "新疆维吾尔自治区博尔塔拉蒙古自治州博乐市",
            "新疆维吾尔自治区博尔塔拉蒙古自治州精河县",
            "新疆维吾尔自治区博尔塔拉蒙古自治州温泉县",
            "新疆维吾尔自治区巴音郭楞蒙古自治州库尔勒市",
            "新疆维吾尔自治区巴音郭楞蒙古自治州轮台县",
            "新疆维吾尔自治区巴音郭楞蒙古自治州尉犁县",
            "新疆维吾尔自治区巴音郭楞蒙古自治州若羌县",
            "新疆维吾尔自治区巴音郭楞蒙古自治州且末县",
            "新疆维吾尔自治区巴音郭楞蒙古自治州焉耆回族自治县",
            "新疆维吾尔自治区巴音郭楞蒙古自治州和静县",
            "新疆维吾尔自治区巴音郭楞蒙古自治州和硕县",
            "新疆维吾尔自治区巴音郭楞蒙古自治州博湖县",
            "新疆维吾尔自治区阿克苏地区阿克苏市",
            "新疆维吾尔自治区阿克苏地区温宿县",
            "新疆维吾尔自治区阿克苏地区库车县",
            "新疆维吾尔自治区阿克苏地区沙雅县",
            "新疆维吾尔自治区阿克苏地区新和县",
            "新疆维吾尔自治区阿克苏地区拜城县",
            "新疆维吾尔自治区阿克苏地区乌什县",
            "新疆维吾尔自治区阿克苏地区阿瓦提县",
            "新疆维吾尔自治区阿克苏地区柯坪县",
            "新疆维吾尔自治区克孜勒苏柯尔克孜自治州阿图什市",
            "新疆维吾尔自治区克孜勒苏柯尔克孜自治州阿克陶县",
            "新疆维吾尔自治区克孜勒苏柯尔克孜自治州阿合奇县",
            "新疆维吾尔自治区克孜勒苏柯尔克孜自治州乌恰县",
            "新疆维吾尔自治区喀什地区喀什市",
            "新疆维吾尔自治区喀什地区疏附县",
            "新疆维吾尔自治区喀什地区疏勒县",
            "新疆维吾尔自治区喀什地区英吉沙县",
            "新疆维吾尔自治区喀什地区泽普县",
            "新疆维吾尔自治区喀什地区莎车县",
            "新疆维吾尔自治区喀什地区叶城县",
            "新疆维吾尔自治区喀什地区麦盖提县",
            "新疆维吾尔自治区喀什地区岳普湖县",
            "新疆维吾尔自治区喀什地区伽师县",
            "新疆维吾尔自治区喀什地区巴楚县",
            "新疆维吾尔自治区喀什地区塔什库尔干塔吉克自治县",
            "新疆维吾尔自治区和田地区和田市",
            "新疆维吾尔自治区和田地区和田县",
            "新疆维吾尔自治区和田地区墨玉县",
            "新疆维吾尔自治区和田地区皮山县",
            "新疆维吾尔自治区和田地区洛浦县",
            "新疆维吾尔自治区和田地区策勒县",
            "新疆维吾尔自治区和田地区于田县",
            "新疆维吾尔自治区和田地区民丰县",
            "新疆维吾尔自治区伊犁哈萨克自治州伊宁市",
            "新疆维吾尔自治区伊犁哈萨克自治州奎屯市",
            "新疆维吾尔自治区伊犁哈萨克自治州伊宁县",
            "新疆维吾尔自治区伊犁哈萨克自治州察布查尔锡伯自治县",
            "新疆维吾尔自治区伊犁哈萨克自治州霍城县",
            "新疆维吾尔自治区伊犁哈萨克自治州巩留县",
            "新疆维吾尔自治区伊犁哈萨克自治州新源县",
            "新疆维吾尔自治区伊犁哈萨克自治州昭苏县",
            "新疆维吾尔自治区伊犁哈萨克自治州特克斯县",
            "新疆维吾尔自治区伊犁哈萨克自治州尼勒克县",
            "新疆维吾尔自治区塔城地区塔城市",
            "新疆维吾尔自治区塔城地区乌苏市",
            "新疆维吾尔自治区塔城地区额敏县",
            "新疆维吾尔自治区塔城地区沙湾县",
            "新疆维吾尔自治区塔城地区托里县",
            "新疆维吾尔自治区塔城地区裕民县",
            "新疆维吾尔自治区塔城地区和布克赛尔蒙古自治县",
            "新疆维吾尔自治区阿勒泰地区阿勒泰市",
            "新疆维吾尔自治区阿勒泰地区布尔津县",
            "新疆维吾尔自治区阿勒泰地区富蕴县",
            "新疆维吾尔自治区阿勒泰地区福海县",
            "新疆维吾尔自治区阿勒泰地区哈巴河县",
            "新疆维吾尔自治区阿勒泰地区青河县",
            "新疆维吾尔自治区阿勒泰地区吉木乃县",
            "新疆维吾尔自治区石河子市",
            "新疆维吾尔自治区阿拉尔市",
            "新疆维吾尔自治区图木舒克市",
            "新疆维吾尔自治区五家渠市"
    };

    // 路名
    private static final String[] roadNames = {
            "安业路",
            "安义路",
            "安逸路",
            "安友路",
            "安远路",
            "安泽路",
            "安中路",
            "庵后路",
            "鞍山路",
            "山支路",
            "奥纳路",
            "澳门路",
            "澳尼路",
            "鳌山路",
            "八滧路",
            "八一路",
            "八字路",
            "巴里路",
            "巴林路",
            "巴圣路",
            "坝桥路",
            "陈公路",
            "白城路",
            "白渡路",
            "白河路",
            "白鹤路",
            "白桦路",
            "白兰路",
            "白丽路",
            "白莲路",
            "白龙路",
            "白牛路",
            "白石路",
            "白水路",
            "白奚路",
            "白象路",
            "白杨路",
            "白漾路",
            "白衣路",
            "白玉路",
            "白云路",
            "白樟路",
            "百安路",
            "百官路",
            "百花路",
            "百家路",
            "百乐路",
            "乐支路",
            "百翎路",
            "百禄路",
            "百岁路",
            "百熙路",
            "子庵路",
            "柏枝路",
            "径园路",
            "淞园路",
            "伴亭路",
            "板桥路",
            "板泉路",
            "班溪路",
            "包桥路",
            "包头路",
            "报春路",
            "安公路",
            "宝安路",
            "宝昌路",
            "宝城路",
            "宝带路",
            "宝东路",
            "宝乐路",
            "贸易路",
            "新洲路",
            "浦庭路",
            "浦澳路",
            "浦润路",
            "浦华路",
            "浦逸路",
            "浦阳路",
            "九干路",
            "富漕路",
            "青腾路",
            "新德路",
            "卡园路",
            "汇通路",
            "瀛洲路",
            "崇明路",
            "山岛路",
            "农谊路",
            "金腾路",
            "金百路",
            "金舸路",
            "金流路",
            "天工路",
            "揽工路",
            "月工路",
            "金水路",
            "宝联路",
            "宝林路",
            "宝支路",
            "宝南路",
            "宝潘路",
            "宝祁路",
            "钱公路",
            "宝庆路",
            "宝泉路",
            "宝仁路",
            "宝山路",
            "宝胜路",
            "宝盛路",
            "宝通路",
            "宝翔路",
            "宝秀路",
            "宝杨路",
            "宝银路",
            "宝源路",
            "环西路",
            "民翔路",
            "巡北路",
            "环南路",
            "茸加路",
            "茸康路",
            "宝中路",
            "保安路",
            "保德路",
            "保定路",
            "保乐路",
            "保宁路",
            "保仁路",
            "保屯路",
            "北艾路",
            "北安路",
            "北浜路",
            "宝兴路",
            "北蔡路",
            "草塘路",
            "长山路",
            "陈公路",
            "城壕路",
            "北城路",
            "嘉定路",
            "北大路",
            "枫泾路",
            "北翟路",
            "北斗路",
            "钩玉路",
            "北海路",
            "海宁路",
            "北和路",
            "北虹路",
            "西渡路",
            "外冈路",
            "高桥路",
            "奉城街",
            "颛桥路",
            "京东路",
            "京西路",
            "孔家路",
            "良泾路",
            "北弄路",
            "北门路",
            "惠南路",
            "崇明路",
            "北门路",
            "北牧路",
            "期昌路",
            "青公路",
            "北角路",
            "栅桥路",
            "北厍路",
            "北石路",
            "北石路",
            "北市路",
            "市梢路",
            "施家路",
            "松公路",
            "苏州路",
            "塘河路",
            "北汀路",
            "蕰川路",
            "无锡路",
            "北吴路",
            "北溪路",
            "新公路",
            "北新路",
            "北兴路",
            "星公路",
            "沿公路",
            "果园路",
            "祝景路",
            "艾家路",
            "爱都路",
            "爱国路",
            "爱华路",
            "爱辉路",
            "爱民路",
            "爱特路",
            "安邦路",
            "安边路",
            "安波路",
            "安达路",
            "安东路",
            "安汾路",
            "汾支路",
            "安丰路",
            "安福路",
            "安国路",
            "安航路",
            "安化路",
            "安家路",
            "安居路",
            "安康路",
            "安澜路",
            "安乐路",
            "安临路",
            "安龙路",
            "安宁路",
            "安平路",
            "庆东路",
            "安庆路",
            "安仁路",
            "安塞路",
            "安顺路",
            "安泰路",
            "安亭路",
            "安亭路",
            "安图路",
            "安西路",
            "安新路",
            "北盐路",
            "洋泾路",
            "滧公路",
            "北翼路",
            "北车路",
            "北渔路",
            "北园路",
            "北泽路",
            "张家路",
            "北张路",
            "北中路",
            "北周路",
            "本溪路",
            "泵公路",
            "碧波路",
            "碧江路",
            "碧泉路",
            "碧水路",
            "碧溪路",
            "碧秀路",
            "碧瀛路",
            "碧玉路",
            "碧云路",
            "宾川路",
            "宾阳路",
            "滨海路",
            "滨江路",
            "滨州路",
            "厂田路",
            "冰克路",
            "百色路",
            "伯士路",
            "波阳路",
            "博华路",
            "博乐路",
            "博乐路",
            "博山路",
            "博山路",
            "博文路",
            "博兴路",
            "布长路",
            "哺坊路",
            "堡八路",
            "堡港路",
            "堡江路",
            "堡粮路",
            "堡南路",
            "堡兴路",
            "堡镇路",
            "亭林路",
            "西门路",
            "大新路",
            "大兴路",
            "大姚路",
            "叶公路",
            "大盈路",
            "大宅路",
            "治河路",
            "大治路",
            "大中路",
            "打虎路",
            "打浦路",
            "铁浜路",
            "达布路",
            "达山路",
            "岱山路",
            "丹巴路",
            "丹东路",
            "丹凤路",
            "丹格路",
            "丹根路",
            "丹桂路",
            "丹棱路",
            "丹徒路",
            "丹阳路",
            "淡水路",
            "泾公路",
            "荡湾路",
            "倒川路",
            "道堂路",
            "德堡路",
            "德北路",
            "德昌路",
            "德都路",
            "德宏路",
            "崇明路",
            "菜场路",
            "菜花路",
            "蔡家路",
            "蔡阳路",
            "仓场路",
            "仓城路",
            "仓储路",
            "仓基路",
            "浜后路",
            "仓桥路",
            "苍梧路",
            "沧源路",
            "庵公路",
            "草高路",
            "草窝路",
            "草湾路",
            "曹安路",
            "曹丰路",
            "家浜路",
            "家河路",
            "曹家路",
            "曹堰路",
            "曹建路",
            "曹市路",
            "曹王路",
            "新公路",
            "曹新路",
            "曹杨路",
            "漕宝路",
            "漕沧路",
            "漕东路",
            "东支路",
            "漕河路",
            "河泾路",
            "漕平路",
            "漕溪路",
            "漕溪路",
            "操场路",
            "茶庵路",
            "茶陵路",
            "茶陵路",
            "长安路",
            "长白路",
            "长浜路",
            "长春路",
            "春支路",
            "岛北路",
            "长岛路",
            "岛南路",
            "长岛路",
            "长东路",
            "长发路",
            "长丰路",
            "长凤路",
            "长谷路",
            "长海路",
            "长和路",
            "长虹路",
            "侯公路",
            "长华路",
            "长江路",
            "江南路",
            "江西路",
            "长乐路",
            "长联路",
            "长临路",
            "长岭路",
            "长柳路",
            "溇浜路",
            "长宁路",
            "长桥路",
            "松江路",
            "桥南路",
            "长清路",
            "长沙路",
            "长厍路",
            "长生路",
            "石公路",
            "长石路",
            "长寿路",
            "长顺路",
            "长松路",
            "洞泾路",
            "长兴路",
            "长阳路",
            "长逸路",
            "长樱路",
            "长征路",
            "长治路",
            "场北路",
            "场东路",
            "场联路",
            "新桥路",
            "场南路",
            "场署路",
            "场西路",
            "场中路",
            "昌北路",
            "昌达路",
            "昌化路",
            "昌吉路",
            "昌东路",
            "昌里路",
            "昌林路",
            "昌平路",
            "昌盛路",
            "昌翔路",
            "昌邑路",
            "常德路",
            "常和路",
            "常熟路",
            "朝凤路",
            "朝阳路",
            "潮晖路",
            "车陈路",
            "车蒋路",
            "车九路",
            "车石路",
            "车漯路",
            "亭公路",
            "车新路",
            "站北路",
            "站东路",
            "站后路",
            "车站路",
            "青浦路",
            "车站路",
            "辰桥路",
            "香阁路",
            "安公路",
            "陈宝路",
            "仓门路",
            "陈川路",
            "川西路",
            "春公路",
            "陈春路",
            "陈东路",
            "陈富路",
            "陈阁路",
            "陈广路",
            "海公路",
            "行公路",
            "陈行路",
            "陈恒路",
            "陈家路",
            "陈家路",
            "陈江路",
            "南公路",
            "陈南路",
            "陈桥路",
            "陈青路",
            "陈厍路",
            "安桥路",
            "陈太路",
            "陈湾路",
            "翔公路",
            "滧公路",
            "陈谊路",
            "陈镇路",
            "晨阳路",
            "成才路",
            "成北路",
            "成都路",
            "毛公路",
            "成山路",
            "成园路",
            "呈祥路",
            "城北路",
            "城大路",
            "城东路",
            "城丰路",
            "城基路",
            "城南路",
            "川沙路",
            "城西路",
            "川沙路",
            "南桥路",
            "青村路",
            "城银路",
            "城北路",
            "城东路",
            "城中路",
            "城中路",
            "朱泾路",
            "奉城路",
            "城南路",
            "城西路",
            "河浜路",
            "程家路",
            "澄江路",
            "澄浏路",
            "池沟路",
            "池泾路",
            "池泾路",
            "赤峰路",
            "庆南路",
            "重庆路",
            "崇安路",
            "崇德路",
            "崇明路",
            "明支路",
            "储粮路",
            "川公路",
            "川北路",
            "环东路",
            "川环路",
            "川黄路",
            "川公路",
            "奉公路",
            "川桥路",
            "川沙路",
            "川巷路",
            "川心路",
            "川杨路",
            "周公路",
            "穿心路",
            "穿心路",
            "船厂路",
            "船厂路",
            "船舫路",
            "创建路",
            "创新路",
            "浦东路",
            "春潮路",
            "春东路",
            "春光路",
            "春和路",
            "春及路",
            "春江路",
            "春兰路",
            "春雷路",
            "春龙路",
            "春泉路",
            "春申路",
            "春生路",
            "春西路",
            "春公路",
            "春晓路",
            "春源路",
            "春耘路",
            "春中路",
            "椿樟街",
            "慈善路",
            "慈溪路",
            "慈云路",
            "翠峰路",
            "翠红路",
            "翠瑚路",
            "翠环路",
            "翠琳路",
            "翠柳路",
            "翠珀路",
            "翠松路",
            "翠怡路",
            "翠钰路",
            "大北路",
            "场东路",
            "场河路",
            "大场路",
            "大陈路",
            "大德路",
            "大堤路",
            "德华路",
            "德利路",
            "德林路",
            "德南路",
            "德平路",
            "德兴路",
            "德园路",
            "德州路",
            "邓川路",
            "邓家路",
            "灯辉路",
            "灯民路",
            "登云路",
            "地梨路",
            "地园路",
            "电大路",
            "电力路",
            "电台路",
            "淀湖路",
            "河东路",
            "浦河路",
            "淀浦路",
            "滇池路",
            "殿前路",
            "丁家路",
            "丁香路",
            "定边路",
            "定福路",
            "海港路",
            "定海路",
            "定水路",
            "定威路",
            "定西路",
            "定兴路",
            "东安路",
            "八灶路",
            "东支路",
            "东滨路",
            "东波路",
            "长治路",
            "东昌路",
            "东城路",
            "东城路",
            "东川路",
            "东川路",
            "东村路",
            "东大路",
            "祝桥路",
            "嘉定路",
            "叶榭路",
            "崇明路",
            "东名路",
            "东方路",
            "东风路",
            "东福路",
            "东港路",
            "东高路",
            "东葛路",
            "东沟路",
            "东沟路",
            "钩玉路",
            "东海路",
            "汉阳路",
            "河浜路",
            "河沿路",
            "东河路",
            "河沿路",
            "横浜路",
            "东后路",
            "东湖路",
            "东华路",
            "华美路",
            "环龙路",
            "东环路",
            "东汇路",
            "东建路",
            "东江路",
            "江湾路",
            "东交路",
            "东礁路",
            "外冈路",
            "高桥路",
            "奉城路",
            "东街路",
            "东井路",
            "港丰路",
            "港红路",
            "港洪路",
            "港九路",
            "港久路",
            "港庙路",
            "港桥路",
            "港涛路",
            "港西路",
            "港新路",
            "港兴路",
            "港沿路",
            "港业路",
            "港镇路",
            "港镇路",
            "港中路",
            "皋兰路",
            "高安路",
            "高潮路",
            "高墩路",
            "高行路",
            "高家路",
            "高家路",
            "高泾路",
            "高境路",
            "高科路",
            "高李路",
            "高林路",
            "高陵路",
            "高庙路",
            "高平路",
            "高桥路",
            "高桥路",
            "高青路",
            "高泉路",
            "高石路",
            "高田路",
            "巷头路",
            "高新路",
            "高兴路",
            "高雄路",
            "高阳路",
            "高逸路",
            "高邮路",
            "高资路",
            "革新路",
            "葛桥路",
            "耕耘路",
            "农北路",
            "工农路",
            "大东路",
            "大东路",
            "渡河路",
            "大方路",
            "方支路",
            "大夫路",
            "大港路",
            "大沽路",
            "大关路",
            "大华路",
            "大华路",
            "大吉路",
            "大境路",
            "大境路",
            "大理路",
            "大连路",
            "连西路",
            "大林路",
            "陵河路",
            "大闵路",
            "大名路",
            "木桥路",
            "大泥路",
            "大泥路",
            "大碾路",
            "大宁路",
            "大庆路",
            "大生路",
            "大水路",
            "大塘路",
            "大田路",
            "大亭路",
            "大同路",
            "大统路",
            "大通路",
            "东靖路",
            "东康路",
            "东兰路",
            "东乐路",
            "东联路",
            "东良路",
            "东粮路",
            "东林街",
            "东林路",
            "东刘弄",
            "东弄路",
            "东陆路",
            "东马路",
            "东美路",
            "东梅路",
            "东门路",
            "惠南路",
            "崇明路",
            "东门路",
            "东民路",
            "东明路",
            "东南路",
            "东泥路",
            "东平路",
            "期昌路",
            "东庆路",
            "青莲路",
            "东泉路",
            "东泉路",
            "东三路",
            "里桥路",
            "虹港路",
            "东珊路",
            "栅桥路",
            "东升路",
            "东胜路",
            "东市路",
            "东穗路",
            "东太路",
            "东台路",
            "东泰路",
            "东塘路",
            "东亭路",
            "东外路",
            "东吴路",
            "东西路",
            "东溪路",
            "东翔路",
            "东港路",
            "东新路",
            "新民路",
            "新支路",
            "东兴路",
            "东绣路",
            "东亚路",
            "姚家路",
            "东义路",
            "东引路",
            "余杭路",
            "东园路",
            "东园路",
            "东闸路",
            "祝公路",
            "东诸路",
            "东庄路",
            "冬融路",
            "洞泾路",
            "洞庭路",
            "洞西路",
            "洞莘路",
            "洞新路",
            "洞薛路",
            "董家路",
            "斗台路",
            "豆市路",
            "杜黄路",
            "国江路",
            "国京路",
            "国康路",
            "国年路",
            "国庆路",
            "国权路",
            "国顺路",
            "奉浦路",
            "国泰路",
            "国伟路",
            "国庠路",
            "国新路",
            "果牧路",
            "郭汇路",
            "守敬路",
            "哈雷路",
            "哈密路",
            "海安路",
            "海昌路",
            "海潮路",
            "海辰路",
            "海城路",
            "海防路",
            "海高路",
            "海光路",
            "海虹路",
            "海洪路",
            "海江路",
            "海军路",
            "海口路",
            "海拉路",
            "海陆路",
            "海伦路",
            "海伦路",
            "海门路",
            "海南路",
            "海宁路",
            "海桥路",
            "海山路",
            "海塘路",
            "海棠路",
            "海涛路",
            "海天路",
            "海桐路",
            "海通路",
            "海徐路",
            "海燕路",
            "海阳路",
            "海盈路",
            "海园路",
            "海州路",
            "汉口路",
            "汉阳路",
            "汉阴路",
            "汉源路",
            "汉中路",
            "邯郸路",
            "含笑路",
            "韩城路",
            "韩村路",
            "韩谊路",
            "寒山路",
            "行南路",
            "杭湾路",
            "杭州路",
            "航安路",
            "航北路",
            "航城路",
            "航东路",
            "航飞路",
            "航虹路",
            "航建路",
            "航津路",
            "航南路",
            "航青路",
            "航全路",
            "航塘路",
            "航西路",
            "航翔路",
            "航新路",
            "航行路",
            "航兴路",
            "航油路",
            "航宇路",
            "航中路",
            "合川路",
            "合肥路",
            "合欢路",
            "合浦路",
            "合水路",
            "杜家路",
            "杜九路",
            "都春路",
            "都江路",
            "都市路",
            "渡口路",
            "段泾路",
            "敦化路",
            "敦煌路",
            "墩安路",
            "墩平路",
            "丁香路",
            "七浦路",
            "七莘路",
            "九龙路",
            "九江路",
            "九亭镇",
            "九思堂",
            "九星路",
            "九潭路",
            "人民路",
            "人和路",
            "万山路",
            "万安路",
            "万灯路",
            "万春路",
            "万泉路",
            "万荣路",
            "万祥路",
            "航渡路",
            "万源路",
            "万镇路",
            "三门路",
            "三甲路",
            "三江路",
            "三达路",
            "三岔港",
            "三河路",
            "三泉路",
            "三原路",
            "三泰路",
            "三墩路",
            "上大路",
            "上川路",
            "上川路",
            "上中路",
            "上中路",
            "上南路",
            "上钦路",
            "上浦路",
            "下南路",
            "久安路",
            "义王路",
            "习勤路",
            "千阳路",
            "大木路",
            "大叶路",
            "大宁路",
            "大田路",
            "大关路",
            "大兴路",
            "大华路",
            "大吉路",
            "大同路",
            "大名路",
            "大连路",
            "大林路",
            "大沽路",
            "大姚路",
            "大洪路",
            "大统路",
            "大境路",
            "子长路",
            "子洲路",
            "木桥路",
            "小白路",
            "山丹路",
            "山阴路",
            "山花路",
            "山连路",
            "川大路",
            "川公路",
            "川展路",
            "川桥路",
            "川黄路",
            "工业路",
            "广中路",
            "广元路",
            "广东路",
            "广兰路",
            "广州路",
            "广延路",
            "广纪路",
            "广贤路",
            "广顺路",
            "广通路",
            "广粤路",
            "广联路",
            "广福路",
            "广德路",
            "飞马路",
            "飞乐路",
            "飞达路",
            "飞腾路",
            "马厂路",
            "马吉路",
            "马当路",
            "马陆镇",
            "中心路",
            "中心镇",
            "中宁路",
            "中兴路",
            "中华路",
            "中州路",
            "中江路",
            "中沟路",
            "中和路",
            "中坪路",
            "中泾路",
            "中青路",
            "中原路",
            "中谊路",
            "中联路",
            "中漕路",
            "中潭路",
            "丰庄路",
            "丰收路",
            "丰谷路",
            "丰和路",
            "丰和路",
            "丰南路",
            "丰顺路",
            "丰翔路",
            "丰溪路",
            "丰镇路",
            "丹巴路",
            "丹风路",
            "丹东路",
            "丹阳路",
            "丹徒路",
            "丹桂路",
            "乌镇路",
            "云山路",
            "云山路",
            "云天路",
            "云台路",
            "云阳路",
            "云和路",
            "云桥路",
            "云莲路",
            "云锦路",
            "五星路",
            "五原路",
            "五莲路",
            "仁德路",
            "元江路",
            "元阳路",
            "公平路",
            "公兴路",
            "六合路",
            "六陈路",
            "内江路",
            "化工路",
            "厅西路",
            "历城路",
            "友东路",
            "友林路",
            "友谊路",
            "友情路",
            "双山路",
            "双辽路",
            "双阳路",
            "双河路",
            "双城路",
            "双柏路",
            "双峰路",
            "双桥路",
            "双流路",
            "天水路",
            "天宁路",
            "天平路",
            "天池路",
            "天宝路",
            "天河路",
            "天星路",
            "天津路",
            "天等路",
            "天德路",
            "太山路",
            "太仓路",
            "太原路",
            "巴林路",
            "开平路",
            "开封路",
            "开鲁路",
            "支东路",
            "文井路",
            "文华路",
            "文安路",
            "文定路",
            "文昌路",
            "文治路",
            "文都路",
            "方斜路",
            "日京路",
            "月川路",
            "月丰路",
            "月巷路",
            "月春路",
            "月浦镇",
            "止园路",
            "毛家路",
            "毛家路",
            "水丰路",
            "水手路",
            "水电路",
            "水城路",
            "水清路",
            "牛庄路",
            "牛顿路",
            "王桥路",
            "邓发路",
            "长川路",
            "长元路",
            "长乐路",
            "长发路",
            "长宁路",
            "长白路",
            "长兴路",
            "长华路",
            "长安路",
            "长江路",
            "长阳路",
            "长寿路",
            "长岛路",
            "长沙路",
            "长岭路",
            "长治路",
            "长临路",
            "长春路",
            "长柳路",
            "长虹路",
            "长顺路",
            "长桥路",
            "长浜路",
            "长海路",
            "长清路",
            "长逸路",
            "长联路",
            "风阳路",
            "风城路",
            "世界路",
            "业绩路",
            "东川路",
            "东门路",
            "东太路",
            "东兰路",
            "东台路",
            "东平路",
            "东华路",
            "东安路",
            "东园路",
            "东陆路",
            "东建路",
            "东昌路",
            "东明路",
            "东林路",
            "东波路",
            "东闸路",
            "东城路",
            "东泉路",
            "东美路",
            "东胜路",
            "东泰路",
            "东绣路",
            "东湖路",
            "东塘路",
            "东新路",
            "东靖路",
            "乍浦路",
            "乐山路",
            "乐园路",
            "仙霞路",
            "兰州路",
            "兰竹路",
            "兰花路",
            "兰坪路",
            "兰城路",
            "兰陵路",
            "兰溪路",
            "冬融路",
            "加太路",
            "加枫路",
            "包头路",
            "北中路",
            "北斗路",
            "北石路",
            "北艾路",
            "北关路",
            "北利路",
            "北吴路",
            "北城路",
            "北海路",
            "北祥路",
            "北渔路",
            "北港路",
            "北新村",
            "北翟路",
            "半胜路",
            "古井路",
            "古水路",
            "古北路",
            "古龙路",
            "古羊路",
            "古宜路",
            "古美路",
            "古桐路",
            "古浪路",
            "古莲路",
            "句容路",
            "召泰路",
            "可乐路",
            "台桥路",
            "台湾路",
            "史家桥",
            "叶凌路",
            "叶家路",
            "叶谢镇",
            "四元路",
            "四平路",
            "四达路",
            "外马路",
            "宁阳路",
            "宁武路",
            "宁波路",
            "宁夏路",
            "宁桥路",
            "宁强路",
            "巨峰路",
            "巨野路",
            "市一路",
            "市台路",
            "市光路",
            "平山路",
            "平乐路",
            "平吉路",
            "平阳路",
            "平利路",
            "平定路",
            "平武路",
            "平南路",
            "平度路",
            "平顺路",
            "平塘路",
            "平溪路",
            "平福路",
            "归王村",
            "归昌路",
            "打浦路",
            "本溪路",
            "正熙路",
            "民区路",
            "民风路",
            "民风路",
            "民冬路",
            "民生路",
            "民立路",
            "民壮路",
            "民安路",
            "民庆路",
            "民京路",
            "民府路",
            "民治路",
            "民星路",
            "民秋路",
            "民科路",
            "民夏路",
            "民营路",
            "民雪路",
            "民德路",
            "民耀路",
            "永业路",
            "永乐路",
            "永宁路",
            "永兴路",
            "永吉路",
            "永年路",
            "永达路",
            "永和路",
            "永国路",
            "永定路",
            "永明路",
            "永南路",
            "永胜路",
            "永康路",
            "永清路",
            "永登路",
            "永源路",
            "永福路",
            "永德路",
            "汇川路",
            "汇丰路",
            "汇庆路",
            "汇站路",
            "汉口路",
            "汉中路",
            "汉阳路",
            "汉阴路",
            "玉门路",
            "玉兰路",
            "玉田路",
            "甘河路",
            "甘肃路",
            "甘泉路",
            "甘溪路",
            "田东路",
            "田州路",
            "田园路",
            "田园路",
            "申兴路",
            "申江路",
            "申旺路",
            "申波路",
            "申南路",
            "申富路",
            "申强路",
            "电台路",
            "白水路",
            "白兰路",
            "白玉路",
            "白丽路",
            "白杨路",
            "白河路",
            "白城路",
            "白桦路",
            "白渡路",
            "白樟路",
            "目华路",
            "石太路",
            "石皮弄",
            "石龙路",
            "石林路",
            "石屏路",
            "石泉路",
            "石港路",
            "石湾路",
            "石榴路",
            "礼泉路",
            "立跃路",
            "辽宁路",
            "辽阳路",
            "龙三路",
            "龙川路",
            "龙门路",
            "龙东路",
            "龙汇路",
            "龙华路",
            "龙州路",
            "龙江路",
            "龙江路",
            "龙阳路",
            "龙吴路",
            "龙里路",
            "龙居路",
            "龙临路",
            "龙茗路",
            "龙新路",
            "龙溪路",
            "龙漕路",
            "乔家路",
            "交城路",
            "交暨路",
            "伊犁路",
            "众贤路",
            "会文路",
            "会嵇路",
            "伟业路",
            "兆丰路",
            "兆丰路",
            "先新路",
            "光中路",
            "光华路",
            "光启路",
            "光明路",
            "光复路",
            "光新路",
            "共平路",
            "共江路",
            "共和路",
            "共青路",
            "共青路",
            "共悦路",
            "共祥路",
            "共康路",
            "共富路",
            "兴义路",
            "兴业路",
            "兴安路",
            "兴达路",
            "兴国路",
            "兴南路",
            "兴塔镇",
            "军工路",
            "农林路",
            "农南路",
            "冰克路",
            "刘场路",
            "创业路",
            "创新路",
            "华山路",
            "华中路",
            "华丰路",
            "华友路",
            "华开路",
            "华东路",
            "华发路",
            "华宁路",
            "华申路",
            "华光路",
            "华兴路",
            "华江路",
            "华池路",
            "华阳路",
            "华阴路",
            "华严路",
            "华佗路",
            "华灵路",
            "华京路",
            "华坪路",
            "华宝路",
            "华建路",
            "华昌路",
            "华欣路",
            "华泾路",
            "华茂路",
            "华亭路",
            "华亭镇",
            "华星路",
            "华洲路",
            "华济路",
            "华美路",
            "华容路",
            "华康路",
            "华盛路",
            "华翔路",
            "华联路",
            "华新镇",
            "华漕镇",
            "协和路",
            "合川路",
            "合欢路",
            "合阳路",
            "合肥路",
            "吉安路",
            "吉林路",
            "吉浦路",
            "吉祥路",
            "吉镇路",
            "同心路",
            "同乐路",
            "同济路",
            "同泰路",
            "同普路",
            "同嘉路",
            "名都路",
            "向化镇",
            "向东路",
            "向阳路",
            "向城路",
            "团林路",
            "场中路",
            "场北路",
            "场南路",
            "场联路",
            "多伦路",
            "多稼路",
            "如皋路",
            "孙弘路",
            "孙桥路",
            "孙桥镇",
            "孙浦路",
            "孙新路",
            "安义路",
            "安仁路",
            "安化路",
            "安业路",
            "安宁路",
            "安边路",
            "安龙路",
            "安庆路",
            "安西路",
            "安汾路",
            "安国路",
            "安图路",
            "安波路",
            "安亭路",
            "安亭镇",
            "安顺路",
            "安家路",
            "安航路",
            "安福路",
            "安澜路",
            "州工路",
            "巡道街",
            "庄行镇",
            "庄家宅",
            "庆华路",
            "庆达路",
            "庆达路",
            "延川路",
            "延长路",
            "延平路"
    };

}
