/*
 * Decompiled with CFR 0.152.
 */
package com.liys.view;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.animation.LinearInterpolator;
import com.liys.view.R;
import com.liys.view.SquareProView;

public class WaterWaveProView
extends SquareProView {
    protected Path path = new Path();
    protected int waveWidth;
    protected int waveHeight;
    protected int waveSpeed;
    protected float startX = 0.0f;
    ValueAnimator animator;

    public WaterWaveProView(Context context) {
        this(context, null);
    }

    public WaterWaveProView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WaterWaveProView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.WaterWaveProView);
        this.waveWidth = typedArray.getDimensionPixelOffset(R.styleable.WaterWaveProView_water_wave_width, -1);
        this.waveHeight = typedArray.getDimensionPixelOffset(R.styleable.WaterWaveProView_water_wave_height, -1);
        this.waveSpeed = typedArray.getInteger(R.styleable.WaterWaveProView_water_wave_speed, 5);
        if (this.waveSpeed <= 0 || this.waveSpeed > 10) {
            this.waveSpeed = 5;
        }
    }

    @Override
    public void init() {
        if (this.lightShow) {
            this.blankSpace = this.dp2px(10.0f);
            this.refreshLight();
            this.progressPaint.setMaskFilter(null);
        }
        this.progressPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
        if (this.waveWidth == -1) {
            this.waveWidth = this.width / 4;
        }
        if (this.waveHeight == -1) {
            this.waveHeight = this.sp2px(5.0f);
        }
        this.startAnimator();
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        this.drawBessel(this.width, this.startX, (int)((double)this.height * (1.0 - this.progress / this.maxProgress)), this.waveWidth, this.waveHeight, this.path);
        canvas.drawPath(this.path, this.progressPaint);
        canvas.drawBitmap(this.createCircleBitmap(this.width / 2 - this.blankSpace - this.strokeWidth), null, new Rect(0, 0, this.width, this.height), this.progressPaint);
        if (this.lightShow) {
            canvas.drawCircle((float)(this.width / 2), (float)(this.width / 2), (float)(this.width / 2 - this.blankSpace - this.strokeWidth), this.lightPaint);
        }
        if (this.strokeShow) {
            canvas.drawCircle((float)(this.width / 2), (float)(this.width / 2), (float)(this.width / 2 - this.blankSpace - this.strokeWidth), this.strokePaint);
        }
        this.drawText(canvas);
    }

    private void drawBessel(float width, float startX, float startY, float waveWidth, float waveHeight, Path path) {
        path.reset();
        int currentWidth = 0;
        path.moveTo(startX, startY);
        while ((float)currentWidth <= width + 4.0f * waveWidth && waveWidth > 0.0f) {
            path.rQuadTo(waveWidth, -waveHeight, 2.0f * waveWidth, 0.0f);
            path.rQuadTo(waveWidth, waveHeight, 2.0f * waveWidth, 0.0f);
            currentWidth = (int)((float)currentWidth + 2.0f * waveWidth);
        }
        path.lineTo((float)this.getWidth() + 4.0f * waveWidth, (float)this.getHeight());
        path.lineTo(0.0f, (float)this.getHeight());
        path.close();
    }

    private Bitmap createCircleBitmap(int radius) {
        Bitmap canvasBmp = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(canvasBmp);
        canvas.drawColor(0);
        canvas.drawCircle((float)(this.width / 2), (float)(this.height / 2), (float)radius, this.progressBgPaint);
        return canvasBmp;
    }

    private void startAnimator() {
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0 - 4 * this.waveWidth, 0.0f});
        this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        int time = 200;
        if (this.waveSpeed > 0) {
            time = 12000 / this.waveSpeed;
            if (time > 12000) {
                time = 12000;
            } else if (time < 1000) {
                time = 1000;
            }
        }
        this.animator.setDuration((long)time);
        this.animator.setRepeatCount(-1);
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                WaterWaveProView.this.setStartX(((Float)animation.getAnimatedValue()).floatValue());
                WaterWaveProView.this.invalidate();
            }
        });
        this.animator.start();
    }

    public void replace() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
        }
    }

    public void invalidates() {
        this.replace();
        this.startAnimator();
        this.invalidate();
    }

    public int getWaveWidth() {
        return this.waveWidth;
    }

    public void setWaveWidth(int waveWidth) {
        this.waveWidth = waveWidth;
        this.invalidates();
    }

    public int getWaveHeight() {
        return this.waveHeight;
    }

    public void setWaveHeight(int waveHeight) {
        this.waveHeight = waveHeight;
        this.invalidates();
    }

    public int getWaveSpeed() {
        return this.waveSpeed;
    }

    public void setWaveSpeed(int waveSpeed) {
        this.waveSpeed = waveSpeed;
        this.invalidates();
    }

    public float getStartX() {
        return this.startX;
    }

    public void setStartX(float startX) {
        this.startX = startX;
    }
}

