/*
 * Decompiled with CFR 0.152.
 */
package com.liys.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.LinearGradient;
import android.graphics.Path;
import android.graphics.Shader;
import android.support.annotation.ArrayRes;
import android.util.AttributeSet;
import com.liys.view.BaseProView;
import com.liys.view.R;

public abstract class LineBaseProView
extends BaseProView {
    protected float radius;
    protected float leftTopRadius;
    protected float leftBottomRadius;
    protected float rightTopRadius;
    protected float rightBottomRadius;
    protected float progressRadius;
    protected boolean isRadius = true;
    protected float[] floatsIn;
    protected float[] floatsOut;
    protected Path pathIn = new Path();
    protected Path pathOut = new Path();

    public LineBaseProView(Context context) {
        this(context, null);
    }

    public LineBaseProView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LineBaseProView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(context.obtainStyledAttributes(attrs, R.styleable.LineBaseProView));
    }

    private void initAttrs(TypedArray typedArray) {
        this.radius = typedArray.getDimension(R.styleable.LineBaseProView_radius, -1.0f);
        this.leftTopRadius = typedArray.getDimension(R.styleable.LineBaseProView_left_top_radius, 0.0f);
        this.leftBottomRadius = typedArray.getDimension(R.styleable.LineBaseProView_left_bottom_radius, 0.0f);
        this.rightTopRadius = typedArray.getDimension(R.styleable.LineBaseProView_right_top_radius, 0.0f);
        this.rightBottomRadius = typedArray.getDimension(R.styleable.LineBaseProView_right_bottom_radius, 0.0f);
        this.progressRadius = typedArray.getDimension(R.styleable.LineBaseProView_progress_radius, 0.0f);
        if (this.radius == -1.0f) {
            this.isRadius = true;
        }
        if (this.leftTopRadius == 0.0f || this.leftBottomRadius == 0.0f || this.rightTopRadius == 0.0f || this.rightBottomRadius == 0.0f) {
            this.isRadius = true;
        }
    }

    @Override
    public void beforeInit() {
        if (this.isRadius && this.radius == -1.0f) {
            this.radius = this.progressSize / 2;
        }
    }

    protected void refreshRadius() {
        if (this.isRadius) {
            this.floatsIn = new float[]{this.radius, this.radius, this.radius, this.radius, this.radius, this.radius, this.radius, this.radius};
            this.floatsOut = new float[]{this.radius, this.radius, this.progressRadius, this.progressRadius, this.progressRadius, this.progressRadius, this.radius, this.radius};
        } else {
            this.floatsIn = new float[]{this.leftTopRadius, this.leftTopRadius, this.rightTopRadius, this.rightTopRadius, this.rightBottomRadius, this.rightBottomRadius, this.leftBottomRadius, this.leftBottomRadius};
            this.floatsOut = new float[]{this.leftTopRadius, this.leftTopRadius, this.progressRadius, this.progressRadius, this.progressRadius, this.progressRadius, this.leftBottomRadius, this.leftBottomRadius};
        }
    }

    @Override
    public void setOutGradient(final boolean isProDirection, final int ... colors) {
        this.post(new Runnable(){

            @Override
            public void run() {
                int[] colorResArr = new int[colors.length];
                for (int i = 0; i < colors.length; ++i) {
                    colorResArr[i] = colors[i];
                }
                int topOut = (LineBaseProView.this.height - LineBaseProView.this.progressSize) / 2;
                LinearGradient gradient = isProDirection ? new LinearGradient(0.0f, 0.0f, (float)LineBaseProView.this.width, 0.0f, colorResArr, null, Shader.TileMode.CLAMP) : new LinearGradient(0.0f, (float)topOut, 0.0f, (float)(topOut + LineBaseProView.this.progressSize), colorResArr, null, Shader.TileMode.CLAMP);
                LineBaseProView.this.progressPaint.setShader((Shader)gradient);
            }
        });
    }

    public void setOutGradientArray(boolean isHorizontal, @ArrayRes int arrayRes) {
        this.setOutGradient(isHorizontal, this.getResources().getIntArray(arrayRes));
    }

    public float getLeftTopRadius() {
        return this.leftTopRadius;
    }

    public void setLeftTopRadius(float leftTopRadius) {
        this.leftTopRadius = leftTopRadius;
    }

    public float getLeftBottomRadius() {
        return this.leftBottomRadius;
    }

    public void setLeftBottomRadius(float leftBottomRadius) {
        this.leftBottomRadius = leftBottomRadius;
    }

    public float getRightTopRadius() {
        return this.rightTopRadius;
    }

    public void setRightTopRadius(float rightTopRadius) {
        this.rightTopRadius = rightTopRadius;
    }

    public float getRightBottomRadius() {
        return this.rightBottomRadius;
    }

    public void setRightBottomRadius(float rightBottomRadius) {
        this.rightBottomRadius = rightBottomRadius;
    }

    public float getProgressRadius() {
        return this.progressRadius;
    }

    public void setProgressRadius(float progressRadius) {
        this.progressRadius = progressRadius;
    }

    public boolean isRadius() {
        return this.isRadius;
    }

    public void setRadius(boolean radius) {
        this.isRadius = radius;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }
}

