/*
 * Decompiled with CFR 0.152.
 */
package com.liys.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.util.AttributeSet;
import com.liys.view.R;
import com.liys.view.SquareProView;

public class ArcProView
extends SquareProView {
    protected int startAngle = 0;
    protected int drawAngle = 360;
    protected int currentAngle = 0;

    public ArcProView(Context context) {
        this(context, null);
    }

    public ArcProView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ArcProView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ArcProView);
        this.startAngle = typedArray.getInteger(R.styleable.ArcProView_arc_start_angle, 0);
        this.drawAngle = typedArray.getInteger(R.styleable.ArcProView_arc_draw_angle, 360);
    }

    @Override
    public void init() {
        if (this.progressSize == this.height) {
            this.progressSize = this.dp2px(10.0f);
        }
        this.blankSpace = this.dp2px(4.0f);
        this.refreshLight();
        this.progressPaint.setStrokeWidth((float)this.progressSize);
        this.progressPaint.setStrokeCap(Paint.Cap.ROUND);
        this.progressPaint.setStyle(Paint.Style.STROKE);
        this.progressBgPaint.setStrokeWidth((float)this.progressSize);
        this.progressBgPaint.setStrokeCap(Paint.Cap.ROUND);
        this.progressBgPaint.setStyle(Paint.Style.STROKE);
    }

    @Override
    public void setOutGradient(boolean isProDirection, final int ... colors) {
        this.post(new Runnable(){

            @Override
            public void run() {
                int[] colorResArr = new int[colors.length];
                for (int i = 0; i < colors.length; ++i) {
                    colorResArr[i] = colors[i];
                }
                SweepGradient gradient = new SweepGradient((float)(ArcProView.this.width / 2), (float)(ArcProView.this.height / 2), colorResArr, null);
                ArcProView.this.progressPaint.setShader((Shader)gradient);
            }
        });
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        this.currentAngle = (int)(this.progress * (double)this.drawAngle / this.maxProgress);
        int r = this.progressSize / 2;
        RectF rectF = new RectF((float)(r + this.blankSpace), (float)(r + this.blankSpace), (float)(this.width - r - this.blankSpace), (float)(this.height - r - this.blankSpace));
        this.drawInCircle(canvas, rectF);
        this.drawOutCircle(canvas, rectF);
        this.drawText(canvas);
    }

    private void drawLightCircle(Canvas canvas, RectF rectF) {
        canvas.drawArc(rectF, (float)this.startAngle, (float)this.drawAngle, false, this.lightPaint);
    }

    protected void drawInCircle(Canvas canvas, RectF rectF) {
        canvas.drawArc(rectF, (float)this.startAngle, (float)this.drawAngle, false, this.progressBgPaint);
    }

    protected void drawOutCircle(Canvas canvas, RectF rectF) {
        if (this.currentAngle > this.drawAngle) {
            this.currentAngle = this.drawAngle;
        }
        canvas.drawArc(rectF, (float)this.startAngle, (float)this.currentAngle, false, this.progressPaint);
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(int startAngle) {
        this.startAngle = startAngle;
    }

    public int getDrawAngle() {
        return this.drawAngle;
    }

    public void setDrawAngle(int drawAngle) {
        this.drawAngle = drawAngle;
        this.invalidate();
    }

    public int getCurrentAngle() {
        return this.currentAngle;
    }

    public void setCurrentAngle(int currentAngle) {
        this.currentAngle = currentAngle;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }
}

