/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.net.Uri;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import com.livechatinc.inappchat.ChatWindowConfiguration;
import com.livechatinc.inappchat.ChatWindowErrorType;
import com.livechatinc.inappchat.ChatWindowEventsListener;
import com.livechatinc.inappchat.ChatWindowView;
import com.livechatinc.inappchat.R;
import com.livechatinc.inappchat.models.NewMessageModel;
import java.util.HashMap;

public final class ChatWindowFragment
extends Fragment
implements ChatWindowEventsListener {
    private ChatWindowConfiguration configuration;
    private ChatWindowView chatWindow;

    public static ChatWindowFragment newInstance(Object licenceNumber, Object groupId) {
        return ChatWindowFragment.newInstance(licenceNumber, groupId, null, null, null);
    }

    public static ChatWindowFragment newInstance(Object licenceNumber, Object groupId, @Nullable String visitorName, @Nullable String visitorEmail) {
        return ChatWindowFragment.newInstance(licenceNumber, groupId, visitorName, visitorEmail, null);
    }

    public static ChatWindowFragment newInstance(Object licenceNumber, Object groupId, @Nullable String visitorName, @Nullable String visitorEmail, @Nullable HashMap<String, String> customVariables) {
        Bundle arguments = new Bundle();
        arguments.putString("KEY_LICENCE_NUMBER", String.valueOf(licenceNumber));
        arguments.putString("KEY_GROUP_ID", String.valueOf(groupId));
        if (visitorName != null) {
            arguments.putString("KEY_VISITOR_NAME", visitorName);
        }
        if (visitorEmail != null) {
            arguments.putString("KEY_VISITOR_EMAIL", visitorEmail);
        }
        if (customVariables != null) {
            for (String key : customVariables.keySet()) {
                arguments.putString("#LCcustomParam_" + key, customVariables.get(key));
            }
        }
        ChatWindowFragment chatWindowFragment = new ChatWindowFragment();
        chatWindowFragment.setArguments(arguments);
        return chatWindowFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.configuration = ChatWindowConfiguration.fromBundle(this.getArguments());
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.chatWindow = (ChatWindowView)inflater.inflate(R.layout.view_chat_window, container, false);
        this.chatWindow.setEventsListener(this);
        this.chatWindow.supportFileSharing(this.requireActivity().getActivityResultRegistry(), this.getLifecycle(), (LifecycleOwner)this);
        this.chatWindow.init(this.configuration);
        this.chatWindow.showChatWindow();
        return (View)this.chatWindow;
    }

    @Override
    public void onChatWindowVisibilityChanged(boolean visible) {
        if (!visible) {
            this.getActivity().onBackPressed();
        }
    }

    @Override
    public void onNewMessage(NewMessageModel message, boolean windowVisible) {
    }

    @Override
    public boolean handleUri(Uri uri) {
        return false;
    }

    @Override
    public void onFilePickerActivityNotFound() {
    }

    @Override
    public void onWindowInitialized() {
    }

    @Override
    public void onRequestAudioPermissions(String[] permissions, int requestCode) {
    }

    @Override
    public boolean onError(ChatWindowErrorType errorType, int errorCode, String errorDescription) {
        return false;
    }
}

