/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.content.ActivityNotFoundException;
import android.net.Uri;
import android.os.Build;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.livechatinc.inappchat.ActivityNotFoundCallback;
import java.util.Collections;
import java.util.List;

class ChatWindowLifecycleObserver
implements DefaultLifecycleObserver {
    private final ActivityResultRegistry registry;
    private ActivityResultLauncher<String> getContent;
    @RequiresApi(api=21)
    private ActivityResultLauncher<String> getMultipleContent;
    private final MutableLiveData<List<Uri>> resultLiveData = new MutableLiveData();
    private final ActivityNotFoundCallback activityNotFoundCallback;

    public ChatWindowLifecycleObserver(@NonNull ActivityResultRegistry registry, @NonNull ActivityNotFoundCallback activityNotFoundCallback) {
        this.registry = registry;
        this.activityNotFoundCallback = activityNotFoundCallback;
    }

    public void onCreate(@NonNull LifecycleOwner owner) {
        this.registerSingleContentContract(owner);
        if (Build.VERSION.SDK_INT >= 21) {
            this.registerMultipleContentContract(owner);
        }
    }

    private void registerSingleContentContract(@NonNull LifecycleOwner owner) {
        this.getContent = this.registry.register("chatWindowFileResultRegisterKey", owner, (ActivityResultContract)new ActivityResultContracts.GetContent(), file -> this.resultLiveData.postValue(file != null ? Collections.singletonList(file) : Collections.emptyList()));
    }

    @RequiresApi(api=21)
    private void registerMultipleContentContract(@NonNull LifecycleOwner owner) {
        this.getMultipleContent = this.registry.register("chatWindowMultipleFilesResultRegisterKey", owner, (ActivityResultContract)new ActivityResultContracts.GetMultipleContents(), arg_0 -> this.resultLiveData.postValue(arg_0));
    }

    public void selectFile() {
        try {
            this.getContent.launch((Object)"*/*");
        }
        catch (ActivityNotFoundException exception) {
            this.activityNotFoundCallback.onActivityNotFoundException();
            this.resultLiveData.postValue(Collections.emptyList());
        }
    }

    @RequiresApi(api=21)
    public void selectFiles() {
        try {
            this.getMultipleContent.launch((Object)"*/*");
        }
        catch (ActivityNotFoundException exception) {
            this.activityNotFoundCallback.onActivityNotFoundException();
            this.resultLiveData.postValue(Collections.emptyList());
        }
    }

    public LiveData<List<Uri>> getResultLiveData() {
        return this.resultLiveData;
    }
}

