/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ChatWindowConfiguration
implements Serializable {
    public static final String KEY_LICENCE_NUMBER = "KEY_LICENCE_NUMBER";
    public static final String KEY_GROUP_ID = "KEY_GROUP_ID";
    public static final String KEY_VISITOR_NAME = "KEY_VISITOR_NAME";
    public static final String KEY_VISITOR_EMAIL = "KEY_VISITOR_EMAIL";
    private static final String DEFAULT_GROUP_ID = "0";
    private static final String TAG = ChatWindowConfiguration.class.getSimpleName();
    public static final String CUSTOM_PARAM_PREFIX = "#LCcustomParam_";
    public final String licenceNumber;
    public final String groupId;
    public final String visitorName;
    public final String visitorEmail;
    public final HashMap<String, String> customVariables;

    public ChatWindowConfiguration(@NonNull String licenceNumber, @Nullable String groupId, @Nullable String visitorName, @Nullable String visitorEmail, @Nullable HashMap<String, String> customVariables) {
        this.licenceNumber = licenceNumber;
        this.groupId = groupId != null ? groupId : DEFAULT_GROUP_ID;
        this.visitorName = visitorName;
        this.visitorEmail = visitorEmail;
        this.customVariables = customVariables;
    }

    public static ChatWindowConfiguration fromBundle(Bundle arguments) {
        HashMap<String, String> customParams = new HashMap<String, String>();
        for (String key : arguments.keySet()) {
            if (!key.startsWith(CUSTOM_PARAM_PREFIX)) continue;
            customParams.put(key.replaceFirst(CUSTOM_PARAM_PREFIX, ""), arguments.getString(key));
        }
        return new Builder().setLicenceNumber(arguments.getString(KEY_LICENCE_NUMBER)).setGroupId(arguments.getString(KEY_GROUP_ID)).setVisitorName(arguments.getString(KEY_VISITOR_NAME)).setVisitorEmail(arguments.getString(KEY_VISITOR_EMAIL)).setCustomParams(customParams).build();
    }

    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(KEY_LICENCE_NUMBER, this.licenceNumber);
        params.put(KEY_GROUP_ID, this.groupId);
        if (!TextUtils.isEmpty((CharSequence)this.visitorName)) {
            params.put(KEY_VISITOR_NAME, this.visitorName);
        }
        if (!TextUtils.isEmpty((CharSequence)this.visitorEmail)) {
            params.put(KEY_VISITOR_EMAIL, this.visitorEmail);
        }
        if (this.customVariables != null) {
            for (String key : this.customVariables.keySet()) {
                params.put(CUSTOM_PARAM_PREFIX + key, this.customVariables.get(key));
            }
        }
        return params;
    }

    public Bundle asBundle() {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : this.getParams().entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public String addParamsToChatWindowUrl(String chatUrl) {
        try {
            String customParams;
            chatUrl = this.replaceParameter(chatUrl, "license", this.licenceNumber);
            chatUrl = this.replaceParameter(chatUrl, "group", this.groupId);
            chatUrl = chatUrl + "&native_platform=android";
            if (this.visitorName != null) {
                chatUrl = chatUrl + "&name=" + URLEncoder.encode(this.visitorName, "UTF-8").replace("+", "%20");
            }
            if (this.visitorEmail != null) {
                chatUrl = chatUrl + "&email=" + URLEncoder.encode(this.visitorEmail, "UTF-8");
            }
            if (!TextUtils.isEmpty((CharSequence)(customParams = this.escapeCustomParams(this.getParams(), chatUrl)))) {
                chatUrl = chatUrl + "&params=" + customParams;
            }
            if (!chatUrl.startsWith("http")) {
                chatUrl = "https://" + chatUrl;
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("Error while encoding URL: " + e.getMessage()), (Throwable)e);
        }
        return chatUrl;
    }

    private String replaceParameter(String url, String key, String value) {
        return url.replace("{%" + key + "%}", value);
    }

    private String escapeCustomParams(Map<String, String> param, String chatUrl) {
        String params = "";
        for (String key : param.keySet()) {
            if (!key.startsWith(CUSTOM_PARAM_PREFIX)) continue;
            String encodedKey = Uri.encode((String)key.replace(CUSTOM_PARAM_PREFIX, ""));
            String encodedValue = Uri.encode((String)param.get(key));
            if (!TextUtils.isEmpty((CharSequence)params)) {
                params = params + "&";
            }
            params = params + encodedKey + "=" + encodedValue;
        }
        return Uri.encode((String)params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatWindowConfiguration that = (ChatWindowConfiguration)o;
        if (!this.licenceNumber.equals(that.licenceNumber)) {
            return false;
        }
        if (!this.groupId.equals(that.groupId)) {
            return false;
        }
        if (!Objects.equals(this.visitorName, that.visitorName)) {
            return false;
        }
        if (!Objects.equals(this.visitorEmail, that.visitorEmail)) {
            return false;
        }
        return Objects.equals(this.customVariables, that.customVariables);
    }

    public int hashCode() {
        int result = this.licenceNumber.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + (this.visitorName != null ? this.visitorName.hashCode() : 0);
        result = 31 * result + (this.visitorEmail != null ? this.visitorEmail.hashCode() : 0);
        result = 31 * result + (this.customVariables != null ? this.customVariables.hashCode() : 0);
        return result;
    }

    @NonNull
    public String toString() {
        return "licenceNumber='" + this.licenceNumber + "'\ngroupId='" + this.groupId + "'\nvisitorName='" + this.visitorName + "'\nvisitorEmail='" + this.visitorEmail + "'\ncustomVariables=" + this.customVariables;
    }

    public static class Builder {
        private String licenceNumber;
        private String groupId;
        private String visitorName;
        private String visitorEmail;
        private HashMap<String, String> customParams;

        public ChatWindowConfiguration build() {
            if (TextUtils.isEmpty((CharSequence)this.licenceNumber)) {
                throw new IllegalStateException("Licence Number cannot be null");
            }
            return new ChatWindowConfiguration(this.licenceNumber, this.groupId, this.visitorName, this.visitorEmail, this.customParams);
        }

        public Builder setLicenceNumber(String licenceNr) {
            this.licenceNumber = licenceNr;
            return this;
        }

        public Builder setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder setVisitorName(String visitorName) {
            this.visitorName = visitorName;
            return this;
        }

        public Builder setVisitorEmail(String visitorEmail) {
            this.visitorEmail = visitorEmail;
            return this;
        }

        public Builder setCustomParams(HashMap<String, String> customParams) {
            this.customParams = customParams;
            return this;
        }
    }
}

