/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.os.AsyncTask;
import android.util.Log;
import android.webkit.WebView;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.json.JSONException;
import org.json.JSONObject;

class LoadWebViewContentTask
extends AsyncTask<String, Void, String> {
    private static final String URL_STRING = "https://cdn.livechatinc.com/app/mobile/urls.json";
    private static final String JSON_CHAT_URL = "chat_url";
    private static final String PLACEHOLDER_LICENCE = "{%license%}";
    private static final String PLACEHOLDER_GROUP = "{%group%}";
    private static final int INDEX_LICENCE_NUMBER = 0;
    private static final int INDEX_GROUP_ID = 1;
    private static final int INDEX_VISITOR_NAME = 2;
    private static final int INDEX_VISITOR_EMAIL = 3;
    private final WebView mWebView;
    private final ProgressBar mProgressBar;
    private final TextView mTextView;

    public LoadWebViewContentTask(WebView webView, ProgressBar progressBar, TextView textView) {
        this.mWebView = webView;
        this.mProgressBar = progressBar;
        this.mTextView = textView;
    }

    protected void onPreExecute() {
        this.mProgressBar.setVisibility(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doInBackground(String ... params) {
        HttpURLConnection urlConnection = null;
        try {
            URL urlObj = new URL(URL_STRING);
            urlConnection = (HttpURLConnection)urlObj.openConnection();
            urlConnection.setConnectTimeout(15000);
            urlConnection.setReadTimeout(15000);
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                sb.toString();
                JSONObject jsonResponse = new JSONObject(sb.toString());
                String chatUrl = jsonResponse.getString(JSON_CHAT_URL);
                chatUrl = chatUrl.replace(PLACEHOLDER_LICENCE, params[0]);
                chatUrl = chatUrl.replace(PLACEHOLDER_GROUP, params[1]);
                if (params[2] != null) {
                    chatUrl = chatUrl + "&name=" + URLEncoder.encode(params[2], "UTF-8").replace("+", "%20");
                }
                if (params[3] != null) {
                    chatUrl = chatUrl + "&email=" + URLEncoder.encode(params[3], "UTF-8");
                }
                if (!chatUrl.startsWith("http")) {
                    chatUrl = "https://" + chatUrl;
                }
                String string = chatUrl;
                return string;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            Log.e((String)"LiveChat Widget", (String)"Missing internet permission!");
            e.printStackTrace();
        }
        finally {
            if (urlConnection != null) {
                try {
                    urlConnection.disconnect();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    protected void onPostExecute(String result) {
        if (result != null) {
            this.mWebView.loadUrl(result);
            this.mWebView.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(8);
            this.mTextView.setVisibility(0);
        }
    }
}

