/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.net.Uri;
import android.util.Log;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import com.livechatinc.inappchat.ChatWindowConfiguration;
import com.livechatinc.inappchat.ChatWindowErrorType;
import com.livechatinc.inappchat.ChatWindowEventsListener;
import com.livechatinc.inappchat.ChatWindowViewInternal;
import com.livechatinc.inappchat.models.NewMessageModel;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

class ChatWindowPresenter {
    final ChatWindowViewInternal chatWindowView;
    final RequestQueue networkQueue;
    final String TAG = ChatWindowPresenter.class.getSimpleName();
    private ChatWindowConfiguration config;
    protected ChatWindowEventsListener eventsListener;
    protected boolean chatUiReady = false;

    ChatWindowPresenter(ChatWindowViewInternal chatWindowView, RequestQueue networkQueue) {
        this.chatWindowView = chatWindowView;
        this.networkQueue = networkQueue;
    }

    protected void setEventsListener(ChatWindowEventsListener eventsListener) {
        this.eventsListener = eventsListener;
    }

    protected void init() {
        this.checkConfiguration();
        JsonObjectRequest initializationRequest = new JsonObjectRequest(0, "https://cdn.livechatinc.com/app/mobile/urls.json", null, this::onWindowInitialized, this::onWindowInitializationError);
        this.networkQueue.add((Request)initializationRequest);
    }

    protected void setConfig(ChatWindowConfiguration config) {
        this.config = config;
    }

    private void checkConfiguration() {
        if (this.config == null) {
            throw new IllegalStateException("Config must be provided before initialization");
        }
    }

    protected void reinitialize() {
        this.chatWindowView.showProgress();
        this.chatUiReady = false;
        this.init();
    }

    private void onWindowInitialized(JSONObject response) {
        Log.d((String)this.TAG, (String)("Response: " + response));
        String chatUrl = this.constructChatUrl(response);
        Log.d((String)this.TAG, (String)("constructed url: " + chatUrl));
        if (chatUrl != null) {
            this.chatWindowView.loadUrl(chatUrl);
        }
        if (this.eventsListener != null) {
            this.eventsListener.onWindowInitialized();
        }
    }

    private String constructChatUrl(JSONObject jsonResponse) {
        String chatUrl = null;
        try {
            chatUrl = jsonResponse.getString("chat_url");
            chatUrl = this.config.addParamsToChatWindowUrl(chatUrl);
        }
        catch (JSONException e) {
            Log.e((String)this.TAG, (String)("Error parsing chat url from response: " + e.getMessage()), (Throwable)e);
        }
        return chatUrl;
    }

    private void onWindowInitializationError(VolleyError error) {
        int errorCode = error.networkResponse != null ? error.networkResponse.statusCode : -1;
        this.onErrorDetected(ChatWindowErrorType.InitialConfiguration, errorCode, error.getMessage());
    }

    protected void onErrorDetected(ChatWindowErrorType type, int errorCode, String errorDescription) {
        Log.d((String)this.TAG, (String)("Error detected. Type: " + (Object)((Object)type) + ", code: " + errorCode + ", description: " + errorDescription));
        boolean errorHandled = this.eventsListener != null && this.eventsListener.onError(type, errorCode, errorDescription);
        this.chatWindowView.runOnMainThread(this.chatWindowView::hideProgressBar);
        if (!errorHandled) {
            this.chatWindowView.runOnMainThread(this.chatWindowView::showErrorView);
        }
    }

    public void onPageLoaded() {
        this.chatWindowView.showWebView();
    }

    public boolean handleUri(Uri uri, String originalUrl) {
        String uriString = uri.toString();
        Log.d((String)this.TAG, (String)("handle url: " + uriString));
        if (uriString.equals(originalUrl) || this.isSecureLivechatIncDomain(uri.getHost())) {
            return false;
        }
        if (this.eventsListener == null || !this.eventsListener.handleUri(uri)) {
            this.chatWindowView.launchExternalBrowser(uri);
        }
        return true;
    }

    private boolean isSecureLivechatIncDomain(String host) {
        return host != null && Pattern.compile("(secure-?(lc|dal|fra|)\\.(livechat|livechatinc)\\.com)").matcher(host).find();
    }

    protected void onHideChatWindow() {
        this.chatWindowView.runOnMainThread(this.chatWindowView::hideChatWindow);
    }

    protected void onUiReady() {
        this.chatUiReady = true;
        this.chatWindowView.runOnMainThread(this.chatWindowView::hideProgressBar);
    }

    protected void onNewMessageReceived(NewMessageModel newMessageModel) {
        if (this.eventsListener != null) {
            this.chatWindowView.runOnMainThread(() -> this.eventsListener.onNewMessage(newMessageModel, this.chatWindowView.isShown()));
        }
    }

    public void onNoFileSharingSupport() {
        if (this.eventsListener.onError(ChatWindowErrorType.NoFileSharingSupport, -1, "Attachments support not configured")) {
            return;
        }
        this.chatWindowView.showFileSharingNotSupportedMessage();
    }
}

