/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.CookieManager;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultRegistry;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import com.android.volley.toolbox.Volley;
import com.livechatinc.inappchat.ChatWindowConfiguration;
import com.livechatinc.inappchat.ChatWindowEventsListener;
import com.livechatinc.inappchat.ChatWindowJsInterface;
import com.livechatinc.inappchat.ChatWindowLifecycleObserver;
import com.livechatinc.inappchat.ChatWindowPresenter;
import com.livechatinc.inappchat.ChatWindowView;
import com.livechatinc.inappchat.ChatWindowViewInternal;
import com.livechatinc.inappchat.FileChooserMode;
import com.livechatinc.inappchat.LCWebChromeClient;
import com.livechatinc.inappchat.LCWebViewClient;
import com.livechatinc.inappchat.R;
import java.util.List;

public class ChatWindowViewImpl
extends FrameLayout
implements ChatWindowView,
ChatWindowViewInternal {
    private WebView webView;
    private TextView statusText;
    private Button reloadButton;
    private ProgressBar progressBar;
    protected static final int REQUEST_CODE_AUDIO_PERMISSIONS = 89292;
    private ValueCallback<Uri> mUriUploadCallback;
    private ValueCallback<Uri[]> mUriArrayUploadCallback;
    private ViewTreeObserver.OnGlobalLayoutListener layoutListener;
    protected PermissionRequest webRequestPermissions;
    private ChatWindowPresenter presenter;
    private static final String TAG = "ChatWindowView";
    private ChatWindowLifecycleObserver observer;
    private Observer<List<Uri>> uriObserver;

    public ChatWindowViewImpl(@NonNull Context context) {
        super(context);
        this.initView(context);
    }

    public ChatWindowViewImpl(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        Log.d((String)TAG, (String)"Initializing ChatWindowViewImpl");
        this.setFitsSystemWindows(true);
        this.setVisibility(8);
        LayoutInflater.from((Context)context).inflate(R.layout.view_chat_window_internal, (ViewGroup)this, true);
        this.webView = (WebView)this.findViewById(R.id.chat_window_web_view);
        this.statusText = (TextView)this.findViewById(R.id.chat_window_status_text);
        this.progressBar = (ProgressBar)this.findViewById(R.id.chat_window_progress);
        this.reloadButton = (Button)this.findViewById(R.id.chat_window_button);
        this.reloadButton.setOnClickListener(view -> this.reload(true));
        this.presenter = new ChatWindowPresenter(this, Volley.newRequestQueue((Context)context));
        if (Build.VERSION.RELEASE.matches("4\\.4(\\.[12])?")) {
            String userAgentString = this.webView.getSettings().getUserAgentString();
            this.webView.getSettings().setUserAgentString(userAgentString + " AndroidNoFilesharing");
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        this.webView.setFocusable(true);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 17) {
            webSettings.setMediaPlaybackRequiresUserGesture(false);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies(this.webView, true);
        }
        this.webView.setWebViewClient((WebViewClient)new LCWebViewClient(this.presenter));
        this.webView.setWebChromeClient((WebChromeClient)new LCWebChromeClient(this, this.presenter));
        this.webView.requestFocus(130);
        this.webView.setVisibility(8);
        this.webView.setOnTouchListener((view, event) -> {
            switch (event.getAction()) {
                case 0: 
                case 1: {
                    if (view.hasFocus()) break;
                    view.requestFocus();
                }
            }
            return false;
        });
        this.webView.addJavascriptInterface((Object)new ChatWindowJsInterface(this.presenter), "androidMobileWidget");
        this.adjustResizeOnGlobalLayout(this.webView, this.getActivity());
    }

    private Activity getActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    private void adjustResizeOnGlobalLayout(WebView webView, Activity activity) {
        if (!this.shouldAdjustLayout(this.getActivity())) {
            return;
        }
        View decorView = activity.getWindow().getDecorView();
        this.layoutListener = () -> {
            View decorView1 = this.getActivity().getWindow().getDecorView();
            ChatWindowViewImpl viewGroup = this;
            DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
            Rect rect = new Rect();
            decorView1.getWindowVisibleDisplayFrame(rect);
            int paddingBottom = displayMetrics.heightPixels - rect.bottom;
            if (viewGroup.getPaddingBottom() != paddingBottom) {
                viewGroup.setPadding(viewGroup.getPaddingLeft(), viewGroup.getPaddingTop(), viewGroup.getPaddingRight(), paddingBottom);
            } else if (paddingBottom != 0 && Build.VERSION.SDK_INT >= 19) {
                webView.evaluateJavascript("if (document.activeElement) { document.activeElement.scrollIntoView({behavior: \"smooth\", block: \"center\", inline: \"nearest\"}); }", null);
            }
        };
        decorView.getViewTreeObserver().addOnGlobalLayoutListener(this.layoutListener);
    }

    protected void onDetachedFromWindow() {
        this.removeLayoutListener();
        this.webView.destroy();
        if (this.observer != null && this.uriObserver != null) {
            this.observer.getResultLiveData().removeObserver(this.uriObserver);
        }
        super.onDetachedFromWindow();
    }

    private void removeLayoutListener() {
        if (this.layoutListener == null) {
            return;
        }
        View decorView = this.getActivity().getWindow().getDecorView();
        if (Build.VERSION.SDK_INT >= 16) {
            decorView.getViewTreeObserver().removeOnGlobalLayoutListener(this.layoutListener);
        } else {
            decorView.getViewTreeObserver().removeGlobalOnLayoutListener(this.layoutListener);
        }
    }

    private boolean shouldAdjustLayout(Activity activity) {
        if (Build.VERSION.SDK_INT >= 30) {
            return false;
        }
        int flags = activity.getWindow().getAttributes().flags;
        return (flags & 0x400) != 0;
    }

    @Override
    public void setEventsListener(ChatWindowEventsListener listener) {
        this.presenter.setEventsListener(listener);
    }

    @Override
    public void supportFileSharing(ActivityResultRegistry activityResultRegistry, Lifecycle lifecycle, LifecycleOwner owner) {
        this.observer = new ChatWindowLifecycleObserver(activityResultRegistry, () -> {
            if (this.presenter.eventsListener != null) {
                this.presenter.eventsListener.onFilePickerActivityNotFound();
            }
        });
        lifecycle.addObserver((LifecycleObserver)this.observer);
        this.uriObserver = this::onFileChooserResult;
        this.observer.getResultLiveData().observe(owner, this.uriObserver);
    }

    private void onFileChooserResult(List<Uri> selectedFiles) {
        if (this.isUriArrayUpload()) {
            this.mUriArrayUploadCallback.onReceiveValue((Object)selectedFiles.toArray(new Uri[0]));
            this.mUriArrayUploadCallback = null;
        } else if (this.mUriUploadCallback != null) {
            this.mUriUploadCallback.onReceiveValue(selectedFiles.isEmpty() ? null : selectedFiles.get(0));
            this.mUriUploadCallback = null;
        }
    }

    private boolean isUriArrayUpload() {
        return this.mUriArrayUploadCallback != null;
    }

    @Override
    public void init(@NonNull ChatWindowConfiguration config) {
        this.presenter.setConfig(config);
        this.presenter.init();
    }

    @Override
    public void reload(Boolean fullReload) {
        this.presenter.reinitialize();
    }

    @Override
    public void showChatWindow() {
        this.setVisibility(0);
        if (this.presenter.eventsListener != null) {
            this.post(() -> this.presenter.eventsListener.onChatWindowVisibilityChanged(true));
        }
    }

    @Override
    public void hideChatWindow() {
        this.setVisibility(8);
        if (this.presenter.eventsListener != null) {
            this.post(() -> this.presenter.eventsListener.onChatWindowVisibilityChanged(false));
        }
    }

    @Override
    public boolean isChatLoaded() {
        return this.presenter.chatUiReady;
    }

    @Override
    @RequiresApi(api=21)
    public boolean onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == 89292 && this.webRequestPermissions != null) {
            String[] PERMISSIONS = new String[]{"android.webkit.resource.AUDIO_CAPTURE", "android.webkit.resource.VIDEO_CAPTURE"};
            this.webRequestPermissions.grant(PERMISSIONS);
            this.webRequestPermissions = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean onBackPressed() {
        if (this.isShown()) {
            this.hideChatWindow();
            return true;
        }
        return false;
    }

    @Override
    public void loadUrl(String chatUrl) {
        if (this.getContext() != null) {
            this.webView.loadUrl(chatUrl);
        }
    }

    @Override
    public void showWebView() {
        if (this.getContext() != null) {
            this.webView.setVisibility(0);
        }
    }

    @Override
    public void showProgress() {
        if (this.getContext() != null) {
            this.progressBar.setVisibility(0);
            this.webView.setVisibility(8);
            this.statusText.setVisibility(8);
            this.reloadButton.setVisibility(8);
        }
    }

    @Override
    public void hideProgressBar() {
        if (this.getContext() != null) {
            this.progressBar.setVisibility(8);
        }
    }

    @Override
    public void showErrorView() {
        if (this.getContext() != null) {
            this.webView.setVisibility(8);
            this.statusText.setVisibility(0);
            this.reloadButton.setVisibility(0);
        }
    }

    @Override
    public void launchExternalBrowser(Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        this.webView.getContext().startActivity(intent);
    }

    @Override
    public void runOnMainThread(Runnable runnable) {
        this.post(runnable);
    }

    @Override
    public void showFileSharingNotSupportedMessage() {
        Log.e((String)TAG, (String)"Attachment support is not set up");
        Toast.makeText((Context)this.getContext(), (int)R.string.cant_share_files, (int)0).show();
    }

    protected void chooseUriToUpload(ValueCallback<Uri> uriValueCallback) {
        this.resetAllUploadCallbacks();
        this.mUriUploadCallback = uriValueCallback;
        this.startFileChooserActivity();
    }

    @RequiresApi(api=21)
    protected void chooseUriArrayToUpload(ValueCallback<Uri[]> uriArrayValueCallback, FileChooserMode mode) {
        this.resetAllUploadCallbacks();
        this.mUriArrayUploadCallback = uriArrayValueCallback;
        this.startFileChooserActivity(mode);
    }

    private void resetAllUploadCallbacks() {
        this.resetUriUploadCallback();
        this.resetUriArrayUploadCallback();
    }

    private void resetUriUploadCallback() {
        if (this.mUriUploadCallback != null) {
            this.mUriUploadCallback.onReceiveValue(null);
            this.mUriUploadCallback = null;
        }
    }

    private void resetUriArrayUploadCallback() {
        if (this.mUriArrayUploadCallback != null) {
            this.mUriArrayUploadCallback.onReceiveValue(null);
            this.mUriArrayUploadCallback = null;
        }
    }

    private void startFileChooserActivity() {
        if (this.observer == null) {
            this.presenter.onNoFileSharingSupport();
            return;
        }
        this.observer.selectFile();
    }

    @RequiresApi(api=21)
    private void startFileChooserActivity(FileChooserMode mode) {
        if (this.observer == null) {
            this.presenter.onNoFileSharingSupport();
            return;
        }
        switch (mode) {
            case SINGLE: {
                this.observer.selectFile();
                break;
            }
            case MULTIPLE: {
                this.observer.selectFiles();
            }
        }
    }
}

