/*
 * Decompiled with CFR 0.152.
 */
package com.rxjava.rxlife;

import com.rxjava.rxlife.LifeMaybeObserver;
import com.rxjava.rxlife.ObjectHelper;
import com.rxjava.rxlife.RxSource;
import com.rxjava.rxlife.Scope;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.functions.Functions;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeCallbackObserver;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;

public class MaybeLife<T>
extends RxSource<MaybeObserver<? super T>> {
    private final Maybe<T> upStream;

    MaybeLife(Maybe<T> upStream, Scope scope, boolean onMain) {
        super(scope, onMain);
        this.upStream = upStream;
    }

    @Override
    public final Disposable subscribe() {
        return this.subscribe(Functions.emptyConsumer(), (Consumer<Throwable>)Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    public final Disposable subscribe(Consumer<? super T> onSuccess) {
        return this.subscribe(onSuccess, (Consumer<Throwable>)Functions.ON_ERROR_MISSING, Functions.EMPTY_ACTION);
    }

    public final Disposable subscribe(Consumer<? super T> onSuccess, Consumer<? super Throwable> onError) {
        return this.subscribe(onSuccess, onError, Functions.EMPTY_ACTION);
    }

    public final Disposable subscribe(Consumer<? super T> onSuccess, Consumer<? super Throwable> onError, Action onComplete) {
        ObjectHelper.requireNonNull(onSuccess, "onSuccess is null");
        ObjectHelper.requireNonNull(onError, "onError is null");
        ObjectHelper.requireNonNull(onComplete, "onComplete is null");
        return (Disposable)this.subscribeWith(new MaybeCallbackObserver(onSuccess, onError, onComplete));
    }

    @Override
    public final void subscribe(MaybeObserver<? super T> observer) {
        ObjectHelper.requireNonNull(observer, "observer is null");
        observer = RxJavaPlugins.onSubscribe(this.upStream, observer);
        ObjectHelper.requireNonNull(observer, "The RxJavaPlugins.onSubscribe hook returned a null MaybeObserver. Please check the handler provided to RxJavaPlugins.setOnMaybeSubscribe for invalid null returns. Further reading: https://github.com/ReactiveX/RxJava/wiki/Plugins");
        try {
            this.subscribeActual(observer);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal((Throwable)ex);
            NullPointerException npe = new NullPointerException("subscribeActual failed");
            npe.initCause(ex);
            throw npe;
        }
    }

    private void subscribeActual(MaybeObserver<? super T> observer) {
        Maybe upStream = this.upStream;
        if (this.onMain) {
            upStream = upStream.observeOn(AndroidSchedulers.mainThread());
        }
        upStream.onTerminateDetach().subscribe(new LifeMaybeObserver<T>(observer, this.scope));
    }
}

