/*
 * Decompiled with CFR 0.152.
 */
package com.rxjava.rxlife;

import com.rxjava.rxlife.AbstractLifecycle;
import com.rxjava.rxlife.Scope;
import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.operators.ConditionalSubscriber;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscription;

final class LifeConditionalSubscriber<T>
extends AbstractLifecycle<Subscription>
implements ConditionalSubscriber<T> {
    private final ConditionalSubscriber<? super T> downstream;

    LifeConditionalSubscriber(ConditionalSubscriber<? super T> downstream, Scope scope) {
        super(scope);
        this.downstream = downstream;
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce((AtomicReference)this, (Subscription)s)) {
            try {
                this.addObserver();
                this.downstream.onSubscribe(s);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal((Throwable)ex);
                s.cancel();
                this.onError(ex);
            }
        }
    }

    public void onNext(T t) {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.downstream.onNext(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            ((Subscription)this.get()).cancel();
            this.onError(e);
        }
    }

    public void onError(Throwable t) {
        if (this.isDisposed()) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        this.lazySet(SubscriptionHelper.CANCELLED);
        try {
            this.removeObserver();
            this.downstream.onError(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaPlugins.onError((Throwable)new CompositeException(new Throwable[]{t, e}));
        }
    }

    public void onComplete() {
        if (this.isDisposed()) {
            return;
        }
        this.lazySet(SubscriptionHelper.CANCELLED);
        try {
            this.removeObserver();
            this.downstream.onComplete();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal((Throwable)e);
            RxJavaPlugins.onError((Throwable)e);
        }
    }

    public boolean isDisposed() {
        return this.get() == SubscriptionHelper.CANCELLED;
    }

    public void dispose() {
        SubscriptionHelper.cancel((AtomicReference)this);
    }

    public boolean tryOnNext(T t) {
        if (!this.isDisposed()) {
            return this.downstream.tryOnNext(t);
        }
        return false;
    }
}

