/*
 * Decompiled with CFR 0.152.
 */
package com.rxjava.rxlife;

import android.os.Build;
import android.view.View;
import com.rxjava.rxlife.OutsideScopeException;
import com.rxjava.rxlife.Scope;
import io.reactivex.rxjava3.disposables.Disposable;

public final class ViewScope
implements Scope,
View.OnAttachStateChangeListener {
    private final View view;
    private Disposable disposable;
    private final boolean ignoreAttach;

    private ViewScope(View view, boolean ignoreAttach) {
        this.view = view;
        this.ignoreAttach = ignoreAttach;
    }

    static ViewScope from(View view, boolean ignoreAttach) {
        return new ViewScope(view, ignoreAttach);
    }

    @Override
    public void onScopeStart(Disposable d) {
        boolean isAttached;
        this.disposable = d;
        View view = this.view;
        if (view == null) {
            throw new NullPointerException("view is null");
        }
        boolean bl = isAttached = Build.VERSION.SDK_INT >= 19 && view.isAttachedToWindow() || view.getWindowToken() != null;
        if (!isAttached && !this.ignoreAttach) {
            throw new OutsideScopeException("View is not attached!");
        }
        view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }

    @Override
    public void onScopeEnd() {
        View view = this.view;
        if (view == null) {
            return;
        }
        view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }

    public void onViewAttachedToWindow(View v) {
    }

    public void onViewDetachedFromWindow(View v) {
        this.disposable.dispose();
        v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }
}

