/*
 * Decompiled with CFR 0.152.
 */
package com.rxhttp.compiler.ksp;

import com.google.devtools.ksp.KspExperimental;
import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSTypeParameter;
import com.google.devtools.ksp.symbol.KSValueParameter;
import com.rxhttp.compiler.ConstantsKt;
import com.rxhttp.compiler.VariablesKt;
import com.rxhttp.compiler.common.StringUtilKt;
import com.rxhttp.compiler.ksp.KspKt;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.TypeVariableName;
import com.squareup.kotlinpoet.jvm.JvmAnnotations;
import com.squareup.kotlinpoet.ksp.KsTypesKt;
import com.squareup.kotlinpoet.ksp.OriginatingKSFilesKt;
import com.squareup.kotlinpoet.ksp.TypeParameterResolver;
import com.squareup.kotlinpoet.ksp.TypeParameterResolverKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rxhttp.wrapper.annotation.Converter;
import rxhttp.wrapper.annotation.Domain;
import rxhttp.wrapper.annotation.OkClient;
import rxhttp.wrapper.annotation.Param;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0018\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u001d0\u001cj\b\u0012\u0004\u0012\u00020\u001d`\u001eH\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\f`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/rxhttp/compiler/ksp/RxHttpWrapper;", "", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "<init>", "(Lcom/google/devtools/ksp/processing/KSPLogger;)V", "classMap", "Ljava/util/LinkedHashMap;", "", "Lcom/rxhttp/compiler/ksp/RxHttpWrapper$Wrapper;", "Lkotlin/collections/LinkedHashMap;", "elementMap", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "ksFiles", "", "Lcom/google/devtools/ksp/symbol/KSFile;", "add", "", "ksClassDeclaration", "addOkClient", "property", "Lcom/google/devtools/ksp/symbol/KSPropertyDeclaration;", "addConverter", "addDomain", "generateRxWrapper", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "generateRequestFunList", "Ljava/util/ArrayList;", "Lcom/squareup/kotlinpoet/FunSpec;", "Lkotlin/collections/ArrayList;", "Wrapper", "rxhttp-compiler"})
@SourceDebugExtension(value={"SMAP\nRxHttpWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RxHttpWrapper.kt\ncom/rxhttp/compiler/ksp/RxHttpWrapper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,247:1\n216#2:248\n217#2:250\n216#2,2:251\n216#2:253\n217#2:267\n1#3:249\n1563#4:254\n1634#4,3:255\n1634#4,3:263\n37#5:258\n36#5,3:259\n1321#6:262\n1322#6:266\n*S KotlinDebug\n*F\n+ 1 RxHttpWrapper.kt\ncom/rxhttp/compiler/ksp/RxHttpWrapper\n*L\n120#1:248\n120#1:250\n190#1:251,2\n202#1:253\n202#1:267\n203#1:254\n203#1:255,3\n222#1:263,3\n210#1:258\n210#1:259,3\n217#1:262\n217#1:266\n*E\n"})
public final class RxHttpWrapper {
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final LinkedHashMap<String, Wrapper> classMap;
    @NotNull
    private final LinkedHashMap<String, KSClassDeclaration> elementMap;
    @NotNull
    private final Set<KSFile> ksFiles;

    public RxHttpWrapper(@NotNull KSPLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.classMap = new LinkedHashMap();
        this.elementMap = new LinkedHashMap();
        this.ksFiles = new LinkedHashSet();
    }

    @KspExperimental
    public final void add(@NotNull KSClassDeclaration ksClassDeclaration) {
        Intrinsics.checkNotNullParameter((Object)ksClassDeclaration, (String)"ksClassDeclaration");
        Param param = (Param)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)ksClassDeclaration), (KClass)Reflection.getOrCreateKotlinClass(Param.class)));
        if (param == null) {
            return;
        }
        Param annotation = param;
        String name = annotation.methodName();
        ((Map)this.elementMap).put(name, ksClassDeclaration);
        KSFile kSFile = ksClassDeclaration.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        this.ksFiles.add(kSFile);
    }

    @KspExperimental
    public final void addOkClient(@NotNull KSPropertyDeclaration property) {
        String name;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        OkClient okClient = (OkClient)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)property), (KClass)Reflection.getOrCreateKotlinClass(OkClient.class)));
        if (okClient == null) {
            return;
        }
        OkClient okClient2 = okClient;
        if (((CharSequence)okClient2.className()).length() == 0) {
            return;
        }
        Wrapper wrapper = this.classMap.get(okClient2.className());
        if (wrapper == null) {
            wrapper = new Wrapper();
            ((Map)this.classMap).put(okClient2.className(), wrapper);
        }
        if (wrapper.getOkClientName() != null) {
            String msg = "@OkClient annotation className cannot be the same";
            this.logger.error(msg, (KSNode)property);
        }
        if (StringsKt.isBlank((CharSequence)(name = okClient2.name()))) {
            name = KspKt.firstLetterUpperCase(property.getSimpleName().asString());
        }
        wrapper.setOkClientName(name);
        KSFile kSFile = property.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        this.ksFiles.add(kSFile);
    }

    @KspExperimental
    public final void addConverter(@NotNull KSPropertyDeclaration property) {
        String name;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Converter converter = (Converter)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)property), (KClass)Reflection.getOrCreateKotlinClass(Converter.class)));
        if (converter == null) {
            return;
        }
        Converter converter2 = converter;
        if (((CharSequence)converter2.className()).length() == 0) {
            return;
        }
        Wrapper wrapper = this.classMap.get(converter2.className());
        if (wrapper == null) {
            wrapper = new Wrapper();
            ((Map)this.classMap).put(converter2.className(), wrapper);
        }
        if (wrapper.getConverterName() != null) {
            String msg = "@Converter annotation className cannot be the same";
            this.logger.error(msg, (KSNode)property);
        }
        if (StringsKt.isBlank((CharSequence)(name = converter2.name()))) {
            name = KspKt.firstLetterUpperCase(property.getSimpleName().asString());
        }
        wrapper.setConverterName(name);
        KSFile kSFile = property.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        this.ksFiles.add(kSFile);
    }

    @KspExperimental
    public final void addDomain(@NotNull KSPropertyDeclaration property) {
        String name;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Domain domain = (Domain)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)property), (KClass)Reflection.getOrCreateKotlinClass(Domain.class)));
        if (domain == null) {
            return;
        }
        Domain domain2 = domain;
        if (((CharSequence)domain2.className()).length() == 0) {
            return;
        }
        Wrapper wrapper = this.classMap.get(domain2.className());
        if (wrapper == null) {
            wrapper = new Wrapper();
            ((Map)this.classMap).put(domain2.className(), wrapper);
        }
        if (wrapper.getDomainName() != null) {
            String msg = "@Domain annotation className cannot be the same";
            this.logger.error(msg, (KSNode)property);
        }
        if (StringsKt.isBlank((CharSequence)(name = domain2.name()))) {
            name = KspKt.firstLetterUpperCase(property.getSimpleName().asString());
        }
        wrapper.setDomainName(name);
        KSFile kSFile = property.getContainingFile();
        Intrinsics.checkNotNull((Object)kSFile);
        this.ksFiles.add(kSFile);
    }

    @KspExperimental
    public final void generateRxWrapper(@NotNull CodeGenerator codeGenerator) {
        Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
        ArrayList<FunSpec> requestFunList = this.generateRequestFunList();
        Map $this$forEach$iv = this.classMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            TypeName[] it;
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String className = (String)entry.getKey();
            Wrapper wrapper = (Wrapper)entry.getValue();
            CodeBlock.Builder funBody = CodeBlock.Companion.builder();
            TypeName[] typeNameArray = wrapper.getConverterName();
            if (typeNameArray != null) {
                it = typeNameArray;
                boolean bl2 = false;
                funBody.addStatement("set" + (String)it + "()", new Object[0]);
            }
            String string = wrapper.getOkClientName();
            if (string != null) {
                it = string;
                boolean bl3 = false;
                funBody.addStatement("set" + (String)it + "()", new Object[0]);
            }
            String string2 = wrapper.getDomainName();
            if (string2 != null) {
                it = string2;
                boolean bl4 = false;
                funBody.addStatement("setDomainTo" + (String)it + "IfAbsent()", new Object[0]);
            }
            TypeVariableName wildcard = TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)"*", null, (int)2, null);
            it = new TypeName[]{wildcard, wildcard};
            ParameterizedTypeName rxHttpName = ParameterizedTypeName.Companion.get(ConstantsKt.getRxhttpKClass(), it);
            TypeName[] bl4 = new TypeName[]{rxHttpName};
            TypeVariableName typeVariable = TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)"R", (TypeName[])bl4, null, (int)4, null);
            ArrayList<FunSpec> funList = new ArrayList<FunSpec>();
            FunSpec funSpec = new FunSpec[]{KModifier.PRIVATE};
            FunSpec $this$generateRxWrapper_u24lambda_u244_u24lambda_u243 = funSpec = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("wrapper").addKdoc("\u672c\u7c7b\u6240\u6709\u65b9\u6cd5\u90fd\u4f1a\u8c03\u7528\u672c\u65b9\u6cd5", new Object[0]).addModifiers((KModifier[])funSpec), (TypeName)((TypeName)typeVariable), null, (int)2, null).addTypeVariable(typeVariable).addCode(funBody.build()).addCode("return this", new Object[0]), (TypeName)((TypeName)typeVariable), null, (int)2, null).build();
            boolean bl5 = false;
            funList.add($this$generateRxWrapper_u24lambda_u244_u24lambda_u243);
            funList.addAll((Collection)requestFunList);
            TypeSpec.Builder rxHttpBuilder = TypeSpec.Companion.objectBuilder("Rx" + className + "Http").addKdoc("\u672c\u7c7b\u7531@Converter\u3001@Domain\u3001@OkClient\u6ce8\u89e3\u4e2d\u7684className\u5b57\u6bb5\u751f\u6210  \u7c7b\u547d\u540d\u65b9\u5f0f: Rx + {className\u5b57\u6bb5\u503c} + Http\nGithub\nhttps://github.com/liujingxing/rxhttp\nhttps://github.com/liujingxing/rxlife\nhttps://github.com/liujingxing/rxhttp/wiki/FAQ\nhttps://github.com/liujingxing/rxhttp/wiki/\u66f4\u65b0\u65e5\u5fd7", new Object[0]).addFunctions((Iterable)funList);
            OriginatingKSFilesKt.writeTo((FileSpec)FileSpec.Companion.builder(VariablesKt.getRxHttpPackage(), "Rx" + className + "Http").addType(rxHttpBuilder.build()).build(), (CodeGenerator)codeGenerator, (boolean)false, (Iterable)this.ksFiles);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KspExperimental
    private final ArrayList<FunSpec> generateRequestFunList() {
        Iterable $this$generateRequestFunList_u24lambda_u246_u24lambda_u245;
        String key;
        Map.Entry entry;
        Map.Entry element$iv;
        ArrayList<FunSpec> funList = new ArrayList<FunSpec>();
        LinkedHashMap funMap = new LinkedHashMap();
        ((Map)funMap).put("get", "RxHttpNoBodyParam");
        ((Map)funMap).put("head", "RxHttpNoBodyParam");
        ((Map)funMap).put("postBody", "RxHttpBodyParam");
        ((Map)funMap).put("putBody", "RxHttpBodyParam");
        ((Map)funMap).put("patchBody", "RxHttpBodyParam");
        ((Map)funMap).put("deleteBody", "RxHttpBodyParam");
        ((Map)funMap).put("postForm", "RxHttpFormParam");
        ((Map)funMap).put("putForm", "RxHttpFormParam");
        ((Map)funMap).put("patchForm", "RxHttpFormParam");
        ((Map)funMap).put("deleteForm", "RxHttpFormParam");
        ((Map)funMap).put("postJson", "RxHttpJsonParam");
        ((Map)funMap).put("putJson", "RxHttpJsonParam");
        ((Map)funMap).put("patchJson", "RxHttpJsonParam");
        ((Map)funMap).put("deleteJson", "RxHttpJsonParam");
        ((Map)funMap).put("postJsonArray", "RxHttpJsonArrayParam");
        ((Map)funMap).put("putJsonArray", "RxHttpJsonArrayParam");
        ((Map)funMap).put("patchJsonArray", "RxHttpJsonArrayParam");
        ((Map)funMap).put("deleteJsonArray", "RxHttpJsonArrayParam");
        Map $this$forEach$iv = funMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = element$iv = iterator.next();
            boolean bl = false;
            key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ClassName returnType = ConstantsKt.getRxhttpKClass().peerClass(value);
            FunSpec funSpec = new FunSpec[]{KModifier.VARARG};
            funSpec = FunSpec.Builder.returns$default((FunSpec.Builder)KspKt.addParameter(JvmAnnotations.jvmStatic((FunSpec.Builder)FunSpec.Companion.builder(key)).addParameter("url", (TypeName)TypeNames.STRING, new KModifier[0]), "formatArgs", (TypeName)TypeNames.ANY, true, (KModifier[])funSpec).addStatement("return RxHttp." + key + "(url, *formatArgs).wrapper()", new Object[0]), (TypeName)((TypeName)returnType), null, (int)2, null).build();
            $this$generateRequestFunList_u24lambda_u246_u24lambda_u245 = funSpec;
            boolean bl2 = false;
            funList.add((FunSpec)$this$generateRequestFunList_u24lambda_u246_u24lambda_u245);
        }
        $this$forEach$iv = this.elementMap;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            TypeName typeName;
            void $this$mapTo$iv$iv;
            entry = element$iv = iterator.next();
            boolean bl = false;
            key = (String)entry.getKey();
            KSClassDeclaration ksClass = (KSClassDeclaration)entry.getValue();
            Iterable $this$map$iv = ksClass.getTypeParameters();
            boolean $i$f$map = false;
            $this$generateRequestFunList_u24lambda_u246_u24lambda_u245 = $this$map$iv;
            TypeVariableName[] destination$iv$iv = (TypeVariableName[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KSTypeParameter kSTypeParameter = (KSTypeParameter)item$iv$iv;
                TypeVariableName[] typeVariableNameArray = destination$iv$iv;
                boolean bl3 = false;
                typeVariableNameArray.add(KsTypesKt.toTypeVariableName$default((KSTypeParameter)it, null, (int)1, null));
            }
            List rxHttpTypeNames = (List)destination$iv$iv;
            String rxHttpName = "RxHttp" + ksClass.getSimpleName().asString();
            ClassName rxHttpParamName = ConstantsKt.getRxhttpKClass().peerClass(rxHttpName);
            if (!((Collection)rxHttpTypeNames).isEmpty()) {
                Collection $this$toTypedArray$iv = rxHttpTypeNames;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                destination$iv$iv = thisCollection$iv.toArray(new TypeVariableName[0]);
                typeName = (TypeName)ParameterizedTypeName.Companion.get(rxHttpParamName, (TypeName[])Arrays.copyOf(destination$iv$iv, destination$iv$iv.length));
            } else {
                typeName = (TypeName)rxHttpParamName;
            }
            TypeName funReturnType = typeName;
            TypeParameterResolver classTypeParams = TypeParameterResolverKt.toTypeParameterResolver$default((List)ksClass.getTypeParameters(), null, null, (int)3, null);
            Sequence<KSFunctionDeclaration> $this$forEach$iv2 = KspKt.getPublicConstructors(ksClass);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KModifier[] $this$mapTo$iv;
                KSFunctionDeclaration function = (KSFunctionDeclaration)element$iv2;
                boolean bl4 = false;
                TypeParameterResolver functionTypeParams = TypeParameterResolverKt.toTypeParameterResolver$default((List)function.getTypeParameters(), (TypeParameterResolver)classTypeParams, null, (int)2, null);
                Iterable iterable = function.getParameters();
                Collection destination$iv = new ArrayList();
                boolean $i$f$mapTo2 = false;
                FunSpec funSpec = $this$mapTo$iv.iterator();
                while (funSpec.hasNext()) {
                    void it;
                    Object item$iv = funSpec.next();
                    KSValueParameter kSValueParameter = (KSValueParameter)item$iv;
                    Collection collection = destination$iv;
                    boolean bl5 = false;
                    collection.add(KspKt.toKParameterSpec((KSValueParameter)it, functionTypeParams));
                }
                ArrayList parameterSpecs = (ArrayList)destination$iv;
                ParameterSpec parameterSpec = (ParameterSpec)CollectionsKt.firstOrNull((List)parameterSpecs);
                if (Intrinsics.areEqual((Object)(parameterSpec != null ? parameterSpec.getType() : null), (Object)TypeNames.STRING)) {
                    $this$mapTo$iv = new KModifier[]{KModifier.VARARG};
                    parameterSpecs.add(KspKt.newParameterSpec("formatArgs", (TypeName)TypeNames.ANY, true, $this$mapTo$iv));
                }
                String prefix = "return RxHttp." + key + '(';
                String postfix = ").wrapper()";
                String funBody = StringUtilKt.toParamNames(parameterSpecs, prefix, postfix);
                FunSpec $this$generateRequestFunList_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = funSpec = FunSpec.Builder.returns$default((FunSpec.Builder)JvmAnnotations.jvmStatic((FunSpec.Builder)FunSpec.Companion.builder(key)).addParameters((Iterable)parameterSpecs).addTypeVariables((Iterable)rxHttpTypeNames).addStatement(funBody, new Object[0]), (TypeName)funReturnType, null, (int)2, null).build();
                boolean bl6 = false;
                funList.add($this$generateRequestFunList_u24lambda_u2411_u24lambda_u2410_u24lambda_u249);
            }
        }
        return funList;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/rxhttp/compiler/ksp/RxHttpWrapper$Wrapper;", "", "<init>", "()V", "domainName", "", "getDomainName", "()Ljava/lang/String;", "setDomainName", "(Ljava/lang/String;)V", "converterName", "getConverterName", "setConverterName", "okClientName", "getOkClientName", "setOkClientName", "rxhttp-compiler"})
    public static final class Wrapper {
        @Nullable
        private String domainName;
        @Nullable
        private String converterName;
        @Nullable
        private String okClientName;

        @Nullable
        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(@Nullable String string) {
            this.domainName = string;
        }

        @Nullable
        public final String getConverterName() {
            return this.converterName;
        }

        public final void setConverterName(@Nullable String string) {
            this.converterName = string;
        }

        @Nullable
        public final String getOkClientName() {
            return this.okClientName;
        }

        public final void setOkClientName(@Nullable String string) {
            this.okClientName = string;
        }
    }
}

