/*
 * Decompiled with CFR 0.152.
 */
package com.rxhttp.compiler.ksp;

import com.google.devtools.ksp.KspExperimental;
import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import com.google.devtools.ksp.symbol.KSVisitorVoid;
import com.rxhttp.compiler.ConstantsKt;
import com.rxhttp.compiler.ksp.ConverterVisitorKt;
import com.rxhttp.compiler.ksp.KspKt;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeVariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import rxhttp.wrapper.annotation.Converter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0012H\u0017\u00a2\u0006\u0002\u0010\u0015J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/rxhttp/compiler/ksp/ConverterVisitor;", "Lcom/google/devtools/ksp/symbol/KSVisitorVoid;", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "<init>", "(Lcom/google/devtools/ksp/processing/Resolver;Lcom/google/devtools/ksp/processing/KSPLogger;)V", "elementMap", "Ljava/util/LinkedHashMap;", "", "Lcom/google/devtools/ksp/symbol/KSPropertyDeclaration;", "originatingKSFiles", "", "Lcom/google/devtools/ksp/symbol/KSFile;", "getOriginatingKSFiles", "()Ljava/util/List;", "visitPropertyDeclaration", "", "property", "data", "(Lcom/google/devtools/ksp/symbol/KSPropertyDeclaration;Lkotlin/Unit;)V", "getFunList", "Lcom/squareup/kotlinpoet/FunSpec;", "rxhttp-compiler"})
@SourceDebugExtension(value={"SMAP\nConverterVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConverterVisitor.kt\ncom/rxhttp/compiler/ksp/ConverterVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1557#2:103\n1628#2,3:104\n136#3,9:107\n216#3:116\n217#3:118\n145#3:119\n1#4:117\n*S KotlinDebug\n*F\n+ 1 ConverterVisitor.kt\ncom/rxhttp/compiler/ksp/ConverterVisitor\n*L\n28#1:103\n28#1:104,3\n52#1:107,9\n52#1:116\n52#1:118\n52#1:119\n52#1:117\n*E\n"})
public final class ConverterVisitor
extends KSVisitorVoid {
    @NotNull
    private final Resolver resolver;
    @NotNull
    private final KSPLogger logger;
    @NotNull
    private final LinkedHashMap<String, KSPropertyDeclaration> elementMap;

    public ConverterVisitor(@NotNull Resolver resolver, @NotNull KSPLogger logger) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.resolver = resolver;
        this.logger = logger;
        this.elementMap = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KSFile> getOriginatingKSFiles() {
        void $this$mapTo$iv$iv;
        Collection<KSPropertyDeclaration> collection = this.elementMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KSPropertyDeclaration kSPropertyDeclaration = (KSPropertyDeclaration)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            KSFile kSFile = it.getContainingFile();
            Intrinsics.checkNotNull((Object)kSFile);
            collection2.add(kSFile);
        }
        return (List)destination$iv$iv;
    }

    @KspExperimental
    public void visitPropertyDeclaration(@NotNull KSPropertyDeclaration property, @NotNull Unit data) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            Converter annotation;
            ConverterVisitorKt.access$checkConverterProperty(property, this.resolver);
            Converter converter = annotation = (Converter)SequencesKt.firstOrNull((Sequence)UtilsKt.getAnnotationsByType((KSAnnotated)((KSAnnotated)property), (KClass)Reflection.getOrCreateKotlinClass(Converter.class)));
            String name = converter != null ? converter.name() : null;
            CharSequence charSequence = name;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                name = KspKt.firstLetterUpperCase(property.getSimpleName().asString());
            }
            if (this.elementMap.containsKey(name)) {
                String msg = "The variable '" + property.getSimpleName().asString() + "' in the @Converter annotation 'name = " + name + "' is duplicated";
                throw new NoSuchElementException(msg);
            }
            ((Map)this.elementMap).put(name, property);
        }
        catch (NoSuchElementException e) {
            KspKt.error(this.logger, e, (KSNode)property);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FunSpec> getFunList() {
        void $this$mapNotNullTo$iv$iv;
        TypeName[] typeNameArray = new TypeName[1];
        String[] stringArray = new String[]{"P", "R"};
        typeNameArray[0] = KspKt.parameterizedBy(ConstantsKt.getRxhttpKClass(), stringArray);
        TypeVariableName typeVariableR = TypeVariableName.Companion.get$default((TypeVariableName.Companion)TypeVariableName.Companion, (String)"R", (TypeName[])typeNameArray, null, (int)4, null);
        Map $this$mapNotNull$iv = this.elementMap;
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            FunSpec it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = element$iv$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            KSPropertyDeclaration ksProperty = (KSPropertyDeclaration)entry.getValue();
            MemberName memberName = KspKt.toMemberName(ksProperty);
            Object[] objectArray = new Object[]{memberName};
            if (FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder("set" + key).addCode("return setConverter(%M)", objectArray), (TypeName)((TypeName)typeVariableR), null, (int)2, null).build() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

