/*
 * Decompiled with CFR 0.152.
 */
package com.rxhttp.compiler.common;

import com.rxhttp.compiler.RxJavaVersionKt;
import com.rxhttp.compiler.VariablesKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"getObservableClass", "", "", "rxhttp-compiler"})
public final class ObservableUtilKt {
    @NotNull
    public static final Map<String, String> getObservableClass() {
        Map map;
        Map map2 = map = (Map)new LinkedHashMap();
        String string = "ObservableCall";
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("\n        package ").append(VariablesKt.getRxHttpPackage()).append(";\n\n        import org.jetbrains.annotations.NotNull;\n        import org.jetbrains.annotations.Nullable;\n\n        import java.io.IOException;\n        import java.util.Objects;\n        import java.util.concurrent.atomic.AtomicReference;\n\n        import ").append(RxJavaVersionKt.getClassPath("AndroidSchedulers")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Observable")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Observer")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Scheduler")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Disposable")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Exceptions")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Consumer")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("DisposableHelper")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("RxJavaPlugins")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Schedulers")).append(";\n        import okhttp3.Call;\n        import okhttp3.Callback;\n        import okhttp3.Response;\n        import rxhttp.wrapper.BodyParamFactory;\n        import rxhttp.wrapper.CallFactory;\n        import rxhttp.wrapper.callback.ProgressCallback;\n        import rxhttp.wrapper.entity.OkResponse;\n        import rxhttp.wrapper.entity.Progress;\n        import rxhttp.wrapper.parse.OkResponseParser;\n        import rxhttp.wrapper.parse.Parser;\n        import rxhttp.wrapper.parse.StreamParser;\n        import rxhttp.wrapper.utils.LogUtil;\n        \n        /**\n         * User: ljx\n         * Date: 2020/9/5\n         * Time: 21:59\n         */\n        public final class ObservableCall<T> extends Observable<T> {\n\n            private final Parser<T> parser;\n            private final CallFactory callFactory;\n            private boolean syncRequest = false;\n            private boolean callbackProgress = false;\n\n            ObservableCall(CallFactory callFactory, Parser<T> parser) {\n                this.callFactory = callFactory;\n                this.parser = parser;\n            }\n\n            @Override\n            protected void subscribeActual(Observer<? super T> observer) {\n                CallExecuteDisposable<T> d = syncRequest ? new CallExecuteDisposable<>(observer, callFactory, parser) :\n                    new CallEnqueueDisposable<>(observer, callFactory, parser);\n                observer.onSubscribe(d);\n                if (d.isDisposed()) {\n                    return;\n                }\n                if (callbackProgress && observer instanceof ProgressCallback) {\n                    ProgressCallback pc = (ProgressCallback) observer;\n                    Parser<?> streamParser = parser;\n                    while (streamParser instanceof OkResponseParser<?>) {\n                        streamParser = ((OkResponseParser<?>) streamParser).parser;\n                    }    \n                    if (streamParser instanceof StreamParser) {\n                        ((StreamParser<?>) streamParser).setProgressCallback(pc);\n                    } else if (callFactory instanceof BodyParamFactory) {\n                        ((BodyParamFactory) callFactory).getParam().setProgressCallback(pc);\n                    }\n                }\n                d.run();\n            }\n            \n            @NotNull\n            public ObservableCall<@NotNull OkResponse<@Nullable T>> toObservableOkResponse() { \n                return new ObservableCall<>(callFactory, new OkResponseParser<>(parser));\n            }\n\n            @NotNull \n            public ObservableCall<@NotNull T> syncRequest() {\n                syncRequest = true;\n                return this;\n            }\n\n            @NotNull\n            public Observable<@NotNull T> onProgress(@NotNull Consumer<Progress> progressConsumer) {\n                return onProgress(Schedulers.io(), progressConsumer);\n            }\n\n            @NotNull\n            public Observable<@NotNull T> onProgress(@NotNull Scheduler scheduler, @NotNull Consumer<Progress> progressConsumer) {\n                return onProgress(2, scheduler, progressConsumer);\n            }\n\n            @NotNull\n            public Observable<@NotNull T> onMainProgress(@NotNull Consumer<Progress> progressConsumer) {\n                return onMainProgress(2, progressConsumer);\n            }\n\n            @NotNull\n            public Observable<@NotNull T> onMainProgress(int capacity, @NotNull Consumer<Progress> progressConsumer) {\n                return onProgress(capacity, AndroidSchedulers.mainThread(), progressConsumer);\n            }\n\n            /**\n             * Upload or Download progress callback\n             *\n             * @param capacity         queue size, must be in [2..100], is invalid when the scheduler is TrampolineScheduler\n             * @param scheduler        the Scheduler to notify Observers on\n             * @param progressConsumer progress callback\n             * @return the new Observable instance\n             */\n            @NotNull \n            public Observable<@NotNull T> onProgress(int capacity, @NotNull Scheduler scheduler, @NotNull Consumer<Progress> progressConsumer) {\n                if (capacity < 2 || capacity > 100) {\n                    throw new IllegalArgumentException(\"capacity must be in [2..100], but it was \" + capacity);\n                }\n                Objects.requireNonNull(scheduler, \"scheduler is null\");\n                Parser<?> streamParser = parser;\n                while (streamParser instanceof OkResponseParser<?>) {\n                    streamParser = ((OkResponseParser<?>) streamParser).parser;\n                }\n                if (!(streamParser instanceof StreamParser) && !(callFactory instanceof BodyParamFactory)) {\n                    throw new UnsupportedOperationException(\"parser is \" + streamParser.getClass().getName() + \", callFactory is \" + callFactory.getClass().getName());\n                }\n                callbackProgress = true;\n                return new ObservableProgress<>(this, capacity, scheduler, progressConsumer);\n            }\n\n            private static class CallEnqueueDisposable<T> extends CallExecuteDisposable<T> implements Callback {\n\n                CallEnqueueDisposable(Observer<? super T> downstream, CallFactory callFactory, Parser<T> parser) {\n                    super(downstream, callFactory, parser);\n                }\n\n                @Override\n                public void onResponse(@NotNull Call call, @NotNull Response response) {\n                    try {\n                        T t = Objects.requireNonNull(parser.onParse(response), \"The onParse function returned a null value.\");\n                        if (!disposed) {\n                            downstream.onNext(t);\n                        }\n                        if (!disposed) {\n                            downstream.onComplete();\n                        }\n                    } catch (Throwable t) {\n                        onError(call, t);\n                    }\n                }\n\n                @Override\n                public void onFailure(@NotNull Call call, @NotNull IOException e) {\n                    onError(call, e);\n                }\n\n                @Override\n                public void run() {\n                    call = callFactory.newCall();\n                    call.enqueue(this);\n                }\n            }\n\n\n            private static class CallExecuteDisposable<T> implements Disposable {\n\n                protected final Observer<? super T> downstream;\n                protected final Parser<T> parser;\n                protected final CallFactory callFactory;\n                protected volatile boolean disposed;\n                protected Call call;\n                private final AtomicReference<Disposable> upstream;\n\n                CallExecuteDisposable(Observer<? super T> downstream, CallFactory callFactory, Parser<T> parser) {\n                    this.downstream = downstream;\n                    this.callFactory = callFactory;\n                    this.parser = parser;\n                    upstream = new AtomicReference<>();\n                }\n\n                public void run() {\n                    call = callFactory.newCall();\n                    try {\n                        Response response = call.execute();\n                        T t = Objects.requireNonNull(parser.onParse(response), \"The onParse function returned a null value.\");\n                        if (!disposed) {\n                            downstream.onNext(t);\n                        }\n                        if (!disposed) {\n                            downstream.onComplete();\n                        }\n                    } catch (Throwable e) {\n                        onError(call, e);\n                    }\n                }\n\n                void onError(Call call, Throwable e) {\n                    LogUtil.log(call.request().url().toString(), e);\n                    Exceptions.throwIfFatal(e);\n                    if (!disposed) {\n                        downstream.onError(e);\n                    } else {\n                        RxJavaPlugins.onError(e);\n                    }\n                }\n\n                @Override\n                public void dispose() {\n                    DisposableHelper.dispose(upstream);\n                    disposed = true;\n                    if (call != null)\n                        call.cancel();\n                }\n\n                @Override\n                public boolean isDisposed() {\n                    return disposed;\n                }\n\n                public void setDisposable(Disposable d) {\n                    DisposableHelper.setOnce(upstream, d);\n                }\n            }\n        }\n\n    ");
        charSequence = StringsKt.trimIndent((String)((StringBuilder)charSequence).toString());
        map2.put(string, charSequence);
        map2 = map;
        string = "ObservableProgress";
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("\n        package ").append(VariablesKt.getRxHttpPackage()).append(";\n        \n        import org.jetbrains.annotations.NotNull;\n\n        import java.util.Queue;\n        import java.util.concurrent.LinkedBlockingQueue;\n        import java.util.concurrent.atomic.AtomicInteger;\n\n        import ").append(RxJavaVersionKt.getClassPath("Observable")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Observer")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Scheduler")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Scheduler")).append(".Worker;\n        import ").append(RxJavaVersionKt.getClassPath("Disposable")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Exceptions")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("Consumer")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("DisposableHelper")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("TrampolineScheduler")).append(";\n        import ").append(RxJavaVersionKt.getClassPath("RxJavaPlugins")).append(";\n        import rxhttp.wrapper.callback.ProgressCallback;\n        import rxhttp.wrapper.entity.Progress;\n\n        public final class ObservableProgress<T> extends Observable<T> {\n\n            private final Observable<T> source;\n            private final int capacity;\n            private final Scheduler scheduler;\n            private final Consumer<Progress> progressConsumer;\n\n            ObservableProgress(Observable<T> source, int capacity, Scheduler scheduler, Consumer<Progress> progressConsumer) {\n                this.source = source;\n                this.capacity = capacity;\n                this.scheduler = scheduler;\n                this.progressConsumer = progressConsumer;\n            }\n\n            @Override\n            protected void subscribeActual(@NotNull Observer<? super T> observer) {\n                if (scheduler instanceof TrampolineScheduler) {\n                    source.subscribe(new SyncObserver<>(observer, progressConsumer));\n                } else {\n                    Worker worker = scheduler.createWorker();\n                    source.subscribe(new AsyncObserver<>(worker, observer, capacity, progressConsumer));\n                }\n            }\n\n            private static final class SyncObserver<T> implements Observer<T>, Disposable, ProgressCallback {\n\n                private final Observer<? super T> downstream;\n                private final Consumer<Progress> progressConsumer;\n                private Disposable upstream;\n                private boolean done;\n\n                SyncObserver(Observer<? super T> actual, Consumer<Progress> progressConsumer) {\n                    this.downstream = actual;\n                    this.progressConsumer = progressConsumer;\n                }\n\n                @Override\n                public void onSubscribe(@NotNull Disposable d) {\n                    if (DisposableHelper.validate(this.upstream, d)) {\n                        this.upstream = d;\n                        downstream.onSubscribe(this);\n                    }\n                }\n\n                // upload/download progress callback\n                @Override\n                public void onProgress(int progress, long currentSize, long totalSize) {\n                    if (done) {\n                        return;\n                    }\n                    try {\n                        progressConsumer.accept(new Progress(progress, currentSize, totalSize));\n                    } catch (Throwable t) {\n                        fail(t);\n                    }\n                }\n\n                @Override\n                public void onNext(@NotNull T t) {\n                    if (done) {\n                        return;\n                    }\n                    downstream.onNext(t);\n                }\n\n                @Override\n                public void onError(@NotNull Throwable t) {\n                    if (done) {\n                        RxJavaPlugins.onError(t);\n                        return;\n                    }\n                    done = true;\n                    downstream.onError(t);\n                }\n\n                @Override\n                public void onComplete() {\n                    if (done) {\n                        return;\n                    }\n                    done = true;\n                    downstream.onComplete();\n                }\n\n                @Override\n                public void dispose() {\n                    upstream.dispose();\n                }\n\n                @Override\n                public boolean isDisposed() {\n                    return upstream.isDisposed();\n                }\n\n                private void fail(Throwable t) {\n                    Exceptions.throwIfFatal(t);\n                    upstream.dispose();\n                    onError(t);\n                }\n            }\n\n\n            private static final class AsyncObserver<T> extends AtomicInteger implements Observer<T>,\n                Disposable, ProgressCallback, Runnable {\n\n                private final Observer<? super T> downstream;\n                private final Queue<Object> queue;\n                private final Scheduler.Worker worker;\n                private final Consumer<Progress> progressConsumer;\n                private Disposable upstream;\n                private Throwable error;\n                private volatile boolean done;\n                private volatile boolean disposed;\n\n                AsyncObserver(Scheduler.Worker worker, Observer<? super T> actual, int capacity, Consumer<Progress> progressConsumer) {\n                    this.downstream = actual;\n                    this.worker = worker;\n                    this.progressConsumer = progressConsumer;\n                    queue = new LinkedBlockingQueue<>(capacity);\n                }\n\n                @Override\n                public void onSubscribe(@NotNull Disposable d) {\n                    if (DisposableHelper.validate(this.upstream, d)) {\n                        this.upstream = d;\n                        downstream.onSubscribe(this);\n                    }\n                }\n\n                // upload/download progress callback\n                @Override\n                public void onProgress(int progress, long currentSize, long totalSize) {\n                    if (done) {\n                        return;\n                    }\n                    offer(new Progress(progress, currentSize, totalSize));\n                }\n\n                @Override\n                public void onNext(@NotNull T t) {\n                    if (done) {\n                        return;\n                    }\n                    offer(t);\n                }\n\n                private void offer(Object o) {\n                    while (!queue.offer(o)) {\n                        queue.poll();\n                    }\n                    schedule();\n                }\n\n                @Override\n                public void onError(@NotNull Throwable t) {\n                    if (done) {\n                        RxJavaPlugins.onError(t);\n                        return;\n                    }\n                    error = t;\n                    done = true;\n                    schedule();\n                }\n\n                @Override\n                public void onComplete() {\n                    if (done) {\n                        return;\n                    }\n                    done = true;\n                    schedule();\n                }\n\n\n                void schedule() {\n                    if (getAndIncrement() == 0) {\n                        worker.schedule(this);\n                    }\n                }\n\n                @SuppressWarnings(\"unchecked\")\n                @Override\n                public void run() {\n                    int missed = 1;\n\n                    final Queue<?> q = queue;\n                    final Observer<? super T> a = downstream;\n                    while (!checkTerminated(done, q.isEmpty(), a)) {\n                        for (; ; ) {\n                            boolean d = done;\n                            Object o;\n                            try {\n                                o = q.poll();\n\n                                boolean empty = o == null;\n\n                                if (checkTerminated(d, empty, a)) {\n                                    return;\n                                }\n                                if (empty) {\n                                    break;\n                                }\n                                if (o instanceof Progress) {\n                                    progressConsumer.accept((Progress) o);\n                                } else {\n                                    a.onNext((T) o);\n                                }\n                            } catch (Throwable ex) {\n                                Exceptions.throwIfFatal(ex);\n                                disposed = true;\n                                upstream.dispose();\n                                q.clear();\n                                a.onError(ex);\n                                worker.dispose();\n                                return;\n                            }\n                        }\n                        missed = addAndGet(-missed);\n                        if (missed == 0) {\n                            break;\n                        }\n                    }\n                }\n\n                boolean checkTerminated(boolean d, boolean empty, Observer<? super T> a) {\n                    if (isDisposed()) {\n                        queue.clear();\n                        return true;\n                    }\n                    if (d) {\n                        Throwable e = error;\n                        if (e != null) {\n                            disposed = true;\n                            queue.clear();\n                            a.onError(e);\n                            worker.dispose();\n                            return true;\n                        } else if (empty) {\n                            disposed = true;\n                            a.onComplete();\n                            worker.dispose();\n                            return true;\n                        }\n                    }\n                    return false;\n                }\n\n                @Override\n                public void dispose() {\n                    if (!disposed) {\n                        disposed = true;\n                        upstream.dispose();\n                        worker.dispose();\n                        if (getAndIncrement() == 0) {\n                            queue.clear();\n                        }\n                    }\n                }\n\n                @Override\n                public boolean isDisposed() {\n                    return disposed;\n                }\n            }\n        }\n\n    ");
        charSequence = StringsKt.trimIndent((String)((StringBuilder)charSequence).toString());
        map2.put(string, charSequence);
        return map;
    }
}

