/*
 * Decompiled with CFR 0.152.
 */
package com.ljg.ratingbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.ljg.ratingbar.R;
import java.math.BigDecimal;

public class RatingBar
extends LinearLayout {
    private boolean mClickable;
    private int starCount;
    private OnRatingChangeListener onRatingChangeListener;
    private float starImageSize;
    private float starPadding;
    private float starStep;
    private Drawable starEmptyDrawable;
    private Drawable starFillDrawable;
    private Drawable starHalfDrawable;
    private StepSize stepSize;

    public void setStarHalfDrawable(Drawable starHalfDrawable) {
        this.starHalfDrawable = starHalfDrawable;
    }

    public void setStarFillDrawable(Drawable starFillDrawable) {
        this.starFillDrawable = starFillDrawable;
    }

    public void setStarEmptyDrawable(Drawable starEmptyDrawable) {
        this.starEmptyDrawable = starEmptyDrawable;
    }

    public void setClickable(boolean clickable) {
        this.mClickable = clickable;
    }

    public void setOnRatingChangeListener(OnRatingChangeListener onRatingChangeListener) {
        this.onRatingChangeListener = onRatingChangeListener;
    }

    public void setStarImageSize(float starImageSize) {
        this.starImageSize = starImageSize;
    }

    public void setStepSize(StepSize stepSize) {
        this.stepSize = stepSize;
    }

    public RatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(0);
        TypedArray mTypedArray = context.obtainStyledAttributes(attrs, R.styleable.RatingBar);
        this.starImageSize = mTypedArray.getDimension(R.styleable.RatingBar_starImageSize, 20.0f);
        this.starPadding = mTypedArray.getDimension(R.styleable.RatingBar_starPadding, 10.0f);
        this.starStep = mTypedArray.getFloat(R.styleable.RatingBar_starStep, 1.0f);
        this.stepSize = StepSize.fromStep(mTypedArray.getInt(R.styleable.RatingBar_stepSize, 1));
        this.starCount = mTypedArray.getInteger(R.styleable.RatingBar_starCount, 5);
        Log.i((String)"TAG", (String)("RatingBar: RatingBar_starEmpty=" + mTypedArray.getDrawable(R.styleable.RatingBar_starEmpty)));
        this.starEmptyDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starEmpty) == null ? this.getResources().getDrawable(R.drawable.rating_small_empty) : mTypedArray.getDrawable(R.styleable.RatingBar_starEmpty);
        this.starFillDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starFill) == null ? this.getResources().getDrawable(R.drawable.rating_small_full) : mTypedArray.getDrawable(R.styleable.RatingBar_starFill);
        this.starHalfDrawable = mTypedArray.getDrawable(R.styleable.RatingBar_starHalf) == null ? this.getResources().getDrawable(R.drawable.rating_small_half) : mTypedArray.getDrawable(R.styleable.RatingBar_starHalf);
        this.mClickable = mTypedArray.getBoolean(R.styleable.RatingBar_clickable, true);
        mTypedArray.recycle();
        for (int i = 0; i < this.starCount; ++i) {
            final ImageView imageView = this.getStarImageView();
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (RatingBar.this.mClickable) {
                        BigDecimal b2;
                        int fint = (int)RatingBar.this.starStep;
                        BigDecimal b1 = new BigDecimal(Float.toString(RatingBar.this.starStep));
                        float fPoint = b1.subtract(b2 = new BigDecimal(Integer.toString(fint))).floatValue();
                        if (fPoint == 0.0f) {
                            --fint;
                        }
                        int index = RatingBar.this.indexOfChild(v);
                        if (RatingBar.this.indexOfChild(v) > fint) {
                            RatingBar.this.setStar(RatingBar.this.indexOfChild(v) + 1);
                        } else if (RatingBar.this.indexOfChild(v) == fint) {
                            if (RatingBar.this.stepSize == StepSize.Full) {
                                if (imageView.getDrawable().getCurrent().getConstantState().equals(RatingBar.this.starFillDrawable.getConstantState())) {
                                    RatingBar.this.setStar(RatingBar.this.indexOfChild(v));
                                } else if (imageView.getDrawable().getCurrent().getConstantState().equals(RatingBar.this.starEmptyDrawable.getConstantState())) {
                                    RatingBar.this.setStar(RatingBar.this.indexOfChild(v) + 1);
                                }
                                return;
                            }
                            if (imageView.getDrawable().getCurrent().getConstantState().equals(RatingBar.this.starHalfDrawable.getConstantState())) {
                                RatingBar.this.setStar(RatingBar.this.indexOfChild(v));
                            } else if (imageView.getDrawable().getCurrent().getConstantState().equals(RatingBar.this.starFillDrawable.getConstantState())) {
                                RatingBar.this.setStar((float)RatingBar.this.indexOfChild(v) + 0.5f);
                            } else if (imageView.getDrawable().getCurrent().getConstantState().equals(RatingBar.this.starEmptyDrawable.getConstantState())) {
                                RatingBar.this.setStar(RatingBar.this.indexOfChild(v) + 1);
                            }
                        } else {
                            RatingBar.this.setStar((float)RatingBar.this.indexOfChild(v) + 1.0f);
                        }
                    }
                }
            });
            this.addView((View)imageView);
        }
        this.setStar(this.starStep);
    }

    private ImageView getStarImageView() {
        ImageView imageView = new ImageView(this.getContext());
        LinearLayout.LayoutParams layout = new LinearLayout.LayoutParams(Math.round(this.starImageSize), Math.round(this.starImageSize));
        layout.setMargins(0, 0, Math.round(this.starPadding), 0);
        imageView.setLayoutParams((ViewGroup.LayoutParams)layout);
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        imageView.setImageDrawable(this.starEmptyDrawable);
        imageView.setMinimumWidth(10);
        imageView.setMaxHeight(10);
        return imageView;
    }

    public void setStar(float rating) {
        int i;
        if (this.onRatingChangeListener != null) {
            this.onRatingChangeListener.onRatingChange(rating);
        }
        this.starStep = rating;
        int fint = (int)rating;
        BigDecimal b1 = new BigDecimal(Float.toString(rating));
        BigDecimal b2 = new BigDecimal(Integer.toString(fint));
        float fPoint = b1.subtract(b2).floatValue();
        for (i = 0; i < fint; ++i) {
            ((ImageView)this.getChildAt(i)).setImageDrawable(this.starFillDrawable);
        }
        for (i = fint; i < this.starCount; ++i) {
            ((ImageView)this.getChildAt(i)).setImageDrawable(this.starEmptyDrawable);
        }
        if (fPoint > 0.0f) {
            ((ImageView)this.getChildAt(fint)).setImageDrawable(this.starHalfDrawable);
        }
    }

    public static int dp2px(Context context, int dip) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)dip * scale + 0.5f);
    }

    public static int px2dp(Context context, int px) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)px / scale + 0.5f);
    }

    public static enum StepSize {
        Half(0),
        Full(1);

        int step;

        private StepSize(int step) {
            this.step = step;
        }

        public static StepSize fromStep(int step) {
            for (StepSize f : StepSize.values()) {
                if (f.step != step) continue;
                return f;
            }
            throw new IllegalArgumentException();
        }
    }

    public static interface OnRatingChangeListener {
        public void onRatingChange(float var1);
    }
}

