/*
 * Decompiled with CFR 0.152.
 */
package com.lid.lib;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import com.lid.lib.R;

public class LabelViewHelper {
    private static final int LEFT_TOP = 1;
    private static final int RIGHT_TOP = 2;
    private static final int LEFT_BOTTOM = 3;
    private static final int RIGHT_BOTTOM = 4;
    private static final int DEFAULT_DISTANCE = 40;
    private static final int DEFAULT_HEIGHT = 20;
    private static final int DEFAULT_STROKE_WIDTH = 1;
    private static final int DEFAULT_TEXT_SIZE = 14;
    private static final int DEFAULT_BACKGROUND_COLOR = -1624781376;
    private static final int DEFAULT_STROKE_COLOR = -1;
    private static final int DEFAULT_TEXT_COLOR = -1;
    private static final int DEFAULT_ORIENTATION = 1;
    private static final int DEFAULT_TEXT_STYLE = 0;
    private int distance;
    private int height;
    private int strokeWidth;
    private String text;
    private int backgroundColor;
    private int strokeColor;
    private int textSize;
    private int textStyle;
    private int textColor;
    private boolean visual;
    private int orientation;
    private Paint rectPaint;
    private Paint rectStrokePaint;
    private Path rectPath;
    private Path textPath;
    private Paint textPaint;
    private Rect textBound;
    private Context context;
    private int alpha;

    public LabelViewHelper(Context context, AttributeSet attrs, int defStyleAttr) {
        this.context = context;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.LabelView, defStyleAttr, 0);
        this.distance = attributes.getDimensionPixelSize(R.styleable.LabelView_label_distance, this.dip2Px(40.0f));
        this.height = attributes.getDimensionPixelSize(R.styleable.LabelView_label_height, this.dip2Px(20.0f));
        this.strokeWidth = attributes.getDimensionPixelSize(R.styleable.LabelView_label_strokeWidth, this.dip2Px(1.0f));
        this.text = attributes.getString(R.styleable.LabelView_label_text);
        this.backgroundColor = attributes.getColor(R.styleable.LabelView_label_backgroundColor, -1624781376);
        this.strokeColor = attributes.getColor(R.styleable.LabelView_label_strokeColor, -1);
        this.textSize = attributes.getDimensionPixelSize(R.styleable.LabelView_label_textSize, this.dip2Px(14.0f));
        this.textStyle = attributes.getInt(R.styleable.LabelView_label_textStyle, 0);
        this.textColor = attributes.getColor(R.styleable.LabelView_label_textColor, -1);
        this.visual = attributes.getBoolean(R.styleable.LabelView_label_visual, true);
        this.orientation = attributes.getInteger(R.styleable.LabelView_label_orientation, 1);
        attributes.recycle();
        this.rectPaint = new Paint();
        this.rectPaint.setDither(true);
        this.rectPaint.setAntiAlias(true);
        this.rectPaint.setStyle(Paint.Style.FILL);
        this.rectStrokePaint = new Paint();
        this.rectStrokePaint.setDither(true);
        this.rectStrokePaint.setAntiAlias(true);
        this.rectStrokePaint.setStyle(Paint.Style.STROKE);
        this.rectPath = new Path();
        this.rectPath.reset();
        this.textPath = new Path();
        this.textPath.reset();
        this.textPaint = new Paint();
        this.textPaint.setDither(true);
        this.textPaint.setAntiAlias(true);
        this.textPaint.setStrokeJoin(Paint.Join.ROUND);
        this.textPaint.setStrokeCap(Paint.Cap.SQUARE);
        this.textBound = new Rect();
    }

    public void onDraw(Canvas canvas, int measuredWidth, int measuredHeight) {
        if (!this.visual || this.text == null) {
            return;
        }
        float actualDistance = this.distance + this.height / 2;
        this.calcOffset(measuredWidth, measuredHeight);
        this.rectPaint.setColor(this.backgroundColor);
        if (this.alpha != 0) {
            this.rectPaint.setAlpha(this.alpha);
        }
        this.rectStrokePaint.setColor(this.strokeColor);
        this.rectStrokePaint.setStrokeWidth((float)this.strokeWidth);
        canvas.drawPath(this.rectPath, this.rectPaint);
        canvas.drawPath(this.rectPath, this.rectStrokePaint);
        this.textPaint.setTextSize((float)this.textSize);
        this.textPaint.setColor(this.textColor);
        this.textPaint.getTextBounds(this.text, 0, this.text.length(), this.textBound);
        this.textPaint.setTypeface(Typeface.defaultFromStyle((int)this.textStyle));
        float begin_w_offset = 1.4142135f * actualDistance / 2.0f - (float)(this.textBound.width() / 2);
        if (begin_w_offset < 0.0f) {
            begin_w_offset = 0.0f;
        }
        canvas.drawTextOnPath(this.text, this.textPath, begin_w_offset, (float)(this.textBound.height() / 2), this.textPaint);
    }

    private void calcOffset(int measuredWidth, int measuredHeight) {
        float startPosX = measuredWidth - this.distance - this.height;
        float endPosX = measuredWidth;
        float startPosY = measuredHeight - this.distance - this.height;
        float endPosY = measuredHeight;
        float middle = this.height / 2;
        switch (this.orientation) {
            case 1: {
                this.rectPath.reset();
                this.rectPath.moveTo(0.0f, (float)this.distance);
                this.rectPath.lineTo((float)this.distance, 0.0f);
                this.rectPath.lineTo((float)(this.distance + this.height), 0.0f);
                this.rectPath.lineTo(0.0f, (float)(this.distance + this.height));
                this.rectPath.close();
                this.textPath.reset();
                this.textPath.moveTo(0.0f, (float)this.distance + middle);
                this.textPath.lineTo((float)this.distance + middle, 0.0f);
                this.textPath.close();
                break;
            }
            case 2: {
                this.rectPath.reset();
                this.rectPath.moveTo(startPosX, 0.0f);
                this.rectPath.lineTo(startPosX + (float)this.height, 0.0f);
                this.rectPath.lineTo(endPosX, (float)this.distance);
                this.rectPath.lineTo(endPosX, (float)(this.distance + this.height));
                this.rectPath.close();
                this.textPath.reset();
                this.textPath.moveTo(startPosX + middle, 0.0f);
                this.textPath.lineTo(endPosX, (float)this.distance + middle);
                this.textPath.close();
                break;
            }
            case 3: {
                this.rectPath.reset();
                this.rectPath.moveTo(0.0f, startPosY);
                this.rectPath.lineTo((float)(this.distance + this.height), endPosY);
                this.rectPath.lineTo((float)this.distance, endPosY);
                this.rectPath.lineTo(0.0f, startPosY + (float)this.height);
                this.rectPath.close();
                this.textPath.reset();
                this.textPath.moveTo(0.0f, startPosY + middle);
                this.textPath.lineTo((float)this.distance + middle, endPosY);
                this.textPath.close();
                break;
            }
            case 4: {
                this.rectPath.reset();
                this.rectPath.moveTo(startPosX, endPosY);
                this.rectPath.lineTo((float)measuredWidth, startPosY);
                this.rectPath.lineTo((float)measuredWidth, startPosY + (float)this.height);
                this.rectPath.lineTo(startPosX + (float)this.height, endPosY);
                this.rectPath.close();
                this.textPath.reset();
                this.textPath.moveTo(startPosX + middle, endPosY);
                this.textPath.lineTo(endPosX, startPosY + middle);
                this.textPath.close();
            }
        }
    }

    private int dip2Px(float dip) {
        return (int)(dip * this.context.getResources().getDisplayMetrics().density + 0.5f);
    }

    private int px2Dip(float px) {
        return (int)(px / this.context.getResources().getDisplayMetrics().density + 0.5f);
    }

    public void setLabelHeight(View view, int height) {
        if (this.height != this.dip2Px(height)) {
            this.height = this.dip2Px(height);
            view.invalidate();
        }
    }

    public int getLabelHeight() {
        return this.px2Dip(this.height);
    }

    public void setLabelDistance(View view, int distance) {
        if (this.distance != this.dip2Px(distance)) {
            this.distance = this.dip2Px(distance);
            view.invalidate();
        }
    }

    public int getLabelStrokeWidth() {
        return this.px2Dip(this.strokeWidth);
    }

    public void setLabelStrokeWidth(View view, int strokeWidth) {
        if (this.strokeWidth != this.dip2Px(strokeWidth)) {
            this.strokeWidth = this.dip2Px(strokeWidth);
            view.invalidate();
        }
    }

    public int getLabelDistance() {
        return this.px2Dip(this.distance);
    }

    public boolean isLabelVisual() {
        return this.visual;
    }

    public void setLabelVisual(View view, boolean visual) {
        if (this.visual != visual) {
            this.visual = visual;
            view.invalidate();
        }
    }

    public int getLabelOrientation() {
        return this.orientation;
    }

    public void setLabelOrientation(View view, int orientation) {
        if (this.orientation != orientation && orientation <= 4 && orientation >= 1) {
            this.orientation = orientation;
            view.invalidate();
        }
    }

    public int getLabelTextColor() {
        return this.textColor;
    }

    public void setLabelTextColor(View view, int textColor) {
        if (this.textColor != textColor) {
            this.textColor = textColor;
            view.invalidate();
        }
    }

    public int getLabelBackgroundColor() {
        return this.backgroundColor;
    }

    public void setLabelBackgroundColor(View view, int backgroundColor) {
        if (this.backgroundColor != backgroundColor) {
            this.backgroundColor = backgroundColor;
            view.invalidate();
        }
    }

    public int getLabelStrokeColor() {
        return this.strokeColor;
    }

    public void setLabelStrokeColor(View view, int strokeColor) {
        if (this.strokeColor != strokeColor) {
            this.strokeColor = strokeColor;
            view.invalidate();
        }
    }

    public void setLabelBackgroundAlpha(View view, int alpha) {
        if (this.alpha != alpha) {
            this.alpha = alpha;
            view.invalidate();
        }
    }

    public String getLabelText() {
        return this.text;
    }

    public void setLabelText(View view, String text) {
        if (this.text == null || !this.text.equals(text)) {
            this.text = text;
            view.invalidate();
        }
    }

    public int getLabelTextSize() {
        return this.px2Dip(this.textSize);
    }

    public void setLabelTextSize(View view, int textSize) {
        if (this.textSize != textSize) {
            this.textSize = textSize;
            view.invalidate();
        }
    }

    public int getLabelTextStyle() {
        return this.textStyle;
    }

    public void setLabelTextStyle(View view, int textStyle) {
        if (this.textStyle == textStyle) {
            return;
        }
        this.textStyle = textStyle;
        view.invalidate();
    }
}

