/*
 * Decompiled with CFR 0.152.
 */
package me.leefeng.promptlibrary;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import me.leefeng.promptlibrary.Builder;
import me.leefeng.promptlibrary.PromptButton;
import me.leefeng.promptlibrary.PromptDialog;
import me.leefeng.promptlibrary.R;

@SuppressLint(value={"AppCompatCustomView"})
class PromptView
extends ImageView {
    public static final int PROMPT_SUCCESS = 101;
    public static final int PROMPT_LOADING = 102;
    public static final int PROMPT_ERROR = 103;
    public static final int PROMPT_NONE = 104;
    public static final int PROMPT_INFO = 105;
    public static final int PROMPT_WARN = 106;
    public static final int PROMPT_ALERT_WARN = 107;
    private static final String TAG = "LOADVIEW";
    public static final int PROMPT_CUSTOM = 108;
    public static final int PROMPT_AD = 109;
    public static final int CUSTOMER_LOADING = 110;
    private PromptDialog promptDialog;
    private Builder builder;
    private int width;
    private int height;
    private ValueAnimator animator;
    private Paint paint;
    private float density;
    private Rect textRect;
    private int canvasWidth;
    private int canvasHeight;
    private RectF roundRect;
    private int currentType;
    private PromptButton[] buttons = new PromptButton[0];
    private RectF roundTouchRect;
    float buttonW;
    float buttonH;
    private boolean isSheet;
    private float bottomHeight;
    private float sheetHeight;
    private Drawable drawableClose;
    private int transX;
    private int transY;
    private Bitmap adBitmap;
    private Matrix max;

    public PromptView(Context context) {
        super(context);
    }

    public PromptView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PromptView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public PromptView(Activity context, Builder builder, PromptDialog promptDialog) {
        super((Context)context);
        this.density = this.getResources().getDisplayMetrics().density;
        this.builder = builder;
        this.promptDialog = promptDialog;
    }

    private Bitmap createRoundConerImage(Bitmap source) {
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        Bitmap target = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(target);
        RectF rect = new RectF(0.0f, 0.0f, (float)source.getWidth(), (float)source.getHeight());
        float mRadius = 50.0f;
        canvas.drawRoundRect(rect, mRadius, mRadius, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        return target;
    }

    protected void onDraw(Canvas canvas) {
        if (this.paint == null) {
            return;
        }
        if (this.canvasWidth == 0) {
            this.canvasWidth = this.getWidth();
            this.canvasHeight = this.getHeight();
        }
        this.paint.reset();
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.builder.backColor);
        this.paint.setAlpha(this.builder.backAlpha);
        canvas.drawRect(0.0f, 0.0f, (float)this.canvasWidth, (float)this.canvasHeight, this.paint);
        if (this.currentType == 109) {
            Drawable drawable2 = this.getDrawable();
            if (drawable2 == null) {
                return;
            }
            Rect bound = drawable2.getBounds();
            this.transX = this.canvasWidth / 2 - bound.width() / 2;
            this.transY = this.canvasHeight / 2 - bound.height() / 2 - bound.height() / 10;
            canvas.translate((float)this.transX, (float)this.transY);
            if (this.adBitmap == null) {
                Bitmap.Config config = drawable2.getOpacity() != -1 ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
                Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getMinimumWidth(), (int)drawable2.getMinimumHeight(), (Bitmap.Config)config);
                Canvas ca = new Canvas(bitmap);
                drawable2.setBounds(0, 0, drawable2.getMinimumWidth(), drawable2.getMinimumHeight());
                drawable2.draw(ca);
                this.adBitmap = this.createRoundConerImage(bitmap);
            }
            canvas.drawBitmap(this.adBitmap, 0.0f, 0.0f, null);
            if (this.drawableClose == null) {
                this.drawableClose = this.getResources().getDrawable(R.drawable.ic_prompt_close);
            }
            this.width = this.drawableClose.getMinimumWidth() / 2;
            this.height = this.drawableClose.getMinimumHeight() / 2;
            int left = bound.width() / 2 - this.width;
            int top = bound.height() + this.height;
            int right = left + this.width * 2;
            int bottom = top + this.height * 2;
            this.drawableClose.setBounds(left, top, right, bottom);
            this.drawableClose.draw(canvas);
            canvas.save();
            return;
        }
        if (this.isSheet) {
            float padBottom;
            boolean textNotNull;
            String text = this.builder.text;
            boolean bl = textNotNull = text != null && text.length() > 0;
            if (this.roundTouchRect == null) {
                this.roundTouchRect = new RectF();
            }
            this.roundTouchRect.set(0.0f, (float)this.canvasHeight - this.bottomHeight, (float)this.canvasWidth, (float)this.canvasHeight);
            canvas.translate(0.0f, (float)this.canvasHeight - this.bottomHeight);
            this.paint.reset();
            this.paint.setAntiAlias(true);
            this.paint.setColor(-1);
            this.paint.setAlpha(this.builder.roundAlpha);
            int sheetCellPad = this.builder.sheetCellPad;
            float left = padBottom = (float)sheetCellPad * this.density;
            float top = this.sheetHeight - padBottom - (float)this.builder.sheetCellHeight * this.density;
            float right = (float)this.canvasWidth - padBottom;
            float bottom = this.sheetHeight - padBottom;
            float round = this.builder.round * this.density;
            if (this.roundRect == null) {
                this.roundRect = new RectF();
            }
            this.roundRect.set(left, top, right, bottom);
            canvas.drawRoundRect(this.roundRect, round, round, this.paint);
            bottom = top - padBottom / 2.0f;
            top = 0.0f;
            if (textNotNull) {
                this.paint.reset();
                this.paint.setColor(this.builder.textColor);
                this.paint.setStrokeWidth(1.0f * this.density);
                this.paint.setTextSize(this.density * this.builder.textSize);
                this.paint.setAntiAlias(true);
                this.paint.getTextBounds(text, 0, text.length(), this.textRect);
                top = (float)(-this.textRect.height()) - 1.5f * (float)this.builder.sheetCellPad * this.density;
            }
            this.paint.reset();
            this.paint.setAntiAlias(true);
            this.paint.setColor(-1);
            this.paint.setAlpha(this.builder.roundAlpha);
            this.roundRect.set(left, top, right, bottom);
            canvas.drawRoundRect(this.roundRect, round, round, this.paint);
            this.paint.setColor(-7829368);
            this.paint.setAlpha(100);
            this.paint.setStrokeWidth(1.0f);
            this.paint.setAntiAlias(true);
            top = bottom - (float)this.builder.sheetCellHeight * this.density;
            canvas.drawLine(left, top, right, top, this.paint);
            if (this.builder.sheetCellPad == 0) {
                canvas.drawLine(left, bottom, right, bottom, this.paint);
            }
            if (textNotNull) {
                canvas.drawLine(left, 0.0f, right, 0.0f, this.paint);
            }
            PromptButton button = this.buttons[0];
            String buttonText = button.getText();
            this.paint.reset();
            this.paint.setColor(button.getTextColor());
            this.paint.setStrokeWidth(1.0f * this.density);
            this.paint.setTextSize(this.density * button.getTextSize());
            this.paint.setAntiAlias(true);
            this.paint.getTextBounds(buttonText, 0, buttonText.length(), this.textRect);
            bottom = this.sheetHeight - (float)sheetCellPad * this.density - (float)this.builder.sheetCellHeight * this.density / 2.0f + (float)(this.textRect.height() / 2);
            left = this.canvasWidth / 2 - this.textRect.width() / 2;
            if (button.getRect() == null) {
                button.setTouchRect(new RectF((float)sheetCellPad * this.density, (float)this.canvasHeight - (float)sheetCellPad * this.density - (float)this.builder.sheetCellHeight * this.density, (float)this.canvasWidth - (float)sheetCellPad * this.density, (float)this.canvasHeight - (float)sheetCellPad * this.density));
            }
            canvas.drawText(buttonText, left, bottom, this.paint);
            if (button.isFocus()) {
                this.paint.reset();
                this.paint.setAntiAlias(true);
                this.paint.setColor(-16777216);
                this.paint.setAlpha(this.builder.sheetPressAlph);
                RectF rect = new RectF((float)sheetCellPad * this.density, this.sheetHeight - (float)sheetCellPad * this.density - (float)this.builder.sheetCellHeight * this.density, (float)this.canvasWidth - (float)sheetCellPad * this.density, this.sheetHeight - (float)sheetCellPad * this.density);
                canvas.drawRoundRect(rect, round, round, this.paint);
            }
            button = this.buttons[1];
            buttonText = button.getText();
            this.paint.reset();
            this.paint.setColor(button.getTextColor());
            this.paint.setStrokeWidth(1.0f * this.density);
            this.paint.setTextSize(this.density * button.getTextSize());
            this.paint.setAntiAlias(true);
            this.paint.getTextBounds(buttonText, 0, buttonText.length(), this.textRect);
            bottom = this.sheetHeight - 1.5f * (float)sheetCellPad * this.density - (float)this.builder.sheetCellHeight * this.density * 1.5f + (float)(this.textRect.height() / 2);
            left = this.canvasWidth / 2 - this.textRect.width() / 2;
            if (button.getRect() == null) {
                button.setTouchRect(new RectF((float)sheetCellPad * this.density, (float)this.canvasHeight - 1.5f * (float)sheetCellPad * this.density - 2.0f * (float)this.builder.sheetCellHeight * this.density, (float)this.canvasWidth - (float)sheetCellPad * this.density, (float)this.canvasHeight - 1.5f * (float)sheetCellPad * this.density - (float)this.builder.sheetCellHeight * this.density));
            }
            canvas.drawText(buttonText, left, bottom, this.paint);
            if (button.isFocus()) {
                float[] outerR = new float[]{0.0f, 0.0f, 0.0f, 0.0f, round, round, round, round};
                ShapeDrawable mDrawables = new ShapeDrawable((Shape)new RoundRectShape(outerR, null, null));
                mDrawables.getPaint().setColor(-16777216);
                mDrawables.getPaint().setAlpha(this.builder.sheetPressAlph);
                RectF rect = button.getRect();
                Rect rectPre = new Rect((int)rect.left, (int)(rect.top - (float)this.canvasHeight + this.sheetHeight), (int)rect.right, (int)(rect.bottom - (float)this.canvasHeight + this.sheetHeight));
                mDrawables.setBounds(rectPre);
                mDrawables.draw(canvas);
            }
            for (int i = 2; i < this.buttons.length; ++i) {
                button = this.buttons[i];
                buttonText = button.getText();
                this.paint.reset();
                this.paint.setColor(button.getTextColor());
                this.paint.setStrokeWidth(1.0f * this.density);
                this.paint.setTextSize(this.density * button.getTextSize());
                this.paint.setAntiAlias(true);
                this.paint.getTextBounds(buttonText, 0, buttonText.length(), this.textRect);
                bottom = this.sheetHeight - 1.5f * (float)sheetCellPad * this.density - ((float)i + 0.5f) * (float)this.builder.sheetCellHeight * this.density + (float)(this.textRect.height() / 2);
                left = this.canvasWidth / 2 - this.textRect.width() / 2;
                if (button.getRect() == null) {
                    button.setTouchRect(new RectF((float)sheetCellPad * this.density, (float)this.canvasHeight - 1.5f * (float)sheetCellPad * this.density - ((float)i + 1.0f) * (float)this.builder.sheetCellHeight * this.density, (float)this.canvasWidth - (float)sheetCellPad * this.density, (float)this.canvasHeight - 1.5f * (float)sheetCellPad * this.density - (float)(i * this.builder.sheetCellHeight) * this.density));
                }
                canvas.drawText(buttonText, left, bottom, this.paint);
                if (i != this.buttons.length - 1) {
                    this.paint.setColor(-7829368);
                    this.paint.setAlpha(100);
                    this.paint.setStrokeWidth(1.0f);
                    this.paint.setAntiAlias(true);
                    top = this.sheetHeight - 1.5f * padBottom - (float)((i + 1) * this.builder.sheetCellHeight) * this.density;
                    canvas.drawLine(padBottom, top, (float)this.canvasWidth - padBottom, top, this.paint);
                }
                if (!button.isFocus()) continue;
                RectF rect = button.getRect();
                Rect rectPre = new Rect((int)rect.left, (int)(rect.top - (float)this.canvasHeight + this.sheetHeight), (int)rect.right, (int)(rect.bottom - (float)this.canvasHeight + this.sheetHeight));
                if (i == this.buttons.length - 1 && !textNotNull) {
                    float[] outerR = new float[]{round, round, round, round, 0.0f, 0.0f, 0.0f, 0.0f};
                    ShapeDrawable mDrawables = new ShapeDrawable((Shape)new RoundRectShape(outerR, null, null));
                    mDrawables.getPaint().setColor(-16777216);
                    mDrawables.getPaint().setAlpha(this.builder.sheetPressAlph);
                    mDrawables.setBounds(rectPre);
                    mDrawables.draw(canvas);
                    continue;
                }
                this.paint.reset();
                this.paint.setAntiAlias(true);
                this.paint.setColor(-16777216);
                this.paint.setAlpha(this.builder.sheetPressAlph);
                canvas.drawRect(rectPre, this.paint);
            }
            if (textNotNull) {
                this.paint.reset();
                this.paint.setColor(this.builder.textColor);
                this.paint.setStrokeWidth(1.0f * this.density);
                this.paint.setTextSize(this.density * this.builder.textSize);
                this.paint.setAntiAlias(true);
                this.paint.getTextBounds(text, 0, text.length(), this.textRect);
                top = (float)(-this.textRect.height()) - 1.5f * (float)this.builder.sheetCellPad * this.density;
                canvas.drawText(text, (float)(this.canvasWidth / 2 - this.textRect.width() / 2), top / 2.0f + (float)(this.textRect.height() / 2), this.paint);
            }
            return;
        }
        String text = this.builder.text;
        float pad = this.builder.padding * this.density;
        float round = this.builder.round * this.density;
        this.paint.reset();
        this.paint.setColor(this.builder.textColor);
        this.paint.setStrokeWidth(1.0f * this.density);
        this.paint.setTextSize(this.density * this.builder.textSize);
        this.paint.setAntiAlias(true);
        this.paint.getTextBounds(text, 0, text.length(), this.textRect);
        float popWidth = 0.0f;
        float popHeight = 0.0f;
        switch (this.currentType) {
            case 107: {
                popWidth = Math.max((float)this.textRect.width() + pad * 2.0f, 2.0f * this.buttonW);
                if (this.buttonW * 2.0f < (float)this.textRect.width() + pad * 2.0f) {
                    this.buttonW = ((float)this.textRect.width() + pad * 2.0f) / 2.0f;
                }
                popHeight = (float)this.textRect.height() + 3.0f * pad + (float)(this.height * 2) + this.buttonH;
                break;
            }
            default: {
                popWidth = Math.max(100.0f * this.density, (float)this.textRect.width() + pad * 2.0f);
                popHeight = (float)this.textRect.height() + 3.0f * pad + (float)(this.height * 2);
            }
        }
        float transTop = (float)(this.canvasHeight / 2) - popHeight / 2.0f;
        float transLeft = (float)(this.canvasWidth / 2) - popWidth / 2.0f;
        canvas.translate(transLeft, transTop);
        this.paint.reset();
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.builder.roundColor);
        this.paint.setAlpha(this.builder.roundAlpha);
        if (this.roundTouchRect == null) {
            this.roundTouchRect = new RectF();
        }
        this.roundTouchRect.set(transLeft, transTop, transLeft + popWidth, transTop + popHeight);
        if (this.roundRect == null) {
            this.roundRect = new RectF(0.0f, 0.0f, popWidth, popHeight);
        }
        this.roundRect.set(0.0f, 0.0f, popWidth, popHeight);
        canvas.drawRoundRect(this.roundRect, round, round, this.paint);
        this.paint.reset();
        this.paint.setColor(this.builder.textColor);
        this.paint.setStrokeWidth(1.0f * this.density);
        this.paint.setTextSize(this.density * this.builder.textSize);
        this.paint.setAntiAlias(true);
        float top = pad * 2.0f + (float)(this.height * 2) + (float)this.textRect.height();
        float left = popWidth / 2.0f - (float)(this.textRect.width() / 2);
        canvas.drawText(text, left, top, this.paint);
        if (this.currentType == 107) {
            this.paint.setColor(-7829368);
            this.paint.setStrokeWidth(1.0f);
            this.paint.setAntiAlias(true);
            canvas.drawLine(0.0f, top += pad, popWidth, top, this.paint);
            if (this.buttons.length == 1) {
                PromptButton button = this.buttons[0];
                if (button.isFocus()) {
                    this.paint.reset();
                    this.paint.setAntiAlias(true);
                    this.paint.setColor(button.getFocusBacColor());
                    this.paint.setStyle(Paint.Style.FILL);
                    canvas.drawRect(0.0f, top, popWidth, top + this.buttonH - round, this.paint);
                    canvas.drawCircle(round, top + this.buttonH - round, round, this.paint);
                    canvas.drawCircle(popWidth - round, top + this.buttonH - round, round, this.paint);
                    canvas.drawRect(round, top + this.buttonH - round, popWidth - round, top + this.buttonH, this.paint);
                }
                String buttonText = button.getText();
                this.paint.reset();
                this.paint.setColor(button.getTextColor());
                this.paint.setStrokeWidth(1.0f * this.density);
                this.paint.setTextSize(this.density * button.getTextSize());
                this.paint.setAntiAlias(true);
                this.paint.getTextBounds(buttonText, 0, buttonText.length(), this.textRect);
                button.setTouchRect(new RectF(transLeft, transTop + top, transLeft + popWidth, transTop + top + this.buttonH));
                canvas.drawText(buttonText, popWidth / 2.0f - (float)(this.textRect.width() / 2), top + (float)(this.textRect.height() / 2) + this.buttonH / 2.0f, this.paint);
            }
            if (this.buttons.length > 1) {
                canvas.drawLine(popWidth / 2.0f, top, popWidth / 2.0f, popHeight, this.paint);
                for (int i = 0; i < this.buttons.length; ++i) {
                    PromptButton button = this.buttons[i];
                    if (button.isFocus()) {
                        this.paint.reset();
                        this.paint.setAntiAlias(true);
                        this.paint.setColor(button.getFocusBacColor());
                        this.paint.setStyle(Paint.Style.FILL);
                        canvas.drawRect(this.buttonW * (float)i, top + 1.0f, this.buttonW * (float)(i + 1), top + 1.0f + this.buttonH - round, this.paint);
                        if (i == 0) {
                            canvas.drawCircle(round, top + this.buttonH - round, round, this.paint);
                            canvas.drawRect(round, top + this.buttonH - round, this.buttonW * (float)(i + 1), top + this.buttonH, this.paint);
                        } else if (i == 1) {
                            canvas.drawCircle(this.buttonW * 2.0f - round, top + this.buttonH - round, round, this.paint);
                            canvas.drawRect(this.buttonW, top + this.buttonH - round, this.buttonW * 2.0f - round, top + this.buttonH, this.paint);
                        }
                    }
                    String buttonText = button.getText();
                    this.paint.reset();
                    this.paint.setColor(button.getTextColor());
                    this.paint.setStrokeWidth(1.0f * this.density);
                    this.paint.setTextSize(this.density * button.getTextSize());
                    this.paint.setAntiAlias(true);
                    this.paint.getTextBounds(buttonText, 0, buttonText.length(), this.textRect);
                    button.setTouchRect(new RectF(transLeft + (float)i * this.buttonW, transTop + top, transLeft + (float)i * this.buttonW + this.buttonW, transTop + top + this.buttonH));
                    canvas.drawText(buttonText, this.buttonW / 2.0f - (float)(this.textRect.width() / 2) + (float)i * this.buttonW, top + (float)(this.textRect.height() / 2) + this.buttonH / 2.0f, this.paint);
                }
            }
        }
        canvas.translate(popWidth / 2.0f - (float)this.width, pad);
        super.onDraw(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setScaleType(ImageView.ScaleType.MATRIX);
        if (this.paint == null) {
            this.paint = new Paint();
        }
        this.initData();
    }

    private void initData() {
        if (this.textRect == null) {
            this.textRect = new Rect();
        }
        if (this.roundRect == null) {
            this.roundTouchRect = new RectF();
        }
        this.buttonW = this.density * 120.0f;
        this.buttonH = this.density * 44.0f;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.adBitmap != null) {
            this.adBitmap.recycle();
        }
        this.adBitmap = null;
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.animator = null;
        this.buttons = null;
        this.promptDialog.onDetach();
        this.currentType = 104;
    }

    private void start() {
        if (this.max == null || this.animator == null) {
            this.max = new Matrix();
            this.animator = ValueAnimator.ofInt((int[])new int[]{0, 12});
            this.animator.setDuration(960L);
            this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.animator.setRepeatCount(100000);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float degrees = 30 * (Integer)valueAnimator.getAnimatedValue();
                    PromptView.this.max.setRotate(degrees, (float)PromptView.this.width, (float)PromptView.this.height);
                    PromptView.this.setImageMatrix(PromptView.this.max);
                }
            });
        }
        if (!this.animator.isRunning()) {
            this.animator.start();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (this.currentType == 107) {
            if (this.builder.cancleAble && event.getAction() == 1 && !this.roundTouchRect.contains(x, y)) {
                this.promptDialog.dismiss();
            }
            for (final PromptButton button : this.buttons) {
                if (button.getRect() == null || !button.getRect().contains(x, y)) continue;
                if (event.getAction() == 0) {
                    button.setFocus(true);
                    this.invalidate();
                }
                if (event.getAction() == 1) {
                    button.setFocus(false);
                    this.invalidate();
                    if (button.isDismissAfterClick()) {
                        this.promptDialog.dismiss();
                    }
                    if (button.getListener() != null) {
                        if (button.isDelyClick()) {
                            this.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    button.getListener().onClick(button);
                                }
                            }, PromptDialog.viewAnimDuration + 100L);
                        } else {
                            button.getListener().onClick(button);
                        }
                    }
                }
                return true;
            }
            if (event.getAction() == 1) {
                for (final PromptButton button : this.buttons) {
                    button.setFocus(false);
                    this.invalidate();
                }
            }
        } else if (this.currentType == 109 && event.getAction() == 1) {
            if (this.drawableClose != null && this.drawableClose.getBounds().contains((int)event.getX() - this.transX, (int)event.getY() - this.transY) || this.builder.cancleAble) {
                this.promptDialog.dismiss();
            } else if (this.getDrawable() != null && this.getDrawable().getBounds().contains((int)event.getX() - this.transX, (int)event.getY() - this.transY)) {
                this.promptDialog.onAdClick();
                this.promptDialog.dismiss();
            }
        }
        return !this.builder.touchAble;
    }

    private void endAnimator() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.end();
        }
    }

    public void showLoading() {
        this.isSheet = this.currentType == 107 ? this.buttons.length > 2 : false;
        this.setImageDrawable(this.getResources().getDrawable(this.builder.icon));
        this.width = this.getDrawable().getMinimumWidth() / 2;
        this.height = this.getDrawable().getMinimumHeight() / 2;
        this.start();
        this.currentType = 102;
    }

    Builder getBuilder() {
        return this.builder;
    }

    public void showSomthing(int currentType) {
        this.currentType = currentType;
        this.isSheet = currentType == 107 ? this.buttons.length > 2 : false;
        this.endAnimator();
        this.setImageDrawable(this.getResources().getDrawable(this.builder.icon));
        this.width = this.getDrawable().getMinimumWidth() / 2;
        this.height = this.getDrawable().getMinimumHeight() / 2;
        if (this.max != null) {
            this.max.setRotate(0.0f, (float)this.width, (float)this.height);
            this.setImageMatrix(this.max);
        }
        if (this.isSheet) {
            this.sheetHeight = (1.5f * (float)this.builder.sheetCellPad + (float)(this.builder.sheetCellHeight * this.buttons.length)) * this.density;
            Log.i((String)TAG, (String)("showSomthing: " + this.sheetHeight));
            this.startBottomToTopAnim();
        }
        this.invalidate();
    }

    private void startBottomToTopAnim() {
        ValueAnimator bottomToTopAnim = ObjectAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        bottomToTopAnim.setDuration(300L);
        bottomToTopAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                Float value = (Float)valueAnimator.getAnimatedValue();
                PromptView.this.bottomHeight = PromptView.this.sheetHeight * value.floatValue();
                Log.i((String)PromptView.TAG, (String)("onAnimationUpdate: " + PromptView.this.bottomHeight));
                PromptView.this.invalidate();
            }
        });
        bottomToTopAnim.start();
    }

    void showSomthingAlert(PromptButton ... button) {
        this.buttons = button;
        this.showSomthing(107);
    }

    public void setBuilder(Builder builder) {
        if (this.builder != builder) {
            this.builder = builder;
        }
    }

    public int getCurrentType() {
        return this.currentType;
    }

    public void setText(String msg) {
        this.builder.text(msg);
        this.invalidate();
    }

    public void dismiss() {
        if (this.isSheet) {
            ValueAnimator bottomToTopAnim = ObjectAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            bottomToTopAnim.setDuration(300L);
            bottomToTopAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    Float value = (Float)valueAnimator.getAnimatedValue();
                    PromptView.this.bottomHeight = PromptView.this.sheetHeight * value.floatValue();
                    PromptView.this.invalidate();
                }
            });
            bottomToTopAnim.start();
        }
    }

    public void showAd() {
        this.currentType = 109;
        this.endAnimator();
    }

    public void showCustomLoading() {
        this.isSheet = this.currentType == 107 ? this.buttons.length > 2 : false;
        this.setImageDrawable(this.getResources().getDrawable(this.builder.icon));
        this.width = this.getDrawable().getMinimumWidth() / 2;
        this.height = this.getDrawable().getMinimumHeight() / 2;
        AnimationDrawable animationDrawable = (AnimationDrawable)this.getDrawable();
        animationDrawable.start();
        this.currentType = 110;
    }

    public void stopCustomerLoading() {
        AnimationDrawable animationDrawable = (AnimationDrawable)this.getDrawable();
        animationDrawable.stop();
    }
}

