/*
 * Decompiled with CFR 0.152.
 */
package me.leefeng.promptlibrary;

public class Builder {
    private static Builder defaultBuilder;
    private static Builder alertDefaultBuilder;
    int backColor = -16777216;
    int backAlpha = 90;
    int textColor = -1;
    float textSize = 14.0f;
    float padding = 15.0f;
    float round = 8.0f;
    int roundColor = -16777216;
    int roundAlpha = 120;
    boolean touchAble = false;
    boolean withAnim = true;
    long stayDuration = 1000L;
    boolean cancleAble;
    int icon;
    String text;

    public Builder backColor(int backColor) {
        this.backColor = backColor;
        return this;
    }

    public Builder backAlpha(int backAlpha) {
        this.backAlpha = backAlpha;
        return this;
    }

    public Builder textColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public Builder textSize(float textSize) {
        this.textSize = textSize;
        return this;
    }

    public Builder padding(float padding) {
        this.padding = padding;
        return this;
    }

    public Builder round(float round) {
        this.round = round;
        return this;
    }

    public Builder roundColor(int roundColor) {
        this.roundColor = roundColor;
        return this;
    }

    public Builder roundAlpha(int roundAlpha) {
        this.roundAlpha = roundAlpha;
        return this;
    }

    public Builder touchAble(boolean touchAble) {
        this.touchAble = touchAble;
        return this;
    }

    public Builder withAnim(boolean withAnim) {
        this.withAnim = withAnim;
        return this;
    }

    public Builder stayDuration(long time) {
        this.stayDuration = time;
        return this;
    }

    public Builder cancleAble(boolean time) {
        this.cancleAble = time;
        return this;
    }

    static Builder getDefaultBuilder() {
        if (defaultBuilder == null) {
            defaultBuilder = new Builder();
        }
        return defaultBuilder;
    }

    static Builder getAlertDefaultBuilder() {
        if (alertDefaultBuilder == null) {
            alertDefaultBuilder = new Builder().roundColor(-1).roundAlpha(255).textColor(-7829368).textSize(15.0f).cancleAble(true);
        }
        return alertDefaultBuilder;
    }

    public Builder icon(int icon) {
        this.icon = icon;
        return this;
    }

    public Builder text(String msg) {
        this.text = msg;
        return this;
    }
}

