/*
 * Decompiled with CFR 0.152.
 */
package com.llw.easyutil;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.llw.easyutil.R;

public class EasyView
extends View {
    private Paint mPaint;
    private int mBgColor;
    private float mBgRadius;
    private Paint mTextPaint;
    private int mTextColor;
    private float mTextSize;
    private String text;
    private int mBgWidth;
    private int mBgHeight;
    private int mTextWidth;
    private int mTextHeight;
    private float mPaddingLeft;
    private float mPaddingRight;
    private float mPaddingTop;
    private float mPaddingBottom;

    public EasyView(Context context) {
        super(context);
        this.init();
    }

    public EasyView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.EasyView);
        this.mBgColor = typedArray.getColor(R.styleable.EasyView_android_color, -16777216);
        this.mBgRadius = typedArray.getDimension(R.styleable.EasyView_android_radius, 48.0f);
        this.text = typedArray.getString(R.styleable.EasyView_android_text) == null ? "" : typedArray.getString(R.styleable.EasyView_android_text);
        this.mTextColor = typedArray.getColor(R.styleable.EasyView_android_textColor, -1);
        this.mTextSize = typedArray.getDimension(R.styleable.EasyView_android_textSize, 14.0f);
        this.mPaddingLeft = this.getPaddingLeft() == 0 ? 60.0f : (float)this.getPaddingLeft();
        this.mPaddingLeft = this.getPaddingStart() == 0 ? 60.0f : (float)this.getPaddingStart();
        this.mPaddingRight = this.getPaddingRight() == 0 ? 60.0f : (float)this.getPaddingRight();
        this.mPaddingRight = this.getPaddingEnd() == 0 ? 60.0f : (float)this.getPaddingEnd();
        this.mPaddingTop = this.getPaddingTop() == 0 ? 40.0f : (float)this.getPaddingTop();
        this.mPaddingBottom = this.getPaddingBottom() == 0 ? 40.0f : (float)this.getPaddingBottom();
        typedArray.recycle();
        this.init();
    }

    public EasyView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public EasyView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mBgColor);
        this.mPaint.setStrokeWidth(6.0f);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(this.mTextColor);
        this.mTextPaint.setTextSize(this.mTextSize);
        this.mTextPaint.setStyle(Paint.Style.FILL);
        this.mTextPaint.setAntiAlias(true);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        this.mTextWidth = (int)this.mTextPaint.measureText(this.text);
        this.mTextHeight = this.mTextWidth == 0 ? 0 : (int)(fontMetrics.bottom - fontMetrics.top);
        this.mBgWidth = (int)((float)this.mTextWidth + this.mPaddingLeft + this.mPaddingRight);
        this.mBgHeight = (int)((float)this.mTextHeight + this.mPaddingTop + this.mPaddingBottom);
        int mWidth = this.mBgWidth;
        int mHeight = this.mBgHeight;
        if (widthMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(mWidth, mHeight);
        } else if (widthMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(mWidth, heightSize);
        } else if (heightMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(widthSize, mHeight);
        }
    }

    public void layout(int l, int t, int r, int b) {
        super.layout(l, t, r, b);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.mBgWidth, (float)this.mBgHeight);
        canvas.drawRoundRect(rectF, this.mBgRadius, this.mBgRadius, this.mPaint);
        float textX = this.mPaddingLeft;
        Paint.FontMetrics fontMetrics = this.mTextPaint.getFontMetrics();
        float distanceY = rectF.centerY() + ((fontMetrics.bottom - fontMetrics.top) / 2.0f - fontMetrics.bottom);
        canvas.drawText(this.text, textX, distanceY, this.mTextPaint);
    }

    protected void setBgColor(Context context, int color) {
        this.mBgColor = Color.parseColor((String)context.getResources().getString(color));
        this.init();
    }

    protected void setBgColor(String colorString) {
        this.mBgColor = Color.parseColor((String)colorString);
        this.init();
    }

    protected void setBgRadius(float radius) {
        this.mBgRadius = radius;
    }

    protected void setText(String text) {
        this.text = text;
    }

    protected void setTextSize(float size) {
        this.mTextSize = size;
    }

    protected void setTextColor(String colorString) {
        this.mTextColor = Color.parseColor((String)colorString);
        this.init();
    }

    protected void setTextColor(Context context, int color) {
        this.mTextColor = Color.parseColor((String)context.getResources().getString(color));
        this.init();
    }
}

