/*
 * Decompiled with CFR 0.152.
 */
package com.llw.easyutil;

public final class EasyRegex {
    public static final String REGEX_NUMBER = "^[0-9]*$";
    public static final String REGEX_MOBILE_SIMPLE = "^[1]\\d{10}$";
    public static final String REGEX_MOBILE_EXACT = "^1(3[0-9]|4[01456879]|5[0-35-9]|6[2567]|7[0-8]|8[0-9]|9[0-35-9])\\d{8}$";
    public static final String REGEX_TELEPHONE_NUMBER = "\\d{3}-\\d{8}|\\d{4}-\\d{7}";
    public static final String REGEX_CHINESE_CHARACTER = "^[\\u4e00-\\u9fa5]+$";
    public static final String REGEX_USER_NAME = "^[\\u4e00-\\u9fa5]{2,4}";
    public static final String REGEX_ID_CARD_15 = "^[1-9]\\d{5}\\d{2}((0[1-9])|(1[0-2]))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$";
    public static final String REGEX_ID_CARD_18 = "^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(1[0-2]))(([0-2][1-9])|10|20|30|31)\\d{3}([0-9Xx])$";
    public static final String REGEX_ID_CARD_LAST_SIX = "^(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$";
    public static final String REGEX_QQ = "[1-9][0-9]{4,9}";
    public static final String REGEX_POSTAL_CODE = "[1-9]\\d{5}(?!\\d)";
    public static final String REGEX_EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    public static final String REGEX_DOMAIN_NAME = "[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+\\.?";
    public static final String REGEX_URL_SIMPLE = "^[a-zA-z]+://[^\\s]*";
    public static final String REGEX_URL_EXACT = "^http://([\\w-]+\\.)+[\\w-]+(/[\\w-./?%&=]*)?$";
    public static final String REGEX_CHAR = "^.{3,20}$";
    public static final String REGEX_EN_CHAR = "^[A-Za-z]+$";
    public static final String REGEX_EN_CHAR_BIG = "^[A-Z]+$";
    public static final String REGEX_EN_CHAR_SMALL = "^[A-Z]+$";
    public static final String REGEX_EN_CHAR_NUMBER = "^[A-Za-z0-9]+$";
    public static final String ACCOUNT = "^[a-zA-Z][a-zA-Z0-9_]{4,15}$";
    public static final String REGEX_PWD = "^[a-zA-Z]\\w{5,17}$";
    public static final String REGEX_PWD_STRONG = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,16}$";
    public static final String REGEX_PWD_STRONG_NO_USED_SPECIAL_CHAR = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z])[a-zA-Z0-9]{8,16}$";

    private EasyRegex() {
        throw new UnsupportedOperationException("What are you doing?");
    }

    public static boolean isNumber(String number) {
        return number.matches(REGEX_NUMBER);
    }

    public static boolean isNumber(String number, String regex) {
        return number.matches(regex);
    }

    public static boolean isPhoneNumber(String phoneNumber) {
        return phoneNumber.matches(REGEX_MOBILE_SIMPLE);
    }

    public static boolean isPhoneNumber(String phoneNumber, String regex) {
        return phoneNumber.matches(regex);
    }

    public static boolean isPhoneNumberExact(String phoneNumber) {
        return phoneNumber.matches(REGEX_MOBILE_EXACT);
    }

    public static boolean isPhoneNumberExact(String phoneNumber, String regex) {
        return phoneNumber.matches(regex);
    }

    public static boolean isTelephoneNumber(String telephoneNumber) {
        return telephoneNumber.matches(REGEX_TELEPHONE_NUMBER);
    }

    public static boolean isTelephoneNumber(String telephoneNumber, String regex) {
        return telephoneNumber.matches(regex);
    }

    public static boolean isChineseCharacter(String chineseCharacter) {
        return chineseCharacter.matches(REGEX_CHINESE_CHARACTER);
    }

    public static boolean isChineseCharacter(String chineseCharacter, String regex) {
        return chineseCharacter.matches(regex);
    }

    public static boolean isName(String userName) {
        return userName.matches(REGEX_USER_NAME);
    }

    public static boolean isName(String userName, String regex) {
        return userName.matches(regex);
    }

    public static boolean isIdCard15(String idCard15) {
        return idCard15.matches(REGEX_ID_CARD_15);
    }

    public static boolean isIdCard15(String idCard15, String regex) {
        return idCard15.matches(regex);
    }

    public static boolean isIdCard18(String idCard18) {
        return idCard18.matches(REGEX_ID_CARD_18);
    }

    public static boolean isIdCard18(String idCard18, String regex) {
        return idCard18.matches(regex);
    }

    public static boolean isIdCardLast6(String idCardLast6) {
        return idCardLast6.matches(REGEX_ID_CARD_LAST_SIX);
    }

    public static boolean isIdCardLast6(String idCardLast6, String regex) {
        return idCardLast6.matches(regex);
    }

    public static boolean isQQ(String qq) {
        return qq.matches(REGEX_QQ);
    }

    public static boolean isQQ(String qq, String regex) {
        return qq.matches(regex);
    }

    public static boolean isPostalCode(String postalCode) {
        return postalCode.matches(REGEX_POSTAL_CODE);
    }

    public static boolean isPostalCode(String postalCode, String regex) {
        return postalCode.matches(regex);
    }

    public static boolean isEmail(String email) {
        return email.matches(REGEX_EMAIL);
    }

    public static boolean isEmail(String email, String regex) {
        return email.matches(regex);
    }

    public static boolean isDomainName(String domainName) {
        return domainName.matches(REGEX_DOMAIN_NAME);
    }

    public static boolean isDomainName(String domainName, String regex) {
        return domainName.matches(regex);
    }

    public static boolean isUrl(String url) {
        return url.matches(REGEX_URL_SIMPLE);
    }

    public static boolean isUrl(String url, String regex) {
        return url.matches(regex);
    }

    public static boolean isUrlExact(String url) {
        return url.matches(REGEX_URL_EXACT);
    }

    public static boolean isUrlExact(String url, String regex) {
        return url.matches(regex);
    }

    public static boolean isChar(String character) {
        return character.matches(REGEX_CHAR);
    }

    public static boolean isChar(String character, String regex) {
        return character.matches(regex);
    }

    public static boolean isCharEn(String enChar) {
        return enChar.matches(REGEX_EN_CHAR);
    }

    public static boolean isCharEn(String enChar, String regex) {
        return enChar.matches(regex);
    }

    public static boolean isCharEnBig(String enChar) {
        return enChar.matches("^[A-Z]+$");
    }

    public static boolean isCharEnBig(String enChar, String regex) {
        return enChar.matches(regex);
    }

    public static boolean isCharEnSmall(String enChar) {
        return enChar.matches("^[A-Z]+$");
    }

    public static boolean isCharEnSmall(String enChar, String regex) {
        return enChar.matches(regex);
    }

    public static boolean isCharEnAndNumber(String enCharAndNumber) {
        return enCharAndNumber.matches(REGEX_EN_CHAR_NUMBER);
    }

    public static boolean isCharEnAndNumber(String enCharAndNumber, String regex) {
        return enCharAndNumber.matches(regex);
    }

    public static boolean isAccount(String account) {
        return account.matches(ACCOUNT);
    }

    public static boolean isAccount(String account, String regex) {
        return account.matches(regex);
    }

    public static boolean isPwd(String password) {
        return password.matches(REGEX_PWD);
    }

    public static boolean isPwd(String password, String regex) {
        return password.matches(regex);
    }

    public static boolean isPwdStrong(String password) {
        return password.matches(REGEX_PWD_STRONG);
    }

    public static boolean isPwdStrong(String password, String regex) {
        return password.matches(regex);
    }

    public static boolean isPwdStrongPlus(String password) {
        return password.matches(REGEX_PWD_STRONG_NO_USED_SPECIAL_CHAR);
    }

    public static boolean isPwdStrongPlus(String password, String regex) {
        return password.matches(regex);
    }
}

