/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.support.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.security.MessageDigest;

class GlideRoundTransform
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;
    private float leftTop_radius;
    private float leftBottom_radius;
    private float rightTop_radius;
    private float rightBottom_radius;
    private boolean isLeftTop;
    private boolean isRightTop;
    private boolean isLeftBottom;
    private boolean isRightBottom;

    public GlideRoundTransform(Context context, float leftTop_radius, float leftBottom_radius, float rightTop_radius, float rightBottom_radius) {
        this.mBitmapPool = Glide.get((Context)context).getBitmapPool();
        this.leftTop_radius = leftTop_radius;
        if (leftTop_radius != 0.0f) {
            this.isLeftTop = true;
        }
        this.leftBottom_radius = leftBottom_radius;
        if (leftBottom_radius != 0.0f) {
            this.isLeftBottom = true;
        }
        this.rightTop_radius = rightTop_radius;
        if (rightTop_radius != 0.0f) {
            this.isRightTop = true;
        }
        this.rightBottom_radius = rightBottom_radius;
        if (rightBottom_radius != 0.0f) {
            this.isRightBottom = true;
        }
    }

    @NonNull
    public Resource<Bitmap> transform(@NonNull Context context, @NonNull Resource<Bitmap> resource, int outWidth, int outHeight) {
        int finalHeight;
        int finalWidth;
        Bitmap source = (Bitmap)resource.get();
        if (outWidth > outHeight) {
            float scale = (float)outHeight / (float)outWidth;
            finalWidth = source.getWidth();
            finalHeight = (int)((float)source.getWidth() * scale);
            if (finalHeight > source.getHeight()) {
                scale = (float)outWidth / (float)outHeight;
                finalHeight = source.getHeight();
                finalWidth = (int)((float)source.getHeight() * scale);
            }
        } else if (outWidth < outHeight) {
            float scale = (float)outWidth / (float)outHeight;
            finalHeight = source.getHeight();
            finalWidth = (int)((float)source.getHeight() * scale);
            if (finalWidth > source.getWidth()) {
                scale = (float)outHeight / (float)outWidth;
                finalWidth = source.getWidth();
                finalHeight = (int)((float)source.getWidth() * scale);
            }
        } else {
            finalWidth = finalHeight = source.getHeight();
        }
        this.leftTop_radius *= (float)finalHeight / (float)outHeight;
        this.leftBottom_radius *= (float)finalHeight / (float)outHeight;
        this.rightTop_radius *= (float)finalHeight / (float)outHeight;
        this.rightBottom_radius *= (float)finalHeight / (float)outHeight;
        Bitmap outBitmap = this.mBitmapPool.get(finalWidth, finalHeight, Bitmap.Config.ARGB_8888);
        if (outBitmap == null) {
            outBitmap = Bitmap.createBitmap((int)finalWidth, (int)finalHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(outBitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        int width = (source.getWidth() - finalWidth) / 2;
        int height = (source.getHeight() - finalHeight) / 2;
        if (width != 0 || height != 0) {
            Matrix matrix = new Matrix();
            matrix.setTranslate((float)(-width), (float)(-height));
            shader.setLocalMatrix(matrix);
        }
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        RectF rectF = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        float[] outerR = new float[]{this.leftTop_radius, this.leftTop_radius, this.rightTop_radius, this.rightTop_radius, this.rightBottom_radius, this.rightBottom_radius, this.leftBottom_radius, this.leftBottom_radius};
        Path path = new Path();
        path.addRoundRect(rectF, outerR, Path.Direction.CW);
        canvas.drawPath(path, paint);
        return BitmapResource.obtain((Bitmap)outBitmap, (BitmapPool)this.mBitmapPool);
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
    }
}

