/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.FrameLayout;
import com.lihang.R;

public class ShadowLayout
extends FrameLayout {
    private int mBackGroundColor;
    private int mBackGroundColorClicked;
    private int mShadowColor;
    private float mShadowLimit;
    private float mCornerRadius;
    private float mDx;
    private float mDy;
    private boolean leftShow;
    private boolean rightShow;
    private boolean topShow;
    private boolean bottomShow;
    private Paint shadowPaint;
    private Paint paint;
    private int leftPading;
    private int topPading;
    private int rightPading;
    private int bottomPading;
    private RectF rectf = new RectF();
    private int selectorType = 3;
    private boolean isShowShadow = true;
    private boolean isSym;

    public ShadowLayout(Context context) {
        this(context, null);
    }

    public ShadowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShadowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.selectorType == 3 || this.selectorType == 2) {
            if (selected) {
                this.paint.setColor(this.mBackGroundColorClicked);
            } else {
                this.paint.setColor(this.mBackGroundColor);
            }
            this.postInvalidate();
            this.invalidate();
        }
    }

    public void setMDx(float mDx) {
        this.mDx = Math.abs(mDx) > this.mShadowLimit ? (mDx > 0.0f ? this.mShadowLimit : -this.mShadowLimit) : mDx;
        this.setPading();
    }

    public void setMDy(float mDy) {
        this.mDy = Math.abs(mDy) > this.mShadowLimit ? (mDy > 0.0f ? this.mShadowLimit : -this.mShadowLimit) : mDy;
        this.setPading();
    }

    public float getmCornerRadius() {
        return this.mCornerRadius;
    }

    public void setmCornerRadius(int mCornerRadius) {
        this.mCornerRadius = mCornerRadius;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
    }

    public float getmShadowLimit() {
        return this.mShadowLimit;
    }

    public void setmShadowLimit(int mShadowLimit) {
        this.mShadowLimit = mShadowLimit;
        this.setPading();
    }

    public void setmShadowColor(int mShadowColor) {
        this.mShadowColor = mShadowColor;
        if (this.getWidth() != 0 && this.getHeight() != 0) {
            this.setBackgroundCompat(this.getWidth(), this.getHeight());
        }
    }

    public void setLeftShow(boolean leftShow) {
        this.leftShow = leftShow;
        this.setPading();
    }

    public void setRightShow(boolean rightShow) {
        this.rightShow = rightShow;
        this.setPading();
    }

    public void setTopShow(boolean topShow) {
        this.topShow = topShow;
        this.setPading();
    }

    public void setBottomShow(boolean bottomShow) {
        this.bottomShow = bottomShow;
        this.setPading();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            this.setBackgroundCompat(w, h);
        }
    }

    private void initView(Context context, AttributeSet attrs) {
        this.initAttributes(attrs);
        this.shadowPaint = new Paint();
        this.shadowPaint.setAntiAlias(true);
        this.shadowPaint.setStyle(Paint.Style.FILL);
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.mBackGroundColor);
        this.setPading();
    }

    public void setPading() {
        if (this.isSym) {
            int xPadding = (int)(this.mShadowLimit + Math.abs(this.mDx));
            int yPadding = (int)(this.mShadowLimit + Math.abs(this.mDy));
            this.leftPading = this.leftShow ? xPadding : 0;
            this.topPading = this.topShow ? yPadding : 0;
            this.rightPading = this.rightShow ? xPadding : 0;
            this.bottomPading = this.bottomShow ? yPadding : 0;
        } else {
            if (Math.abs(this.mDy) > this.mShadowLimit) {
                this.mDy = this.mDy > 0.0f ? this.mShadowLimit : 0.0f - this.mShadowLimit;
            }
            if (Math.abs(this.mDx) > this.mShadowLimit) {
                this.mDx = this.mDx > 0.0f ? this.mShadowLimit : 0.0f - this.mShadowLimit;
            }
            this.topPading = this.topShow ? (int)(this.mShadowLimit - this.mDy) : 0;
            this.bottomPading = this.bottomShow ? (int)(this.mShadowLimit + this.mDy) : 0;
            this.rightPading = this.rightShow ? (int)(this.mShadowLimit - this.mDx) : 0;
            this.leftPading = this.leftShow ? (int)(this.mShadowLimit + this.mDx) : 0;
        }
        this.setPadding(this.leftPading, this.topPading, this.rightPading, this.bottomPading);
    }

    private void setBackgroundCompat(int w, int h) {
        if (this.isShowShadow) {
            this.isAddAlpha(this.mShadowColor);
            Bitmap bitmap = this.createShadowBitmap(w, h, this.mCornerRadius, this.mShadowLimit, this.mDx, this.mDy, this.mShadowColor, 0);
            BitmapDrawable drawable = new BitmapDrawable(bitmap);
            if (Build.VERSION.SDK_INT <= 16) {
                this.setBackgroundDrawable((Drawable)drawable);
            } else {
                this.setBackground((Drawable)drawable);
            }
        } else {
            this.setBackgroundColor(Color.parseColor((String)"#00000000"));
        }
    }

    private void initAttributes(AttributeSet attrs) {
        TypedArray attr = this.getContext().obtainStyledAttributes(attrs, R.styleable.ShadowLayout);
        if (attr == null) {
            return;
        }
        try {
            this.isShowShadow = attr.getBoolean(R.styleable.ShadowLayout_hl_isShowShadow, true);
            this.leftShow = attr.getBoolean(R.styleable.ShadowLayout_hl_leftShow, true);
            this.rightShow = attr.getBoolean(R.styleable.ShadowLayout_hl_rightShow, true);
            this.bottomShow = attr.getBoolean(R.styleable.ShadowLayout_hl_bottomShow, true);
            this.topShow = attr.getBoolean(R.styleable.ShadowLayout_hl_topShow, true);
            this.mCornerRadius = attr.getDimension(R.styleable.ShadowLayout_hl_cornerRadius, this.getResources().getDimension(R.dimen.dp_0));
            this.mShadowLimit = attr.getDimension(R.styleable.ShadowLayout_hl_shadowLimit, this.getResources().getDimension(R.dimen.dp_5));
            this.mDx = attr.getDimension(R.styleable.ShadowLayout_hl_dx, 0.0f);
            this.mDy = attr.getDimension(R.styleable.ShadowLayout_hl_dy, 0.0f);
            this.mShadowColor = attr.getColor(R.styleable.ShadowLayout_hl_shadowColor, this.getResources().getColor(R.color.default_shadow_color));
            this.mBackGroundColor = attr.getColor(R.styleable.ShadowLayout_hl_shadowBackColor, this.getResources().getColor(R.color.default_shadowback_color));
            this.mBackGroundColorClicked = attr.getColor(R.styleable.ShadowLayout_hl_shadowBackColorClicked, this.getResources().getColor(R.color.default_shadowback_color));
            if (this.mBackGroundColorClicked != -1) {
                this.setClickable(true);
            }
            this.selectorType = attr.getInt(R.styleable.ShadowLayout_hl_selectorMode, 3);
            this.isSym = attr.getBoolean(R.styleable.ShadowLayout_hl_isSym, true);
        }
        finally {
            attr.recycle();
        }
    }

    private Bitmap createShadowBitmap(int shadowWidth, int shadowHeight, float cornerRadius, float shadowRadius, float dx, float dy, int shadowColor, int fillColor) {
        dx /= 4.0f;
        dy /= 4.0f;
        cornerRadius /= 4.0f;
        Bitmap output = Bitmap.createBitmap((int)(shadowWidth /= 4), (int)(shadowHeight /= 4), (Bitmap.Config)Bitmap.Config.ARGB_4444);
        Canvas canvas = new Canvas(output);
        RectF shadowRect = new RectF(shadowRadius /= 4.0f, shadowRadius, (float)shadowWidth - shadowRadius, (float)shadowHeight - shadowRadius);
        if (this.isSym) {
            if (dy > 0.0f) {
                shadowRect.top += dy;
                shadowRect.bottom -= dy;
            } else if (dy < 0.0f) {
                shadowRect.top += Math.abs(dy);
                shadowRect.bottom -= Math.abs(dy);
            }
            if (dx > 0.0f) {
                shadowRect.left += dx;
                shadowRect.right -= dx;
            } else if (dx < 0.0f) {
                shadowRect.left += Math.abs(dx);
                shadowRect.right -= Math.abs(dx);
            }
        } else {
            shadowRect.top -= dy;
            shadowRect.bottom -= dy;
            shadowRect.right -= dx;
            shadowRect.left -= dx;
        }
        this.shadowPaint.setColor(fillColor);
        if (!this.isInEditMode()) {
            this.shadowPaint.setShadowLayer(shadowRadius, dx, dy, shadowColor);
        }
        canvas.drawRoundRect(shadowRect, cornerRadius, cornerRadius, this.shadowPaint);
        return output;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.rectf.left = this.leftPading;
        this.rectf.top = this.topPading;
        this.rectf.right = this.getWidth() - this.rightPading;
        this.rectf.bottom = this.getHeight() - this.bottomPading;
        int trueHeight = (int)(this.rectf.bottom - this.rectf.top);
        if (this.mCornerRadius > (float)(trueHeight / 2)) {
            canvas.drawRoundRect(this.rectf, (float)(trueHeight / 2), (float)(trueHeight / 2), this.paint);
        } else {
            canvas.drawRoundRect(this.rectf, this.mCornerRadius, this.mCornerRadius, this.paint);
        }
    }

    public void isAddAlpha(int color2) {
        if (Color.alpha((int)color2) == 255) {
            String red = Integer.toHexString(Color.red((int)color2));
            String green = Integer.toHexString(Color.green((int)color2));
            String blue = Integer.toHexString(Color.blue((int)color2));
            if (red.length() == 1) {
                red = "0" + red;
            }
            if (green.length() == 1) {
                green = "0" + green;
            }
            if (blue.length() == 1) {
                blue = "0" + blue;
            }
            String endColor = "#2a" + red + green + blue;
            this.mShadowColor = ShadowLayout.convertToColorInt(endColor);
        }
    }

    public static int convertToColorInt(String argb) throws IllegalArgumentException {
        if (!argb.startsWith("#")) {
            argb = "#" + argb;
        }
        return Color.parseColor((String)argb);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mBackGroundColorClicked != -1) {
            switch (event.getAction()) {
                case 0: {
                    if (this.isSelected() || this.selectorType == 2) break;
                    this.paint.setColor(this.mBackGroundColorClicked);
                    this.postInvalidate();
                    break;
                }
                case 1: {
                    if (this.isSelected() || this.selectorType == 2) break;
                    this.paint.setColor(this.mBackGroundColor);
                    this.postInvalidate();
                }
            }
        }
        return super.onTouchEvent(event);
    }
}

