/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.tools;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import org.openpdf.text.error_messages.MessageLocalization;

public class Executable {
    private static String acroread = null;

    private static Process action(String fileName, String parameters, boolean waitForTermination) throws IOException {
        Process process = null;
        parameters = ((String)parameters).trim().length() > 0 ? " " + ((String)parameters).trim() : "";
        if (acroread != null) {
            process = Runtime.getRuntime().exec(Executable.createCommand(new String[]{acroread, parameters, " \"", fileName, "\""}));
        } else if (Executable.isWindows()) {
            process = Executable.isWindows9X() ? Runtime.getRuntime().exec(Executable.createCommand(new String[]{"command.com /C start acrord32", parameters, " \"", fileName, "\""})) : Runtime.getRuntime().exec(Executable.createCommand(new String[]{"cmd /c start acrord32", parameters, " \"", fileName, "\""}));
        } else if (Executable.isMac()) {
            process = ((String)parameters).trim().length() == 0 ? Runtime.getRuntime().exec(new String[]{"/usr/bin/open", fileName}) : Runtime.getRuntime().exec(new String[]{"/usr/bin/open", ((String)parameters).trim(), fileName});
        }
        try {
            if (process != null && waitForTermination) {
                process.waitFor();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return process;
    }

    private static String[] createCommand(String ... arguments) {
        return arguments;
    }

    public static Process openDocument(String fileName, boolean waitForTermination) throws IOException {
        return Executable.action(fileName, "", waitForTermination);
    }

    public static Process openDocument(File file, boolean waitForTermination) throws IOException {
        return Executable.openDocument(file.getAbsolutePath(), waitForTermination);
    }

    public static Process openDocument(String fileName) throws IOException {
        return Executable.openDocument(fileName, false);
    }

    public static Process openDocument(File file) throws IOException {
        return Executable.openDocument(file, false);
    }

    public static Process printDocument(String fileName, boolean waitForTermination) throws IOException {
        return Executable.action(fileName, "/p", waitForTermination);
    }

    public static Process printDocument(File file, boolean waitForTermination) throws IOException {
        return Executable.printDocument(file.getAbsolutePath(), waitForTermination);
    }

    public static Process printDocument(String fileName) throws IOException {
        return Executable.printDocument(fileName, false);
    }

    public static Process printDocument(File file) throws IOException {
        return Executable.printDocument(file, false);
    }

    public static Process printDocumentSilent(String fileName, boolean waitForTermination) throws IOException {
        return Executable.action(fileName, "/p /h", waitForTermination);
    }

    public static Process printDocumentSilent(File file, boolean waitForTermination) throws IOException {
        return Executable.printDocumentSilent(file.getAbsolutePath(), waitForTermination);
    }

    public static Process printDocumentSilent(String fileName) throws IOException {
        return Executable.printDocumentSilent(fileName, false);
    }

    public static Process printDocumentSilent(File file) throws IOException {
        return Executable.printDocumentSilent(file, false);
    }

    public static void launchBrowser(String url) throws IOException {
        try {
            if (Executable.isMac()) {
                Class<?> macUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                Method openURL = macUtils.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (Executable.isWindows()) {
                Runtime.getRuntime().exec(Executable.createCommand("rundll32 url.dll,FileProtocolHandler ", url));
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    throw new Exception(MessageLocalization.getComposedMessage((String)"could.not.find.web.browser"));
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            throw new IOException(MessageLocalization.getComposedMessage((String)"error.attempting.to.launch.web.browser"));
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("windows") || os.contains("nt");
    }

    public static boolean isWindows9X() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.equals("windows 95") || os.equals("windows 98");
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac");
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("linux");
    }
}

