/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import org.openpdf.text.Document;
import org.openpdf.text.pdf.PdfCopy;
import org.openpdf.text.pdf.PdfImportedPage;
import org.openpdf.text.pdf.PdfReader;
import org.openpdf.text.pdf.SimpleBookmark;

public class ConcatPdf {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("arguments: file1 [file2 ...] destfile");
        } else {
            try {
                File outFile = new File(args[args.length - 1]);
                ArrayList<File> sources = new ArrayList<File>();
                for (int i = 0; i < args.length - 1; ++i) {
                    sources.add(new File(args[i]));
                }
                ConcatPdf.concat(sources, outFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void concat(List<File> sources, File target) throws IOException {
        for (File source : sources) {
            if (source.isFile() && source.canRead()) continue;
            throw new IOException("cannot read:" + source.getAbsolutePath());
        }
        int pageOffset = 0;
        ArrayList master = new ArrayList();
        Document document = new Document();
        PdfCopy writer = new PdfCopy(document, (OutputStream)new BufferedOutputStream(Files.newOutputStream(target.toPath(), new OpenOption[0])));
        writer.setPdfVersion("2.0");
        writer.setFullCompression();
        writer.setCompressionLevel(9);
        document.open();
        for (File source : sources) {
            PdfReader reader = new PdfReader((InputStream)new BufferedInputStream(Files.newInputStream(source.toPath(), new OpenOption[0])));
            reader.consolidateNamedDestinations();
            int numberOfPages = reader.getNumberOfPages();
            List bookmarks = SimpleBookmark.getBookmarkList((PdfReader)reader);
            if (bookmarks != null) {
                if (pageOffset != 0) {
                    SimpleBookmark.shiftPageNumbersInRange((List)bookmarks, (int)pageOffset, null);
                }
                master.addAll(bookmarks);
            }
            pageOffset += numberOfPages;
            for (int i = 1; i <= numberOfPages; ++i) {
                PdfImportedPage page = writer.getImportedPage(reader, i);
                writer.addPage(page);
            }
            writer.freeReader(reader);
        }
        if (!master.isEmpty()) {
            writer.setOutlines(master);
        }
        document.close();
    }
}

