/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.toolbox;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openpdf.toolbox.arguments.AbstractArgument;
import org.openpdf.tools.Executable;

public abstract class AbstractTool
implements ActionListener {
    public static final int MENU_EXECUTE = 1;
    public static final int MENU_EXECUTE_SHOW = 2;
    public static final int MENU_EXECUTE_PRINT = 4;
    public static final int MENU_EXECUTE_PRINT_SILENT = 8;
    public static ArrayList<String> versionsarray = new ArrayList();
    protected JInternalFrame internalFrame = null;
    protected ArrayList<AbstractArgument> arguments = new ArrayList();
    protected int menuoptions = 1;
    private Desktop awtdesktop = null;
    private JMenuBar menubar;

    public AbstractTool() {
        if (Desktop.isDesktopSupported()) {
            this.awtdesktop = Desktop.getDesktop();
        }
    }

    protected static void addVersion(String version) {
        version = version.substring(5, version.length() - 2);
        versionsarray.add(version);
    }

    public void setMainArguments(String[] args) {
        int counter = 0;
        for (AbstractArgument argument : this.arguments) {
            if (args.length <= counter) break;
            argument.setValue(args[counter]);
            ++counter;
        }
    }

    public ArrayList<AbstractArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(ArrayList<AbstractArgument> arguments) {
        this.arguments = arguments;
    }

    public Object getValue(String name) throws InstantiationException {
        for (AbstractArgument argument : this.arguments) {
            if (!name.equals(argument.getName())) continue;
            return argument.getArgument();
        }
        return null;
    }

    public JInternalFrame getInternalFrame() {
        if (this.internalFrame == null) {
            this.createFrame();
        }
        return this.internalFrame;
    }

    public void setInternalFrame(JInternalFrame internalFrame) {
        this.internalFrame = internalFrame;
    }

    public JMenuBar getMenubar() {
        JMenuItem execute;
        this.menubar = new JMenuBar();
        JMenu tool = new JMenu("Tool");
        tool.setMnemonic(70);
        JMenuItem usage = new JMenuItem("Usage");
        usage.setMnemonic(85);
        usage.addActionListener(this);
        tool.add(usage);
        JMenuItem args = new JMenuItem("Arguments");
        args.setMnemonic(65);
        args.addActionListener(this);
        tool.add(args);
        if ((this.menuoptions & 1) > 0) {
            execute = new JMenuItem("Execute");
            execute.setMnemonic(69);
            execute.addActionListener(this);
            tool.add(execute);
        }
        if ((this.menuoptions & 2) > 0) {
            execute = new JMenuItem("Execute+Open");
            execute.addActionListener(this);
            tool.add(execute);
        }
        if ((this.menuoptions & 4) > 0) {
            execute = new JMenuItem("Execute+Printdialog");
            execute.addActionListener(this);
            tool.add(execute);
        }
        if ((this.menuoptions & 8) > 0) {
            execute = new JMenuItem("Execute+Print");
            execute.addActionListener(this);
            tool.add(execute);
        }
        JMenuItem close = new JMenuItem("Close");
        close.setMnemonic(67);
        close.addActionListener(this);
        tool.add(close);
        this.menubar.add(tool);
        if (!this.arguments.isEmpty()) {
            JMenu params = new JMenu("Arguments");
            tool.setMnemonic(84);
            for (AbstractArgument argument : this.arguments) {
                JMenuItem item = new JMenuItem(argument.getName());
                item.setToolTipText(argument.getDescription());
                item.addActionListener(argument);
                params.add(item);
            }
            this.menubar.add(params);
        }
        return this.menubar;
    }

    public void setMenubar(JMenuBar menubar) {
        this.menubar = menubar;
    }

    public String getUsage() {
        StringBuilder buf = new StringBuilder("java ");
        buf.append(this.getClass().getName());
        for (AbstractArgument argument : this.arguments) {
            buf.append(' ');
            buf.append(argument.getName());
        }
        buf.append('\n');
        for (AbstractArgument argument : this.arguments) {
            buf.append(argument.getUsage());
        }
        return buf.toString();
    }

    private String getArgs() {
        StringBuilder buf = new StringBuilder("Current arguments:\n");
        for (AbstractArgument argument : this.arguments) {
            buf.append("  ");
            buf.append(argument.getName());
            if (argument.getValue() == null) {
                buf.append(" = null\n");
                continue;
            }
            buf.append(" = '");
            buf.append(argument.toString());
            buf.append("'\n");
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if ("Close".equals(evt.getActionCommand())) {
            System.out.println("=== " + this.getInternalFrame().getTitle() + " CLOSED ===");
            this.internalFrame.dispose();
        }
        if ("Usage".equals(evt.getActionCommand())) {
            JOptionPane.showMessageDialog(this.internalFrame, this.getUsage());
        }
        if ("Arguments".equals(evt.getActionCommand())) {
            JOptionPane.showMessageDialog(this.internalFrame, this.getArgs());
        }
        if ("Execute".equals(evt.getActionCommand())) {
            this.execute();
        }
        if ("Execute+Open".equals(evt.getActionCommand())) {
            this.execute();
            try {
                if (this.awtdesktop != null && this.awtdesktop.isSupported(Desktop.Action.OPEN)) {
                    this.awtdesktop.open(this.getDestPathPDF());
                } else {
                    Executable.openDocument(this.getDestPathPDF());
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if ("Execute+Printdialog".equals(evt.getActionCommand())) {
            this.execute();
            try {
                if (this.awtdesktop != null && this.awtdesktop.isSupported(Desktop.Action.PRINT)) {
                    this.awtdesktop.print(this.getDestPathPDF());
                } else {
                    Executable.printDocument(this.getDestPathPDF());
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        if ("Execute+Print".equals(evt.getActionCommand())) {
            this.execute();
            try {
                Executable.printDocumentSilent(this.getDestPathPDF());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    protected abstract File getDestPathPDF() throws InstantiationException;

    protected abstract void createFrame();

    public abstract void execute();

    public abstract void valueHasChanged(AbstractArgument var1);
}

