/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins.watermarker;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.toolbox.plugins.watermarker.Writer;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Watermarker {
    private final PdfReader reader;
    private final ByteArrayOutputStream outputStream;
    private final PdfStamper stamp;
    private final String text;
    private final int fontsize;
    private final float opacity;
    private Color color = Color.BLACK;

    public Watermarker(byte[] input, String text, int fontsize, float opacity) throws IOException, DocumentException {
        this.reader = new PdfReader(input);
        this.outputStream = new ByteArrayOutputStream();
        this.stamp = new PdfStamper(this.reader, (OutputStream)this.outputStream);
        this.text = text;
        this.fontsize = fontsize;
        this.opacity = opacity;
    }

    public Watermarker withColor(Color color) {
        this.color = color;
        return this;
    }

    public byte[] write() throws IOException, DocumentException {
        Writer writer = new Writer(this.reader, this.stamp, this.text, this.fontsize, this.opacity, this.color);
        writer.write();
        return this.outputStream.toByteArray();
    }
}

