/*
 * Decompiled with CFR 0.152.
 */
package org.librepdf.openpdf.examples.radiobutton;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RadioCheckField;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class RadioButtonPageBreak {
    public static void main(String ... args) throws FileNotFoundException, DocumentException {
        Document document = new Document(PageSize.A4);
        FileOutputStream outputStream = new FileOutputStream("RadioButtonPageBreak.pdf");
        PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        document.open();
        RadioButtonPageBreak.almostFillThePage(document);
        RadioButtonPageBreak.addTableWithRadioButtons(document, writer);
        document.close();
    }

    private static void almostFillThePage(Document document) throws DocumentException {
        document.add((Element)new Paragraph("This example shows: A table with a radio group. Each radio button is in a different row. If the table is split due a page break, then the radio button on page 1will be drawn in page 2, but in the corresponding page position, as if it was drawn in page 1."));
        for (int i = 0; i < 36; ++i) {
            document.add((Element)Chunk.NEWLINE);
        }
    }

    private static void addTableWithRadioButtons(Document document, PdfWriter writer) throws DocumentException {
        String[] values;
        PdfPTable table = new PdfPTable(3);
        RadioButtonPageBreak.addRow(table, "Column 1", "Column 2", "Column 3");
        RadioButtonPageBreak.addRow(table, "Radio buttons", "coming", "soon");
        PdfFormField radioGroup = PdfFormField.createRadioButton((PdfWriter)writer, (boolean)true);
        radioGroup.setFieldName("radio");
        for (String value : values = new String[]{"Selection One", "Selection Two"}) {
            PdfPCell radioCell = new PdfPCell();
            radioCell.setCellEvent((PdfPCellEvent)new MyCellEvent(radioGroup, value, writer));
            table.addCell(radioCell);
            table.addCell(value);
            table.completeRow();
        }
        document.add((Element)table);
        writer.addAnnotation((PdfAnnotation)radioGroup);
    }

    private static void addRow(PdfPTable table, String ... cells) {
        Arrays.stream(cells).forEach(arg_0 -> ((PdfPTable)table).addCell(arg_0));
        table.completeRow();
    }

    private static class MyCellEvent
    implements PdfPCellEvent {
        private final PdfFormField radioGroup;
        private final String value;
        private final PdfWriter writer;

        public MyCellEvent(PdfFormField radioGroup, String value, PdfWriter writer) {
            this.radioGroup = radioGroup;
            this.value = value;
            this.writer = writer;
        }

        public void cellLayout(PdfPCell cell, Rectangle position, PdfContentByte[] canvases) {
            RadioCheckField radio = new RadioCheckField(this.writer, position, null, this.value);
            radio.setBorderColor((Color)GrayColor.GRAYBLACK);
            radio.setCheckType(2);
            try {
                this.radioGroup.addKid(radio.getRadioField());
            }
            catch (DocumentException | IOException e) {
                throw new ExceptionConverter((Exception)e);
            }
        }
    }
}

