/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.text.PageSize;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.OptionArgument;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

public class PageSizeArgument
extends OptionArgument {
    private TreeMap<Object, Object> options = new TreeMap();

    public PageSizeArgument(AbstractTool tool, String name, String description) {
        super(tool, name, description);
        Class<PageSize> ps = PageSize.class;
        Field[] sizes = ps.getDeclaredFields();
        try {
            for (Field size : sizes) {
                this.addOption(size.getName(), size.get(null));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addOption(Object description, Object value) {
        this.options.put(description, value);
    }

    public TreeMap<Object, Object> getOptions() {
        return this.options;
    }

    @Override
    public Object getArgument() throws InstantiationException {
        if (this.value == null) {
            return null;
        }
        try {
            return this.options.get(this.value);
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    @Override
    public String getUsage() {
        StringBuilder buf = new StringBuilder("  ");
        buf.append(this.name);
        buf.append(" -  ");
        buf.append(this.description);
        buf.append('\n');
        buf.append("    possible options:\n");
        for (Object o : this.options.keySet()) {
            String s = (String)o;
            buf.append("    - ");
            buf.append(s);
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object[] message = new Object[2];
        message[0] = "Choose one of the following pagesizes:";
        JComboBox<Object> cb = new JComboBox<Object>();
        for (Object o : this.options.keySet()) {
            cb.addItem(o);
        }
        message[1] = cb;
        int result = JOptionPane.showOptionDialog(this.tool.getInternalFrame(), message, this.description, 2, 3, null, null, null);
        if (result == 0) {
            this.setValue(cb.getSelectedItem());
        }
    }

    @Override
    public String toString() {
        return super.getValue().toString();
    }
}

